/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirectoryException;
import fuego.directory.exception.ListenerException;
import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryEventGenerator;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.log.Log;

public class MultipleEventGenerator
implements DirectoryEventGenerator {
    private final DirectoryEventGenerator[] generators;
    private boolean listening;
    private final DirObjectType objectType;

    public MultipleEventGenerator(DirObjectType objectType, DirectoryEventGenerator[] generators) {
        this.objectType = objectType;
        this.generators = generators;
    }

    @Override
    public DirObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public boolean isSynchronized() {
        for (int i = 0; i < this.generators.length; ++i) {
            DirectoryEventGenerator generator = this.generators[i];
            if (generator.isSynchronized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<DirectoryNotificationEvent> generateEvents() throws DirectoryException {
        ArrayList<List<DirectoryNotificationEvent>> events = new ArrayList<List<DirectoryNotificationEvent>>();
        for (DirectoryEventGenerator generator : this.generators) {
            try {
                events.add(generator.generateEvents());
            }
            catch (Throwable throwable) {
                Log.logSevere(throwable);
            }
        }
        return this.mergeEvents(events);
    }

    @Override
    public void initializeForListening() throws ListenerException {
        for (int i = 0; i < this.generators.length; ++i) {
            DirectoryEventGenerator eventGenerator = this.generators[i];
            eventGenerator.initializeForListening();
        }
    }

    @Override
    public void stopListening() throws ListenerException {
        for (int i = 0; i < this.generators.length; ++i) {
            DirectoryEventGenerator generator = this.generators[i];
            generator.stopListening();
        }
    }

    @Override
    public void synchronize() throws DirectoryException {
        for (DirectoryEventGenerator generator : this.generators) {
            generator.synchronize();
        }
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public void setListening(boolean listening) {
        this.listening = listening;
        for (int i = 0; i < this.generators.length; ++i) {
            DirectoryEventGenerator eventGenerator = this.generators[i];
            eventGenerator.setListening(this.listening);
        }
    }

    protected List<DirectoryNotificationEvent> mergeEvents(List<List<DirectoryNotificationEvent>> events) {
        ArrayList<DirectoryNotificationEvent> result = new ArrayList<DirectoryNotificationEvent>();
        for (List<DirectoryNotificationEvent> list : events) {
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    protected DirectoryEventGenerator[] getGenerators() {
        return this.generators;
    }
}

