/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.CommunicationException;
import fuego.directory.DirectoryException;
import fuego.directory.exception.ListenerException;
import fuego.directory.listener.BusinessParameterListenerInterface;
import fuego.directory.listener.CalendarRuleListenerInterface;
import fuego.directory.listener.DirectoryListenerInterface;
import fuego.directory.listener.DirectoryNotifierInterface;
import fuego.directory.listener.DirectoryStatusListenerInterface;
import fuego.directory.listener.HolidayRuleListenerInterface;
import fuego.directory.listener.HumanParticipantListenerInterface;
import fuego.directory.listener.OrganizationalGroupListenerInterface;
import fuego.directory.listener.OrganizationalRoleListenerInterface;
import fuego.directory.listener.PresentationListenerInterface;
import fuego.directory.listener.ProcessVariableListenerInterface;
import fuego.directory.listener.ViewListenerInterface;
import fuego.directory.msg.DirectoryMsg;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.notifiers.Constants;
import fuego.directory.provider.notifiers.DirObjectNotifier;
import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryEventGenerator;
import fuego.directory.provider.notifiers.DirectoryNotificationDispatcher;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import fuego.directory.provider.notifiers.DirectoryStatusNotificationDispatcher;
import fuego.directory.provider.notifiers.NotifierMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;

public class DirectoryNotifier
implements DirectoryNotifierInterface,
Constants {
    protected final Map<Integer, DirectoryEventGenerator> eventGenerators;
    protected final DirectoryNotificationDispatcher objectEventsDispatcher;
    protected NotifierScheduler scheduler;
    protected final DirectorySessionImpl session;
    protected int status = 1;
    protected final DirectoryStatusNotificationDispatcher statusEventsDispatcher;
    private NotifierMode.Changes changesMode;
    private long frequency;
    private boolean handlesChanges;
    private boolean handlesRecovery;
    private NotifierMode.Recovery recoveryMode;
    private boolean serviceAvailable = true;
    private final List<DirectoryEventGenerator> sortedGenerators;
    public static final int STARTED = 0;
    public static final int STOPPED = 1;

    public DirectoryNotifier(DirectorySessionImpl session) {
        this.session = session;
        this.objectEventsDispatcher = new DirectoryNotificationDispatcher();
        this.statusEventsDispatcher = new DirectoryStatusNotificationDispatcher();
        this.eventGenerators = new HashMap<Integer, DirectoryEventGenerator>(10);
        this.sortedGenerators = new ArrayList<DirectoryEventGenerator>(10);
    }

    @Override
    public void addBusinessParameterCreatedListener(BusinessParameterListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.BUSINESS_PARAMETER, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addBusinessParameterDeletedListener(BusinessParameterListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.BUSINESS_PARAMETER, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addBusinessParameterListener(BusinessParameterListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.BUSINESS_PARAMETER, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addBusinessParameterUpdatedListener(BusinessParameterListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.BUSINESS_PARAMETER, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addCalendarRuleUpdatedListener(CalendarRuleListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.CALENDAR_RULE, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addDirectoryStatusListener(DirectoryStatusListenerInterface listener) throws DirectoryException {
        this.statusEventsDispatcher.addListener(listener);
        if (this.isListening()) {
            this.notifyAvailability(listener);
        }
    }

    @Override
    public void addGroupCreatedListener(OrganizationalGroupListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.GROUP, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addGroupDeletedListener(OrganizationalGroupListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.GROUP, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addGroupListener(OrganizationalGroupListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.GROUP, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addGroupUpdatedListener(OrganizationalGroupListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.GROUP, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addHolidayRuleUpdatedListener(HolidayRuleListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.HOLIDAY_RULE, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addParticipantCreatedListener(HumanParticipantListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PARTICIPANT, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addParticipantDeletedListener(HumanParticipantListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PARTICIPANT, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addParticipantListener(HumanParticipantListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PARTICIPANT, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addParticipantUpdatedListener(HumanParticipantListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PARTICIPANT, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addPresentationCreatedListener(PresentationListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PRESENTATION, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addPresentationDeletedListener(PresentationListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PRESENTATION, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addPresentationListener(PresentationListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PRESENTATION, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addPresentationUpdatedListener(PresentationListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PRESENTATION, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addProcessVariableCreatedListener(ProcessVariableListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PROCESS_VARIABLE, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addProcessVariableDeletedListener(ProcessVariableListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PROCESS_VARIABLE, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addProcessVariableListener(ProcessVariableListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PROCESS_VARIABLE, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addProcessVariableUpdatedListener(ProcessVariableListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.PROCESS_VARIABLE, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addRoleCreatedListener(OrganizationalRoleListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.ROLE, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addRoleDeletedListener(OrganizationalRoleListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.ROLE, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addRoleListener(OrganizationalRoleListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.ROLE, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addRoleUpdatedListener(OrganizationalRoleListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.ROLE, listener);
        this.addUpdateListener(notifier);
    }

    @Override
    public void addViewCreatedListener(ViewListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.VIEW, listener);
        this.addCreateListener(notifier);
    }

    @Override
    public void addViewDeletedListener(ViewListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.VIEW, listener);
        this.addDeleteListener(notifier);
    }

    @Override
    public void addViewListener(ViewListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.VIEW, listener);
        this.addAllListener(notifier);
    }

    @Override
    public void addViewUpdatedListener(ViewListenerInterface listener) throws DirectoryException {
        DirObjectNotifier notifier = this.obtainNotifier(DirObjectType.VIEW, listener);
        this.addUpdateListener(notifier);
    }

    public NotifierMode getChangesMode() {
        if (this.changesMode == null) {
            this.changesMode = NotifierMode.createChangesMode(this, this.handlesChanges());
        }
        return this.changesMode;
    }

    public NotifierMode getRecoveryMode() {
        if (this.recoveryMode == null) {
            this.recoveryMode = NotifierMode.createRecoveryMode(this, this.handlesRecovery());
        }
        return this.recoveryMode;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void initializeForListening() {
        try {
            for (DirectoryEventGenerator eventGenerator : this.eventGenerators.values()) {
                eventGenerator.initializeForListening();
                eventGenerator.setListening(true);
            }
            this.status = 0;
        }
        catch (ListenerException e) {
            Log.logInfo(e);
        }
    }

    public boolean isListening() {
        return this.status == 0;
    }

    public boolean isServiceAvailable() {
        return this.serviceAvailable;
    }

    @Override
    public boolean isSynchronized() {
        for (DirectoryEventGenerator eventGenerator : this.eventGenerators.values()) {
            if (eventGenerator.isSynchronized()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChanges() throws DirectoryException {
        boolean transactionStarted = this.session.isTransactionStarted();
        if (!transactionStarted) {
            this.session.startTransaction();
        }
        try {
            if (!this.isSynchronized()) {
                this.synchronize();
            }
            try {
                for (DirectoryEventGenerator eventGenerator : this.sortedGenerators) {
                    try {
                        List<DirectoryNotificationEvent> events = eventGenerator.generateEvents();
                        Collections.sort(events);
                        DirectoryNotificationEvent lastEventDispatched = null;
                        for (DirectoryNotificationEvent event : events) {
                            if (lastEventDispatched != null && lastEventDispatched.equals(event)) continue;
                            this.objectEventsDispatcher.dispatch(event);
                            lastEventDispatched = event;
                        }
                    }
                    catch (DirectoryException e) {
                        Log.logSevere(e);
                    }
                }
                this.notifyServiceAvailable();
            }
            catch (CommunicationException cex) {
                if (Log.isDebugging()) {
                    Log.logDebug(cex);
                }
                this.notifyServiceNotAvailable();
            }
            if (!transactionStarted) {
                this.session.commitTransaction();
            }
        }
        finally {
            if (!transactionStarted) {
                this.session.rollbackTransaction();
            }
        }
    }

    public void notifyServiceAvailable() {
        if (!this.isServiceAvailable()) {
            this.statusEventsDispatcher.dispatch(1);
            this.setServiceAvailable();
            this.getActiveMode().switchToChangesMode();
        }
    }

    public void notifyServiceNotAvailable() {
        if (this.isServiceAvailable()) {
            this.statusEventsDispatcher.dispatch(2);
            this.setServiceNotAvailable();
            this.getActiveMode().switchToRecoveryMode();
        }
    }

    public void release() {
        if (this.getScheduler() != null) {
            this.getScheduler().stopPolling();
        }
        this.status = 1;
    }

    @Override
    public void removeAllListeners() {
        this.objectEventsDispatcher.removeAllNotifiers();
    }

    public void sessionConnected() {
        this.statusEventsDispatcher.dispatch(4);
    }

    public void sessionDisconnected() {
        if (this.isListening()) {
            this.statusEventsDispatcher.dispatch(8);
        }
        this.stopListening();
    }

    public void setServiceAvailable() {
        this.serviceAvailable = true;
    }

    public void setServiceNotAvailable() {
        this.serviceAvailable = false;
    }

    @Override
    public void startListening() throws DirectoryException {
        this.startListening(300000L, true, true);
    }

    @Override
    public void startListening(long f) throws DirectoryException {
        this.startListening(f, true, true);
    }

    @Override
    public void startListening(boolean handleChanges, boolean handleRecovery) throws DirectoryException {
        this.startListening(300000L, handleChanges, handleRecovery);
    }

    @Override
    public void startListening(long f, boolean handleChanges, boolean handleRecovery) throws DirectoryException {
        if (this.isListening()) {
            return;
        }
        this.setFrequency(f);
        this.setHandlesChanges(handleChanges);
        this.setHandlesRecovery(handleRecovery);
        this.getChangesMode().startMode();
    }

    public void startPolling() {
        if (this.scheduler == null) {
            this.scheduler = new NotifierScheduler(this, this.getFrequency());
            this.scheduler.start();
        }
    }

    @Override
    public void stopListening() {
        if (!this.isListening()) {
            return;
        }
        if (this.getScheduler() != null) {
            this.getScheduler().stopPolling();
            this.scheduler = null;
        }
        try {
            for (DirectoryEventGenerator eventGenerator : this.eventGenerators.values()) {
                eventGenerator.stopListening();
                eventGenerator.setListening(false);
            }
        }
        catch (ListenerException e) {
            Log.logInfo(e);
        }
        this.status = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize() throws DirectoryException {
        boolean transactionStarted = this.session.isTransactionStarted();
        if (!transactionStarted) {
            this.session.startTransaction();
        }
        try {
            try {
                for (DirectoryEventGenerator eventGenerator : this.eventGenerators.values()) {
                    eventGenerator.synchronize();
                }
            }
            catch (DirectoryException e) {
                Log.logInfo(e);
            }
            if (!transactionStarted) {
                this.session.commitTransaction();
            }
        }
        finally {
            if (!transactionStarted) {
                this.session.rollbackTransaction();
            }
        }
    }

    protected NotifierMode getActiveMode() {
        return this.getRecoveryMode().isActive() ? this.getRecoveryMode() : this.getChangesMode();
    }

    protected NotifierScheduler getScheduler() {
        return this.scheduler;
    }

    private void addAllListener(DirObjectNotifier notifier) {
        this.objectEventsDispatcher.addNotifier(notifier, 7);
        this.checkEventGenerator(notifier);
    }

    private void addCreateListener(DirObjectNotifier notifier) {
        this.objectEventsDispatcher.addNotifier(notifier, 2);
        this.checkEventGenerator(notifier);
    }

    private void addDeleteListener(DirObjectNotifier notifier) {
        this.objectEventsDispatcher.addNotifier(notifier, 1);
        this.checkEventGenerator(notifier);
    }

    private void addUpdateListener(DirObjectNotifier notifier) {
        this.objectEventsDispatcher.addNotifier(notifier, 4);
        this.checkEventGenerator(notifier);
    }

    private void checkEventGenerator(DirObjectNotifier notifier) {
        DirObjectType objectType = notifier.getObjectType();
        DirectoryEventGenerator generator = this.eventGenerators.get(objectType.ordinal());
        if (generator == null) {
            generator = objectType.createEventGenerator(this.session);
            if (generator != null) {
                this.eventGenerators.put(objectType.ordinal(), generator);
                this.insertSortedGenerator(generator);
            } else if (Log.isDebugging()) {
                Log.logDebug("The session will not generate events for this object type " + (Object)((Object)objectType));
            }
        }
    }

    private void insertSortedGenerator(DirectoryEventGenerator generator) {
        Comparator<DirectoryEventGenerator> comparator = new Comparator<DirectoryEventGenerator>(){

            @Override
            public int compare(DirectoryEventGenerator o1, DirectoryEventGenerator o2) {
                return o1.getObjectType().ordinal() - o2.getObjectType().ordinal();
            }
        };
        int position = Collections.binarySearch(this.sortedGenerators, generator, comparator);
        if (position < 0) {
            position = -position - 1;
        }
        this.sortedGenerators.add(position, generator);
    }

    private long getFrequency() {
        return this.frequency;
    }

    private boolean handlesChanges() {
        return this.handlesChanges;
    }

    private boolean handlesRecovery() {
        return this.handlesRecovery;
    }

    private void notifyAvailability(DirectoryStatusListenerInterface listener) {
        if (!this.isServiceAvailable()) {
            listener.directoryNotAvailable();
        } else {
            listener.directoryAvailable();
        }
    }

    private DirObjectNotifier obtainNotifier(DirObjectType objectType, DirectoryListenerInterface listener) {
        return this.objectEventsDispatcher.getNotifierForListener(objectType, listener);
    }

    private void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    private void setHandlesChanges(boolean handles) {
        this.handlesChanges = handles;
    }

    private void setHandlesRecovery(boolean handles) {
        this.handlesRecovery = handles;
    }

    public static class NotifierScheduler
    extends Thread {
        private Boolean continuePolling_d;
        private long interval_d;
        private DirectoryNotifierInterface notifier_d;

        public NotifierScheduler(DirectoryNotifierInterface notifier, long interval) {
            this.setName("Directory-Polling: " + Time.now());
            this.continuePolling_d = Boolean.TRUE;
            this.notifier_d = notifier;
            this.interval_d = interval;
        }

        @Override
        public void run() {
            while (this.continuePolling().booleanValue()) {
                try {
                    try {
                        NotifierScheduler.sleep(this.interval_d);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (!this.continuePolling().booleanValue()) continue;
                    this.notifier_d.notifyChanges();
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        Log.logSevere(DirectoryMsg.DIR_30000(this.toString(), this.hashCode()));
                        Log.logFatal(t);
                        continue;
                    }
                    Log.logSevere(DirectoryMsg.DIR_30001(this.toString(), this.hashCode()));
                    Log.logSevere(t);
                }
            }
        }

        public void stopPolling() {
            this.continuePolling(Boolean.FALSE);
            this.interrupt();
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Boolean continuePolling() {
            Boolean bl = this.continuePolling_d;
            synchronized (bl) {
                return this.continuePolling_d;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void continuePolling(Boolean willContinue) {
            Boolean bl = this.continuePolling_d;
            synchronized (bl) {
                this.continuePolling_d = willContinue;
            }
        }
    }
}

