/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirObject;
import fuego.directory.listener.DirectoryListenerInterface;
import fuego.directory.provider.notifiers.Constants;
import fuego.directory.provider.notifiers.DirObjectNotifier;
import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import java.util.IdentityHashMap;
import java.util.Map;

class DirectoryNotificationDispatcher
implements Constants {
    private final Map<DirObjectNotifier, Integer> notifiers = new IdentityHashMap<DirObjectNotifier, Integer>();
    private final Map<DirObjectType, Map<DirectoryListenerInterface, DirObjectNotifier>> notifiersByListener = new IdentityHashMap<DirObjectType, Map<DirectoryListenerInterface, DirObjectNotifier>>();

    DirectoryNotificationDispatcher() {
    }

    public void addNotifier(DirObjectNotifier notifier, int eventTypeMask) {
        int mask = eventTypeMask | notifier.getObjectType().getMask();
        Integer oldMask = this.notifiers.put(notifier, mask);
        if (oldMask != null) {
            this.notifiers.put(notifier, oldMask | mask);
        }
        DirObjectNotifier exists = this.getNotifiersMap(notifier.getObjectType()).put(notifier.getListener(), notifier);
        assert (exists == null || oldMask == null || (eventTypeMask & oldMask) == 0) : "The listener should not be added twice";
    }

    void removeAllNotifiers() {
        this.notifiers.clear();
        this.notifiersByListener.clear();
    }

    void dispatch(DirectoryNotificationEvent event) {
        for (Map.Entry<DirObjectNotifier, Integer> entry : this.notifiers.entrySet()) {
            DirObjectNotifier notifier = entry.getKey();
            int listenerMask = entry.getValue();
            int eventMask = event.getMask();
            if ((eventMask & listenerMask) != eventMask) continue;
            this.notifyListener(notifier, event);
        }
    }

    void removeListener(DirObjectNotifier notifier, int mask) {
        DirObjectNotifier exists = this.getNotifiersMap(notifier.getObjectType()).remove(notifier.getListener());
        assert (exists == notifier) : "the listener was referred by another notifier";
        int oldMask = this.notifiers.remove(notifier);
        if (oldMask != mask) {
            this.notifiers.put(notifier, oldMask & ~mask);
        }
    }

    DirObjectNotifier getNotifierForListener(DirObjectType objectType, DirectoryListenerInterface listener) {
        DirObjectNotifier notifier = this.getNotifiersMap(objectType).get(listener);
        return notifier != null ? notifier : objectType.createNotifier(listener);
    }

    private Map<DirectoryListenerInterface, DirObjectNotifier> getNotifiersMap(DirObjectType objectType) {
        Map<DirectoryListenerInterface, DirObjectNotifier> notifiersMap = this.notifiersByListener.get((Object)objectType);
        if (notifiersMap == null) {
            notifiersMap = new IdentityHashMap<DirectoryListenerInterface, DirObjectNotifier>();
            this.notifiersByListener.put(objectType, notifiersMap);
        }
        return notifiersMap;
    }

    private void notifyListener(DirObjectNotifier notifier, DirectoryNotificationEvent event) {
        switch (event.getEventType()) {
            case 2: {
                DirObject object = event.getObject();
                assert (object != null) : "Update event do not contain the object: " + event;
                notifier.notifyCreated(object);
                break;
            }
            case 4: {
                DirObject object = event.getObject();
                assert (object != null) : "Update event do not contain the object: " + event;
                notifier.notifyUpdated(object);
                break;
            }
            case 1: {
                String objectId = event.getObjectId();
                assert (objectId != null) : "Delete event do not contain the object Id: " + event;
                notifier.notifyDeleted(objectId);
                break;
            }
            default: {
                assert (false) : "Invalid event type " + event.getEventType();
                break;
            }
        }
    }
}

