/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirectoryException;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryEventGeneratorImpl;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import fuego.directory.provider.notifiers.DirectoryObjectProxy;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.Time;

public abstract class BasePollingEventGenerator
extends DirectoryEventGeneratorImpl {
    private List<DirectoryObjectProxy> proxies;

    public BasePollingEventGenerator(DirObjectType objectType, DirectorySessionImpl session) {
        super(objectType, session);
    }

    @Override
    public List<DirectoryNotificationEvent> generateEvents() throws DirectoryException {
        List<DirectoryObjectProxy> newProxies = this.buildCurrentProxies();
        List<DirectoryNotificationEvent> events = this.buildEvents(newProxies);
        this.proxies = newProxies;
        this.updateTimeStamp();
        return events;
    }

    @Override
    public void initializeForListening() {
    }

    @Override
    public boolean isSynchronized() {
        return this.proxies != null;
    }

    @Override
    public void stopListening() {
        this.proxies = null;
        this.initTimeStamps(null);
    }

    @Override
    public void synchronize() throws DirectoryException {
        if (this.proxies == null) {
            this.initTimeStamps(Time.valueOf(0L));
            List<DirectoryObjectProxy> newProxies = this.buildCurrentProxies();
            for (DirectoryObjectProxy proxy : newProxies) {
                this.updateTimestampBuffer(proxy);
            }
            this.updateTimeStamp();
            this.proxies = newProxies;
        }
    }

    protected abstract List<DirectoryObjectProxy> buildCurrentProxies() throws DirectoryException;

    protected List<DirectoryNotificationEvent> buildEvents(List<DirectoryObjectProxy> newProxies) {
        return this.buildEvents(newProxies, true);
    }

    protected List<DirectoryNotificationEvent> buildEvents(List<DirectoryObjectProxy> newProxies, boolean isFullScan) {
        ArrayList<DirectoryNotificationEvent> createUpdateEvents = new ArrayList<DirectoryNotificationEvent>();
        ArrayList<DirectoryObjectProxy> oldProxies = new ArrayList<DirectoryObjectProxy>(this.proxies);
        for (DirectoryObjectProxy proxy : newProxies) {
            try {
                Object newEvent;
                DirectoryObjectProxy ownerProxy;
                this.updateTimestampBuffer(proxy);
                int index = oldProxies.indexOf(proxy);
                if (index == -1) {
                    newEvent = proxy.isPropertyProxy() ? ((ownerProxy = proxy.findOwnerProxy(newProxies)) == null || createUpdateEvents.contains(ownerProxy.createAddEvent()) ? null : ownerProxy.createChangeEvent()) : (isFullScan ? proxy.createAddEvent() : null);
                } else {
                    oldProxies.remove(index);
                    newEvent = proxy.wasModifiedSince(this.getTimestamp()) ? (proxy.isPropertyProxy() ? ((ownerProxy = proxy.findOwnerProxy(newProxies)) != null ? ownerProxy.createChangeEvent() : null) : proxy.createChangeEvent()) : null;
                }
                if (newEvent == null) continue;
                createUpdateEvents.add((DirectoryNotificationEvent)newEvent);
            }
            catch (DirectoryException e) {
                e.printStackTrace();
            }
        }
        ArrayList<DirectoryNotificationEvent> deleteEvents = new ArrayList<DirectoryNotificationEvent>();
        if (isFullScan) {
            for (DirectoryObjectProxy proxy : oldProxies) {
                try {
                    if (proxy.isPropertyProxy()) continue;
                    deleteEvents.add(proxy.createDeleteEvent());
                }
                catch (DirectoryException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<DirectoryNotificationEvent> result = new ArrayList<DirectoryNotificationEvent>();
        for (DirectoryNotificationEvent event : deleteEvents) {
            event.getObjectType().addEvent(result, event);
        }
        for (DirectoryNotificationEvent event : createUpdateEvents) {
            event.getObjectType().addEvent(result, event);
        }
        return result;
    }

    private void updateTimestampBuffer(DirectoryObjectProxy proxy) {
        this.updateTimeStampBuffer(proxy.getModified(), proxy.toString());
    }
}

