/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.DirectoryRuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.bpm.lang.Literals;

public class Util {
    protected static final char ESC_CHAR = '?';

    public static String deEscapeKey(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer deEscKey = new StringBuffer();
        char[] values = key.toCharArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == '?') {
                if (i < values.length - 1 && values[i + 1] == '?') {
                    deEscKey.append('?');
                    ++i;
                    continue;
                }
                deEscKey.append("/");
                continue;
            }
            deEscKey.append(values[i]);
        }
        return deEscKey.toString();
    }

    public static String decodeURLProperty(String property) {
        try {
            return URLDecoder.decode(property, Literals.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return property;
        }
    }

    public static byte[] digest(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(input);
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw DirectoryRuntimeException.wrapException(e);
        }
    }

    public static String encodeURLProperty(String property) {
        try {
            return URLEncoder.encode(property, Literals.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return property;
        }
    }

    public static String escapeKey(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer escKey = new StringBuffer();
        char[] values = key.toCharArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == "/".toCharArray()[0]) {
                escKey.append('?');
                continue;
            }
            if (values[i] == '?') {
                escKey.append('?');
                escKey.append('?');
                continue;
            }
            escKey.append(values[i]);
        }
        return escKey.toString();
    }
}

