/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.AuthenticationException;
import fuego.directory.CommunicationException;
import fuego.directory.DirHumanParticipant;
import fuego.directory.Directory;
import fuego.directory.DirectoryConfigurationManagerInterface;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectoryPropertiesProvider;
import fuego.directory.DirectorySession;
import fuego.directory.auth.AuthenticatorFactory;
import fuego.directory.exception.CouldNotCleanSchemaException;
import fuego.directory.exception.CouldNotCreateSchemaException;
import fuego.directory.exception.CouldNotDropSchemaException;
import fuego.directory.exception.DirectoryNotAvailableException;
import fuego.directory.exception.ProtocolNotSupportedException;
import fuego.directory.provider.AttributeValidator;
import fuego.directory.provider.AuthenticationAccessor;
import fuego.directory.provider.DirectoryPersistenceManager;
import fuego.directory.provider.DirectoryPreferencesAccessor;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.DirectoryStatus;
import fuego.directory.provider.EngineAccessor;
import fuego.directory.provider.GroupAccessor;
import fuego.directory.provider.ObjectClassInstanceAccessor;
import fuego.directory.provider.ObjectPropertiesAccessor;
import fuego.directory.provider.OrganizationAccessor;
import fuego.directory.provider.ParticipantAccessor;
import fuego.directory.provider.ProcessAccessor;
import fuego.directory.provider.ProcessManagerAccessor;
import fuego.directory.provider.ProjectAccessor;
import fuego.directory.provider.SchemaCreationBean;
import fuego.directory.provider.TransactionSupport;
import fuego.directory.provider.ValidationAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.DirectoryProviderMetadata;
import oracle.bpm.lang.Platform;

public abstract class Factory<T> {
    protected Map<String, Map<String, AuthenticatorFactory>> authenticationFactories = new HashMap<String, Map<String, AuthenticatorFactory>>();
    private final Map<Integer, T> internalObjects = new HashMap<Integer, T>();
    private static String[] reservedWords = new String[]{"fuego"};
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String ORGNAME = "ORGNAME";
    public static final String PROTOCOL_KEY = "PROTOCOL";
    public static final String ROOT = "ROOT";
    public static final String ROOTPASSWORD = "ROOTPASSWORD";
    public static final String SKIP_AUTH = "skip-auth";
    public static final String SKIP_AUTH_CHAR = "*";
    public static final String SHOW_SCRIPTS = "SHOW_SCRIPTS";
    public static final String RESET_PASSWORD = "reset-password";
    private static Map<String, Factory> factories = null;
    private static Map<String, Extension<DirectoryProviderMetadata>> extensions = null;
    public static final int CONTEXT_WAM = 1;
    public static final String URL = "URL";
    public static final String CONFIGURATION_NAME = "FDI_CONFIGURATION";
    public static final String ANONYMOUS_USER = "anonymous-user";
    public static final String ANONYMOUS_PASSWORD = "anonymous-password";
    public static final int LDAP = 0;
    public static final int JDBC = 1;
    public static final int HYBRID = 2;
    private static final Map<String, DirectorySessionImpl.SchemaInfo> schemaInfoMap = Collections.synchronizedMap(new HashMap());

    protected Factory() {
        this.init();
    }

    public abstract void createSchema(oracle.bpm.util.Properties var1) throws CouldNotCreateSchemaException;

    public abstract void dropSchema(oracle.bpm.util.Properties var1) throws CouldNotDropSchemaException;

    public abstract DirectoryStatus getDirectoryStatusFor(DirectoryPassport var1) throws AuthenticationException, CommunicationException;

    public abstract String getProtocolProvided();

    public abstract int getProviderType();

    public abstract SchemaCreationBean createSchemaCreationBean(DirectoryPropertiesProvider var1);

    public abstract String getPanelClassName();

    public abstract void buildCreationSentences(String var1, oracle.bpm.util.Properties var2);

    public static void add(Factory directoryFactory) {
        Factory.getFactories().put(directoryFactory.getProtocolProvided(), directoryFactory);
    }

    public static oracle.bpm.util.Properties buildDirectoryPropertiesFrom(String stringProperties) {
        oracle.bpm.util.Properties result = new oracle.bpm.util.Properties();
        if (stringProperties.length() <= 3) {
            return result;
        }
        StringTokenizer propertyTokenizer = new StringTokenizer(stringProperties, ";");
        while (propertyTokenizer.hasMoreElements()) {
            String nextToken = propertyTokenizer.nextToken();
            String key = nextToken.substring(0, nextToken.indexOf("=")).trim();
            String value = nextToken.substring(nextToken.indexOf("=") + 1, nextToken.length()).trim();
            result.put(key, value);
        }
        return result;
    }

    public static Factory getFactoryFor(String protocol) throws ProtocolNotSupportedException {
        if (protocol == null) {
            throw ProtocolNotSupportedException.create(protocol);
        }
        Factory.initPlugins();
        Factory factory = Factory.getFactories().get(protocol);
        if (factory == null) {
            Extension<DirectoryProviderMetadata> extension = Factory.getExtensions().get(protocol);
            if (extension == null) {
                throw ProtocolNotSupportedException.create(protocol);
            }
            try {
                factory = extension.instantiateAs(Factory.class);
            }
            catch (InstantiationException e) {
                ProtocolNotSupportedException p = ProtocolNotSupportedException.create(protocol);
                p.initCause(e);
                throw p;
            }
            Factory.getFactories().put(protocol, factory);
        }
        return factory;
    }

    @Deprecated
    public static Factory getFactoryFromPassport(DirectoryPassport passport) throws ProtocolNotSupportedException {
        return Factory.getDirectoryFactory(passport.getId());
    }

    public static Factory getDirectoryFactory(String directoryId) throws ProtocolNotSupportedException {
        DirectoryConfigurationManagerInterface directoryConfigurationManagerInterface = Directory.getPropertyManager(directoryId);
        if (directoryConfigurationManagerInterface == null) {
            throw new IllegalStateException("The directory id [" + directoryId + "] is not registered");
        }
        return Factory.getFactoryFor(directoryConfigurationManagerInterface.getDirectoryConfigType());
    }

    public static void refreshFactories() {
        for (Factory factory : Factory.getFactories().values()) {
            factory.refresh();
        }
    }

    public DirectorySessionImpl<T> buildSession(DirectoryPassport passport) {
        return new DirectorySessionImpl(passport, this);
    }

    public DirHumanParticipant authenticate(DirectoryPassport passport) throws AuthenticationException, CommunicationException {
        DirectorySessionImpl<T> session = this.buildSession(passport);
        return session.authenticate();
    }

    public final String buildDirectoryPropertiesFrom(oracle.bpm.util.Properties properties) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("#\n");
        return stringBuffer.toString();
    }

    public void cleanSchema(oracle.bpm.util.Properties properties) throws CouldNotCleanSchemaException {
        if (properties == null) {
            throw CouldNotCleanSchemaException.emptyProperties();
        }
    }

    public void fillPassport(DirectoryPassport passport) throws AuthenticationException, CommunicationException {
        throw new UnsupportedOperationException();
    }

    public Map<String, AuthenticatorFactory> getAuthMethods(String directoryId) {
        if (this.authenticationFactories.get(directoryId) == null) {
            this.createAuthFactories(directoryId);
        }
        return this.authenticationFactories.get(directoryId);
    }

    public String getCreateSentences(String directoryId) {
        throw new UnsupportedOperationException();
    }

    public T getInternalObject(int key) {
        return this.internalObjects.get(key);
    }

    public void initializeSchema(oracle.bpm.util.Properties properties) throws CouldNotCreateSchemaException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isAvailable(DirectoryPassport passport) {
        DirectorySession anonymous = null;
        try {
            anonymous = this.startSession(passport);
            boolean bl = anonymous != null;
            return bl;
        }
        catch (AuthenticationException ex) {
            boolean bl = false;
            return bl;
        }
        catch (CommunicationException ex) {
            boolean bl = false;
            return bl;
        }
        catch (DirectoryNotAvailableException ex2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (anonymous != null) {
                try {
                    anonymous.disconnect();
                }
                catch (DirectoryException e) {}
            }
        }
    }

    public T setInternalObject(int key, T value) {
        return this.internalObjects.put(key, value);
    }

    public DirectorySession startSession(DirectoryPassport passport) throws AuthenticationException, CommunicationException {
        DirectorySessionImpl<T> session = this.buildSession(passport);
        session.connect();
        return session;
    }

    public Factory<T> mapFactory(Properties properties) throws ProtocolNotSupportedException {
        return this;
    }

    public String getSessionKey(DirectorySession session) {
        if (session.hasSchemaInfo()) {
            return session.getSchemaId();
        }
        return null;
    }

    protected abstract AuthenticationAccessor createAuthenticationAccessor(DirectorySessionImpl<T> var1);

    protected abstract void createAuthFactories(String var1);

    protected abstract EngineAccessor createEngineAccessor(DirectorySessionImpl<T> var1);

    protected abstract GroupAccessor createGroupAccessor(DirectorySessionImpl<T> var1);

    protected abstract ObjectPropertiesAccessor createObjectPropertiesAccessor(DirectorySessionImpl<T> var1);

    protected abstract OrganizationAccessor createOrganizationAccessor(DirectorySessionImpl<T> var1);

    protected abstract ParticipantAccessor createParticipantAccessor(DirectorySessionImpl<T> var1);

    protected abstract ProcessManagerAccessor createProcessManagerAccessor(DirectorySessionImpl<T> var1);

    protected abstract ObjectClassInstanceAccessor createObjectClassInstanceAccessor(DirectorySessionImpl<T> var1);

    protected abstract DirectoryPersistenceManager createPersistenceManager(DirectorySessionImpl<T> var1);

    protected abstract ProcessAccessor createProcessAccessor(DirectorySessionImpl<T> var1);

    protected abstract ProjectAccessor createProjectAccessor(DirectorySessionImpl<T> var1);

    protected abstract TransactionSupport createTransactionSupport(DirectorySessionImpl<T> var1);

    protected abstract ValidationAccessor createValidationAccessor(DirectorySessionImpl<T> var1);

    protected abstract DirectoryPreferencesAccessor createDirectoryPreferencesAccessor(DirectorySessionImpl<T> var1);

    protected abstract void initializeSession(DirectorySessionImpl<T> var1, DirectoryPassport var2);

    protected static Map<String, Extension<DirectoryProviderMetadata>> getExtensions() {
        if (extensions == null) {
            TreeMap<String, Extension<DirectoryProviderMetadata>> metadata = new TreeMap<String, Extension<DirectoryProviderMetadata>>(String.CASE_INSENSITIVE_ORDER);
            ExtensionService extensionService = Platform.getExtensionService();
            List<Extension<DirectoryProviderMetadata>> extensions = extensionService.getExtensionsByPoint(DirectoryProviderMetadata.class);
            for (Extension<DirectoryProviderMetadata> extension : extensions) {
                metadata.put(extension.getMetadata().protocol(), extension);
            }
            Factory.extensions = metadata;
        }
        return extensions;
    }

    protected static boolean isReservedWord(String text) {
        for (String reservedWord : reservedWords) {
            if (!reservedWord.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    protected void init() {
    }

    protected void addAuthMethod(String directoryId, AuthenticatorFactory factory) {
        Map<String, AuthenticatorFactory> authFactories = this.authenticationFactories.get(directoryId);
        if (authFactories == null) {
            authFactories = new HashMap<String, AuthenticatorFactory>();
            this.authenticationFactories.put(directoryId, authFactories);
        }
        authFactories.put(factory.getId(), factory);
    }

    protected String buildContainerAuthPresetString(StringBuffer stringBuffer, String[] properties) {
        stringBuffer.append("#\n");
        stringBuffer.append("# Preset for external authentication. (e.g. web application with security constraint)\n");
        stringBuffer.append("#\n");
        for (String property : properties) {
            stringBuffer.append("directory.default.preset.container-auth.");
            stringBuffer.append(property);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected AttributeValidator createAttributeValidator(DirectorySessionImpl<T> session) {
        return new AttributeValidator(session);
    }

    protected DirectorySessionImpl.SchemaInfo obtainSchemaInfo(DirectorySessionImpl<T> directorySession) throws AuthenticationException {
        DirectorySessionImpl.SchemaInfo result;
        String key = directorySession.getSessionKey();
        if (key != null) {
            result = schemaInfoMap.get(key);
            if (result == null) {
                result = directorySession.getAuthenticationAccessor().getSchemaInfo();
                assert (result != null) : "getSchemaInfo should return an object or throw an exception!!";
                schemaInfoMap.put(directorySession.getSessionKey(), result);
            }
        } else {
            result = directorySession.getAuthenticationAccessor().getSchemaInfo();
        }
        directorySession.setSchemaInfo(result);
        return result;
    }

    protected void refresh() {
    }

    protected String getDirectoryId(oracle.bpm.util.Properties schemaProperties) {
        String directoryId = schemaProperties.getProperty("DIRECTORY_ID");
        if (directoryId == null) {
            directoryId = "default";
        }
        return directoryId;
    }

    private static Map<String, Factory> getFactories() {
        if (factories == null) {
            factories = new TreeMap<String, Factory>();
        }
        return factories;
    }

    private static void initPlugins() {
    }
}

