/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalRole;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.DirectorySession;
import fuego.directory.PasswordPolicyContext;
import fuego.directory.exception.InvalidAttributeValueException;

public class AttributeValidator {
    DirectorySession session;
    private boolean validateGroupValidCharacters = true;
    private boolean validateParticipantValidCharacters = true;
    public static final String GROUP_NAME = "Group name";
    public static final String OU_NAME = "OU name";
    public static final String PARTICIPANT_ID = "Participant ID";
    public static final String OU_FULL_NAME = "OU full name";
    public static final String ROLE_NAME = "Role name";
    public static final String CALENDAR_NAME = "Calendar Rule name";
    public static final String HOLIDAY_NAME = "Holiday Rule name";
    public static final String PARAMETER_VALUE = "Role Parameter value";
    public static final String PROCESS_DEFINITION_ID = "Process Definition ID";
    public static final String PROCESS_VARIATION = "Process Variation";
    public static final String DESCRIPTION = "Description";
    public static final String VIEW_ID = "View ID";
    public static final String PRESENTATION_ID = "Presentation ID";
    public static final String PROCESSVARIABLE_ID = "Process Variable ID";
    public static final String BUSINESSPARAMETER_ID = "Business Parameter ID";
    public static final String ORGANIZATION_NAME = "Organization name";
    public static final String ENGINE_ID = "Engine ID";
    public static final String OBJECT_CLASS_INSTANCE_NAME = "Object Class Instance name";

    public AttributeValidator(DirectorySession session) {
        this.session = session;
    }

    protected AttributeValidator() {
    }

    public static final boolean isValidCompositeValue(String value, char[] invalidChars) {
        char[] valueArray = value.toCharArray();
        for (int i = 0; i < invalidChars.length; ++i) {
            for (int j = 0; j < valueArray.length; ++j) {
                if (invalidChars[i] != valueArray[j] || valueArray[j] == '/') continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isValidValue(String value, char[] invalidChars, boolean emptyAllowed) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return emptyAllowed;
        }
        char[] valueArray = value.toCharArray();
        for (int i = 0; i < invalidChars.length; ++i) {
            for (int j = 0; j < valueArray.length; ++j) {
                if (invalidChars[i] != valueArray[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static final void validateAnyWhitespaces(String attributeName, String name) {
        if (name.indexOf(32) != -1) {
            throw InvalidAttributeValueException.whitespaceNotAllowed(attributeName, name);
        }
    }

    public static final void validateCompositeValue(String attributeName, String value, char[] invalidChars, boolean emptyAllowed) {
        if (!(emptyAllowed || value != null && value.trim().length() != 0)) {
            throw InvalidAttributeValueException.valueEmpty(attributeName);
        }
        char[] valueArray = value.toCharArray();
        for (int i = 0; i < invalidChars.length; ++i) {
            for (int j = 0; j < valueArray.length; ++j) {
                if (valueArray[j] == '/') {
                    if (j + 1 == valueArray.length) {
                        throw InvalidAttributeValueException.invalidValue(attributeName, value, valueArray[j]);
                    }
                    if (valueArray[j + 1] != '/') continue;
                    throw InvalidAttributeValueException.invalidValue(attributeName, value, valueArray[j]);
                }
                if (invalidChars[i] != valueArray[j]) continue;
                throw InvalidAttributeValueException.invalidValue(attributeName, value, valueArray[j]);
            }
        }
    }

    public static final void validateWhitespaces(String attributeName, String name) {
        if (!name.equals(name.trim())) {
            throw InvalidAttributeValueException.whitespaceNotAllowed(attributeName, name);
        }
    }

    public boolean isValidOUFullName(String name) {
        return AttributeValidator.isValidCompositeValue(name, DirObject.INVALID_EXTENDED_ID_CHARS);
    }

    public boolean isValidRoleName(String name) {
        return AttributeValidator.isValidValue(name, DirOrganizationalRole.INVALID_ID_CHARS, false) && name.equals(name.trim());
    }

    public String validateDescription(String description) {
        if (description != null && description.length() == 0) {
            description = null;
        }
        if (description != null && description.length() > this.getMaxDescriptionLength()) {
            throw InvalidAttributeValueException.lengthNotAllowed(DESCRIPTION, description, this.getMaxDescriptionLength());
        }
        return description;
    }

    public final void validateIdValue(String attributeName, String value, char[] invalidChars, boolean emptyAllowed) {
        if (value == null) {
            throw InvalidAttributeValueException.valueEmpty(attributeName);
        }
        if (value.length() == 0) {
            if (!emptyAllowed) {
                throw InvalidAttributeValueException.valueEmpty(attributeName);
            }
            return;
        }
        if (value.length() > this.getMaxIdLength()) {
            throw InvalidAttributeValueException.lengthNotAllowed(attributeName, value, this.getMaxIdLength());
        }
        char[] valueArray = value.toCharArray();
        for (int j = 0; j < valueArray.length; ++j) {
            if (invalidChars == null) continue;
            for (int i = 0; i < invalidChars.length; ++i) {
                if (invalidChars[i] != valueArray[j]) continue;
                throw InvalidAttributeValueException.invalidValue(attributeName, value, valueArray[j]);
            }
        }
    }

    public int getMaxDescriptionLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxIdLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxParametricValueLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxVariationLength() {
        return Integer.MAX_VALUE;
    }

    public void validateNewGroupName(String name) {
        if (this.validateGroupValidCharacters) {
            this.validateIdValue(GROUP_NAME, name, DirObject.INVALID_BASE_ID_CHARS, false);
        }
        AttributeValidator.validateWhitespaces(GROUP_NAME, name);
    }

    public void setValidateGroupValidCharacters(boolean validateGroupValidCharacters) {
        this.validateGroupValidCharacters = validateGroupValidCharacters;
    }

    public void setValidateParticipantValidCharacters(boolean validateParticipantValidCharacters) {
        this.validateParticipantValidCharacters = validateParticipantValidCharacters;
    }

    public void validateNewOUName(String name, String parentName) {
        this.validateIdValue(OU_NAME, name, DirObject.INVALID_EXTENDED_ID_CHARS, false);
        AttributeValidator.validateWhitespaces(OU_NAME, name);
    }

    public void validateNewRoleName(String name) {
        this.validateIdValue(ROLE_NAME, name, DirOrganizationalRole.INVALID_ID_CHARS, false);
        AttributeValidator.validateWhitespaces(ROLE_NAME, name);
    }

    public void validateOUName(String name, String fullName) {
        assert (fullName.toLowerCase().endsWith(name.toLowerCase())) : "OU name [" + name + "] is not included in full name [" + fullName + "]";
        this.validateIdValue(OU_NAME, name, DirObject.INVALID_EXTENDED_ID_CHARS, DirOrganizationalUnit.isRootId(name));
        AttributeValidator.validateWhitespaces(OU_NAME, name);
        AttributeValidator.validateCompositeValue(OU_FULL_NAME, fullName, DirObject.INVALID_EXTENDED_ID_CHARS, DirOrganizationalUnit.isRootId(name));
    }

    public void validateParametricValue(String parametricValue) {
        this.validateValue(PARAMETER_VALUE, parametricValue, DirOrganizationalRole.INVALID_ID_CHARS, false, this.getMaxParametricValueLength());
        AttributeValidator.validateWhitespaces(PARAMETER_VALUE, parametricValue);
    }

    public void validateParticipantId(String id) {
        if (this.validateParticipantValidCharacters) {
            this.validateIdValue(PARTICIPANT_ID, id, DirObject.INVALID_BASE_ID_CHARS, false);
        }
        AttributeValidator.validateWhitespaces(PARTICIPANT_ID, id);
    }

    public void validatePresentationId(String id) {
        this.validateIdValue(PRESENTATION_ID, id, null, false);
        AttributeValidator.validateWhitespaces(PRESENTATION_ID, id);
    }

    public void validateProcessDefinitionId(String id) {
        this.validateIdValue(PROCESS_DEFINITION_ID, id, DirObject.INVALID_EXTENDED_ID_CHARS, false);
        AttributeValidator.validateWhitespaces(PROCESS_DEFINITION_ID, id);
    }

    public final void validateValue(String attributeName, String value, char[] invalidChars, boolean emptyAllowed, int maxLength) {
        if (!(emptyAllowed || value != null && value.trim().length() != 0)) {
            throw InvalidAttributeValueException.valueEmpty(attributeName);
        }
        if (value.length() > maxLength) {
            throw InvalidAttributeValueException.lengthNotAllowed(attributeName, value, maxLength);
        }
        char[] valueArray = value.toCharArray();
        for (int i = 0; i < invalidChars.length; ++i) {
            for (int j = 0; j < valueArray.length; ++j) {
                if (invalidChars[i] != valueArray[j]) continue;
                throw InvalidAttributeValueException.invalidValue(attributeName, value, valueArray[j]);
            }
        }
    }

    public void validateViewId(String id) {
        this.validateIdValue(VIEW_ID, id, null, false);
        AttributeValidator.validateWhitespaces(VIEW_ID, id);
    }

    public void validateObjectClassInstanceName(String id) {
        this.validateIdValue(OBJECT_CLASS_INSTANCE_NAME, id, null, false);
        AttributeValidator.validateWhitespaces(OBJECT_CLASS_INSTANCE_NAME, id);
    }

    public boolean isValidCalendarName(String name) {
        return AttributeValidator.isValidValue(name, new char[0], false) && name.equals(name.trim());
    }

    public boolean isValidHolidayName(String name) {
        return AttributeValidator.isValidValue(name, new char[0], false) && name.equals(name.trim());
    }

    public void validateBusinessParameterId(String id) {
        AttributeValidator.validateAnyWhitespaces(BUSINESSPARAMETER_ID, id);
    }

    public void validateNewCalendarName(String name) {
        this.validateIdValue(CALENDAR_NAME, name, new char[0], false);
        AttributeValidator.validateWhitespaces(CALENDAR_NAME, name);
    }

    public void validateNewHolidayName(String name) {
        this.validateIdValue(HOLIDAY_NAME, name, new char[0], false);
        AttributeValidator.validateWhitespaces(HOLIDAY_NAME, name);
    }

    public void validateProcessVariableId(String id) {
        AttributeValidator.validateAnyWhitespaces(PROCESSVARIABLE_ID, id);
    }

    public void validateRoleAssignment(DirHumanParticipant.RoleAssignment roleAssignment) {
        this.validateNewRoleName(roleAssignment.role);
        if (roleAssignment.parametricValue != null) {
            this.validateParametricValue(roleAssignment.parametricValue);
        }
        if (roleAssignment.permissions < 0 || roleAssignment.permissions > 255) {
            throw InvalidAttributeValueException.invalidValue("Role permissions", String.valueOf(roleAssignment.permissions));
        }
    }

    public void validateOrganizationName(String organization) {
        this.validateIdValue(ORGANIZATION_NAME, organization, new char[0], false);
        AttributeValidator.validateWhitespaces(ORGANIZATION_NAME, organization);
    }

    public void validateEngineId(String id) {
        this.validateIdValue(ENGINE_ID, id, DirObject.INVALID_BASE_ID_CHARS, false);
        AttributeValidator.validateWhitespaces(ENGINE_ID, id);
    }

    public void validateBusinessRuleId(String id) {
        AttributeValidator.validateAnyWhitespaces(BUSINESSPARAMETER_ID, id);
    }

    public void validatePassword(PasswordPolicyContext context, String password) {
    }
}

