/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.AuthenticationException;
import fuego.directory.Directory;
import fuego.directory.exception.ProtocolNotSupportedException;
import java.io.Serializable;
import java.util.Map;
import oracle.bpm.lang.ConnectionPassport;
import oracle.bpm.log.Log;
import oracle.bpm.util.Properties;

public class DirectoryPassport
implements ConnectionPassport,
Serializable {
    private PasswordHolder holder_d;
    private String id_d;
    private boolean ignoreGlobalProperties;
    private String participant_d;
    private String preset_d;
    private Properties properties_d = new Properties();
    public static final String PARTICIPANT_PASSWORD = "participant_password";
    public static final String PARTICIPANT = "participant";
    static final long serialCheck = -4933834864295909335L;
    static final long serialVersionUID = 3666828476712770817L;

    private DirectoryPassport(String id, String participant) {
        this.participant_d = participant;
        this.id_d = id;
    }

    @Deprecated
    public static DirectoryPassport createStandaloneWithURL(String participant) {
        DirectoryPassport result = new DirectoryPassport(null, participant);
        result.ignoreGlobalProperties = true;
        return result;
    }

    public static DirectoryPassport createWithID(String id, String participant) {
        if (id == null || id.length() == 0) {
            throw new NullPointerException("id");
        }
        return new DirectoryPassport(id, participant);
    }

    public static DirectoryPassport createWithID(String id) {
        return DirectoryPassport.createWithID(id, null);
    }

    public static DirectoryPassport createWithIDAndPreset(String id, String preset) {
        if (id == null || id.length() == 0) {
            throw new NullPointerException("id");
        }
        if (preset == null || preset.length() == 0) {
            throw new NullPointerException("preset");
        }
        DirectoryPassport result = new DirectoryPassport(id, null);
        result.preset_d = preset;
        return result;
    }

    @Deprecated
    public static DirectoryPassport createWithURLAndPreset(String url, String preset) {
        return DirectoryPassport.createWithIDAndPreset("default", preset);
    }

    @Deprecated
    public static DirectoryPassport createWithURL(String url, String participant) {
        return new DirectoryPassport("default", participant);
    }

    @Deprecated
    public static DirectoryPassport createWithURL(String url) {
        return DirectoryPassport.createWithID(url, null);
    }

    @Override
    public boolean isAnonymous() {
        if (this.preset_d == null || this.participant_d != null) {
            return this.participant_d == null;
        }
        return this.lookupProperty(PARTICIPANT) == null;
    }

    @Override
    public String getId() {
        return this.id_d;
    }

    @Override
    public void setParticipant(String participant) {
        this.participant_d = participant;
    }

    public String getParticipant() {
        String result;
        String string = result = this.preset_d == null || this.participant_d != null ? this.participant_d : this.lookupProperty(PARTICIPANT);
        if (result != null && (result = result.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    @Override
    public void setPassword(String password) {
        this.holder_d = new PasswordHolder(password);
    }

    public String getPassword() {
        String result;
        String string = this.preset_d == null || this.holder_d != null ? (this.holder_d != null ? this.holder_d.password : null) : (result = this.lookupProperty(PARTICIPANT_PASSWORD));
        if (result != null && result.length() == 0) {
            result = null;
        }
        return result;
    }

    @Override
    public String getPreset() {
        return this.preset_d;
    }

    public Properties getProperties() {
        return this.properties_d;
    }

    @Override
    public Object getProperty(String property) {
        return this.properties_d.get(property);
    }

    @Deprecated
    public String getRealUrl() {
        return null;
    }

    @Override
    @Deprecated
    public String getUrl() {
        return null;
    }

    @Override
    public void fillPassport() {
        try {
            Directory.fillPassport(this);
        }
        catch (ProtocolNotSupportedException e) {
            Log.logWarning(e);
        }
        catch (AuthenticationException e) {
            Log.logWarning(e);
        }
    }

    public String lookupProperty(String key) {
        return this.lookupProperty(key, false);
    }

    public String lookupProperty(String key, boolean ignoreProperties) {
        String result = this.properties_d.getProperty(key);
        if (result == null && !this.ignoreGlobalProperties && !ignoreProperties) {
            result = Directory.getPropertyManager(this.getId()).lookupProperty(key, this.getPreset(), this.participant_d, this.id_d);
        }
        return result;
    }

    @Override
    public void putProperties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> objectObjectEntry : properties.entrySet()) {
                Map.Entry<Object, Object> entry = objectObjectEntry;
                if (!(entry.getKey() instanceof String)) continue;
                this.putProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void putProperty(String property, Object value) {
        this.properties_d.put(property, value);
    }

    private static class PasswordHolder
    implements Serializable {
        String password;
        static final long serialCheck = -1572205443782689379L;
        static final long serialVersionUID = 1539132637159060188L;

        PasswordHolder(String password) {
            this.password = password;
        }
    }
}

