/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.BusinessParameterMapping;
import fuego.directory.ConfMapping;
import fuego.directory.DirDeployedProcess;
import fuego.directory.DirObject;
import fuego.directory.DirProcessDefinition;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.RoleMapping;
import fuego.directory.VarMapping;
import fuego.directory.exception.OperationNotSupportedException;
import oracle.bpm.util.ArrayUtils;

public class DirProjectRevision
extends DirObject {
    protected BusinessParameterMapping[] businessParameterMappings;
    protected ConfMapping[] confMapping;
    protected VarMapping[] varMapping;
    private int major;
    private int minor;
    private String projectName;
    private String remarks;
    private int revision;
    public static final String JSP_JAR_ENTRY = "JSP.jar";
    public static final String WEB_RESOURCES_JAR_ENTRY = "WEB_RESOURCES.jar";
    public static final String JCL_PREFIX = "fuegojcl-";
    public static final String CATALOG_ENTRY = "catalog";
    static final long serialVersionUID = -6407098642582443873L;
    static final long serialCheck = 3578623009229896521L;

    public DirProjectRevision(DirectorySession session, int in, String projectName, int major, int minor, int revision, String remarks, VarMapping[] varmap, ConfMapping[] confmap, BusinessParameterMapping[] businessParameterMappings, String internalId) {
        super(session, in, internalId);
        this.projectName = projectName;
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.remarks = remarks;
        this.varMapping = varmap;
        this.businessParameterMappings = businessParameterMappings;
        this.confMapping = confmap;
    }

    public static DirProjectRevision create(DirectorySession session, String projectName, int major, int minor, int revision, String remarks, int[] jars, VarMapping[] varMapping, ConfMapping[] confMapping, BusinessParameterMapping[] businessParameterMappings) throws DirectoryException {
        Directory.checkSession(session);
        assert (jars != null);
        assert (varMapping != null);
        assert (confMapping != null);
        varMapping = ArrayUtils.trim(varMapping);
        confMapping = ArrayUtils.trim(confMapping);
        businessParameterMappings = ArrayUtils.trim(businessParameterMappings);
        return session.getProjectAccessor().createProjectRevision(projectName, major, minor, revision, remarks, jars, varMapping, confMapping, businessParameterMappings);
    }

    public static DirProjectRevision fetch(DirectorySession session, int in) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchProjectRevisionByIn(in);
    }

    public static DirProjectRevision[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchAll();
    }

    public static String[] fetchAllProjectNames(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchAllProjectNames();
    }

    public static DirProjectRevision[] fetchByProjectName(DirectorySession session, String projectName) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchProjectRevisionsByProjectName(projectName);
    }

    public BusinessParameterMapping[] getBusinessParameterMappings() {
        return this.businessParameterMappings;
    }

    public ConfMapping[] getConfMapping() {
        return this.confMapping;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public int getRevision() {
        return this.revision;
    }

    public VarMapping[] getVarMapping() {
        return this.varMapping;
    }

    public void addProcessDefinitions(DirProcessDefinition[] processDefinitions, RoleMapping[][] processDefinitionRoleMappings) throws DirectoryException {
        this.getDirectorySession().getProjectAccessor().addProcessDefinitions(this, processDefinitions, processDefinitionRoleMappings);
    }

    public String getDeployedId() {
        return this.projectName + "-" + this.getMajor() + "." + this.getMinor();
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.projectName + "-" + this.getMajor() + "." + this.getMinor() + "." + this.getRevision();
    }

    public int compareTo(DirProjectRevision other) {
        if (this.getMajor() < other.getMajor()) {
            return -1;
        }
        if (this.getMajor() > other.getMajor()) {
            return 1;
        }
        if (this.getMinor() < other.getMinor()) {
            return -1;
        }
        if (this.getMinor() > other.getMinor()) {
            return 1;
        }
        if (this.getRevision() < other.getRevision()) {
            return -1;
        }
        if (this.getRevision() > other.getRevision()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getProjectAccessor().deleteProjectRevision(this);
        this.getDirectoryAdministratorSession().getProcessAccessor().deleteUnusedProcesses();
    }

    public DirDeployedProcess[] fetchDeployedProcesses(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchDeployedProcesses(this);
    }

    public int[] fetchJars() throws DirectoryException {
        return this.getDirectorySession().getProjectAccessor().fetchPublishedCatalogJars(this.in_d);
    }

    public DirProcessDefinition[] fetchProcesses() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchProcessDefinitionsForProjectRevision(this);
    }

    public RoleMapping[] fetchRoleMapping(DirProcessDefinition processDefinition) throws DirectoryException {
        return this.getDirectorySession().getProjectAccessor().fetchRoleMapping(this, processDefinition);
    }

    @Override
    public void refresh() throws DirectoryException {
        throw new OperationNotSupportedException("refresh", this.getId());
    }

    @Override
    public void update() throws DirectoryException {
        throw new OperationNotSupportedException("update", this.getId());
    }
}

