/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import oracle.bpm.xml.XmlWriter;

public class DirPresentation
extends DirObject {
    private String id;
    private String properties;
    private int type;
    public static final String ELEM_PRESENTATION = "DirPresentation";
    public static final String ELEM_ID = "id";
    public static final String ELEM_PROPERTIES = "properties";
    public static final String ELEM_TYPE = "type";
    static final long serialVersionUID = -3106592980681000743L;
    static final long serialCheck = 5693201951303044772L;

    public DirPresentation(DirectorySession session, String id, int type, String properties, String internalId) {
        this(session, -1, id, type, properties, internalId);
    }

    public DirPresentation(DirectorySession session, int in, String id, int type, String properties, String internalId) {
        super(session, in, internalId);
        this.id = id;
        this.properties = properties;
        this.type = type;
    }

    public static DirPresentation create(DirectorySession session, String id, int type, String properties) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAttributeValidator().validatePresentationId(id);
        return session.getOrganizationAccessor().createPresentation(id, type, properties);
    }

    public static DirPresentation fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchPresentation(id);
    }

    public static DirPresentation[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchAllPresentations();
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().deletePresentation(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().refreshPresentation(this);
    }

    @Override
    public String toString() {
        return "type:" + this.getType() + ",properties:" + this.getProperties() + "|" + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().updatePresentation(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_PRESENTATION);
        xmlWriter.printValuedElement(ELEM_ID, this.getId());
        xmlWriter.printValuedElement(ELEM_TYPE, String.valueOf(this.getType()));
        xmlWriter.printCDATAElement(ELEM_PROPERTIES, this.getProperties());
        xmlWriter.endElement();
    }
}

