/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import oracle.bpm.xml.XmlWriter;

public class DirHolidayRule
extends DirObject {
    protected String name_d;
    protected String properties_d;
    public static final String ELEM_HOL_RULE = "DirHolidayRule";
    static final long serialVersionUID = -8067535603112238267L;
    static final long serialCheck = -3748384282379240852L;

    public DirHolidayRule(DirectorySession session, String name, String properties, String internalId) {
        this(session, -1, name, properties, internalId);
    }

    public DirHolidayRule(DirectorySession session, int in, String name, String properties, String internalId) {
        super(session, in, internalId);
        this.name_d = name;
        this.properties_d = properties;
    }

    public static DirHolidayRule create(DirectorySession session, String name, String properties) throws DirectoryException {
        Directory.checkSession(session);
        session.getAttributeValidator().validateNewHolidayName(name);
        return session.getOrganizationAccessor().createHolidayRule(name, properties);
    }

    public static DirHolidayRule fetch(DirectorySession session, String name) throws DirectoryException {
        Directory.checkSession(session);
        if (!session.getAttributeValidator().isValidHolidayName(name)) {
            return null;
        }
        return session.getOrganizationAccessor().fetchHolidayRule(name);
    }

    public static DirHolidayRule[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchAllHolidayRules();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public void setHolidayCalendar(String holidayCalendar) {
        this.setProperties(holidayCalendar);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name_d;
    }

    public void setProperties(String properties) {
        this.properties_d = properties;
    }

    public String getProperties() {
        return this.properties_d;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().deleteHolidayRule(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().refreshHolidayRule(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().updateHolidayRule(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_HOL_RULE);
        xmlWriter.printValuedElement("name", this.getName());
        xmlWriter.printCDATAElement("properties", this.getProperties(), true);
        xmlWriter.endElement();
    }
}

