/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.tutor.ConvertOptionsDialog;
import oracle.tutor.ModelTypeAttributes;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.ProgressDialog;
import oracle.tutor.docx.TutorDoc;
import oracle.tutor.visio.UserCancelException;
import oracle.tutor.xpdl.Utility;

public class TempIO {
    private static File _sPriorOpenedFolder = null;
    private static Map<ModelType, ModelTypeAttributes> _sModelTypes = null;

    private ModelTypeAttributes createModelTypeAttributes(String name, String extension, boolean multiplePages, ModelTypeAttributes.PoolSupportType poolSupport) {
        ModelTypeAttributes modelTypeAttrs = new ModelTypeAttributes();
        modelTypeAttrs.setName(name);
        modelTypeAttrs.setPoolSupport(poolSupport);
        modelTypeAttrs.setExtension(extension);
        modelTypeAttrs.setMultiplePages(multiplePages);
        return modelTypeAttrs;
    }

    private void _initModelTypes() {
        _sModelTypes = new HashMap<ModelType, ModelTypeAttributes>();
        ModelTypeAttributes tutorAttrs = this.createModelTypeAttributes("Oracle Tutor", "docx", false, ModelTypeAttributes.PoolSupportType.UPSTREAM_DOWNSTREAM);
        ModelTypeAttributes visioAttrs = this.createModelTypeAttributes("Visio", "vdx", true, ModelTypeAttributes.PoolSupportType.MULTIPLE);
        ModelTypeAttributes xpdlAttrs = this.createModelTypeAttributes("XPDL", "xpdl", true, ModelTypeAttributes.PoolSupportType.MULTIPLE);
        ModelTypeAttributes bpmAttrs = this.createModelTypeAttributes("Oracle BPM", "bpmn", false, ModelTypeAttributes.PoolSupportType.NONE);
        ModelTypeAttributes bpaAttrs = this.createModelTypeAttributes("Oracle BPA", null, false, ModelTypeAttributes.PoolSupportType.MULTIPLE);
        _sModelTypes.put(ModelType.TUTOR, tutorAttrs);
        _sModelTypes.put(ModelType.VISIO, visioAttrs);
        _sModelTypes.put(ModelType.XPDL, xpdlAttrs);
        _sModelTypes.put(ModelType.BPA, bpaAttrs);
        _sModelTypes.put(ModelType.BPM, bpmAttrs);
    }

    ConvertOptionsDialog getConvertOptionsDialog(int numFiles, BusinessProcessDiagram[] bpdArray, ModelTypeAttributes srcModelType, ModelTypeAttributes tgtModelType) {
        ConvertOptionsDialog tempDlg = null;
        if (numFiles == 1) {
            if (bpdArray.length == 1) {
                if (srcModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.MULTIPLE) {
                    if (tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.NONE && bpdArray[0].getPools().size() > 1) {
                        tempDlg = new ConvertOptionsDialog();
                        tempDlg.showOption(ConvertOptionsDialog.ShowOption.SPLIT_OR_MERGE);
                        tempDlg.showOption(ConvertOptionsDialog.ShowOption.CHOOSE_POOLS);
                        for (Pool pool : bpdArray[0].getPools().values()) {
                            tempDlg.addName(pool.getName());
                        }
                    } else if (tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.UPSTREAM_DOWNSTREAM && bpdArray[0].getPools().size() > 1) {
                        tempDlg = new ConvertOptionsDialog();
                        tempDlg.showOption(ConvertOptionsDialog.ShowOption.SPLIT_OR_MERGE);
                    }
                } else if (srcModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.UPSTREAM_DOWNSTREAM) {
                    if (tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.MULTIPLE) {
                        tempDlg = new ConvertOptionsDialog();
                        tempDlg.showOption(ConvertOptionsDialog.ShowOption.SPECIFY_POOL);
                    } else if (tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.NONE && bpdArray[0].getPools().size() > 1) {
                        tempDlg = new ConvertOptionsDialog();
                        tempDlg.showOption(ConvertOptionsDialog.ShowOption.FORCE_MERGE);
                    }
                }
            } else if (bpdArray.length > 1 && srcModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.MULTIPLE && tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.NONE && srcModelType.containsMultiplePages() && !tgtModelType.containsMultiplePages()) {
                tempDlg = new ConvertOptionsDialog();
                tempDlg.showOption(ConvertOptionsDialog.ShowOption.SPLIT_OR_MERGE);
            }
        } else if (numFiles > 1) {
            if (bpdArray.length == 1) {
                if (srcModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.MULTIPLE && tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.NONE) {
                    tempDlg = new ConvertOptionsDialog();
                    tempDlg.showOption(ConvertOptionsDialog.ShowOption.SPLIT_OR_MERGE);
                }
            } else if (bpdArray.length > 1 && srcModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.MULTIPLE && tgtModelType.getPoolSupport() == ModelTypeAttributes.PoolSupportType.NONE && srcModelType.containsMultiplePages() && !tgtModelType.containsMultiplePages()) {
                tempDlg = new ConvertOptionsDialog();
                tempDlg.showOption(ConvertOptionsDialog.ShowOption.SPLIT_OR_MERGE);
            }
        }
        tempDlg.createConvertOptionsDialog();
        return tempDlg;
    }

    public void importModel(ModelType[] sourceModelTypes, ModelType targetModelType, String xmlFolder, ProgressDialog progressDlg) throws UserCancelException {
        JFileChooser fileChooser = null;
        File[] importFiles = null;
        BusinessProcessDiagram[] bpdArray = null;
        fileChooser = _sPriorOpenedFolder == null ? new JFileChooser() : new JFileChooser(_sPriorOpenedFolder);
        ModelTypeAttributes tgtTypeAttrs = _sModelTypes.get((Object)targetModelType);
        if (sourceModelTypes == null) {
            sourceModelTypes = new ModelType[]{ModelType.TUTOR, ModelType.XPDL, ModelType.VISIO};
        }
        for (ModelType srcType : sourceModelTypes) {
            if (srcType == targetModelType) continue;
            ModelTypeAttributes srcTypeAttrs = _sModelTypes.get((Object)srcType);
            String extName = srcTypeAttrs.getName();
            String extension = srcTypeAttrs.getExtension();
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter(extName, extension));
        }
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(true);
        int result = fileChooser.showOpenDialog(null);
        if (result == 1) {
            return;
        }
        if (result == -1) {
            return;
        }
        if (result == 0) {
            _sPriorOpenedFolder = fileChooser.getCurrentDirectory();
            importFiles = fileChooser.getSelectedFiles();
            ModelType[] selectedTypes = new ModelType[importFiles.length];
            int ctr = 0;
            int xpdlctr = 0;
            int visioctr = 0;
            int docxctr = 0;
            for (File file : importFiles) {
                if (xpdlctr < 1 && "xpdl".equalsIgnoreCase(file.getName().substring(file.getName().lastIndexOf(".")))) {
                    selectedTypes[ctr] = ModelType.XPDL;
                    ++xpdlctr;
                    continue;
                }
                if (visioctr < 1 && "vdx".equalsIgnoreCase(file.getName().substring(file.getName().lastIndexOf(".")))) {
                    selectedTypes[ctr] = ModelType.VISIO;
                    ++visioctr;
                    continue;
                }
                if (docxctr >= true || !"docx".equalsIgnoreCase(file.getName().substring(file.getName().lastIndexOf(".")))) continue;
                selectedTypes[ctr] = ModelType.TUTOR;
                ++docxctr;
            }
            if (importFiles.length == 1) {
                File file = importFiles[0];
                ModelTypeAttributes srcModelType = _sModelTypes.get((Object)selectedTypes[0]);
                try {
                    switch (selectedTypes[0]) {
                        case XPDL: {
                            bpdArray = Utility.importFromXPDL((String)file.getAbsolutePath(), (String)xmlFolder);
                            break;
                        }
                        case VISIO: {
                            oracle.tutor.visio.Utility util = new oracle.tutor.visio.Utility();
                            bpdArray = util.importVdx(file.getAbsolutePath(), progressDlg, 100, xmlFolder);
                            break;
                        }
                        case TUTOR: {
                            TutorDoc td = new TutorDoc();
                            td.loadDocx(file.getAbsolutePath());
                            bpdArray[0] = td.getBpdDiagram("Enterprise");
                            break;
                        }
                    }
                }
                catch (UserCancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static enum ModelType {
        TUTOR,
        VISIO,
        XPDL,
        BPM,
        BPA;

    }
}

