/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.msg;

import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TErrorMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PmlSecurityMsg
extends MsgBundle {
    public static final ErrorMsg IDENTITY_SERVICE_ERROR = PmlSecurityMsg.errorMsg("Error while creating the security service", "The Identity Service could not be created", "");
    private static final TErrorMsg IDENTITY_STORE_ERROR = PmlSecurityMsg.tErrorMsg("Error in the Identity Store", "%0", "");
    public static final ErrorMsg IDENTITY_STORE_NOT_SUPPORTED = PmlSecurityMsg.errorMsg("Error in the Identity Store", "A non supported Identity Store has been detected", "");
    private static final TErrorMsg SERVICE_CREATION_ERROR = PmlSecurityMsg.tErrorMsg("Error while creating the security service", "%0", "");
    public static final Msg SERVICE_CREATION_ERROR_DESCRIPTION = PmlSecurityMsg.msg("An error occurred during the creation of the security service");
    public static final Msg SECURITY_SERVICE_CLASS_NOT_FOUND = PmlSecurityMsg.msg("PML security class oracle.bpm.services.pml.impl.OpssCoreHelperImpl could not be loaded");
    public static final ErrorMsg MIGRATION_ERROR = PmlSecurityMsg.errorMsg("Error detected", "An error occurred during BPM Role Security Migration", "");
    public static final TErrorMsg POLICY_STORE_ERROR = PmlSecurityMsg.tErrorMsg("An error in the policy store prevents the action from being performed", "%0", "");
    private static final TErrorMsg GENERIC_SECURITY_ERROR = PmlSecurityMsg.tErrorMsg("Generic Security Error", "%0", "");
    private static final TErrorMsg SECURED_OBJECT_NOT_FOUND = PmlSecurityMsg.tErrorMsg("Secured object %0 not found", "The object %0 could not be found in the repository", "");
    private static final TErrorMsg PROJECT_ALREADY_EXISTS = PmlSecurityMsg.tErrorMsg("The project '%0' already exists", "A project with the same name was found in the specified location", "Either change the name of the project or ask for EDITOR permissions on this project");
    private static final TErrorMsg INSUFFICIENT_RIGHTS = PmlSecurityMsg.tErrorMsg("User '%0' has insufficient privileges for the current operation", "The user was unable to complete the requested action due to insufficient rights (Required Role: %1, Current Role: %2)", "");
    public static final Msg PROJECT_ROLE_OWNER = PmlSecurityMsg.msg("Owner");
    public static final Msg PROJECT_ROLE_EDITOR = PmlSecurityMsg.msg("Editor");
    public static final Msg PROJECT_ROLE_VIEWER = PmlSecurityMsg.msg("Viewer");
    public static final Msg PROJECT_NO_ROLE = PmlSecurityMsg.msg("No Role");

    public static ErrorMsg SECURED_OBJECT_NOT_FOUND(@NotNull String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.SECURED_OBJECT_NOT_FOUND must not be null");
        }
        return SECURED_OBJECT_NOT_FOUND.args(resourceName);
    }

    public static ErrorMsg PROJECT_ALREADY_EXISTS(@NotNull String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.PROJECT_ALREADY_EXISTS must not be null");
        }
        return PROJECT_ALREADY_EXISTS.args(resourceName);
    }

    public static ErrorMsg INSUFFICIENT_RIGHTS(@NotNull String userName, @NotNull ProjectRole requiredRole, @Nullable ProjectRole currentRole) {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.INSUFFICIENT_RIGHTS must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.INSUFFICIENT_RIGHTS must not be null");
        }
        String role = currentRole == null ? PROJECT_NO_ROLE.getString() : currentRole.getString();
        return INSUFFICIENT_RIGHTS.args(userName, requiredRole.getString(), role);
    }

    public static ErrorMsg GENERIC_SECURITY_ERROR(@NotNull String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.GENERIC_SECURITY_ERROR must not be null");
        }
        return GENERIC_SECURITY_ERROR.args(exceptionMessage);
    }

    public static ErrorMsg POLICY_STORE_ERROR(@NotNull String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.POLICY_STORE_ERROR must not be null");
        }
        return POLICY_STORE_ERROR.args(exceptionMessage);
    }

    public static ErrorMsg IDENTITY_STORE_ERROR(@NotNull String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.IDENTITY_STORE_ERROR must not be null");
        }
        return IDENTITY_STORE_ERROR.args(exceptionMessage);
    }

    public static ErrorMsg SERVICE_CREATION_ERROR(@NotNull String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/msg/PmlSecurityMsg.SERVICE_CREATION_ERROR must not be null");
        }
        return SERVICE_CREATION_ERROR.args(exceptionMessage);
    }

    static {
        PmlSecurityMsg.init(PmlSecurityMsg.class, LogComponent.DEFAULT, ErrorRange.PML_SECURITY, 80100, 80199);
    }
}

