/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.model;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public enum ProjectAction {
    VIEW("view"),
    EDIT("edit"),
    DOCUMENT("document"),
    DELETE("delete"),
    DEPLOY("deploy"),
    GRANT("grant");

    private String name;
    private static final char SEPARATOR = ',';
    private static final Pattern SPLITTER;

    private ProjectAction(String actionName) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectAction.<init> must not be null");
        }
        this.name = actionName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static ProjectAction valueOfAction(@NotNull String actionName) {
        if (actionName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectAction.valueOfAction must not be null");
        }
        ProjectAction result = null;
        for (ProjectAction action : ProjectAction.values()) {
            if (!actionName.equals(action.name)) continue;
            result = action;
            break;
        }
        return result;
    }

    public static EnumSet<ProjectAction> fromString(@NotNull String actionsString) {
        String[] actions;
        if (actionsString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectAction.fromString must not be null");
        }
        EnumSet<ProjectAction> result = EnumSet.noneOf(ProjectAction.class);
        for (String action : actions = SPLITTER.split(actionsString)) {
            ProjectAction projectAction = ProjectAction.valueOfAction(action);
            if (projectAction == null) continue;
            result.add(projectAction);
        }
        return result;
    }

    public static String toString(@NotNull EnumSet<ProjectAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectAction.toString must not be null");
        }
        StringBuffer result = new StringBuffer();
        for (ProjectAction action : actions) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(action.getName());
        }
        return result.toString();
    }

    public static Set<String> toStringSet(@NotNull EnumSet<ProjectAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectAction.toStringSet must not be null");
        }
        HashSet<String> result = new HashSet<String>();
        for (ProjectAction action : actions) {
            result.add(action.getName());
        }
        return result;
    }

    public static List<String> toStringList(@NotNull EnumSet<ProjectAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectAction.toStringList must not be null");
        }
        LinkedList<String> result = new LinkedList<String>();
        for (ProjectAction action : actions) {
            result.add(action.getName());
        }
        return result;
    }

    static {
        SPLITTER = Pattern.compile(Character.toString(','));
    }
}

