/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.impl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.impl.ProjectPolicyImpl;
import oracle.bpm.pml.security.impl.SecuredProjectImpl;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectPolicies;
import oracle.bpm.pml.security.model.ProjectPolicy;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import oracle.bpm.pml.security.service.PmlSecurityService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPoliciesImpl
implements ProjectPolicies {
    private boolean isPublic;
    private Map<ProjectRole, ProjectPolicy> policies;
    private String projectId;
    private PmlSecurityService service;
    private Set<String> totalUsers;
    private static final long serialVersionUID = -1504874887701060516L;

    public ProjectPoliciesImpl(@NotNull PmlSecurityService service, @NotNull String projectId) throws PmlSecurityException {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.<init> must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.<init> must not be null");
        }
        this.projectId = projectId;
        this.policies = new HashMap<ProjectRole, ProjectPolicy>();
        this.service = service;
        this.totalUsers = new HashSet<String>();
        this.loadPolicies();
    }

    @Override
    public String getProjectName() {
        return this.projectId;
    }

    @Override
    public ProjectPolicy getPolicyFor(@NotNull ProjectRole projectRole) {
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.getPolicyFor must not be null");
        }
        return this.policies.get(projectRole);
    }

    @Override
    public ProjectPolicy getPolicy() throws PmlSecurityException {
        ProjectPolicy result = null;
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            ProjectPolicy policy;
            if (result != null && !role.implies(result.getSecuredProject().getProjectRole()) || !(policy = this.getPolicyFor(role)).isGrantedTo(this.service.getPrincipal())) continue;
            result = policy;
        }
        return result;
    }

    @Override
    public void setPolicy(@NotNull ProjectPolicy projectPolicy) throws PmlSecurityException {
        if (projectPolicy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.setPolicy must not be null");
        }
        SecuredProject securedProject = projectPolicy.getSecuredProject();
        ProjectRole role = securedProject.getProjectRole();
        this.policies.get(role).setPrincipals(projectPolicy.getPrincipals());
    }

    @Override
    public void setPrincipals(@NotNull ProjectRole projectRole, @Nullable Set<String> principals) {
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.setPrincipals must not be null");
        }
        this.policies.get(projectRole).setPrincipals(principals);
    }

    @Override
    public void addPrincipal(@NotNull ProjectRole projectRole, @NotNull String principal) {
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.addPrincipal must not be null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.addPrincipal must not be null");
        }
        HashSet<String> principals = new HashSet<String>();
        principals.add(principal);
        this.addPrincipals(projectRole, principals);
    }

    @Override
    public void addPrincipals(@NotNull ProjectRole projectRole, @NotNull Set<String> principals) {
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.addPrincipals must not be null");
        }
        if (principals == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.addPrincipals must not be null");
        }
        this.policies.get(projectRole).addPrincipals(principals);
    }

    @Override
    public void removePrincipal(@NotNull ProjectRole projectRole, @NotNull String principal) {
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.removePrincipal must not be null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.removePrincipal must not be null");
        }
        HashSet<String> principals = new HashSet<String>();
        principals.add(principal);
        this.removePrincipals(projectRole, principals);
    }

    @Override
    public void removePrincipals(@NotNull ProjectRole projectRole, @NotNull Set<String> principals) {
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.removePrincipals must not be null");
        }
        if (principals == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPoliciesImpl.removePrincipals must not be null");
        }
        this.policies.get(projectRole).removePrincipals(principals);
    }

    @Override
    public void save() throws PmlSecurityException {
        this.service.assertPrivilege(this.projectId, ProjectRole.OWNER);
        EnumSet<ProjectRole> dirtyRoles = EnumSet.noneOf(ProjectRole.class);
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            if (!this.policies.get(role).resetDirty()) continue;
            dirtyRoles.add(role);
        }
        this.service.revokeProjectRoles(dirtyRoles, this.projectId);
        String applicationName = this.service.getApplicationName();
        for (ProjectRole role : dirtyRoles) {
            ProjectPolicy policy = this.policies.get(role);
            HashSet<PmlPrincipal> principals = new HashSet<PmlPrincipal>();
            if (policy.isEmpty()) continue;
            for (String userName : policy.getPrincipals()) {
                principals.add(new PmlPrincipal(userName, applicationName));
            }
            if (policy.isPublic()) {
                principals.add(PmlPrincipal.getPublicPrincipal(applicationName));
            }
            this.service.grantProjectRole(role, this.projectId, principals);
        }
        this.updateIsShared();
    }

    @Override
    public boolean isShared() {
        return this.isPublic || this.totalUsers.size() > 1;
    }

    private void updateIsShared() throws PmlSecurityException {
        this.isPublic = false;
        this.totalUsers.clear();
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            this.totalUsers.addAll(this.policies.get(role).getPrincipals());
            if (!this.policies.get(role).isPublic()) continue;
            this.isPublic = true;
        }
        ProjectPolicy policy = this.getPolicy();
        boolean isOwner = policy != null && policy.getSecuredProject().getProjectRole().implies(ProjectRole.OWNER);
        boolean isShared = this.isShared();
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            SecuredProject project = this.getPolicyFor(role).getSecuredProject();
            project.setIsShared(isShared);
            project.setIsOwner(isOwner);
        }
    }

    private void loadPolicies() throws PmlSecurityException {
        Map<ProjectRole, Set<String>> projectPolicies = this.service.getProjectGrants(this.projectId);
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            SecuredProjectImpl project = new SecuredProjectImpl(this.projectId, role);
            this.policies.put(role, new ProjectPolicyImpl(this.service.getApplicationName(), project, projectPolicies.get(role)));
        }
        this.updateIsShared();
    }
}

