/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.impl;

import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.impl.ProjectPoliciesImpl;
import oracle.bpm.pml.security.model.ProjectPolicies;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.service.PmlSecurityManagerService;
import oracle.bpm.pml.security.service.PmlSecurityService;
import org.jetbrains.annotations.NotNull;

public class PmlSecurityManagerServiceImpl
implements PmlSecurityManagerService {
    private PmlSecurityService service;

    public PmlSecurityManagerServiceImpl(@NotNull PmlSecurityService service) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityManagerServiceImpl.<init> must not be null");
        }
        this.service = service;
    }

    @Override
    public ProjectPolicies getProjectPolicies(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityManagerServiceImpl.getProjectPolicies must not be null");
        }
        this.service.assertPrivilege(projectId, ProjectRole.VIEWER);
        return new ProjectPoliciesImpl(this.service, projectId);
    }

    @Override
    public void saveProjectPolicies(@NotNull ProjectPolicies policy) throws PmlSecurityException {
        if (policy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityManagerServiceImpl.saveProjectPolicies must not be null");
        }
        policy.save();
    }
}

