/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.exception;

import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.msg.PmlSecurityMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PmlSecurityPermissionDeniedException
extends PmlSecurityException {
    private ProjectRole userRole;
    private static final long serialVersionUID = 3823120649600449454L;

    public PmlSecurityPermissionDeniedException(@NotNull String userName, @NotNull ProjectRole requiredRole, @Nullable ProjectRole currentRole) {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityPermissionDeniedException.<init> must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityPermissionDeniedException.<init> must not be null");
        }
        super(PmlSecurityMsg.INSUFFICIENT_RIGHTS(userName, requiredRole, currentRole));
        this.userRole = currentRole;
    }

    public PmlSecurityPermissionDeniedException(@NotNull String userName, @NotNull ProjectRole requiredRole, @Nullable ProjectRole currentRole, @NotNull Throwable cause) {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityPermissionDeniedException.<init> must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityPermissionDeniedException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityPermissionDeniedException.<init> must not be null");
        }
        super(PmlSecurityMsg.INSUFFICIENT_RIGHTS(userName, requiredRole, currentRole), cause);
        this.userRole = currentRole;
    }

    public ProjectRole getUserRole() {
        return this.userRole;
    }

    public boolean hasPermissions() {
        return this.userRole != null;
    }
}

