/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.exception;

import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityObjectNotFoundException;
import oracle.bpm.pml.security.exception.PmlSecurityPermissionDeniedException;
import oracle.bpm.pml.security.exception.PmlSecurityProjectAlreadyExistsException;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.msg.PmlSecurityMsg;
import oracle.security.jps.JpsException;
import oracle.security.jps.service.idstore.IdentityStoreException;
import oracle.security.jps.service.policystore.PolicyStoreException;
import oracle.tip.pc.services.identity.BPMIdentityException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PmlSecurityExceptionFactory {
    public static PmlSecurityObjectNotFoundException createObjectNotFoundException(@NotNull String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createObjectNotFoundException must not be null");
        }
        return new PmlSecurityObjectNotFoundException(PmlSecurityMsg.SECURED_OBJECT_NOT_FOUND(resourceName));
    }

    public static PmlSecurityObjectNotFoundException createObjectNotFoundException(@NotNull String resourceName, @NotNull PolicyStoreException cause) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createObjectNotFoundException must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createObjectNotFoundException must not be null");
        }
        return new PmlSecurityObjectNotFoundException(PmlSecurityMsg.SECURED_OBJECT_NOT_FOUND(resourceName), (Throwable)cause);
    }

    public static PmlSecurityObjectNotFoundException createObjectNotFoundException(@NotNull String resourceName, @NotNull BPMIdentityException cause) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createObjectNotFoundException must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createObjectNotFoundException must not be null");
        }
        return new PmlSecurityObjectNotFoundException(PmlSecurityMsg.SECURED_OBJECT_NOT_FOUND(resourceName), (Throwable)cause);
    }

    public static PmlSecurityProjectAlreadyExistsException createProjectAlreadyExistsException(@NotNull String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createProjectAlreadyExistsException must not be null");
        }
        return new PmlSecurityProjectAlreadyExistsException(PmlSecurityMsg.PROJECT_ALREADY_EXISTS(resourceName));
    }

    public static PmlSecurityProjectAlreadyExistsException createProjectAlreadyExistsException(@NotNull String resourceName, @NotNull PmlSecurityPermissionDeniedException cause) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createProjectAlreadyExistsException must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createProjectAlreadyExistsException must not be null");
        }
        return new PmlSecurityProjectAlreadyExistsException(PmlSecurityMsg.PROJECT_ALREADY_EXISTS(resourceName), (Throwable)cause);
    }

    public static PmlSecurityPermissionDeniedException createPermissionDeniedException(@NotNull String userName, @NotNull ProjectRole requiredRole, @Nullable ProjectRole currentRole) {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createPermissionDeniedException must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createPermissionDeniedException must not be null");
        }
        return new PmlSecurityPermissionDeniedException(userName, requiredRole, currentRole);
    }

    public static PmlSecurityPermissionDeniedException createPermissionDeniedException(@NotNull String userName, @NotNull ProjectRole requiredRole, @Nullable ProjectRole currentRole, @NotNull PmlSecurityPermissionDeniedException cause) {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createPermissionDeniedException must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createPermissionDeniedException must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createPermissionDeniedException must not be null");
        }
        return new PmlSecurityPermissionDeniedException(userName, requiredRole, currentRole, cause);
    }

    public static PmlSecurityException createServiceCreationException(@NotNull WorkflowException e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createServiceCreationException must not be null");
        }
        String message = String.format("(%d) %s", e.getErrorCode(), e.getMessage());
        return new PmlSecurityException(PmlSecurityMsg.SERVICE_CREATION_ERROR(message), (Throwable)e);
    }

    public static PmlSecurityException createServiceCreationException(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createServiceCreationException must not be null");
        }
        String cause = PmlSecurityMsg.SECURITY_SERVICE_CLASS_NOT_FOUND.getString();
        return new PmlSecurityException(PmlSecurityMsg.SERVICE_CREATION_ERROR(cause), (Throwable)e);
    }

    public static PmlSecurityException createSecurityException(@NotNull PolicyStoreException e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createSecurityException must not be null");
        }
        String message = String.format("(%s) %s", e.getErrorCode(), e.getMessage());
        return new PmlSecurityException(PmlSecurityMsg.POLICY_STORE_ERROR(message), (Throwable)e);
    }

    public static PmlSecurityException createSecurityException(@NotNull JpsException e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createSecurityException must not be null");
        }
        String message = String.format("(%s) %s", e.getErrorCode(), e.getMessage());
        return new PmlSecurityException(PmlSecurityMsg.GENERIC_SECURITY_ERROR(message), (Throwable)e);
    }

    public static PmlSecurityException createSecurityException(@NotNull IdentityStoreException e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createSecurityException must not be null");
        }
        String message = String.format("(%s) %s", e.getErrorCode(), e.getMessage());
        return new PmlSecurityException(PmlSecurityMsg.IDENTITY_STORE_ERROR(message), (Throwable)e);
    }

    public static PmlSecurityException createIdentityException(@NotNull BPMIdentityException e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createIdentityException must not be null");
        }
        String message = String.format("(%s) %s", e.getErrorCode(), e.getMessage());
        return new PmlSecurityException(PmlSecurityMsg.IDENTITY_STORE_ERROR(message), (Throwable)e);
    }

    public static PmlSecurityException createSecurityException(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/exception/PmlSecurityExceptionFactory.createSecurityException must not be null");
        }
        return new PmlSecurityException(PmlSecurityMsg.GENERIC_SECURITY_ERROR(e.getMessage()), (Throwable)e);
    }
}

