/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder.util;

import java.sql.Timestamp;
import oracle.bpm.analytics.simulation.model.builder.util.RowActivityData;
import oracle.bpm.analytics.simulation.model.builder.util.RowBoundaryData;
import oracle.bpm.analytics.simulation.model.builder.util.RowEventData;
import oracle.bpm.analytics.simulation.model.builder.util.RowGatewayData;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import org.jetbrains.annotations.NotNull;

public class RowFlowNodeData {
    private FlowNode flowNode;
    private long sampleSize;
    private double sampleSqrSum;
    private double sampleSum;
    private Timestamp timestamp;

    protected RowFlowNodeData(@NotNull FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    public static RowFlowNodeData create(@NotNull FlowNode flowNode) {
        return new RowFlowNodeData(flowNode);
    }

    public String getFlowNodeId() {
        return this.getFlowNode().getId();
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(long sampleSize) {
        this.sampleSize = sampleSize;
    }

    public double getSampleSum() {
        return this.sampleSum;
    }

    public void setSampleSum(double sampleSum) {
        this.sampleSum = sampleSum;
    }

    public double getSampleSqrSum() {
        return this.sampleSqrSum;
    }

    public void setSampleSqrSum(double sampleSqrSum) {
        this.sampleSqrSum = sampleSqrSum;
    }

    public boolean isStartEvent() {
        if (this.getFlowNode().getBpmnType().isEvent()) {
            Event event = (Event)this.getFlowNode().asAnyNode(Event.class);
            return !event.isIntermediate() && event.isStart();
        }
        return false;
    }

    public boolean isActivity() {
        return this.getFlowNode().isActivity();
    }

    public RowActivityData asRowActivityData() {
        if (this.isActivity() && this.getFlowNode() instanceof Activity) {
            RowActivityData rowActivityData = new RowActivityData((Activity)this.flowNode);
            rowActivityData.setTimestamp(this.getTimestamp());
            rowActivityData.setSampleSize(this.getSampleSize());
            rowActivityData.setSampleSum(this.getSampleSum());
            rowActivityData.setSampleSqrSum(this.getSampleSqrSum());
            return rowActivityData;
        }
        throw new IllegalStateException("Invalid conversion type (" + this.getFlowNode().getBpmnType().name() + " -> Activity");
    }

    public boolean isGateway() {
        return this.getFlowNode().isGateway();
    }

    public RowGatewayData asRowGatewayData() {
        if (this.isGateway() && this.getFlowNode() instanceof Gateway) {
            Gateway gateway = (Gateway)this.getFlowNode();
            return new RowGatewayData(gateway);
        }
        throw new IllegalStateException("Invalid conversion type (" + this.getFlowNode().getBpmnType().name() + " -> Gateway");
    }

    public boolean isEvent() {
        return this.getFlowNode().isEvent();
    }

    public RowEventData asRowEventData() {
        if (this.isEvent() && this.getFlowNode() instanceof Event) {
            RowEventData rowEventData = new RowEventData((Event)this.getFlowNode());
            rowEventData.setTimestamp(this.getTimestamp());
            rowEventData.setSampleSize(this.getSampleSize());
            rowEventData.setSampleSum(this.getSampleSum());
            rowEventData.setSampleSqrSum(this.getSampleSqrSum());
            return rowEventData;
        }
        throw new IllegalStateException("Invalid conversion type (" + this.getFlowNode().getBpmnType().name() + " -> Event");
    }

    public boolean isBoundaryEvent() {
        return this.getFlowNode().getBpmnType() == BpmnType.BOUNDARY_EVENT;
    }

    public RowBoundaryData asRowBoundaryData() {
        if (this.isBoundaryEvent() && this.getFlowNode() instanceof BoundaryEvent) {
            RowBoundaryData rowBoundaryData = new RowBoundaryData((FlowNode)((BoundaryEvent)this.getFlowNode()));
            rowBoundaryData.setTimestamp(this.getTimestamp());
            rowBoundaryData.setSampleSize(this.getSampleSize());
            rowBoundaryData.setSampleSum(this.getSampleSum());
            rowBoundaryData.setSampleSqrSum(this.getSampleSqrSum());
            return rowBoundaryData;
        }
        throw new IllegalStateException("Invalid conversion type (" + this.getFlowNode().getBpmnType().name() + " -> BoundaryEvent");
    }
}

