/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder;

import oracle.bpm.analytics.simulation.model.builder.ActivityDistributionData;
import oracle.bpm.analytics.simulation.model.builder.DistributionData;
import oracle.bpm.lang.Time;
import oracle.bpm.project.io.simulation.jaxb.model.ObjectFactory;
import oracle.bpm.project.io.simulation.jaxb.model.Transition;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import org.jetbrains.annotations.NotNull;

public class TransitionDistributionData {
    private ActivityDistributionData activityDistributionData;
    private DistributionData dueTimeDistributionData;
    private boolean isDue = false;
    private boolean isInterrupting = false;
    private String relatedBoundary;
    private String sourceActivity;
    private long totalInstances = 0L;
    private String transitionId;

    private TransitionDistributionData(@NotNull String transitionId, @NotNull String sourceActivity, @NotNull DistributionCriteria criteria) {
        this.transitionId = transitionId;
        this.sourceActivity = sourceActivity;
        this.dueTimeDistributionData = DistributionData.create(criteria);
    }

    public static TransitionDistributionData create(@NotNull String transitionId, @NotNull String sourceActivity, @NotNull DistributionCriteria distributionCriteria) {
        return new TransitionDistributionData(transitionId, sourceActivity, distributionCriteria);
    }

    public static TransitionDistributionData create(@NotNull String transitionId, @NotNull ActivityDistributionData activityDistributionData, @NotNull DistributionCriteria distributionCriteria) {
        TransitionDistributionData transitionDistributionData = new TransitionDistributionData(transitionId, activityDistributionData.getActivityId(), distributionCriteria);
        transitionDistributionData.setActivityDistributionData(activityDistributionData);
        return transitionDistributionData;
    }

    public String getSourceActivity() {
        return this.sourceActivity;
    }

    public void setDue(boolean due) {
        this.isDue = due;
    }

    public boolean isDue() {
        return this.isDue;
    }

    public void setInterrupting(boolean interrupt) {
        this.isInterrupting = interrupt;
    }

    public boolean isInterrupting() {
        return this.isInterrupting;
    }

    public void addInstances(long sampleSize) {
        this.totalInstances += sampleSize;
    }

    public Transition getModelSimulation() {
        ObjectFactory objectFactory = new ObjectFactory();
        Transition transition = objectFactory.createTransition();
        transition.setName(this.transitionId);
        transition.setProbability(Double.valueOf(this.getProbability()));
        transition.setRelatedBoundary(this.getRelatedBoundary());
        if (this.isDue()) {
            transition.setDueInterval(String.valueOf(this.dueTimeDistributionData.getMean()));
        }
        return transition;
    }

    public void setActivityDistributionData(@NotNull ActivityDistributionData activityDistributionData) {
        this.activityDistributionData = activityDistributionData;
        this.activityDistributionData.addTransition(this);
    }

    public void addSampleDueTime(Time timestamp, long sampleSize, double dueTimeSum, double dueTimeSqrSum) {
        if (dueTimeSum > 0.0) {
            this.isDue = true;
            this.dueTimeDistributionData.addSample(timestamp, sampleSize, dueTimeSum, dueTimeSqrSum);
        }
    }

    public long getDueTime() {
        return (long)this.dueTimeDistributionData.getMean();
    }

    public long getTotalInstances() {
        return this.totalInstances;
    }

    public String getRelatedBoundary() {
        return this.relatedBoundary;
    }

    public void setRelatedBoundary(String relatedBoundary) {
        this.relatedBoundary = relatedBoundary;
    }

    private double getProbability() {
        if (this.isDue() || this.activityDistributionData == null) {
            return 0.0;
        }
        if (this.isInterrupting()) {
            return (double)this.totalInstances / (double)this.activityDistributionData.getCanceledInstances();
        }
        return (double)this.totalInstances / (double)this.activityDistributionData.getTotalInstances();
    }
}

