/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder;

import fuego.simulation.RealDistribution;
import fuego.simulation.RealDistributionCriteriaHelper;
import oracle.bpm.analytics.simulation.model.builder.DistributionData;
import oracle.bpm.analytics.simulation.model.builder.util.DistributionCriteriaHelper;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import org.jetbrains.annotations.NotNull;

public class RealDistributionData {
    private RealDistributionCriteriaHelper delegate;
    private DistributionData[] slots;

    private RealDistributionData(RealDistributionCriteriaHelper delegate) {
        this.slots = new DistributionData[delegate.size()];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = DistributionData.create();
        }
        this.delegate = delegate;
    }

    public static RealDistributionData create(@NotNull DistributionCriteria distributionCriteria) {
        RealDistributionCriteria criteria = DistributionCriteriaHelper.convertToRealDistributionCriteria(distributionCriteria);
        return new RealDistributionData(RealDistributionCriteriaHelper.resolve((RealDistributionCriteria)criteria));
    }

    public static RealDistributionData create(RealDistributionCriteriaHelper delegate) {
        return new RealDistributionData(delegate);
    }

    public RealDistribution getRealDistribution() {
        RealDistribution distribution = RealDistribution.createEmpty((RealDistributionCriteria)this.delegate.getCriteria());
        for (DistributionData slot : this.slots) {
            distribution.addDistribution((Distribution)slot.getNormalDistribution());
        }
        return distribution;
    }

    public RealDistribution getRealDistributionMicroseconds() {
        RealDistribution distribution = RealDistribution.createEmpty((RealDistributionCriteria)this.delegate.getCriteria());
        for (DistributionData slot : this.slots) {
            distribution.addDistribution((Distribution)slot.getNormalDistributionMicroseconds());
        }
        return distribution;
    }

    public void addSample(Time timestamp, long sampleSize, double sum, double sqrSum) {
        int index = this.delegate.getIndex(timestamp);
        this.slots[index].addSample(timestamp, sampleSize, sum, sqrSum);
    }
}

