/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.bpm.analytics.simulation.SimulationException;
import oracle.bpm.analytics.simulation.model.builder.ActivityDistributionData;
import oracle.bpm.analytics.simulation.model.builder.DistributionData;
import oracle.bpm.analytics.simulation.model.builder.DistributionDataBuilder;
import oracle.bpm.analytics.simulation.model.builder.TransitionDistributionData;
import oracle.bpm.analytics.simulation.model.builder.util.RowActivityData;
import oracle.bpm.analytics.simulation.model.builder.util.RowBoundaryData;
import oracle.bpm.analytics.simulation.model.builder.util.RowFlowNodeData;
import oracle.bpm.analytics.simulation.model.builder.util.RowInstanceData;
import oracle.bpm.analytics.simulation.model.builder.util.RowTransitionData;
import oracle.bpm.project.io.simulation.jaxb.model.Activities;
import oracle.bpm.project.io.simulation.jaxb.model.Activity;
import oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation;
import oracle.bpm.project.io.simulation.jaxb.model.ObjectFactory;
import oracle.bpm.project.io.simulation.jaxb.model.Transition;
import oracle.bpm.project.io.simulation.jaxb.model.Transitions;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;

public class ModelSimulationBuilder {
    private String componentName;
    private DistributionDataBuilder distributionDataBuilder;
    private JAXBContext jaxbContext;
    private String name;
    private static final Object lock = new Object();

    private ModelSimulationBuilder(@NotNull String name, @NotNull String componentName, @NotNull DistributionCriteria distributionCriteria) {
        this.name = name;
        this.componentName = componentName;
        this.distributionDataBuilder = DistributionDataBuilder.create(distributionCriteria);
    }

    public static ModelSimulationBuilder create() {
        return new ModelSimulationBuilder("Unknown", "Unknown", DistributionCriteria.HOURLY);
    }

    public static ModelSimulationBuilder create(@NotNull String name, @NotNull String componentName, @NotNull DistributionCriteria distributionCriteria) {
        return new ModelSimulationBuilder(name, componentName, distributionCriteria);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.distributionDataBuilder.setTimeZone(timeZone);
    }

    public String buildModel() throws SimulationException {
        this.distributionDataBuilder.mapTransitions();
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (Map.Entry<String, DistributionData> entry : this.distributionDataBuilder.getInstancesDistributionData().entrySet()) {
            activities.add(entry.getValue().getModelSimulationAsActivity(entry.getKey()));
        }
        for (ActivityDistributionData activityDistributionData : this.distributionDataBuilder.getActivities()) {
            activities.add(activityDistributionData.getModelSimulation());
        }
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (TransitionDistributionData transitionDistributionData : this.distributionDataBuilder.getTransitions()) {
            transitions.add(transitionDistributionData.getModelSimulation());
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Activities _activities = objectFactory.createActivities();
        _activities.getActivity().addAll(activities);
        Transitions _transitions = objectFactory.createTransitions();
        _transitions.getTransition().addAll(transitions);
        ModelSimulation modelSimulation = objectFactory.createModelSimulation();
        modelSimulation.setName(this.name);
        modelSimulation.setProcessId(this.componentName);
        modelSimulation.setActivities(_activities);
        modelSimulation.setTransitions(_transitions);
        return this.toXML(modelSimulation);
    }

    public void addSample(@NotNull RowInstanceData rowInstanceData) {
        this.distributionDataBuilder.addSample(rowInstanceData);
    }

    public void addSample(@NotNull RowFlowNodeData rowFlowNodeData) {
        this.distributionDataBuilder.addSample(rowFlowNodeData);
    }

    public void addSample(@NotNull RowActivityData rowActivityData) {
        this.distributionDataBuilder.addSample(rowActivityData);
    }

    public void addSample(@NotNull RowBoundaryData rowBoundaryData) {
        this.distributionDataBuilder.addSample(rowBoundaryData);
    }

    public void addSample(@NotNull RowTransitionData rowTransitionData) {
        if (rowTransitionData.getSequenceFlow().getSource().getBpmnType() != BpmnType.BOUNDARY_EVENT) {
            this.distributionDataBuilder.addSample(rowTransitionData);
        }
    }

    public void addInstanceSamples(@NotNull Collection<RowInstanceData> rows) {
        for (RowInstanceData row : rows) {
            this.distributionDataBuilder.addSample(row);
        }
    }

    public void addFlowNodeSamples(@NotNull Collection<RowFlowNodeData> rows) {
        for (RowFlowNodeData row : rows) {
            this.distributionDataBuilder.addSample(row);
        }
    }

    public void addTransitionSamples(@NotNull Collection<RowTransitionData> rows) {
        for (RowTransitionData row : rows) {
            this.distributionDataBuilder.addSample(row);
        }
    }

    private String toXML(@NotNull ModelSimulation model) throws SimulationException {
        try {
            StringWriter writer = new StringWriter();
            JAXBContext jaxbContext = this.getJAXBContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)model, (Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (JAXBException cause) {
            throw new SimulationException((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext() {
        Object object = lock;
        synchronized (object) {
            if (this.jaxbContext == null) {
                this.jaxbContext = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class});
            }
        }
        return this.jaxbContext;
    }
}

