/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import oracle.bpm.analytics.simulation.model.builder.ActivityDistributionData;
import oracle.bpm.analytics.simulation.model.builder.DistributionData;
import oracle.bpm.analytics.simulation.model.builder.TransitionDistributionData;
import oracle.bpm.analytics.simulation.model.builder.util.RowBoundaryData;
import oracle.bpm.analytics.simulation.model.builder.util.RowFlowNodeData;
import oracle.bpm.analytics.simulation.model.builder.util.RowInstanceData;
import oracle.bpm.analytics.simulation.model.builder.util.RowTransitionData;
import oracle.bpm.lang.Time;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import org.jetbrains.annotations.NotNull;

public class DistributionDataBuilder {
    private Map<String, ActivityDistributionData> activityDistributionDataMap;
    private DistributionCriteria distributionCriteria = DistributionCriteria.HOURLY;
    private Map<String, DistributionData> instanceDistributionDataMap = new TreeMap<String, DistributionData>(String.CASE_INSENSITIVE_ORDER);
    private TimeZone timeZone;
    private Map<String, TransitionDistributionData> transitionDistributionDataMap;

    private DistributionDataBuilder() {
        this.activityDistributionDataMap = new TreeMap<String, ActivityDistributionData>(String.CASE_INSENSITIVE_ORDER);
        this.transitionDistributionDataMap = new TreeMap<String, TransitionDistributionData>(String.CASE_INSENSITIVE_ORDER);
    }

    public static DistributionDataBuilder create() {
        return new DistributionDataBuilder();
    }

    public static DistributionDataBuilder create(@NotNull DistributionCriteria distributionCriteria) {
        DistributionDataBuilder distributionDataBuilder = new DistributionDataBuilder();
        distributionDataBuilder.distributionCriteria = distributionCriteria;
        return distributionDataBuilder;
    }

    public DistributionCriteria getDistributionCriteria() {
        return this.distributionCriteria;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void addSample(@NotNull RowInstanceData row) {
        DistributionData instanceDistributionData = this.instanceDistributionDataMap.get(row.getFlowNodeId());
        if (instanceDistributionData == null) {
            instanceDistributionData = DistributionData.create(this.distributionCriteria);
            this.instanceDistributionDataMap.put(row.getFlowNodeId(), instanceDistributionData);
        }
        instanceDistributionData.addSample(this.getTime(row.getTimestamp()), row.getSampleSize(), row.getSampleSum(), row.getSampleSqrSum());
    }

    public void addSample(@NotNull RowFlowNodeData row) {
        if (!row.isStartEvent()) {
            if (row.isBoundaryEvent()) {
                RowBoundaryData rowBoundaryData = row.asRowBoundaryData();
                TransitionDistributionData transitionDistributionData = this.transitionDistributionDataMap.get(rowBoundaryData.getTransitionId());
                if (transitionDistributionData == null) {
                    transitionDistributionData = TransitionDistributionData.create(rowBoundaryData.getTransitionId(), rowBoundaryData.getSourceActivityId(), this.distributionCriteria);
                    transitionDistributionData.setRelatedBoundary(rowBoundaryData.getBoundaryEventId());
                    transitionDistributionData.setDue(rowBoundaryData.isDue());
                    transitionDistributionData.setInterrupting(rowBoundaryData.isInterrupting());
                    this.transitionDistributionDataMap.put(rowBoundaryData.getTransitionId(), transitionDistributionData);
                }
                if (rowBoundaryData.isDue()) {
                    transitionDistributionData.addSampleDueTime(this.getTime(row.getTimestamp()), row.getSampleSize(), row.getSampleSum(), row.getSampleSqrSum());
                } else {
                    transitionDistributionData.addInstances(row.getSampleSize());
                }
            } else {
                ActivityDistributionData activityDistributionData = this.activityDistributionDataMap.get(row.getFlowNodeId());
                if (activityDistributionData == null) {
                    activityDistributionData = new ActivityDistributionData(row.getFlowNodeId(), row.getFlowNode().getBpmnType(), this.distributionCriteria);
                    this.activityDistributionDataMap.put(activityDistributionData.getActivityId(), activityDistributionData);
                }
                activityDistributionData.addSampleInstanceLife(this.getTime(row.getTimestamp()), row.getSampleSize(), row.getSampleSum(), row.getSampleSqrSum());
            }
        }
    }

    public void addSample(@NotNull RowTransitionData row) {
        TransitionDistributionData transitionDistributionData = this.transitionDistributionDataMap.get(row.getTransitionId());
        if (transitionDistributionData == null) {
            transitionDistributionData = TransitionDistributionData.create(row.getTransitionId(), row.getSourceActivityId(), this.distributionCriteria);
            this.transitionDistributionDataMap.put(row.getTransitionId(), transitionDistributionData);
        }
        transitionDistributionData.addInstances(row.getSampleSize());
    }

    public void mapTransitions() {
        for (TransitionDistributionData transition : this.transitionDistributionDataMap.values()) {
            ActivityDistributionData activity = this.activityDistributionDataMap.get(transition.getSourceActivity());
            if (activity == null) continue;
            transition.setActivityDistributionData(activity);
        }
    }

    public Map<String, DistributionData> getInstancesDistributionData() {
        return this.instanceDistributionDataMap;
    }

    public Collection<ActivityDistributionData> getActivities() {
        return this.activityDistributionDataMap.values();
    }

    public Collection<TransitionDistributionData> getTransitions() {
        return this.transitionDistributionDataMap.values();
    }

    private Time getTime(@NotNull Timestamp timestamp) {
        Time time = Time.valueOf((Timestamp)timestamp);
        if (this.timeZone != null) {
            Time.setTimeZone((TimeZone)this.timeZone);
        }
        return time;
    }
}

