/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder;

import fuego.simulation.ConstantDistribution;
import fuego.simulation.ExponentialDistribution;
import fuego.simulation.UniformDistribution;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.analytics.simulation.model.builder.RealDistributionData;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution;
import oracle.bpm.project.io.simulation.jaxb.model.Activity;
import oracle.bpm.project.io.simulation.jaxb.model.CalculatedDistributions;
import oracle.bpm.project.io.simulation.jaxb.model.Distribution;
import oracle.bpm.project.io.simulation.jaxb.model.NormalDistribution;
import oracle.bpm.project.io.simulation.jaxb.model.ObjectFactory;
import oracle.bpm.project.io.simulation.jaxb.model.RealDistribution;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import org.jetbrains.annotations.NotNull;

public class DistributionData {
    private RealDistributionData realDistributionData;
    private long totalSampleSize = 0L;
    private double totalSqrSum = 0.0;
    private double totalSum = 0.0;
    private static final long MILLISECONDS_TO_MICROSECONDS = 1000L;

    private DistributionData() {
    }

    public static DistributionData create() {
        return new DistributionData();
    }

    public static DistributionData create(@NotNull DistributionCriteria distributionCriteria) {
        DistributionData distributionData = new DistributionData();
        distributionData.realDistributionData = RealDistributionData.create(distributionCriteria);
        return distributionData;
    }

    public Distribution getModelSimulation() {
        ObjectFactory objectFactory = new ObjectFactory();
        ConstantDistribution constantDistribution = this.getConstantDistributionMicroseconds();
        oracle.bpm.project.io.simulation.jaxb.model.ConstantDistribution _constantDistribution = objectFactory.createConstantDistribution();
        _constantDistribution.setPeriod(constantDistribution.getPeriod());
        ExponentialDistribution exponentialDistribution = this.getExponentialDistributionMicroseconds();
        oracle.bpm.project.io.simulation.jaxb.model.ExponentialDistribution _exponentialDistribution = objectFactory.createExponentialDistribution();
        _exponentialDistribution.setEvents(exponentialDistribution.getEvents());
        _exponentialDistribution.setIntervalValue(exponentialDistribution.getIntervalValue());
        fuego.simulation.NormalDistribution normalDistribution = this.getNormalDistributionMicroseconds();
        NormalDistribution _normalDistribution = objectFactory.createNormalDistribution();
        _normalDistribution.setDeviation(normalDistribution.getDeviation());
        _normalDistribution.setMean(normalDistribution.getMean());
        fuego.simulation.RealDistribution realDistribution = this.getRealDistributionMicroseconds();
        RealDistribution _realDistribution = objectFactory.createRealDistribution();
        _realDistribution.setRealDistributionSubtype(realDistribution.getRealDistributionCriteria().name());
        for (int i = 0; i < realDistribution.groupsSize(); ++i) {
            oracle.bpm.project.model.simulation.Distribution slotDistribution = realDistribution.getDistribution(i);
            NormalDistribution _slotNormalDistribution = objectFactory.createNormalDistribution();
            _slotNormalDistribution.setDeviation(slotDistribution.getDeviation());
            _slotNormalDistribution.setMean(slotDistribution.getAvgValue());
            _realDistribution.getConstantDistributionOrNormalDistributionOrUniformDistribution().add(_slotNormalDistribution);
        }
        UniformDistribution uniformDistribution = this.getUniformDistributionMicroseconds();
        oracle.bpm.project.io.simulation.jaxb.model.UniformDistribution _uniformDistribution = objectFactory.createUniformDistribution();
        _uniformDistribution.setAvg(uniformDistribution.getAvg());
        _uniformDistribution.setDeviation(uniformDistribution.getDeviation());
        Distribution _distribution = objectFactory.createDistribution();
        _distribution.setConstantDistributionOrNormalDistributionOrUniformDistribution((AbstractDistribution)_realDistribution);
        return _distribution;
    }

    public Activity getModelSimulationAsActivity(String activityName) {
        ObjectFactory objectFactory = new ObjectFactory();
        Activity activity = objectFactory.createActivity();
        activity.setName(activityName);
        activity.setAbortProbability(0.0);
        activity.setExceptionProbability(0.0);
        activity.setDistribution(this.getModelSimulation());
        activity.setCalculatedDistributions(this.getCalculatedModelSimulation());
        return activity;
    }

    public CalculatedDistributions getCalculatedModelSimulation() {
        ObjectFactory objectFactory = new ObjectFactory();
        ConstantDistribution constantDistribution = this.getConstantDistributionMicroseconds();
        oracle.bpm.project.io.simulation.jaxb.model.ConstantDistribution _constantDistribution = objectFactory.createConstantDistribution();
        _constantDistribution.setPeriod(constantDistribution.getPeriod());
        ExponentialDistribution exponentialDistribution = this.getExponentialDistributionMicroseconds();
        oracle.bpm.project.io.simulation.jaxb.model.ExponentialDistribution _exponentialDistribution = objectFactory.createExponentialDistribution();
        _exponentialDistribution.setEvents(exponentialDistribution.getEvents());
        _exponentialDistribution.setIntervalValue(exponentialDistribution.getIntervalValue());
        fuego.simulation.NormalDistribution normalDistribution = this.getNormalDistributionMicroseconds();
        NormalDistribution _normalDistribution = objectFactory.createNormalDistribution();
        _normalDistribution.setDeviation(normalDistribution.getDeviation());
        _normalDistribution.setMean(normalDistribution.getMean());
        fuego.simulation.RealDistribution realDistribution = this.getRealDistributionMicroseconds();
        RealDistribution _realDistribution = objectFactory.createRealDistribution();
        _realDistribution.setRealDistributionSubtype(realDistribution.getRealDistributionCriteria().name());
        for (int i = 0; i < realDistribution.groupsSize(); ++i) {
            oracle.bpm.project.model.simulation.Distribution slotDistribution = realDistribution.getDistribution(i);
            NormalDistribution _slotNormalDistribution = objectFactory.createNormalDistribution();
            _slotNormalDistribution.setDeviation(slotDistribution.getDeviation());
            _slotNormalDistribution.setMean(slotDistribution.getAvgValue());
            _realDistribution.getConstantDistributionOrNormalDistributionOrUniformDistribution().add(_slotNormalDistribution);
        }
        UniformDistribution uniformDistribution = this.getUniformDistributionMicroseconds();
        oracle.bpm.project.io.simulation.jaxb.model.UniformDistribution _uniformDistribution = objectFactory.createUniformDistribution();
        _uniformDistribution.setAvg(uniformDistribution.getAvg());
        _uniformDistribution.setDeviation(uniformDistribution.getDeviation());
        CalculatedDistributions calculatedDistributions = objectFactory.createCalculatedDistributions();
        calculatedDistributions.setConstantDistributionOrNormalDistributionOrUniformDistribution((AbstractDistribution)_realDistribution);
        return calculatedDistributions;
    }

    public RealDistribution getRealDistributionModelSimulation() {
        ObjectFactory objectFactory = new ObjectFactory();
        fuego.simulation.RealDistribution realDistribution = this.getRealDistributionMicroseconds();
        RealDistribution _realDistribution = objectFactory.createRealDistribution();
        _realDistribution.setRealDistributionSubtype(realDistribution.getRealDistributionCriteria().name());
        for (int i = 0; i < realDistribution.groupsSize(); ++i) {
            oracle.bpm.project.model.simulation.Distribution slotDistribution = realDistribution.getDistribution(i);
            NormalDistribution _slotNormalDistribution = objectFactory.createNormalDistribution();
            _slotNormalDistribution.setDeviation(slotDistribution.getDeviation());
            _slotNormalDistribution.setMean(slotDistribution.getAvgValue());
            _realDistribution.getConstantDistributionOrNormalDistributionOrUniformDistribution().add(_slotNormalDistribution);
        }
        return _realDistribution;
    }

    public fuego.simulation.NormalDistribution getNormalDistribution() {
        return this.getNormalDistribution(1L);
    }

    public fuego.simulation.NormalDistribution getNormalDistribution(long unitConverter) {
        if (this.totalSampleSize == 0L) {
            return new fuego.simulation.NormalDistribution(Long.MAX_VALUE, 0L);
        }
        return new fuego.simulation.NormalDistribution((long)this.getMean() * unitConverter, (long)((int)((long)this.getNormalDeviation() * unitConverter)));
    }

    public fuego.simulation.NormalDistribution getNormalDistributionMicroseconds() {
        return this.getNormalDistribution(1000L);
    }

    public ConstantDistribution getConstantDistribution() {
        return this.getConstantDistribution(1L);
    }

    public ConstantDistribution getConstantDistribution(long unitConverter) {
        if (this.totalSampleSize == 0L) {
            return new ConstantDistribution(Long.MAX_VALUE);
        }
        return new ConstantDistribution((long)this.getMean() * unitConverter);
    }

    public ConstantDistribution getConstantDistributionMicroseconds() {
        return this.getConstantDistribution(1000L);
    }

    public ExponentialDistribution getExponentialDistribution(long unitConverter) {
        if (this.totalSampleSize == 0L) {
            return new ExponentialDistribution(1, Interval.valueOf((long)Long.MAX_VALUE));
        }
        double mean = this.getMean();
        int events = (int)Math.round((double)Interval.ONE_HOUR.getTotalMicroseconds() / (mean * (double)unitConverter));
        return new ExponentialDistribution(events, Interval.ONE_HOUR);
    }

    public ExponentialDistribution getExponentialDistributionMicroseconds() {
        return this.getExponentialDistribution(1000L);
    }

    public ExponentialDistribution getExponentialDistribution() {
        return this.getExponentialDistribution(1L);
    }

    public UniformDistribution getUniformDistribution() {
        return this.getUniformDistribution(1L);
    }

    public UniformDistribution getUniformDistribution(long unitConverter) {
        if (this.totalSampleSize == 0L) {
            return new UniformDistribution(Long.MAX_VALUE, 0L);
        }
        return new UniformDistribution((long)this.getMean() * unitConverter, (long)((int)((long)this.getUniformDeviation() * unitConverter)));
    }

    public UniformDistribution getUniformDistributionMicroseconds() {
        return this.getUniformDistribution(1000L);
    }

    public fuego.simulation.RealDistribution getRealDistribution() {
        return this.realDistributionData.getRealDistribution();
    }

    public fuego.simulation.RealDistribution getRealDistributionMicroseconds() {
        return this.realDistributionData.getRealDistributionMicroseconds();
    }

    public void addSample(Time timestamp, long sampleSize, double sum, double sqrSum) {
        assert (sqrSum >= 0.0) : "Overflow of sqrSum:" + sqrSum;
        this.totalSampleSize += sampleSize;
        this.totalSum += sum;
        this.totalSqrSum += sqrSum;
        if (this.realDistributionData != null) {
            this.realDistributionData.addSample(timestamp, sampleSize, sum, sqrSum);
        }
        assert (this.totalSampleSize >= 0L) : "Overflow of totalSampleSize:" + this.totalSampleSize;
        assert (this.totalSum >= 0.0) : "Overflow of totalSum:" + this.totalSum;
    }

    public long getTotalSampleSize() {
        return this.totalSampleSize;
    }

    public List<oracle.bpm.project.model.simulation.Distribution> getDistributions() {
        ArrayList<oracle.bpm.project.model.simulation.Distribution> list = new ArrayList<oracle.bpm.project.model.simulation.Distribution>();
        list.add((oracle.bpm.project.model.simulation.Distribution)this.getRealDistributionMicroseconds());
        list.add((oracle.bpm.project.model.simulation.Distribution)this.getNormalDistributionMicroseconds());
        list.add((oracle.bpm.project.model.simulation.Distribution)this.getConstantDistributionMicroseconds());
        list.add((oracle.bpm.project.model.simulation.Distribution)this.getUniformDistributionMicroseconds());
        list.add((oracle.bpm.project.model.simulation.Distribution)this.getExponentialDistributionMicroseconds());
        return list;
    }

    public double getMean() {
        return this.totalSum / (double)this.totalSampleSize;
    }

    public long getMeanInMicroseconds() {
        return (long)(this.getMean() * 1000.0);
    }

    private double getVariance() {
        if (this.totalSampleSize > 0L) {
            return this.totalSqrSum / (double)this.totalSampleSize - Math.pow(this.getMean(), 2.0);
        }
        return 0.0;
    }

    private double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    private int getNormalDeviation() {
        return (int)this.getStandardDeviation();
    }

    private int getUniformDeviation() {
        return this.getNormalDeviation();
    }
}

