/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.simulation.model.builder;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.analytics.simulation.model.builder.DistributionData;
import oracle.bpm.analytics.simulation.model.builder.TransitionDistributionData;
import oracle.bpm.lang.Time;
import oracle.bpm.project.io.simulation.jaxb.model.Activity;
import oracle.bpm.project.io.simulation.jaxb.model.ObjectFactory;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import org.jetbrains.annotations.NotNull;

public class ActivityDistributionData {
    private String activityId;
    private BpmnType activityType;
    private DistributionData instanceLifeDistributionData;
    private long totalAbortedInst = 0L;
    private long totalBackInst = 0L;
    private long totalSendInst = 0L;
    private long totalSkipInst = 0L;
    private List<TransitionDistributionData> transitionDistributions = new LinkedList<TransitionDistributionData>();

    public ActivityDistributionData(String activityId, BpmnType activityType, DistributionCriteria criteria) {
        this.activityId = activityId;
        this.activityType = activityType;
        this.instanceLifeDistributionData = DistributionData.create(criteria);
    }

    public void addSampleInstanceLife(@NotNull Time timestamp, long sampleSize, double instanceLifeTimeSum, double instanceLifeTimeSqrSum) {
        this.instanceLifeDistributionData.addSample(timestamp, sampleSize, instanceLifeTimeSum, instanceLifeTimeSqrSum);
    }

    public void addAborted(long abortedInst) {
        this.totalAbortedInst += abortedInst;
    }

    public void addBack(long backInst) {
        this.totalBackInst += backInst;
    }

    public void addSkip(long skipInst) {
        this.totalSkipInst += skipInst;
    }

    public void addSend(long sendInst) {
        this.totalSendInst += sendInst;
    }

    public Activity getModelSimulation() {
        long sampleSize = this.instanceLifeDistributionData.getTotalSampleSize();
        double abortProbability = this.totalAbortedInst / sampleSize;
        ObjectFactory objectFactory = new ObjectFactory();
        Activity activity = objectFactory.createActivity();
        activity.setName(this.getActivityId());
        activity.setAbortProbability(abortProbability);
        activity.setExceptionProbability(0.0);
        if (this.activityType != BpmnType.USER_TASK) {
            activity.setCapacity(5);
        }
        activity.setDistribution(this.instanceLifeDistributionData.getModelSimulation());
        activity.setCalculatedDistributions(this.instanceLifeDistributionData.getCalculatedModelSimulation());
        return activity;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public long getTotalInstances() {
        return this.instanceLifeDistributionData.getTotalSampleSize() - this.getDueTotalInstances();
    }

    public void addTransition(TransitionDistributionData transitionDistributionData) {
        this.transitionDistributions.add(transitionDistributionData);
    }

    public long getCanceledInstances() {
        long canceledInstances = 0L;
        for (TransitionDistributionData transitionDistributionData : this.transitionDistributions) {
            if (!transitionDistributionData.isInterrupting()) continue;
            canceledInstances += transitionDistributionData.getTotalInstances();
        }
        return canceledInstances;
    }

    public boolean isValid() {
        return this.getTotalInstances() > 0L;
    }

    private long getDueTimeMicroseconds() {
        return this.getDueTime() * 1000000L;
    }

    private long getDueTime() {
        for (TransitionDistributionData transitionDistribution : this.transitionDistributions) {
            if (!transitionDistribution.isDue() || transitionDistribution.getTotalInstances() <= 0L) continue;
            return transitionDistribution.getDueTime();
        }
        return 0L;
    }

    private long getDueTotalInstances() {
        for (TransitionDistributionData transitionDistribution : this.transitionDistributions) {
            if (!transitionDistribution.isDue()) continue;
            return transitionDistribution.getTotalInstances();
        }
        return 0L;
    }
}

