/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.IMeasurementConstants;
import oracle.bpm.analytics.measurement.MeasurementPublisherException;
import oracle.bpm.analytics.measurement.impl.MeasuredData;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.analytics.measurement.metadata.model.TPropertyType;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditInstance;

public class Util
implements IMeasurementConstants {
    private TopicConnection connection;
    private TopicPublisher publisher;
    private TopicSession topicSession;
    private static final String LOG_CLASS_NAME = "oracle.bpm.analytics.measurement.impl.Util";

    protected void publishMessageList(List<IAuditInstance> aiList, List<IMeasure> measureList) throws MeasurementPublisherException {
        try {
            ArrayList<Long> aiKeyList = new ArrayList<Long>();
            ArrayList<Long> altKeyList = new ArrayList<Long>();
            ArrayList<String> altActionsList = new ArrayList<String>();
            String actionsListString = Util.getActionsListAsString(measureList.get(0));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publishMessageList", (String)("Common Actions List String: " + actionsListString));
            for (IAuditInstance ai : aiList) {
                String currActionsListString = Util.getActionsListAsString(measureList.get(aiList.indexOf(ai)));
                if (currActionsListString.equals(actionsListString)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publishMessageList", (String)("Adding to batch QueryId: " + ai.getQueryId()));
                    aiKeyList.add(ai.getQueryId());
                    continue;
                }
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publishMessageList", (String)("Adding to single QueryId: " + ai.getQueryId() + " action list: " + currActionsListString));
                altKeyList.add(ai.getQueryId());
                altActionsList.add(currActionsListString);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publishMessageList", (String)"Publishing batch");
            this.publishKeyList(aiKeyList, actionsListString);
            for (int i = 0; i < altKeyList.size(); ++i) {
                ArrayList altAiKeyList = new ArrayList();
                altAiKeyList.add(altKeyList.get(i));
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publishMessageList", (String)("Publishing single QueryId: " + altKeyList.get(i)));
                this.publishKeyList(altAiKeyList, (String)altActionsList.get(i));
            }
        }
        catch (Exception e) {
            String msg = "Error publishing Message to Topic: jms/bpm/MeasurementTopic. " + e.getMessage();
            throw new MeasurementPublisherException(LOG_CLASS_NAME, msg, e);
        }
    }

    protected void publishObjectMessage(IAuditInstance ai, IMeasure measure) throws MeasurementPublisherException {
        try {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publish", (String)"Create Object Message");
            if (ai == null) {
                throw new MeasurementPublisherException("Audit Instance is null");
            }
            if (this.topicSession == null) {
                this.initializeJMSResources();
            }
            ObjectMessage msg = this.topicSession.createObjectMessage((Serializable)ai);
            msg.setStringProperty("actionList", Util.getActionsListAsString(measure));
            if (Util.shouldForcePublish(measure.getActions())) {
                msg.setStringProperty("forcePublish", Boolean.TRUE.toString());
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publish", (String)("Publish Audit Instance" + ai.getQueryId() + ',' + ai.getActivityId() + ',' + ai.getOperation().toString()));
            this.publisher.publish((Message)msg);
        }
        catch (JMSException jmse) {
            String msg = "Error publishing Audit Instance to Topic: jms/bpm/MeasurementTopic for Query Id: " + ai.getQueryId() + '.' + jmse.getMessage();
            throw new MeasurementPublisherException(LOG_CLASS_NAME, msg, (Exception)((Object)jmse));
        }
        catch (Exception e) {
            String msg = "Error publishing Audit Instance to Topic: jms/bpm/MeasurementTopic. " + e.getMessage();
            throw new MeasurementPublisherException(LOG_CLASS_NAME, msg, e);
        }
    }

    protected void initializeJMSResources() throws MeasurementPublisherException {
        try {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"initializeJMSResources", (String)"Create Connection factory.");
            TopicConnectionFactory connectionFactory = this.getTopicConnectionFactory("jms/bpm/MeasurementTopicConnectionFactory");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"initializeJMSResources", (String)"Getting Topic...");
            Topic topic = this.getTopic("jms/bpm/MeasurementTopic");
            this.connection = connectionFactory.createTopicConnection();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"initializeJMSResources", (String)"Create Topic Session...");
            this.topicSession = this.connection.createTopicSession(false, 1);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"initializeJMSResources", (String)"Create Publisher...");
            this.publisher = this.topicSession.createPublisher(topic);
        }
        catch (Exception e) {
            String msg = "Error publishing Audit Instance to Topic: jms/bpm/MeasurementTopic";
            throw new MeasurementPublisherException(LOG_CLASS_NAME, msg, e);
        }
    }

    protected void cleanup(String methodName) {
        if (this.publisher != null) {
            try {
                this.publisher.close();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)methodName, (String)"Close Topic Publisher");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)LOG_CLASS_NAME, (String)methodName, (String)e1.getMessage());
            }
        }
        if (this.topicSession != null) {
            try {
                this.topicSession.close();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)methodName, (String)"Close Topic Session");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)LOG_CLASS_NAME, (String)methodName, (String)e2.getMessage());
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)methodName, (String)"Close Connection");
            }
            catch (Exception e3) {
                e3.printStackTrace();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)LOG_CLASS_NAME, (String)methodName, (String)e3.getMessage());
            }
        }
    }

    private static String getActionsListAsString(IMeasure measure) {
        ArrayList<String> actionNameList = new ArrayList<String>();
        if (measure.getActions() != null) {
            List actionList = measure.getActions();
            for (TAction action : actionList) {
                actionNameList.add(action.getName());
            }
        }
        return ((Object)actionNameList).toString();
    }

    private static boolean shouldForcePublish(List<TAction> actionList) {
        TAction action = null;
        if (actionList == null || actionList.size() > 1) {
            return false;
        }
        action = actionList.get(0);
        if (!"BAMCommand".equals(action.getName())) {
            return false;
        }
        List propertyList = action.getProperties().getProperty();
        if (propertyList != null) {
            for (TPropertyType property : propertyList) {
                if (!"forcePublish".equalsIgnoreCase(property.getName()) || !Boolean.parseBoolean(property.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private TopicConnectionFactory getTopicConnectionFactory(String connectionFactoryName) throws MeasurementPublisherException {
        try {
            return (TopicConnectionFactory)this.jndiLookup(connectionFactoryName);
        }
        catch (Exception e) {
            throw new MeasurementPublisherException(LOG_CLASS_NAME, "Unable to get JMS TopicConnectionFactory : " + connectionFactoryName, e);
        }
    }

    private Topic getTopic(String topicName) throws MeasurementPublisherException {
        try {
            return (Topic)this.jndiLookup(topicName);
        }
        catch (Exception e) {
            throw new MeasurementPublisherException("Util", "Unable to get JMS Topic : , Topic = " + topicName, e);
        }
    }

    private Object jndiLookup(String name) throws NamingException, MeasurementPublisherException {
        Object obj;
        InitialContext jndiContext = new InitialContext();
        try {
            obj = jndiContext.lookup(name);
        }
        catch (NamingException e) {
            throw new MeasurementPublisherException(LOG_CLASS_NAME, "JNDI lookup failed.", (Exception)e);
        }
        return obj;
    }

    private void publishKeyList(List keyList, String actionsListString) throws MeasurementPublisherException {
        try {
            MeasuredData data = new MeasuredData();
            data.setKeyList(keyList);
            if (this.topicSession == null) {
                this.initializeJMSResources();
            }
            ObjectMessage msg = this.topicSession.createObjectMessage((Serializable)((Object)data));
            msg.setStringProperty("actionList", actionsListString);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)LOG_CLASS_NAME, (String)"publish", (String)("Publish Audit Instance List" + data.getKeyList()));
            this.publisher.publish((Message)msg);
        }
        catch (JMSException jmse) {
            String msg = "Error publishing Audit Instance to Topic: jms/bpm/MeasurementTopic ." + jmse.getMessage();
            throw new MeasurementPublisherException(LOG_CLASS_NAME, msg, (Exception)((Object)jmse));
        }
        catch (Exception e) {
            String msg = "Error publishing Audit Instance to Topic: jms/bpm/MeasurementTopic. " + e.getMessage();
            throw new MeasurementPublisherException(LOG_CLASS_NAME, msg, e);
        }
    }
}

