/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.util;

import java.util.Map;
import oracle.bpm.analytics.dashboard.query.JpqlTabularData;
import oracle.bpm.analytics.dashboard.query.WidgetData;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public class LoggerHelper {
    private static final int CLASS_INDEX = 0;
    private static final int METHOD_INDEX = 1;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public static void logWidget(Severity severity, @NotNull WidgetType widget) {
        if (LoggerHelper.canLog(severity)) {
            try {
                String widgetXML = ModelTypeFactory.getXMLFromWidget((WidgetType)widget);
                LoggerHelper.logWidget(severity, widgetXML);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void logWidget(Severity severity, @NotNull String widget) {
        if (LoggerHelper.canLog(severity)) {
            LoggerHelper.log(severity, "Widget [\n" + widget + "\n]");
        }
    }

    public static void logReusedQuery(Severity severity, @NotNull String seriesID, @NotNull String query) {
        if (LoggerHelper.canLog(severity)) {
            StringBuilder message = new StringBuilder();
            message.append("seriesID [");
            message.append(seriesID);
            message.append("] in cache, reused cache JPQL query [");
            message.append(query);
            message.append("].");
            LoggerHelper.log(severity, message.toString());
        }
    }

    public static void logGeneratedQuery(Severity severity, @NotNull String seriesID, @NotNull String query) {
        if (LoggerHelper.canLog(severity)) {
            StringBuilder message = new StringBuilder();
            message.append("seriesID [");
            message.append(seriesID);
            message.append("] not in cache, generated JPQL query [");
            message.append(query);
            message.append("] and add to cache.");
            LoggerHelper.log(Severity.DEBUG, message.toString());
        }
    }

    public static void logQueryBinding(Severity serverity, @NotNull String seriesID, @NotNull Map<String, Object> binding) {
        if (LoggerHelper.canLog(serverity)) {
            StringBuilder message = new StringBuilder("Binding for SeriesID '");
            message.append(seriesID);
            message.append("'");
            for (Map.Entry<String, Object> entry : binding.entrySet()) {
                message.append("\n\tKey [");
                message.append(entry.getKey());
                message.append("] - Value [");
                message.append(entry.getValue());
                message.append("] - Value type [");
                message.append(entry.getValue().getClass().getName());
                message.append("]");
            }
            LoggerHelper.log(serverity, message.toString());
        }
    }

    public static void logColumnLookup(Severity severity, @NotNull String variable, Object[] columnLookup) {
        if (LoggerHelper.canLog(severity)) {
            if (columnLookup == null) {
                LoggerHelper.log(severity, "Resolved column from [" + variable + "] to NULL!!");
            } else {
                LoggerHelper.log(severity, "Resolved column from [" + variable + "] =" + "Column [" + columnLookup[0] + "], Type [" + columnLookup[1] + "], Flex Type [" + columnLookup[2] + "].");
            }
        }
    }

    public static void logInvalidTimeData(@NotNull JpqlTabularData.Item item, long timeValue) {
        String timeValueStr = null;
        if (timeValue == 1000L) {
            timeValueStr = "SECOND";
        } else if (timeValue == 60000L) {
            timeValueStr = "MINUTE";
        } else if (timeValue == 3600000L) {
            timeValueStr = "HOUR";
        } else if (timeValue == 86400000L) {
            timeValueStr = "DAY";
        }
        LoggerHelper.log(Severity.DEBUG, "logInvalidTimeData - skip non numeric data type for " + timeValueStr + " type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
    }

    public static void logInvalidAvgData(@NotNull JpqlTabularData.Item item) {
        LoggerHelper.log(Severity.DEBUG, "logInvalidAvgData - skip non numeric data type for AVG type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
    }

    public static void logInvalidAvgData(@NotNull JpqlTabularData.Item item, double totalQuantity, double totalValue) {
        LoggerHelper.log(Severity.DEBUG, "logInvalidAvgData - skip non numeric data type for AVG type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "], totalQuantity [" + totalQuantity + "], totalValue [" + totalValue + "]");
    }

    public static void logDuplicateAvgData(@NotNull JpqlTabularData.Item item, double totalQuantity, double totalValue) {
        LoggerHelper.log(Severity.DEBUG, "logDuplicateAvgData - skip duplicate / invalid data AVG type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "], totalQuantity [" + totalQuantity + "], totalValue [" + totalValue + "]");
    }

    public static void logSkipSumData(@NotNull JpqlTabularData.Item item) {
        LoggerHelper.log(Severity.DEBUG, "logSkipSumData - skip duplicate / invalid data SUM type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
    }

    public static void logNullData(@NotNull JpqlTabularData tData, @NotNull String operation, @NotNull String invalidData) {
        LoggerHelper.log(Severity.DEBUG, "logNullData - Null" + invalidData + " during " + operation + " calculation encountered. Skipping JpqlTabularData [" + tData.toString() + "].");
    }

    public static void log(Severity severity, @NotNull String message) {
        if (LoggerHelper.canLog(severity)) {
            String[] call = LoggerHelper.getCall();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_DASHBOARDS, (Severity)severity, (String)call[0], (String)call[1], (String)message);
        }
    }

    public static void log(Severity severity, @NotNull Throwable exception) {
        if (LoggerHelper.canLog(severity)) {
            String[] call = LoggerHelper.getCall();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_DASHBOARDS, (Severity)severity, (String)call[0], (String)call[1], (Throwable)exception);
        }
    }

    public static String[] getCall() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (element.getClassName().equalsIgnoreCase(LoggerHelper.class.getName()) || element.getClassName().equalsIgnoreCase(Thread.class.getName())) continue;
            return new String[]{element.getClassName(), element.getMethodName()};
        }
        return new String[]{"", ""};
    }

    public static void logWidgetData(Severity severity, @NotNull WidgetData widgetData) {
        if (LoggerHelper.canLog(severity)) {
            try {
                LoggerHelper.log(Severity.DEBUG, "logWidgetData - size [" + widgetData.size() + "]");
                int ctr = 1;
                for (JpqlTabularData td : widgetData) {
                    LoggerHelper.log(Severity.DEBUG, "logWidgetData - JpqlTabularData " + ctr + " - [" + td.toString() + "]");
                    ++ctr;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static boolean canLog(Severity severity) {
        return BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_DASHBOARDS, (Severity)severity);
    }
}

