/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import oracle.bpm.analytics.dashboard.query.JpqlTabularData;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.TabularDataType;

public class WidgetData
extends ArrayList<JpqlTabularData> {
    private static final long serialVersionUID = -100L;

    protected WidgetData() {
        super(5);
    }

    public static WidgetData create() {
        LoggerHelper.log(Severity.DEBUG, "create");
        return new WidgetData();
    }

    public static WidgetData create(JpqlTabularData jpqlTabularData) {
        LoggerHelper.log(Severity.DEBUG, "create - JpqlTabularData");
        WidgetData widgetData = new WidgetData();
        widgetData.add(jpqlTabularData);
        LoggerHelper.log(Severity.DEBUG, "widgetData " + widgetData.toString());
        return widgetData;
    }

    public static WidgetData create(Collection<JpqlTabularData> jpqlTabularData) {
        LoggerHelper.log(Severity.DEBUG, "create - Collection<JpqlTabularData>");
        WidgetData widgetData = new WidgetData();
        widgetData.addAll(jpqlTabularData);
        LoggerHelper.log(Severity.DEBUG, "widgetData " + widgetData.toString());
        return widgetData;
    }

    public WidgetData add(JpqlTabularData ... jpqlTabularData) {
        LoggerHelper.log(Severity.DEBUG, "add - JpqlTabularData...");
        super.addAll(Arrays.asList(jpqlTabularData));
        LoggerHelper.log(Severity.DEBUG, "widgetData " + this.toString());
        return this;
    }

    public TabularDataType toTabularDataType() {
        LoggerHelper.log(Severity.DEBUG, "toTabularDataType");
        this.aggregateWidgetData();
        TabularDataType result = ((JpqlTabularData)this.get(0)).toTabularDataType();
        if (this.size() > 1) {
            for (int i = 1; i < this.size(); ++i) {
                JpqlTabularData tabularData = (JpqlTabularData)this.get(i);
                for (JpqlTabularData.Item item : tabularData.toArray()) {
                    result.getRows().add(item.toRowData());
                }
            }
        }
        LoggerHelper.log(Severity.DEBUG, "toTabularDataType - " + JpqlTabularData.tabularDataTypeToString(result));
        return result;
    }

    public void aggregateWidgetData() {
        LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData");
        Object ds = null;
        if (this.isEmpty()) {
            LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - null");
            return;
        }
        AggregateFunctionTypeEnum aggregationFcn = this.validateAggregate();
        if (aggregationFcn == null) {
            LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - validation failed, either datatype or aggregation function not consistent.");
            return;
        }
        JpqlTabularData returnTD = JpqlTabularData.create();
        HashMap<String, JpqlTabularData.Item> itemHashMap = new HashMap<String, JpqlTabularData.Item>();
        for (int i = 0; i < this.size(); ++i) {
            JpqlTabularData td = (JpqlTabularData)this.get(i);
            LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - td(" + i + ") - " + td.toString());
            if (td == null) continue;
            if (i == 0) {
                for (JpqlTabularData.Item item : td) {
                    LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - item " + item.toString());
                    itemHashMap.put(item.getSeries(), item);
                }
                continue;
            }
            for (JpqlTabularData.Item item : td) {
                if (itemHashMap.containsKey(item.getSeries())) {
                    LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - match item found (" + item.getSeries() + "), aggregating " + item.toString());
                    itemHashMap.put(item.getSeries(), item.aggregate(aggregationFcn, (JpqlTabularData.Item)itemHashMap.get(item.getSeries())));
                } else {
                    LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - no match item found " + item.toString());
                }
                itemHashMap.put(item.getSeries(), item);
            }
        }
        returnTD.addAll(itemHashMap.values());
        this.clear();
        this.add(returnTD);
        LoggerHelper.log(Severity.DEBUG, "aggregateWidgetData - this " + this.toString());
    }

    @Override
    public String toString() {
        String widgetString = "";
        String seperator = " ; ";
        if (this.isEmpty()) {
            widgetString = "WidgetData is empty.";
        } else {
            for (JpqlTabularData td : this) {
                widgetString = td != null ? widgetString + td.toString() : widgetString + "JpqlTabularData is null.";
                widgetString = widgetString + seperator;
            }
        }
        return widgetString;
    }

    private AggregateFunctionTypeEnum validateAggregate() {
        LoggerHelper.log(Severity.DEBUG, "validateAggregate");
        DataSourceTypeEnum ds = null;
        AggregateFunctionTypeEnum ag = null;
        if (this.isEmpty()) {
            LoggerHelper.log(Severity.DEBUG, "validateAggregate - empty list.");
            return null;
        }
        if (this.size() == 1) {
            LoggerHelper.log(Severity.DEBUG, "validateAggregate - only 1 on list, no need to aggregate.");
            return null;
        }
        JpqlTabularData.Metadata md = ((JpqlTabularData)this.get(0)).getMetadata();
        if (md != null) {
            ag = md.getAggregateFunction();
            ds = md.getDataSourceType();
        }
        for (int i = 1; i < this.size(); ++i) {
            JpqlTabularData.Metadata mdi = ((JpqlTabularData)this.get(i)).getMetadata();
            if (mdi == null) {
                LoggerHelper.log(Severity.DEBUG, "validateAggregate - item (" + i + ") is null.");
                return null;
            }
            if (mdi.getAggregateFunction() == ag && mdi.getDataSourceType() == ds) continue;
            LoggerHelper.log(Severity.DEBUG, "validateAggregate - mismatch detected ag (" + ag + ") mdi.ag (" + mdi.getAggregateFunction() + ") ds (" + ds + ") mdi.ds (" + mdi.getDataSourceType() + ").");
            return null;
        }
        LoggerHelper.log(Severity.DEBUG, "validateAggregate - ok : DataSourceTypeEnum [" + ds.value() + "], AggregateFunctionTypeEnum [" + ag.value() + "].");
        return ag;
    }
}

