/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;
import oracle.bpm.analytics.dashboard.query.VariableNotFoundException;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.processdashboard.IDashboardConstants;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import org.jetbrains.annotations.NotNull;

public class SqlLookup {
    public static Map<String, Column> standardDimensions = new TreeMap<String, Column>();
    public static Map<String, List<Column>> standardDimensionsColumn = new TreeMap<String, List<Column>>();
    private static Column COLUMN_processDomainName = Column.create(CubeProcess.class.getSimpleName(), "domainName", String.class.getName());
    private static Column COLUMN_processCompositeName = Column.create(CubeProcess.class.getSimpleName(), "compositeName", String.class.getName());
    private static Column COLUMN_processCompositeLabel = Column.create(CubeProcess.class.getSimpleName(), "compositeLabel", String.class.getName());
    private static Column COLUMN_processCompositeRevision = Column.create(CubeProcess.class.getSimpleName(), "compositeRevision", String.class.getName());
    private static Column COLUMN_processName = Column.create(CubeProcess.class.getSimpleName(), "processName", String.class.getName());
    private static Column COLUMN_processLabel = Column.create(CubeProcess.class.getSimpleName(), "label", String.class.getName());
    private static Column COLUMN_roleName = Column.create(CubeRole.class.getSimpleName(), "roleName", String.class.getName());
    private static Column COLUMN_roleLabel = Column.create(CubeRole.class.getSimpleName(), "label", String.class.getName());
    private static Column COLUMN_activityName = Column.create(CubeActivity.class.getSimpleName(), "activityName", String.class.getName());
    private static Column COLUMN_activityLabel = Column.create(CubeActivity.class.getSimpleName(), "label", "String");
    private static Column COLUMN_activityProcessName = Column.create("cubeprocess2", "processName", String.class.getName());
    private static Column COLUMN_measurementName = Column.create(CubeActivity.class.getSimpleName(), "activityName", String.class.getName());
    private static Column COLUMN_measurementLabel = Column.create(CubeActivity.class.getSimpleName(), "label", "String");
    private static Column COLUMN_quantity = Column.create(CubeWorkload.class.getSimpleName(), "quantity", Long.class.getName());
    private static Column COLUMN_taskComponentInstance = Column.create(CubeTaskPerformance.class.getSimpleName(), "componentInstanceId", String.class.getName());
    private static Column COLUMN_processComponentInstance = Column.create(CubeProcessPerformance.class.getSimpleName(), "componentInstanceId", String.class.getName());
    private static Column COLUMN_activityType = Column.create(CubeActivity.class.getSimpleName(), "activityType", String.class.getName());

    public static Column lookupColumn(@NotNull PersistenceQueryService persistenceQueryService, @NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull String variable, boolean useRange) throws DashboardQueryException {
        Class clazz = SqlLookup.lookupTable(dataSource);
        if (componentDN != null) {
            LoggerHelper.log(Severity.DEBUG, "ComponentDN [" + componentDN + "], Column [" + variable + "].");
            Object[] resolveFlexAttribute = SqlLookup.resolveFlexAttribute(persistenceQueryService, componentDN, variable, useRange);
            LoggerHelper.logColumnLookup(Severity.DEBUG, variable, resolveFlexAttribute);
            if (resolveFlexAttribute != null && !variable.equals(resolveFlexAttribute[0])) {
                return Column.create(clazz.getSimpleName(), resolveFlexAttribute[0].toString(), resolveFlexAttribute[1].toString(), resolveFlexAttribute[2].toString());
            }
        }
        if (standardDimensions.containsKey(variable)) {
            return standardDimensions.get(variable);
        }
        if (dataSource == DataSourceTypeEnum.CUBE_WORKLOAD && "quantityOfInstances".equals(variable)) {
            return SqlLookup.getQuantityColumn();
        }
        if (dataSource != DataSourceTypeEnum.CUBE_WORKLOAD && "quantityOfInstances".equals(variable)) {
            switch (dataSource) {
                case CUBE_PROCESS_PERFORMANCE: {
                    return SqlLookup.getProcessPerformanceComponentInstanceColumn();
                }
                case CUBE_TASK_PERFORMANCE: {
                    return SqlLookup.getTaskPerformanceComponentInstanceColumn();
                }
            }
            throw new VariableNotFoundException(variable);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(variable)) continue;
            return Column.create(clazz.getSimpleName(), field.getName(), field.getType().getName());
        }
        if (componentDN != null) {
            throw new VariableNotFoundException(variable, componentDN.getDNString());
        }
        throw new VariableNotFoundException(variable);
    }

    public static List<Column> lookupColumns(@NotNull PersistenceQueryService persistenceQueryService, @NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull String variable, boolean useRange) throws DashboardQueryException {
        if (standardDimensionsColumn.containsKey(variable)) {
            return standardDimensionsColumn.get(variable);
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(SqlLookup.lookupColumn(persistenceQueryService, dataSource, componentDN, variable, useRange));
        return columns;
    }

    public static List<Column> lookupGroupByColumns(@NotNull PersistenceQueryService persistenceQueryService, @NotNull DataSourceTypeEnum dataSource, ComponentDNModel componentDN, @NotNull String variable) throws DashboardQueryException {
        if (standardDimensionsColumn.containsKey(variable)) {
            return standardDimensionsColumn.get(variable);
        }
        return SqlLookup.lookupColumns(persistenceQueryService, dataSource, componentDN, variable, false);
    }

    public static boolean isStandardMeasurement(@NotNull String variable, @NotNull DataSourceTypeEnum dataSource) {
        Collection standardMeasurements = null;
        switch (dataSource) {
            case CUBE_WORKLOAD: {
                standardMeasurements = IDashboardConstants.workloadStandardMeasurements;
                break;
            }
            case CUBE_PROCESS_PERFORMANCE: {
                standardMeasurements = IDashboardConstants.processPerformanceStandardMeasurements;
                break;
            }
            case CUBE_TASK_PERFORMANCE: {
                standardMeasurements = IDashboardConstants.taskPerformanceStandardMeasurements;
            }
        }
        return standardMeasurements != null && standardMeasurements.contains(variable);
    }

    public static String getWorkloadTable() {
        return CubeWorkload.class.getSimpleName();
    }

    public static String getTaskPerformanceTable() {
        return CubeTaskPerformance.class.getSimpleName();
    }

    public static String getProcessPerformanceTable() {
        return CubeProcessPerformance.class.getSimpleName();
    }

    public static Column getProcessDomainColumn() {
        return COLUMN_processDomainName;
    }

    public static Column getProcessCompositeNameColumn() {
        return COLUMN_processCompositeName;
    }

    public static Column getProcessCompositeRevisionColumn() {
        return COLUMN_processCompositeRevision;
    }

    public static Column getProcessCompositeLabelColumn() {
        return COLUMN_processCompositeLabel;
    }

    public static Column getProcessNameColumn() {
        return COLUMN_processName;
    }

    public static Column getProcessLabelColumn() {
        return COLUMN_processLabel;
    }

    public static Column getActivityNameColumn() {
        return COLUMN_activityName;
    }

    public static Column getActivityLabelColumn() {
        return COLUMN_activityLabel;
    }

    public static Column getActivityProcessNameColumn() {
        return COLUMN_activityProcessName;
    }

    public static Column getMeasurementNameColumn() {
        return COLUMN_measurementName;
    }

    public static Column getMeasurementLabelColumn() {
        return COLUMN_measurementLabel;
    }

    public static Column getRoleNameColumn() {
        return COLUMN_roleName;
    }

    public static Column getRoleLabelColumn() {
        return COLUMN_roleLabel;
    }

    public static Column getQuantityColumn() {
        return COLUMN_quantity;
    }

    public static Column getActivityTypeColumn() {
        return COLUMN_activityType;
    }

    public static Column getDateTimeColumn(@NotNull Column column) {
        if (column.getColumnName().equalsIgnoreCase("completionDate")) {
            LoggerHelper.log(Severity.DEBUG, "Converting column name from completionDate to completionDateTime");
            return Column.create(column.getTableName(), "completionDateTime", column.getColumnType());
        }
        if (column.getColumnName().equalsIgnoreCase("creationDate")) {
            LoggerHelper.log(Severity.DEBUG, "Converting column name from creationDate to creationDateTime");
            return Column.create(column.getTableName(), "creationDateTime", column.getColumnType());
        }
        return column;
    }

    public static Column getTaskPerformanceComponentInstanceColumn() {
        return COLUMN_taskComponentInstance;
    }

    public static Column getProcessPerformanceComponentInstanceColumn() {
        return COLUMN_processComponentInstance;
    }

    private static Class lookupTable(@NotNull DataSourceTypeEnum dataSource) {
        switch (dataSource) {
            case CUBE_WORKLOAD: {
                return CubeWorkload.class;
            }
            case CUBE_PROCESS_PERFORMANCE: {
                return CubeProcessPerformance.class;
            }
            case CUBE_TASK_PERFORMANCE: {
                return CubeTaskPerformance.class;
            }
        }
        throw new IllegalArgumentException("Invalid " + DataSourceTypeEnum.class.getName());
    }

    private static Object[] resolveFlexAttribute(@NotNull PersistenceQueryService persistenceQueryService, @NotNull ComponentDNModel componentDN, @NotNull String attribute, boolean useRange) throws DashboardQueryException {
        try {
            if (componentDN.getCompositeDN() == null) {
                throw new DashboardQueryException("CompositeDN Model is null");
            }
            if (componentDN.getCompositeDN().getDNString() == null) {
                throw new DashboardQueryException("Composite DN String is null");
            }
            LoggerHelper.log(Severity.DEBUG, "Composite DN String: [" + componentDN.getCompositeDN().getDNString() + "], Composite Name: [" + componentDN.getCompositeDN().getCompositeName() + "], Application Name: [" + componentDN.getCompositeDN().getApplicationName() + "], Component Name: [" + componentDN.getComponentName() + "], Label: [" + componentDN.getCompositeDN().getLabel() + "], Revision: [" + componentDN.getCompositeDN().getRevision() + "], attribute: [" + attribute + "], useRange: [" + useRange + "]");
            return persistenceQueryService.resolveFlexAttribute(componentDN.getCompositeDN().getDNString(), attribute, useRange);
        }
        catch (Exception cause) {
            throw new DashboardQueryException(cause);
        }
    }

    static {
        standardDimensions.put("project", COLUMN_processCompositeName);
        standardDimensions.put("revision", COLUMN_processCompositeRevision);
        standardDimensions.put("process", COLUMN_processName);
        standardDimensions.put("role", COLUMN_roleName);
        standardDimensions.put("activity", COLUMN_activityName);
        standardDimensions.put("measurement", COLUMN_measurementName);
        standardDimensions.put("activityType", COLUMN_activityType);
        ArrayList<Column> fields = new ArrayList<Column>();
        fields.add(COLUMN_processDomainName);
        fields.add(COLUMN_processCompositeName);
        fields.add(COLUMN_processName);
        fields.add(COLUMN_processLabel);
        standardDimensionsColumn.put("process", fields);
        fields = new ArrayList();
        fields.add(COLUMN_roleName);
        fields.add(COLUMN_roleLabel);
        standardDimensionsColumn.put("role", fields);
        fields = new ArrayList();
        fields.add(COLUMN_processDomainName);
        fields.add(COLUMN_processCompositeName);
        fields.add(COLUMN_processName);
        fields.add(COLUMN_processLabel);
        fields.add(COLUMN_activityName);
        fields.add(COLUMN_activityLabel);
        fields.add(COLUMN_activityProcessName);
        standardDimensionsColumn.put("activity", fields);
        fields = new ArrayList();
        fields.add(COLUMN_processDomainName);
        fields.add(COLUMN_processCompositeName);
        fields.add(COLUMN_processName);
        fields.add(COLUMN_processLabel);
        fields.add(COLUMN_measurementName);
        fields.add(COLUMN_measurementLabel);
        standardDimensionsColumn.put("measurement", fields);
    }

    public static class Column {
        private String businessIndicatorType;
        private String columnName;
        private String columnType;
        private String tableName;
        public static final String MEASURE = "M";
        public static final String DIMENSION = "D";
        public static final String COUNTER = "C";
        public static final String NUMBER = "Number";
        public static final String TIMESTAMP = "Timestamp";
        public static final String STRING = "String";

        private Column(String tableName, String columnName, String columnType, String businessIndicatorType) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.columnType = columnType;
            this.businessIndicatorType = businessIndicatorType;
        }

        public static Column create(String tableName, String columnName) {
            return new Column(tableName, columnName, STRING, "");
        }

        public static Column create(String tableName, String columnName, String columnType) {
            return new Column(tableName, columnName, columnType, "");
        }

        public static Column create(String tableName, String columnName, String columnType, String biType) {
            return new Column(tableName, columnName, columnType, biType);
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public String getBusinessIndicatorType() {
            return this.businessIndicatorType;
        }

        public String getQualifiedColumn() {
            return this.getTableName().toLowerCase() + "." + this.getColumnName();
        }

        public boolean isMeasure() {
            return MEASURE.equalsIgnoreCase(this.getBusinessIndicatorType());
        }

        public boolean isDimension() {
            return DIMENSION.equalsIgnoreCase(this.getBusinessIndicatorType());
        }

        public boolean isCounter() {
            return COUNTER.equalsIgnoreCase(this.getBusinessIndicatorType());
        }
    }
}

