/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.SqlLookup;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.RowDataType;
import oracle.bpm.services.processdashboard.model.jaxb.TabularDataType;
import oracle.bpm.services.processdashboard.model.jaxb.TabularMetadataType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueDataType;

public class JpqlTabularData
extends ArrayList<Item> {
    private Metadata metadata;
    private static final long serialVersionUID = -100L;
    public static final String SEPARATOR = "/";

    private JpqlTabularData() {
        super(5);
    }

    public static JpqlTabularData create() {
        return new JpqlTabularData();
    }

    public static JpqlTabularData create(List jpqlQueryResult) {
        JpqlTabularData jpqlTabularData = new JpqlTabularData();
        for (Object object : jpqlQueryResult) {
            jpqlTabularData.add(Item.create(object));
        }
        return jpqlTabularData;
    }

    public static JpqlTabularData create(JPQLQuery jpqlQuery, List jpqlQueryResult) {
        if (jpqlQuery.getMetadata() == null) {
            return JpqlTabularData.create(jpqlQueryResult);
        }
        JPQLQuery.Metadata jpqlMetadata = jpqlQuery.getMetadata();
        Metadata metadata = Metadata.create(jpqlMetadata.getMeasureLabel(), jpqlMetadata.getSeriesLabel(), jpqlMetadata.getGroupLabel(), jpqlQuery.getAggregateFunctionType(), jpqlQuery.getDataSourceType());
        JpqlTabularData jpqlTabularData = new JpqlTabularData();
        jpqlTabularData.setMetadata(metadata);
        for (Object object : jpqlQueryResult) {
            jpqlTabularData.add(Item.create(jpqlMetadata, object));
        }
        return jpqlTabularData;
    }

    public static String tabularDataTypeToString(TabularDataType tabularDataType) {
        String printStr = tabularDataType == null ? "TabularDataType is null." : "TabularDataType : Metadata <" + JpqlTabularData.tabularMetadataTypeToString(tabularDataType.getMetadata()) + ">, Type <" + tabularDataType.getType() + ">, Rows <" + JpqlTabularData.rowDataTypeListToString(tabularDataType.getRows()) + ">. ";
        return printStr;
    }

    public Item[] toArray() {
        return super.toArray(new Item[this.size()]);
    }

    public List<Serializable[]> toList() {
        ArrayList<Serializable[]> list = new ArrayList<Serializable[]>();
        for (Item item : this.toArray()) {
            list.add(item.toArray());
        }
        return list;
    }

    @Override
    public String toString() {
        String tabularDataStr = "Jpql Tabular Data - size [" + this.size() + "]\n";
        tabularDataStr = tabularDataStr + (this.getMetadata() == null ? "Metadata is null. " : this.getMetadata().toString());
        for (Item item : this.toArray()) {
            tabularDataStr = tabularDataStr + item.toString() + "\n";
        }
        return tabularDataStr;
    }

    public TabularDataType toTabularDataType() {
        TabularDataType tabularDataType = ModelTypeFactory.getWidgetTypeFactory().createTabularDataType();
        if (this.getMetadata() != null) {
            TabularMetadataType tabularMetadataType = ModelTypeFactory.getWidgetTypeFactory().createTabularMetadataType();
            tabularMetadataType.setMeasure(this.getMetadata().getMeasure());
            tabularMetadataType.setSeries(this.getMetadata().getSeries());
            tabularMetadataType.setGroup(this.getMetadata().getGroup());
            tabularDataType.setMetadata(tabularMetadataType);
        }
        for (Item item : this.toArray()) {
            tabularDataType.getRows().add(item.toRowData());
        }
        return tabularDataType;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    private static String tabularMetadataTypeToString(TabularMetadataType tabularMetadataType) {
        String printStr = tabularMetadataType == null ? "TabularMetadataType is null." : "TabularMetadataType : Group [" + tabularMetadataType.getGroup() + "], Measure [" + tabularMetadataType.getMeasure() + "], Series [" + tabularMetadataType.getSeries() + "]. ";
        return printStr;
    }

    private static String rowDataTypeListToString(List<RowDataType> rowDataTypeList) {
        String printStr = rowDataTypeList == null ? "RowDataTypeList is null." : "RowDataTypeList size (" + rowDataTypeList.size() + ") == ";
        for (RowDataType rowDataType : rowDataTypeList) {
            printStr = printStr + JpqlTabularData.rowDataTypeToString(rowDataType);
        }
        return printStr;
    }

    private static String rowDataTypeToString(RowDataType rowDataType) {
        String printStr = rowDataType == null ? "RowDataType is null." : "RowDataType : Group {" + JpqlTabularData.valueDataTypeToString(rowDataType.getGroup()) + "}, Measure {" + JpqlTabularData.valueDataTypeToString(rowDataType.getMeasure()) + "}, Series {" + JpqlTabularData.valueDataTypeToString(rowDataType.getSeries()) + "}. ";
        return printStr;
    }

    private static String valueDataTypeToString(ValueDataType valueDataType) {
        String printStr = valueDataType == null ? "ValueDataType is null." : "ValueDataType = JavaType[" + valueDataType.getJavaType() + "], Shortlabel[" + valueDataType.getShortlabel() + "], Label[" + valueDataType.getLabel() + "], Value[" + valueDataType.getValue() + "].";
        return printStr;
    }

    private static class Utils {
        private Utils() {
        }

        public static Number getQuantity(JPQLQuery.Metadata metadata, Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                int groupPos = Utils.isCustomDatasourceGroup(metadata) ? 0 : metadata.getGroup().size();
                int initPos = groupPos + metadata.getSeries().size();
                if (array.length == initPos + 2) {
                    return (Number)array[array.length - 1];
                }
                if (array.length == initPos + 1) {
                    return (Number)array[array.length - 1];
                }
            }
            return null;
        }

        public static Object getMeasure(JPQLQuery.Metadata metadata, Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                int groupPos = Utils.isCustomDatasourceGroup(metadata) ? 0 : metadata.getGroup().size();
                int initPos = groupPos + metadata.getSeries().size();
                if (array.length == initPos + 1) {
                    return array[array.length - 1];
                }
                if (array.length == initPos + 2) {
                    return array[array.length - 2];
                }
                return null;
            }
            return value;
        }

        public static Item.Dimension getSeriesData(JPQLQuery.Metadata metadata, Object value) {
            Object[] array;
            if (value != null && value.getClass().isArray() && (array = (Object[])value).length > 1 && metadata.getSeries().size() > 0) {
                int initPos = Utils.isCustomDatasourceGroup(metadata) ? 0 : metadata.getGroup().size();
                int length = metadata.getSeries().size();
                if (length + initPos <= array.length - 1) {
                    Object[] seriesData = new Object[length];
                    System.arraycopy(array, initPos, seriesData, 0, length);
                    return Utils.getDimension(metadata.getSeries(), seriesData, metadata.seriesUseRanges());
                }
            }
            return null;
        }

        public static Item.Dimension getGroupData(JPQLQuery.Metadata metadata, Object value) {
            Object[] array;
            if (value != null && Utils.isCustomDatasourceGroup(metadata)) {
                return Utils.getDataSourceDimension(metadata.getGroup().get(0));
            }
            if (value != null && value.getClass().isArray() && (array = (Object[])value).length > 2 && metadata.getGroup().size() > 0) {
                int initPos = 0;
                int length = metadata.getGroup().size();
                if (length <= array.length - 2) {
                    Object[] groupData = new Object[length];
                    System.arraycopy(array, initPos, groupData, 0, length);
                    return Utils.getDimension(metadata.getGroup(), groupData, metadata.groupUseRanges());
                }
            }
            return null;
        }

        public static Item.Dimension getParticipantDimension(Object[] value) {
            String participantId = null;
            String participantLabel = "default";
            if (value[0] != null) {
                String composite;
                participantId = value[0].toString();
                int typeSeparatorIndex = participantId.lastIndexOf(",");
                int compositeSeparatorIndex = participantId.lastIndexOf(".");
                String type = typeSeparatorIndex == -1 ? "user" : participantId.substring(typeSeparatorIndex + 1);
                String string = composite = compositeSeparatorIndex == -1 ? null : participantId.substring(0, compositeSeparatorIndex);
                String user = compositeSeparatorIndex == -1 ? (typeSeparatorIndex == -1 ? participantId : participantId.substring(0, typeSeparatorIndex)) : (typeSeparatorIndex == -1 ? participantId.substring(compositeSeparatorIndex + 1) : participantId.substring(compositeSeparatorIndex + 1, typeSeparatorIndex));
                participantLabel = (composite != null ? "[" + composite + "] " : "") + user + " (" + type + ")";
            }
            return new Item.Dimension(participantId, participantLabel);
        }

        private static Item.Dimension getDataSourceDimension(String group) {
            String label = group.equals(DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE.value()) ? "HISTORICAL_PROCESS_PERFORMANCE" : (group.equals(DataSourceTypeEnum.CUBE_TASK_PERFORMANCE.value()) ? "HISTORICAL_TASK_PERFORMANCE" : (group.equals(DataSourceTypeEnum.CUBE_WORKLOAD.value()) ? "CURRENT_WORKLOAD" : "INVALID_DATA_SOURCE"));
            return new Item.Dimension(group, label);
        }

        private static boolean isCustomDatasourceGroup(JPQLQuery.Metadata metadata) {
            List<String> groups = metadata.getGroup();
            if (groups.size() == 1) {
                String group = groups.get(0);
                return group.equals(DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE.value()) || group.equals(DataSourceTypeEnum.CUBE_TASK_PERFORMANCE.value()) || group.equals(DataSourceTypeEnum.CUBE_WORKLOAD.value());
            }
            return false;
        }

        private static Item.Dimension getDimension(List<String> qualifiedColumns, Object[] value, boolean useRanges) {
            Object id;
            if (Utils.isProcessDimension(qualifiedColumns)) {
                return Utils.getProcessDimension(qualifiedColumns, value);
            }
            if (Utils.isActivityDimension(qualifiedColumns)) {
                return Utils.getActivityDimension(qualifiedColumns, value);
            }
            if (Utils.isRoleDimension(qualifiedColumns)) {
                return Utils.getRoleDimension(qualifiedColumns, value);
            }
            if (Utils.isParticipantDimension(qualifiedColumns)) {
                return Utils.getParticipantDimension(value);
            }
            String label = null;
            int length = value.length;
            if (length > 1) {
                label = value[--length].toString();
                StringBuilder idStr = new StringBuilder("");
                boolean appendSeparator = false;
                for (int i = 0; i < length; ++i) {
                    if (appendSeparator) {
                        idStr.append(JpqlTabularData.SEPARATOR);
                    }
                    idStr.append(value[i].toString());
                    appendSeparator = true;
                }
                id = idStr.toString();
            } else {
                id = value[--length];
            }
            if ((id == null || id.toString().isEmpty()) && (label == null || label.isEmpty())) {
                LoggerHelper.log(Severity.DEBUG, "getDimension - resetting label since id is [" + id + "] and label is [" + label + "] - useRanges is [" + useRanges + "] qualifiedColumns is [" + qualifiedColumns + "]");
                if (useRanges) {
                    label = "Out of range";
                } else if (Utils.isParticipantDimension(qualifiedColumns)) {
                    label = "Default";
                }
                LoggerHelper.log(Severity.DEBUG, "getDimension - reset label to [" + label + "]");
            }
            return new Item.Dimension(id, label);
        }

        private static boolean isProcessDimension(List<String> qualifiedColumns) {
            List<SqlLookup.Column> columns = SqlLookup.standardDimensionsColumn.get("process");
            int quantity = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                boolean containsColumn = false;
                for (SqlLookup.Column column : columns) {
                    if (!column.getQualifiedColumn().equals(qualifiedColumn)) continue;
                    containsColumn = true;
                }
                if (containsColumn) {
                    ++quantity;
                    continue;
                }
                return false;
            }
            return quantity == columns.size();
        }

        private static Item.Dimension getProcessDimension(List<String> qualifiedColumns, Object[] value) {
            String domainName = null;
            String compositeName = null;
            String processName = null;
            String processLabel = null;
            int index = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                if (SqlLookup.getProcessDomainColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    domainName = value[index].toString();
                } else if (SqlLookup.getProcessCompositeNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    compositeName = value[index].toString();
                } else if (SqlLookup.getProcessNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processName = value[index].toString();
                } else if (SqlLookup.getProcessLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processLabel = value[index].toString();
                }
                ++index;
            }
            String id = domainName + JpqlTabularData.SEPARATOR + compositeName + JpqlTabularData.SEPARATOR + processName;
            String label = "[" + compositeName + "] " + (processLabel != null ? processLabel : processName);
            String shortLabel = processLabel != null ? processLabel : processName;
            return new Item.Dimension(id, label, shortLabel);
        }

        private static boolean isActivityDimension(List<String> qualifiedColumns) {
            List<SqlLookup.Column> columns = SqlLookup.standardDimensionsColumn.get("activity");
            int quantity = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                boolean containsColumn = false;
                for (SqlLookup.Column column : columns) {
                    if (!column.getQualifiedColumn().equals(qualifiedColumn)) continue;
                    containsColumn = true;
                }
                if (containsColumn) {
                    ++quantity;
                    continue;
                }
                return false;
            }
            return quantity == columns.size();
        }

        private static Item.Dimension getActivityDimension(List<String> qualifiedColumns, Object[] value) {
            String domainName = null;
            String compositeName = null;
            String processName = null;
            String processLabel = null;
            String activityName = null;
            String activityLabel = null;
            String activityProcessName = null;
            int index = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                if (SqlLookup.getProcessDomainColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    domainName = value[index].toString();
                } else if (SqlLookup.getProcessCompositeNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    compositeName = value[index].toString();
                } else if (SqlLookup.getProcessNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processName = value[index].toString();
                } else if (SqlLookup.getProcessLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processLabel = value[index].toString();
                } else if (SqlLookup.getActivityNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    activityName = value[index].toString();
                } else if (SqlLookup.getActivityLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    activityLabel = value[index].toString();
                } else if (SqlLookup.getActivityProcessNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    activityProcessName = value[index].toString();
                }
                ++index;
            }
            String id = domainName + JpqlTabularData.SEPARATOR + compositeName + JpqlTabularData.SEPARATOR + processName + JpqlTabularData.SEPARATOR + activityProcessName + '#' + activityName;
            boolean callable = processName == null ? activityProcessName != null : !processName.equals(activityProcessName);
            String label = "[" + compositeName + "] " + (processLabel == null || processLabel.isEmpty() ? processName : processLabel) + (callable ? "(" + activityProcessName + ")" : "") + " > " + (activityLabel == null || activityLabel.isEmpty() ? activityName : activityLabel);
            String shortLabel = activityLabel == null || activityLabel.isEmpty() ? activityName : activityLabel;
            return new Item.Dimension(id, label, shortLabel);
        }

        private static boolean isRoleDimension(List<String> qualifiedColumns) {
            List<SqlLookup.Column> columns = SqlLookup.standardDimensionsColumn.get("role");
            int quantity = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                boolean containsColumn = false;
                for (SqlLookup.Column column : columns) {
                    if (!column.getQualifiedColumn().equals(qualifiedColumn)) continue;
                    containsColumn = true;
                }
                if (containsColumn) {
                    ++quantity;
                    continue;
                }
                return false;
            }
            return quantity == columns.size();
        }

        private static Item.Dimension getRoleDimension(List<String> qualifiedColumns, Object[] value) {
            String roleName = null;
            String roleLabel = null;
            int index = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                if (SqlLookup.getRoleNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    roleName = value[index].toString();
                } else if (SqlLookup.getRoleLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    roleLabel = value[index].toString();
                }
                ++index;
            }
            String id = roleName;
            String label = roleLabel == null || roleLabel.isEmpty() ? Utils.getUnqualifiedRoleName(roleName) : roleLabel;
            return new Item.Dimension(id, label);
        }

        private static String getUnqualifiedRoleName(String roleName) {
            String ROLE_QUALIFIED_SEPARATOR = ",";
            if (roleName == null) {
                return null;
            }
            int indexOf = roleName.lastIndexOf(",");
            return indexOf > 0 ? roleName.substring(0, indexOf) : roleName;
        }

        private static boolean isParticipantDimension(List<String> qualifiedColumns) {
            String workloadColumn = CubeWorkload.class.getSimpleName().toLowerCase() + "." + "participant";
            String taskPerformanceColumn = CubeTaskPerformance.class.getSimpleName().toLowerCase() + "." + "participant";
            if (qualifiedColumns != null && qualifiedColumns.size() == 1) {
                String qualifiedColumn = qualifiedColumns.get(0);
                return qualifiedColumn.equals(workloadColumn) || qualifiedColumn.equals(taskPerformanceColumn);
            }
            return false;
        }
    }

    public static class Metadata
    implements Serializable {
        private AggregateFunctionTypeEnum aggregateFunction = null;
        private DataSourceTypeEnum dataSourceType = null;
        private String group;
        private String measure;
        private String series;
        private static final long serialVersionUID = -100L;

        private Metadata(String measure, String series, String group, AggregateFunctionTypeEnum aggregateFunction, DataSourceTypeEnum dataSourceType) {
            this.measure = measure;
            this.series = series;
            this.group = group;
            this.aggregateFunction = aggregateFunction;
            this.dataSourceType = dataSourceType;
        }

        public static Metadata create(String measure, String series, String group, AggregateFunctionTypeEnum aggregateFunction, DataSourceTypeEnum dataSourceType) {
            return new Metadata(measure, series, group, aggregateFunction, dataSourceType);
        }

        public String getMeasure() {
            return this.measure;
        }

        public void setMeasure(String measure) {
            this.measure = measure;
        }

        public void setAggregateFunction(AggregateFunctionTypeEnum aggregateFunction) {
            this.aggregateFunction = aggregateFunction;
        }

        public void setDataSourceType(DataSourceTypeEnum dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        public String getSeries() {
            return this.series;
        }

        public String getGroup() {
            return this.group;
        }

        public AggregateFunctionTypeEnum getAggregateFunction() {
            return this.aggregateFunction;
        }

        public DataSourceTypeEnum getDataSourceType() {
            return this.dataSourceType;
        }

        public String toString() {
            return "Metadata : AggregateFunctionTypeEnum [" + this.aggregateFunction + "], DataSourceTypeEnum [" + this.dataSourceType + "], \nGroup [" + this.getGroup() + "], measure [" + this.getMeasure() + "], series [" + this.getSeries() + "].";
        }
    }

    public static class Item
    implements Serializable {
        private Dimension group = null;
        private Number quantity = null;
        private Dimension series = null;
        private Object value = null;
        private static final long serialVersionUID = -100L;

        private Item() {
        }

        public static Item create(Object value) {
            Item tabularDataItem = new Item();
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                switch (array.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        tabularDataItem.setValue(array[0]);
                        break;
                    }
                    case 2: {
                        tabularDataItem.setSeriesValue(array[0]);
                        tabularDataItem.setValue(array[1]);
                        break;
                    }
                    case 3: {
                        tabularDataItem.setGroupValue(array[0]);
                        tabularDataItem.setSeriesValue(array[1]);
                        tabularDataItem.setValue(array[2]);
                        break;
                    }
                    default: {
                        int length = array.length;
                        tabularDataItem.setQuantity((Number)array[--length]);
                        tabularDataItem.setValue(array[--length]);
                        tabularDataItem.setSeriesValue(array[--length]);
                        tabularDataItem.setGroupValue(array[--length]);
                        break;
                    }
                }
            } else {
                tabularDataItem.setValue(value);
            }
            return tabularDataItem;
        }

        public static Item create(JPQLQuery.Metadata metadata, Object value) {
            Item tabularDataItem = new Item();
            tabularDataItem.setValue(Utils.getMeasure(metadata, value));
            tabularDataItem.setSeries(Utils.getSeriesData(metadata, value));
            tabularDataItem.setGroup(Utils.getGroupData(metadata, value));
            Number quantity = Utils.getQuantity(metadata, value);
            if (quantity == null) {
                tabularDataItem.setQuantity(null);
            } else {
                tabularDataItem.setQuantity(quantity);
            }
            return tabularDataItem;
        }

        public String getSeries() {
            if (this.series == null) {
                return "";
            }
            return this.getString(this.series.getId());
        }

        public Dimension getSeriesDimension() {
            return this.series;
        }

        public String getGroup() {
            if (this.group == null) {
                return "";
            }
            return this.getString(this.group.getId());
        }

        public Dimension getGroupDimension() {
            return this.group;
        }

        public Number getQuantity() {
            return this.quantity;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public String getAggregationId() {
            return this.getGroup() + "$" + this.getSeries();
        }

        public Serializable[] toArray() {
            Serializable[] array = new Serializable[]{this.getString(this.group.getId()), this.getString(this.series.getId()), (Serializable)this.value};
            return array;
        }

        public String toString() {
            String itemStr = "Item: group [";
            itemStr = itemStr + (this.group == null ? "null" : this.group.toString());
            itemStr = itemStr + "] series [";
            itemStr = itemStr + (this.series == null ? "null" : this.series.toString());
            itemStr = itemStr + "] value [";
            itemStr = itemStr + (this.value == null ? "null" : this.value.toString());
            itemStr = itemStr + "] quantity [";
            itemStr = itemStr + (this.quantity == null ? "null" : this.quantity.toString());
            itemStr = itemStr + "]\n";
            return itemStr;
        }

        public RowDataType toRowData() {
            ValueDataType measure = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();
            if (this.value == null) {
                measure.setNull(true);
            } else {
                measure.setNull(false);
                measure.setValue(this.getString(this.value));
                measure.setJavaType(this.value.getClass().getName());
                measure.setLabel(null);
            }
            ValueDataType xSeries = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();
            if (this.series == null) {
                xSeries.setNull(true);
            } else {
                xSeries.setNull(false);
                xSeries.setValue(this.getString(this.series.getId()));
                xSeries.setJavaType(this.series.getId().getClass().getName());
                xSeries.setLabel(this.series.getLabel());
            }
            ValueDataType xGroup = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();
            if (this.group == null) {
                xGroup.setNull(true);
            } else {
                xGroup.setNull(false);
                xGroup.setValue(this.getString(this.group.getId()));
                xGroup.setJavaType(this.group.getId().getClass().getName());
                xGroup.setLabel(this.group.getLabel());
            }
            RowDataType rowData = ModelTypeFactory.getWidgetTypeFactory().createRowDataType();
            rowData.setMeasure(measure);
            rowData.setSeries(xSeries);
            rowData.setGroup(xGroup);
            return rowData;
        }

        public void setQuantity(Number quantity) {
            this.quantity = quantity;
        }

        public Item aggregate(AggregateFunctionTypeEnum aggregateFunction, Item item) {
            if (item == null || aggregateFunction == null || !(item.getValue() instanceof Double)) {
                LoggerHelper.log(Severity.DEBUG, "aggregate - return this.");
                return this;
            }
            Item returnItem = null;
            LoggerHelper.log(Severity.DEBUG, "aggregate - aggregateFunction [" + aggregateFunction.value() + "]");
            if (aggregateFunction == AggregateFunctionTypeEnum.SUM) {
                returnItem = this.aggregateSum(item);
            } else if (aggregateFunction == AggregateFunctionTypeEnum.AVG) {
                returnItem = this.aggregateAvg(item);
            } else if (aggregateFunction == AggregateFunctionTypeEnum.MIN) {
                returnItem = this.aggregateMin(item);
            } else if (aggregateFunction == AggregateFunctionTypeEnum.MAX) {
                returnItem = this.aggregateMax(item);
            } else if (aggregateFunction == AggregateFunctionTypeEnum.COUNT) {
                returnItem = this.aggregateCount(item);
            } else {
                LoggerHelper.log(Severity.DEBUG, "aggregate - aggregateFunction not available.");
                returnItem = this;
            }
            LoggerHelper.log(Severity.DEBUG, "aggregate - returnItem {" + returnItem.toString() + "}");
            return returnItem;
        }

        public Item aggregateSum(Item item) {
            LoggerHelper.log(Severity.DEBUG, "aggregateSum - item {" + item.toString() + "} this {" + this.toString() + "}");
            if (item == null || item.getValue() == null || item.getQuantity() == null) {
                LoggerHelper.log(Severity.DEBUG, "aggregateSum - value is null");
                return this;
            }
            this.setQuantity(this.getQuantity().intValue() + item.getQuantity().intValue());
            this.setValue(((Double)this.getValue()).intValue() + ((Double)item.getValue()).intValue());
            return this;
        }

        public Item aggregateAvg(Item item) {
            LoggerHelper.log(Severity.DEBUG, "aggregateAvg - item {" + item.toString() + "} this {" + this.toString() + "}");
            if (item == null || item.getValue() == null || item.getQuantity() == null) {
                LoggerHelper.log(Severity.DEBUG, "aggregateAvg - value is null");
                return this;
            }
            double thisValue = (Double)this.getValue();
            int thisQuantity = item.getQuantity().intValue();
            double itemValue = (Double)item.getValue();
            int itemQuantity = item.getQuantity().intValue();
            Double avgValue = new Double((thisValue * (double)thisQuantity + itemValue * (double)itemQuantity) / (double)(thisQuantity + itemQuantity));
            LoggerHelper.log(Severity.DEBUG, "aggregateAvg - thisValue " + thisValue + " thisQuantity " + thisQuantity + " itemValue " + itemValue + " itemQuantity " + itemQuantity + " avgValue " + avgValue);
            this.setValue(avgValue);
            this.setQuantity(new Double(thisQuantity + itemQuantity));
            return this;
        }

        public Item aggregateMin(Item item) {
            LoggerHelper.log(Severity.DEBUG, "aggregateMin - item {" + item.toString() + "} this {" + this.toString() + "}");
            if (item == null || item.getValue() == null || item.getQuantity() == null) {
                return this;
            }
            if (this.getValue() == null) {
                LoggerHelper.log(Severity.DEBUG, "aggregateMin - value is null");
                return item;
            }
            if (((Double)item.getValue()).intValue() < ((Double)this.getValue()).intValue()) {
                LoggerHelper.log(Severity.DEBUG, "aggregateMin - return item");
                return item;
            }
            LoggerHelper.log(Severity.DEBUG, "aggregateMin - return this");
            return this;
        }

        public Item aggregateMax(Item item) {
            LoggerHelper.log(Severity.DEBUG, "aggregateMax - item {" + item.toString() + "} this {" + this.toString() + "}");
            if (item == null || item.getValue() == null || item.getQuantity() == null) {
                return this;
            }
            if (this.getValue() == null) {
                LoggerHelper.log(Severity.DEBUG, "aggregateMax - value is null");
                return item;
            }
            if (((Double)item.getValue()).intValue() > ((Double)this.getValue()).intValue()) {
                LoggerHelper.log(Severity.DEBUG, "aggregateMax - return item");
                return item;
            }
            LoggerHelper.log(Severity.DEBUG, "aggregateMax - return this");
            return this;
        }

        public Item aggregateCount(Item item) {
            LoggerHelper.log(Severity.DEBUG, "aggregateCount");
            return this.aggregateSum(item);
        }

        private void setGroupValue(Object group) {
            this.group = new Dimension(group, null);
        }

        private void setGroup(Dimension group) {
            this.group = group;
        }

        private void setSeriesValue(Object series) {
            this.series = new Dimension(series, null);
        }

        private void setSeries(Dimension series) {
            this.series = series;
        }

        private void setValue(Object value) {
            this.value = value == null ? null : (value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : (value instanceof String ? value : (value instanceof Date ? value : null)));
        }

        private String getString(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof Date) {
                return DateFormat.getDateInstance(3, Locale.US).format((Date)object);
            }
            return object.toString();
        }

        public static class Dimension
        implements Serializable {
            private Object id;
            private String label;
            private String shortLabel;
            private static final long serialVersionUID = -100L;

            public Dimension(Object id, String label) {
                this.id = id == null ? "" : id;
                this.label = label;
            }

            public Dimension(Object id, String label, String shortLabel) {
                this.id = id == null ? "" : id;
                this.label = label;
                this.shortLabel = shortLabel;
            }

            public Object getId() {
                return this.id;
            }

            public String getLabel() {
                return this.label;
            }

            public String getShortLabel() {
                return this.shortLabel;
            }

            public String toString() {
                return "Dimension: id [" + this.id + "], label [" + this.label + "]";
            }
        }
    }
}

