/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.util.Hashtable;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;

public class JpqlQueryCache {
    private Queue<String> cacheQueue;
    private final int maxQuerySize = 100;
    private Map<String, String> queryCache;

    public JpqlQueryCache() {
        try {
            this.init();
        }
        catch (DashboardQueryException e) {
            e.printStackTrace();
        }
    }

    public void init() throws DashboardQueryException {
        this.queryCache = new Hashtable<String, String>();
        this.cacheQueue = new ConcurrentLinkedQueue<String>();
        this.addToCache("-10000", "SELECT cubeprocess.processName, SUM(cubeworkload.quantity)\n FROM CubeProcess cubeprocess JOIN cubeProcess.cubeWorkloadList cubeworkload JOIN cubeworkload.cubeActivity cubeactivity\n GROUP BY cubeprocess.processName");
        this.addToCache("-10001", "SELECT cubeprocess.processName, cuberole.roleName, SUM(cubeworkload.quantity)\n FROM CubeProcess cubeprocess JOIN cubeProcess.cubeWorkloadList cubeworkload \n      JOIN cubeworkload.cubeActivity cubeactivity, CubeRole cuberole \n      JOIN cuberole.cubeWorkloadList cubeworkload \n GROUP BY cubeprocess.processName, cuberole.roleName");
        this.addToCache("-10002", "SELECT cubeprocess.processName, AVG(cubeprocessperformance.taskTime)\n FROM CubeProcess cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance\n GROUP BY cubeprocess.processName");
        this.addToCache("-10003", "SELECT cubeprocess.processName, cuberole.roleName, AVG(cubeprocessperformance.taskTime)\n FROM CubeProcess cubeprocess JOIN cubeProcess.cubeWorkloadList cubeworkload \n      JOIN cubeworkload.cubeActivity cubeactivity, CubeRole cuberole JOIN cuberole.cubeWorkloadList cubeworkload1 \n GROUP BY cubeprocess.processName, cuberole.roleName");
    }

    public String resolveQueryCache(String seriesId) throws DashboardQueryException {
        return this.queryCache.get(seriesId);
    }

    public Map getCache() throws DashboardQueryException {
        return this.queryCache;
    }

    public Queue getCacheSequenceQueue() throws DashboardQueryException {
        return this.cacheQueue;
    }

    public void updateCacheSequence(String seriesId) {
        if (this.queryCache.get(seriesId) != null) {
            this.cacheQueue.remove(seriesId);
            this.cacheQueue.add(seriesId);
        }
    }

    public void addToCache(String seriesId, String jpqlQuery) throws DashboardQueryException {
        String cacheQuery = this.resolveQueryCache(seriesId);
        if (cacheQuery != null && !cacheQuery.isEmpty()) {
            if (this.cacheQueue.contains(seriesId)) {
                this.updateCacheSequence(seriesId);
            }
        } else {
            if (this.queryCache.size() > 100) {
                this.removeOldCache();
            }
            this.queryCache.put(seriesId, jpqlQuery);
            this.cacheQueue.add(seriesId);
        }
    }

    public void removeFromCache(String seriesId) throws DashboardQueryException {
        this.cacheQueue.remove(seriesId);
        this.queryCache.remove(seriesId);
    }

    public void logJpqlQueryCache() {
        if (this.queryCache == null || this.queryCache.isEmpty()) {
            LoggerHelper.log(Severity.DEBUG, "logCache - queryCache is empty.\n");
        } else {
            String cacheLog = "";
            Set<String> keySet = this.queryCache.keySet();
            if (keySet != null) {
                for (String var : keySet) {
                    cacheLog = cacheLog + "Id: [" + var + "] - value [" + this.queryCache.get(var) + "]\n\n";
                }
                LoggerHelper.log(Severity.DEBUG, "logCache - queryCache is: \n" + cacheLog);
            }
        }
    }

    private void removeOldCache() throws DashboardQueryException {
        String seriesID = this.cacheQueue.remove();
        this.queryCache.remove(seriesID);
    }
}

