/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.util.List;
import java.util.TreeMap;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.JpqlTabularData;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import org.jetbrains.annotations.NotNull;

public class JPQLQueryResultHelper {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public static JpqlTabularData getTabularData(@NotNull JPQLQuery jpqlQuery, @NotNull List jpqlQueryResult) {
        String METHOD_NAME = "getTabularData";
        String jpqlIdStr = JPQLQueryResultHelper.printId(jpqlQuery.getSeriesId());
        String dsStr = jpqlQuery.getDataSourceType() == null ? "DataSourceType not available" : jpqlQuery.getDataSourceType().value();
        LoggerHelper.log(Severity.DEBUG, "getTabularData " + jpqlIdStr + ", AggregateFunctionType [" + jpqlQuery.getAggregateFunctionType() + "], DataSourceType [" + dsStr + "] : " + JPQLQueryResultHelper.printJpqlQueryResultList(jpqlQueryResult));
        JpqlTabularData resultTabularData = JpqlTabularData.create(jpqlQuery, jpqlQueryResult);
        JpqlTabularData.Metadata metadata = resultTabularData.getMetadata();
        if (jpqlQuery.getDataSourceType() != null && jpqlQuery.getDataSourceType() == DataSourceTypeEnum.CUBE_WORKLOAD) {
            String measureColumn = jpqlQuery.getMetadata() == null ? "" : jpqlQuery.getMetadata().getColumn();
            resultTabularData = JPQLQueryResultHelper.fixWorkloadTabularData(resultTabularData, jpqlQuery.getAggregateFunctionType(), measureColumn, jpqlQuery.getSeriesId());
        } else {
            resultTabularData = JPQLQueryResultHelper.fixTabularData(resultTabularData, jpqlQuery.getAggregateFunctionType(), jpqlQuery.getSeriesId());
        }
        resultTabularData = JPQLQueryResultHelper.fixValueType(jpqlQuery.getValueType(), resultTabularData, jpqlQuery.getSeriesId());
        resultTabularData.setMetadata(metadata);
        LoggerHelper.log(Severity.DEBUG, "getTabularData " + jpqlIdStr + "jpqlQueryResult size [" + jpqlQueryResult.size() + "], resultTabularData [" + resultTabularData.toString() + "]");
        return resultTabularData;
    }

    private static JpqlTabularData fixValueType(@NotNull ValueTypeEnum valueType, @NotNull JpqlTabularData jpqlTabularData, String id) {
        String METHOD_NAME = "fixValueType";
        LoggerHelper.log(Severity.DEBUG, "fixValueType " + JPQLQueryResultHelper.printId(id) + "valueType [" + valueType + "] JpqlTabularData [" + jpqlTabularData.toString() + "]");
        switch (valueType) {
            case PERCENTAGE: {
                double total;
                TreeMap<String, Double> totals = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
                for (JpqlTabularData.Item item : jpqlTabularData) {
                    total = 0.0;
                    if (item == null || item.getValue() == null) continue;
                    if (item.getValue() instanceof Number) {
                        item.setValue(new Double(((Number)item.getValue()).doubleValue()));
                    }
                    if (item.getValue() instanceof Double) {
                        if (totals.containsKey(item.getGroup())) {
                            total = (Double)totals.get(item.getGroup());
                        }
                        totals.put(item.getGroup(), total += ((Double)item.getValue()).doubleValue());
                        continue;
                    }
                    LoggerHelper.log(Severity.DEBUG, "fixValueType - " + JPQLQueryResultHelper.printId(id) + "skip non numeric data type for PERCENTAGE type: series [" + item.getSeries() + "], group [" + item.getGroup() + "], quantity [" + item.getQuantity() + "], value [" + item.getValue() + "]");
                }
                for (JpqlTabularData.Item item : jpqlTabularData) {
                    double value;
                    total = 0.0;
                    if (item == null || !(item.getValue() instanceof Double)) continue;
                    if (totals.containsKey(item.getGroup())) {
                        total = (Double)totals.get(item.getGroup());
                    }
                    if ((value = ((Double)item.getValue()).doubleValue()) == 0.0 || total == 0.0) continue;
                    item.setValue(value * 100.0 / total);
                }
                break;
            }
            case SECONDS: {
                jpqlTabularData = JPQLQueryResultHelper.fixTimeValueType(jpqlTabularData, 1000L, id);
                break;
            }
            case MINUTES: {
                jpqlTabularData = JPQLQueryResultHelper.fixTimeValueType(jpqlTabularData, 60000L, id);
                break;
            }
            case HOURS: {
                jpqlTabularData = JPQLQueryResultHelper.fixTimeValueType(jpqlTabularData, 3600000L, id);
                break;
            }
            case DAYS: {
                jpqlTabularData = JPQLQueryResultHelper.fixTimeValueType(jpqlTabularData, 86400000L, id);
            }
        }
        LoggerHelper.log(Severity.DEBUG, "fixValueType " + JPQLQueryResultHelper.printId(id) + "converted to - " + jpqlTabularData.toString());
        return jpqlTabularData;
    }

    private static JpqlTabularData fixTimeValueType(@NotNull JpqlTabularData jpqlTabularData, long timeValue, String id) {
        for (JpqlTabularData.Item item : jpqlTabularData) {
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                item.setValue((Double)item.getValue() / (double)timeValue);
                continue;
            }
            LoggerHelper.logInvalidTimeData(item, timeValue);
        }
        LoggerHelper.log(Severity.DEBUG, "fixTimeValueType " + JPQLQueryResultHelper.printId(id) + "converted to - " + jpqlTabularData.toString());
        return jpqlTabularData;
    }

    private static JpqlTabularData fixWorkloadTabularData(@NotNull JpqlTabularData jpqlTabularData, @NotNull AggregateFunctionTypeEnum aggregateFunctionType, @NotNull String column, String id) {
        LoggerHelper.log(Severity.DEBUG, "fixWorkloadTabularData " + JPQLQueryResultHelper.printId(id) + "initial JpqlTabularData [" + jpqlTabularData.toString() + "] column [" + column + "] aggregateFunctionType [" + aggregateFunctionType + "]");
        JpqlTabularData resultTabularData = JpqlTabularData.create();
        switch (aggregateFunctionType) {
            case AVG: {
                resultTabularData = JPQLQueryResultHelper.fixWorkloadAvgAggregation(jpqlTabularData, column, id);
                break;
            }
            case SUM: {
                resultTabularData = JPQLQueryResultHelper.fixSumCountAggregation(jpqlTabularData, id);
            }
        }
        return resultTabularData;
    }

    private static JpqlTabularData fixWorkloadAvgAggregation(@NotNull JpqlTabularData jpqlTabularData, @NotNull String measureColumn, String id) {
        String METHOD_NAME = "fixWorkloadAvgAggregation";
        TreeMap<String, Double> totals = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, Double> totalsQuantity = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        for (JpqlTabularData.Item item : jpqlTabularData) {
            double totalValue = 0.0;
            double totalQuantity = 0.0;
            if (item == null || item.getValue() == null) continue;
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String aggregationId;
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (totals.containsKey(aggregationId)) {
                    totalValue = (Double)totals.get(aggregationId);
                    totalQuantity = (Double)totalsQuantity.get(aggregationId);
                }
                totalValue = item.getQuantity() != null ? ("avgTimeTask".equals(measureColumn) || "avgTimeProcess".equals(measureColumn) ? (totalValue += (Double)item.getValue() * item.getQuantity().doubleValue()) : (totalValue += ((Double)item.getValue()).doubleValue())) : (totalValue += ((Double)item.getValue()).doubleValue());
                if (item.getQuantity() != null) {
                    totalQuantity += item.getQuantity().doubleValue();
                }
                totals.put(aggregationId, totalValue);
                totalsQuantity.put(aggregationId, totalQuantity);
                continue;
            }
            LoggerHelper.logInvalidAvgData(item);
        }
        JpqlTabularData resultTabularData = JpqlTabularData.create();
        if (totals == null) {
            LoggerHelper.logNullData(jpqlTabularData, "AVG", "totals");
            return resultTabularData;
        }
        if (totalsQuantity == null) {
            LoggerHelper.logNullData(jpqlTabularData, "AVG", "totalsQuantity");
            return resultTabularData;
        }
        double totalValue = 0.0;
        double totalQuantity = 0.0;
        for (JpqlTabularData.Item item : jpqlTabularData) {
            String aggregationId;
            if (item == null || !(item.getValue() instanceof Double)) continue;
            String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
            if (totals.containsKey(aggregationId)) {
                totalValue = (Double)totals.get(aggregationId);
                totalQuantity = (Double)totalsQuantity.get(aggregationId);
                if (totalQuantity != 0.0 && totalValue != 0.0) {
                    item.setValue(totalValue / totalQuantity);
                    totals.remove(aggregationId);
                    totalsQuantity.remove(aggregationId);
                    resultTabularData.add(item);
                    continue;
                }
                LoggerHelper.logInvalidAvgData(item, totalQuantity, totalValue);
                continue;
            }
            LoggerHelper.logDuplicateAvgData(item, totalQuantity, totalValue);
        }
        LoggerHelper.log(Severity.DEBUG, "fixWorkloadAvgAggregation - id [" + id + "] resultTabularData [" + resultTabularData.toString() + "]");
        return resultTabularData;
    }

    private static JpqlTabularData fixTabularData(@NotNull JpqlTabularData jpqlTabularData, @NotNull AggregateFunctionTypeEnum aggregateFunctionType, String id) {
        if (aggregateFunctionType == null) {
            return jpqlTabularData;
        }
        JpqlTabularData resultTabularData = JpqlTabularData.create();
        switch (aggregateFunctionType) {
            case AVG: {
                resultTabularData = JPQLQueryResultHelper.fixAvgAggregation(jpqlTabularData, id);
                break;
            }
            case SUM: 
            case COUNT: {
                resultTabularData = JPQLQueryResultHelper.fixSumCountAggregation(jpqlTabularData, id);
                break;
            }
            case MAX: {
                resultTabularData = JPQLQueryResultHelper.fixMaxAggregation(jpqlTabularData, id);
                break;
            }
            case MIN: {
                resultTabularData = JPQLQueryResultHelper.fixMinAggregation(jpqlTabularData, id);
                break;
            }
            default: {
                resultTabularData = jpqlTabularData;
            }
        }
        return resultTabularData;
    }

    private static JpqlTabularData fixAvgAggregation(@NotNull JpqlTabularData jpqlTabularData, String id) {
        String METHOD_NAME = "fixAvgAggregation";
        TreeMap<String, Double> totals = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, Double> totalsQuantity = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        for (JpqlTabularData.Item item : jpqlTabularData) {
            double totalValue = 0.0;
            double totalQuantity = 0.0;
            if (item == null || item.getValue() == null) continue;
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String aggregationId;
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (totals.containsKey(aggregationId)) {
                    totalValue = (Double)totals.get(aggregationId);
                    totalQuantity = (Double)totalsQuantity.get(aggregationId);
                }
                totalValue = item.getQuantity() != null ? (totalValue += (Double)item.getValue() * item.getQuantity().doubleValue()) : (totalValue += ((Double)item.getValue()).doubleValue());
                if (item.getQuantity() != null) {
                    totalQuantity += item.getQuantity().doubleValue();
                }
                totals.put(aggregationId, totalValue);
                totalsQuantity.put(aggregationId, totalQuantity);
                continue;
            }
            LoggerHelper.logInvalidAvgData(item);
        }
        JpqlTabularData resultTabularData = JpqlTabularData.create();
        if (totals == null) {
            LoggerHelper.logNullData(jpqlTabularData, "AVG", "totals");
            return resultTabularData;
        }
        if (totalsQuantity == null) {
            LoggerHelper.logNullData(jpqlTabularData, "AVG", "totalsQuantity");
            return resultTabularData;
        }
        for (JpqlTabularData.Item item : jpqlTabularData) {
            String aggregationId;
            if (item == null || !(item.getValue() instanceof Double)) continue;
            String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
            if (totals.containsKey(aggregationId)) {
                double totalValue = (Double)totals.get(aggregationId);
                double totalQuantity = (Double)totalsQuantity.get(aggregationId);
                if (totalQuantity != 0.0 && totalValue != 0.0) {
                    item.setValue(totalValue / totalQuantity);
                    totals.remove(aggregationId);
                    totalsQuantity.remove(aggregationId);
                    resultTabularData.add(item);
                    continue;
                }
                LoggerHelper.logInvalidAvgData(item, totalQuantity, totalValue);
                continue;
            }
            LoggerHelper.logDuplicateAvgData(item, 0.0, 0.0);
        }
        LoggerHelper.log(Severity.DEBUG, "fixAvgAggregation - id [" + id + "] resultTabularData [" + resultTabularData.toString() + "]");
        return resultTabularData;
    }

    private static JpqlTabularData fixSumCountAggregation(@NotNull JpqlTabularData jpqlTabularData, String id) {
        String METHOD_NAME = "fixSumCountAggregation";
        TreeMap<String, Double> totals = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        for (JpqlTabularData.Item item : jpqlTabularData) {
            double total = 0.0;
            if (item == null || item.getValue() == null) continue;
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String aggregationId;
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (totals.containsKey(aggregationId)) {
                    total = (Double)totals.get(aggregationId);
                }
                totals.put(item.getAggregationId(), total += ((Double)item.getValue()).doubleValue());
                continue;
            }
            LoggerHelper.log(Severity.DEBUG, "fixSumCountAggregation - skip non numeric data type for SUM workload type [" + item.getValue() + "]");
        }
        JpqlTabularData resultTabularData = JpqlTabularData.create();
        if (totals == null) {
            LoggerHelper.logNullData(jpqlTabularData, "SUM", "totals");
            return resultTabularData;
        }
        for (JpqlTabularData.Item item : jpqlTabularData) {
            if (item == null || !(item.getValue() instanceof Double)) continue;
            String aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
            double value = (Double)item.getValue();
            if (totals.containsKey(aggregationId)) {
                double total = (Double)totals.get(aggregationId);
                if (value != 0.0 && total != 0.0) {
                    totals.remove(aggregationId);
                    resultTabularData.add(item);
                    continue;
                }
                LoggerHelper.log(Severity.DEBUG, "fixSumCountAggregation - skip non numeric data type for id [" + id + "], type [" + item.getValue() + "]");
                continue;
            }
            LoggerHelper.logSkipSumData(item);
        }
        LoggerHelper.log(Severity.DEBUG, "fixSumCountAggregation - id [" + id + "] resultTabularData [" + resultTabularData.toString() + "]");
        return resultTabularData;
    }

    private static JpqlTabularData fixMaxAggregation(@NotNull JpqlTabularData jpqlTabularData, String id) {
        String aggregationId;
        String METHOD_NAME = "fixMaxAggregation";
        TreeMap<String, Double> maximums = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        for (JpqlTabularData.Item item : jpqlTabularData) {
            Double max = null;
            if (item == null || item.getValue() == null) continue;
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (maximums.containsKey(aggregationId)) {
                    max = (Double)maximums.get(aggregationId);
                }
                Double current = (Double)item.getValue();
                max = max == null ? current : Math.max(max, current);
                maximums.put(item.getAggregationId(), max);
                continue;
            }
            LoggerHelper.log(Severity.DEBUG, "fixMaxAggregation - skip non numeric data type for SUM workload type [" + item.getValue() + "]");
        }
        JpqlTabularData returnJpqlTabularData = JpqlTabularData.create();
        for (JpqlTabularData.Item item : jpqlTabularData) {
            if (item == null || !(item.getValue() instanceof Double)) continue;
            String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
            if (maximums.containsKey(aggregationId)) {
                item.setValue((Double)maximums.get(aggregationId));
                maximums.remove(aggregationId);
                returnJpqlTabularData.add(item);
                continue;
            }
            LoggerHelper.logSkipSumData(item);
        }
        LoggerHelper.log(Severity.DEBUG, "fixMaxAggregation - id [" + id + "] resultTabularData [" + returnJpqlTabularData.toString() + "]");
        return returnJpqlTabularData;
    }

    private static JpqlTabularData fixMinAggregation(@NotNull JpqlTabularData jpqlTabularData, String id) {
        String aggregationId;
        String METHOD_NAME = "fixMinAggregation";
        TreeMap<String, Double> minimums = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        for (JpqlTabularData.Item item : jpqlTabularData) {
            Double min = null;
            if (item == null || item.getValue() == null) continue;
            if (item.getValue() instanceof Number) {
                item.setValue(new Double(((Number)item.getValue()).doubleValue()));
            }
            if (item.getValue() instanceof Double) {
                String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
                if (minimums.containsKey(aggregationId)) {
                    min = (Double)minimums.get(aggregationId);
                }
                Double current = (Double)item.getValue();
                min = min == null ? current : Math.min(min, current);
                minimums.put(item.getAggregationId(), min);
                continue;
            }
            LoggerHelper.log(Severity.DEBUG, "fixMinAggregation - skip non numeric data type for SUM workload type [" + item.getValue() + "]");
        }
        JpqlTabularData returnJpqlTabularData = JpqlTabularData.create();
        for (JpqlTabularData.Item item : jpqlTabularData) {
            if (item == null || !(item.getValue() instanceof Double)) continue;
            String string = aggregationId = item.getAggregationId() == null ? "" : item.getAggregationId();
            if (minimums.containsKey(aggregationId)) {
                item.setValue((Double)minimums.get(aggregationId));
                minimums.remove(aggregationId);
                returnJpqlTabularData.add(item);
                continue;
            }
            LoggerHelper.logSkipSumData(item);
        }
        LoggerHelper.log(Severity.DEBUG, "fixMinAggregation - id [" + id + "] resultTabularData [" + returnJpqlTabularData.toString() + "]");
        return returnJpqlTabularData;
    }

    private static String printId(String id) {
        if (id == null) {
            return "";
        }
        return "JPQL Query Data ID - [" + id + "] ";
    }

    private static String printJpqlQueryResultList(List jpqlQueryResult) {
        if (jpqlQueryResult == null) {
            String listString = "Jpql result list is null";
            return listString;
        }
        String listString = "Jpql result list size [" + jpqlQueryResult.size() + "] - ";
        for (Object object : jpqlQueryResult) {
            listString = listString + "{ " + JPQLQueryResultHelper.printObject(object) + "} ";
        }
        return listString;
    }

    private static String printObject(Object value) {
        String objString = "";
        if (value == null) {
            return objString;
        }
        if (value.getClass().isArray()) {
            Object[] array;
            for (Object val : array = (Object[])value) {
                objString = objString + (val == null ? "[null] " : "[" + val.toString() + "] ");
            }
        } else {
            objString = value.toString();
        }
        return objString;
    }
}

