/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;
import oracle.bpm.analytics.cube.persistence.model.CubeOrganizationalUnit;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.SqlLookup;
import oracle.bpm.analytics.dashboard.util.LoggerHelper;
import oracle.bpm.services.common.logger.Severity;

public class JPQLQueryGeneratorHelper {
    private String aggregateFunction;
    private Hashtable<String, Object> binding;
    private Set<String> defaultWhereClauses;
    private Set<String> fromItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private String groupLabel;
    private boolean groupUseRanges;
    private boolean isStandard = false;
    private SqlLookup.Column measure = null;
    private String measureLabel;
    private boolean measurementDimension = false;
    private String seriesLabel;
    private boolean seriesUseRanges;
    private Set<String> whereClauses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private List<SqlLookup.Column> xGroup;
    private List<SqlLookup.Column> xSeries;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile(":(\\w+)");
    private static final String SQL_IGNORE_MEASUREMENTS_SUBPROCESSES = "cubeactivity.activityType NOT IN ('MEASUREMENT_START', 'MEASUREMENT_STOP', 'MEASUREMENT_START_STOP', 'MEASUREMENT_COUNTER', 'SUBPROCESS')";
    private static final String SQL_MEASUREMENTS_DIMENSION = "cubeactivity.activityType IN ('MEASUREMENT_START', 'MEASUREMENT_STOP', 'MEASUREMENT_START_STOP')";

    private JPQLQueryGeneratorHelper() {
        this.defaultWhereClauses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.xSeries = new ArrayList<SqlLookup.Column>();
        this.xGroup = new ArrayList<SqlLookup.Column>();
        this.binding = new Hashtable();
    }

    public static JPQLQueryGeneratorHelper create() {
        return new JPQLQueryGeneratorHelper();
    }

    public void clear() {
        this.measure = null;
        this.aggregateFunction = null;
        this.fromItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.whereClauses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.defaultWhereClauses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.xSeries = new ArrayList<SqlLookup.Column>();
        this.xGroup = new ArrayList<SqlLookup.Column>();
        this.binding = new Hashtable();
        this.isStandard = false;
    }

    public void setIsStandard(boolean pIsStandard) {
        this.isStandard = pIsStandard;
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public void setMeasure(SqlLookup.Column column, String aggregateFunction) {
        this.measure = column;
        this.aggregateFunction = aggregateFunction;
    }

    public SqlLookup.Column getMeasure() {
        return this.measure;
    }

    public void addXSeries(SqlLookup.Column column) {
        this.xSeries.add(column);
    }

    public void addXSeries(Collection<SqlLookup.Column> columns) {
        this.xSeries.addAll(columns);
    }

    public void removeXSeries(SqlLookup.Column column) {
        this.xSeries.remove(column);
    }

    public boolean containsXSeries(SqlLookup.Column column) {
        return this.xSeries.contains(column);
    }

    public Collection<SqlLookup.Column> getXSeries() {
        return this.xSeries;
    }

    public void addXGroup(SqlLookup.Column column) {
        this.xGroup.add(column);
    }

    public void addXGroup(Collection<SqlLookup.Column> columns) {
        this.xGroup.addAll(columns);
    }

    public void removeXGroup(SqlLookup.Column column) {
        this.xGroup.remove(column);
    }

    public boolean containsXGroup(SqlLookup.Column column) {
        return this.xGroup.contains(column);
    }

    public Collection<SqlLookup.Column> getXGroup() {
        return this.xGroup;
    }

    public String generateSelect() {
        StringBuilder select = new StringBuilder("");
        boolean appendComma = false;
        if (this.xGroup != null) {
            for (SqlLookup.Column column : this.xGroup) {
                if (appendComma) {
                    select.append(", ");
                }
                select.append(column.getQualifiedColumn());
                appendComma = true;
            }
        }
        if (this.xSeries != null) {
            for (SqlLookup.Column column : this.xSeries) {
                if (appendComma) {
                    select.append(", ");
                }
                select.append(column.getQualifiedColumn());
                appendComma = true;
            }
        }
        if (appendComma) {
            select.append(", ");
        }
        if (this.useAggregateFunction()) {
            select.append(this.aggregateFunction);
            select.append("(");
            select.append(this.measure.getQualifiedColumn());
            select.append(")");
        } else {
            select.append(this.measure.getQualifiedColumn());
        }
        select.append(", ");
        if (this.useAggregateFunction()) {
            select.append("COUNT");
            select.append("(");
            select.append(this.measure.getQualifiedColumn());
            select.append(")");
        } else {
            select.append(SqlLookup.getQuantityColumn().getQualifiedColumn());
        }
        return select.toString();
    }

    public void addFrom(String table) {
        this.fromItems.add(table);
    }

    public Collection<String> getFromItems() {
        return this.fromItems;
    }

    public String getFrom() {
        String from = "";
        if (this.measure != null) {
            this.fromItems.add(this.measure.getTableName());
        }
        if (!this.xSeries.isEmpty()) {
            for (SqlLookup.Column column : this.xSeries) {
                this.fromItems.add(column.getTableName());
            }
        }
        if (!this.xGroup.isEmpty()) {
            for (SqlLookup.Column column : this.xGroup) {
                this.fromItems.add(column.getTableName());
            }
        }
        if (this.fromItems.contains(CubeWorkload.class.getSimpleName())) {
            from = this.getCubeWorkloadFrom();
        } else if (this.fromItems.contains(CubeProcessPerformance.class.getSimpleName())) {
            from = this.getCubeProcessPerformanceFrom();
        } else if (this.fromItems.contains(CubeTaskPerformance.class.getSimpleName())) {
            from = this.getCubeTaskPerformanceFrom();
        }
        for (String table : this.fromItems) {
            if (from.contains(table.toLowerCase())) continue;
            from = from + ", " + table + " " + table.toLowerCase();
        }
        return from;
    }

    public boolean containsFrom(String table) {
        return this.fromItems.contains(table);
    }

    public void removeFrom(String table) {
        this.fromItems.remove(table);
    }

    public void addWhereClause(String whereClause) {
        this.whereClauses.add(whereClause);
    }

    public void removeWhereClause(String whereClause) {
        this.whereClauses.remove(whereClause);
    }

    public Collection<String> getWhereClauses() {
        return this.whereClauses;
    }

    public void addDefaultWhereClause(String whereClause) {
        this.defaultWhereClauses.add(whereClause);
    }

    public void removeDefaultWhereClause(String whereClause) {
        this.defaultWhereClauses.remove(whereClause);
    }

    public Collection<String> getDefaultWhereClauses() {
        return this.defaultWhereClauses;
    }

    public String getWhere() {
        StringBuilder where = new StringBuilder("");
        boolean appendAnd = false;
        if (this.defaultWhereClauses != null && !this.defaultWhereClauses.isEmpty()) {
            where.append(" (");
            for (String whereClause : this.defaultWhereClauses) {
                where.append(appendAnd ? " AND " : "");
                where.append(whereClause);
                appendAnd = true;
            }
            where.append(") ");
        }
        appendAnd = false;
        if (this.whereClauses != null && !this.whereClauses.isEmpty()) {
            if (where.length() != 0) {
                where.append(" AND ");
            }
            where.append(" (");
            for (String whereClause : this.whereClauses) {
                where.append(appendAnd ? " AND " : "");
                where.append(whereClause);
                appendAnd = true;
            }
            where.append(") ");
        }
        return where.toString();
    }

    public boolean hasGroupBy() {
        return this.xGroup != null || this.xSeries != null || this.useAggregateFunction();
    }

    public String generateGroupBy() {
        StringBuilder groupBy = new StringBuilder("");
        boolean appendComma = false;
        if (this.xGroup != null) {
            for (SqlLookup.Column column : this.xGroup) {
                if (appendComma) {
                    groupBy.append(", ");
                }
                groupBy.append(column.getQualifiedColumn());
                appendComma = true;
            }
        }
        if (this.xSeries != null) {
            for (SqlLookup.Column column : this.xSeries) {
                if (appendComma) {
                    groupBy.append(", ");
                }
                groupBy.append(column.getQualifiedColumn());
                appendComma = true;
            }
        }
        if (!this.useAggregateFunction()) {
            if (appendComma) {
                groupBy.append(", ");
            }
            groupBy.append(this.measure.getQualifiedColumn());
            groupBy.append(", ");
            groupBy.append(SqlLookup.getQuantityColumn().getQualifiedColumn());
        }
        return groupBy.toString();
    }

    public boolean hasOrderBy() {
        return this.xGroup != null && !this.xGroup.isEmpty() || this.xSeries != null && !this.xSeries.isEmpty();
    }

    public String generateOrderBy() {
        StringBuilder orderBy = new StringBuilder("");
        boolean appendComma = false;
        if (this.xGroup != null) {
            for (SqlLookup.Column column : this.xGroup) {
                if (appendComma) {
                    orderBy.append(", ");
                }
                orderBy.append(column.getQualifiedColumn());
                appendComma = true;
            }
        }
        if (this.xSeries != null) {
            for (SqlLookup.Column column : this.xSeries) {
                if (appendComma) {
                    orderBy.append(", ");
                }
                orderBy.append(column.getQualifiedColumn());
                appendComma = true;
            }
        }
        return orderBy.toString();
    }

    public String bindVariable(String variable, Object value) {
        int index = 0;
        String _variable = variable;
        while (this.binding.containsKey(_variable)) {
            _variable = variable + ++index;
        }
        LoggerHelper.log(Severity.DEBUG, "bindVariable - variable is [" + _variable + "], value is [" + value + "].");
        this.binding.put(_variable, value);
        return _variable;
    }

    public boolean validateBinding(String query) {
        String qVariable;
        if (this.binding == null) {
            return true;
        }
        TreeSet<String> bindingVariables = new TreeSet<String>(this.binding.keySet());
        TreeSet<String> queryVariables = new TreeSet<String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(query);
        boolean found = matcher.find();
        while (found) {
            String variable = matcher.group(1);
            queryVariables.add(variable);
            found = matcher.find();
        }
        ArrayList<String> notInBinding = new ArrayList<String>();
        ArrayList<String> notInQuery = new ArrayList<String>();
        Iterator bIte = bindingVariables.iterator();
        Iterator qIte = queryVariables.iterator();
        String bVariable = bIte.hasNext() ? (String)bIte.next() : null;
        String string = qVariable = qIte.hasNext() ? (String)qIte.next() : null;
        while (bVariable != null && qVariable != null) {
            int order = bVariable.compareTo(qVariable);
            if (order == 0) {
                bVariable = bIte.hasNext() ? (String)bIte.next() : null;
                qVariable = qIte.hasNext() ? (String)qIte.next() : null;
                continue;
            }
            if (order < 0) {
                notInQuery.add(bVariable);
                bVariable = bIte.hasNext() ? (String)bIte.next() : null;
                continue;
            }
            notInBinding.add(qVariable);
            qVariable = qIte.hasNext() ? (String)qIte.next() : null;
        }
        while (bVariable != null) {
            notInQuery.add(bVariable);
            bVariable = bIte.hasNext() ? (String)bIte.next() : null;
        }
        while (qVariable != null) {
            notInBinding.add(qVariable);
            qVariable = qIte.hasNext() ? (String)qIte.next() : null;
        }
        if (!notInBinding.isEmpty() || !notInQuery.isEmpty()) {
            if (!notInQuery.isEmpty()) {
                LoggerHelper.log(Severity.INFORMATION, "validateBinding - variables " + ((Object)notInQuery).toString() + " not found in query [" + query + "].");
            }
            if (!notInBinding.isEmpty()) {
                LoggerHelper.log(Severity.INFORMATION, "validateBinding - variables " + ((Object)notInBinding).toString() + " not found in binding [" + query + "].");
            }
            return false;
        }
        return true;
    }

    public Map<String, Object> getBinding() {
        return this.binding;
    }

    public JPQLQuery.Metadata getMetadata() {
        JPQLQuery.Metadata metadata = JPQLQuery.Metadata.create(this.measure.getQualifiedColumn(), this.aggregateFunction);
        if (this.xSeries != null) {
            for (SqlLookup.Column column : this.xSeries) {
                metadata.addSeries(column.getQualifiedColumn());
            }
        }
        if (this.xGroup != null) {
            for (SqlLookup.Column column : this.xGroup) {
                metadata.addGroup(column.getQualifiedColumn());
            }
        }
        metadata.setMeasureLabel(this.getMeasureLabel());
        metadata.setSeriesLabel(this.getSeriesLabel());
        metadata.setSeriesUseRanges(this.seriesUseRanges());
        metadata.setGroupLabel(this.getGroupLabel());
        metadata.setGroupUseRanges(this.groupUseRanges());
        return metadata;
    }

    public String getMeasureLabel() {
        return this.measureLabel;
    }

    public void setMeasureLabel(String measureLabel) {
        this.measureLabel = measureLabel;
    }

    public String getSeriesLabel() {
        return this.seriesLabel;
    }

    public void setSeriesLabel(String seriesLabel) {
        this.seriesLabel = seriesLabel;
    }

    public boolean seriesUseRanges() {
        return this.seriesUseRanges;
    }

    public void setSeriesUseRanges(boolean seriesUseRanges) {
        this.seriesUseRanges = seriesUseRanges;
    }

    public String getGroupLabel() {
        return this.groupLabel;
    }

    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }

    public boolean groupUseRanges() {
        return this.groupUseRanges;
    }

    public void setGroupUseRanges(boolean groupUseRanges) {
        this.groupUseRanges = groupUseRanges;
    }

    public void setMeasurementDimension(boolean measurementDimension) {
        if (measurementDimension) {
            this.defaultWhereClauses.add(this.getMeasurementDimensionClause());
        } else {
            this.defaultWhereClauses.remove(this.getMeasurementDimensionClause());
        }
        this.measurementDimension = measurementDimension;
    }

    private String getCubeWorkloadFrom() {
        String from;
        String cubeOrganizationalUnitTable = CubeOrganizationalUnit.class.getSimpleName();
        String cubeProcessTable = CubeProcess.class.getSimpleName();
        String cubeActivityTable = CubeActivity.class.getSimpleName();
        String cubeRoleTable = CubeRole.class.getSimpleName();
        if (!this.fromItems.contains(cubeProcessTable)) {
            this.fromItems.add(cubeProcessTable);
        }
        if (!this.fromItems.contains(cubeActivityTable)) {
            this.fromItems.add(cubeActivityTable);
        }
        if (this.fromItems.contains(cubeOrganizationalUnitTable)) {
            if (this.fromItems.contains(cubeRoleTable)) {
                from = "CubeOrganizationalUnit cubeorganizationalunit JOIN cubeorganizationalunit.cubeProcessList cubeprocess JOIN cubeprocess.cubeWorkloadList cubeworkload JOIN cubeworkload.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2, CubeRole cuberole JOIN cuberole.cubeWorkloadList roleworkload";
                this.addDefaultWhereClause("roleworkload.workloadId = cubeworkload.workloadId");
            } else {
                from = "CubeOrganizationalUnit cubeorganizationalunit JOIN cubeorganizationalunit.cubeProcessList cubeprocess JOIN cubeprocess.cubeWorkloadList cubeworkload  JOIN cubeworkload.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2";
            }
        } else if (this.fromItems.contains(cubeRoleTable)) {
            from = "CubeProcess cubeprocess JOIN cubeprocess.cubeWorkloadList cubeworkload JOIN cubeworkload.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2, CubeRole cuberole JOIN cuberole.cubeWorkloadList roleworkload";
            this.addDefaultWhereClause("roleworkload.workloadId = cubeworkload.workloadId");
        } else {
            from = "CubeProcess cubeprocess JOIN cubeprocess.cubeWorkloadList cubeworkload JOIN cubeworkload.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2";
        }
        this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
        if (this.ignoreMeasurementsAndSubprocesses()) {
            this.addDefaultWhereClause(this.getIgnoreMeasurementsAndSubprocessesClause());
        }
        this.addDefaultWhereClause("cubeworkload.snapshotTime = (select cubelastsnapshot.lastSnapShot from CubeLastSnapshot cubelastsnapshot)");
        return from;
    }

    private String getCubeProcessPerformanceFrom() {
        String from;
        String cubeOrganizationalUnitTable = CubeOrganizationalUnit.class.getSimpleName();
        String cubeProcessTable = CubeProcess.class.getSimpleName();
        String cubeActivityTable = CubeActivity.class.getSimpleName();
        String cubeProcessPerformanceTable = CubeProcessPerformance.class.getSimpleName();
        if (!this.fromItems.contains(cubeProcessTable)) {
            this.fromItems.add(cubeProcessTable);
        }
        if (!this.fromItems.contains(cubeProcessPerformanceTable)) {
            this.fromItems.add(cubeProcessPerformanceTable);
        }
        if (this.fromItems.contains(cubeOrganizationalUnitTable)) {
            if (this.fromItems.contains(cubeActivityTable)) {
                from = "CubeOrganizationalUnit cubeorganizationalunit JOIN cubeorganizationalunit.cubeProcessList cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance JOIN cubeprocess.cubeActivityList cubeactivity";
                this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
            } else {
                from = "CubeOrganizationalUnit cubeorganizationalunit JOIN cubeorganizationalunit.cubeProcessList cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance";
                this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
            }
        } else if (this.fromItems.contains(cubeProcessTable)) {
            if (this.fromItems.contains(cubeActivityTable)) {
                from = "CubeProcess cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance JOIN cubeprocess.cubeActivityList cubeactivity";
                this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
            } else {
                from = "CubeProcess cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance";
                this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
            }
        } else if (this.fromItems.contains(cubeActivityTable)) {
            from = "CubeProcess cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance JOIN cubeprocess.cubeActivityList cubeactivity";
            this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
        } else {
            from = "CubeProcessPerformance cubeprocessperformance";
        }
        this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
        if (this.fromItems.contains(cubeActivityTable) && this.ignoreMeasurementsAndSubprocesses()) {
            this.addDefaultWhereClause(this.getIgnoreMeasurementsAndSubprocessesClause());
        }
        return from;
    }

    private String getCubeTaskPerformanceFrom() {
        String from;
        String cubeOrganizationalUnitTable = CubeOrganizationalUnit.class.getSimpleName();
        String cubeProcessTable = CubeProcess.class.getSimpleName();
        String cubeActivityTable = CubeActivity.class.getSimpleName();
        String cubeRoleTable = CubeRole.class.getSimpleName();
        String cubeTaskPerformanceTable = CubeTaskPerformance.class.getSimpleName();
        if (!this.fromItems.contains(cubeProcessTable)) {
            this.fromItems.add(cubeProcessTable);
        }
        if (this.fromItems.contains(cubeOrganizationalUnitTable)) {
            if (this.fromItems.contains(cubeRoleTable)) {
                from = "CubeOrganizationalUnit cubeorganizationalunit JOIN cubeorganizationalunit.cubeProcessList cubeprocess JOIN cubeprocess.cubeTaskPerformanceList cubetaskperformance JOIN cubetaskperformance.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2, CubeRole cuberole JOIN cuberole.cubeTaskPerformanceList roletaskperformance";
                this.addDefaultWhereClause("roletaskperformance.taskPerfId = cubetaskperformance.taskPerfId");
            } else {
                from = "CubeOrganizationalUnit cubeorganizationalunit JOIN cubeorganizationalunit.cubeProcessList cubeprocess JOIN cubeprocess.cubeTaskPerformanceList cubetaskperformance JOIN cubetaskperformance.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2";
            }
            this.fromItems.add(cubeActivityTable);
            this.fromItems.add(cubeTaskPerformanceTable);
        } else {
            if (this.fromItems.contains(cubeRoleTable)) {
                from = "CubeProcess cubeprocess JOIN cubeprocess.cubeTaskPerformanceList cubetaskperformance JOIN cubetaskperformance.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2, CubeRole cuberole JOIN cuberole.cubeTaskPerformanceList roletaskperformance";
                this.addDefaultWhereClause("roletaskperformance.taskPerfId = cubetaskperformance.taskPerfId");
            } else {
                from = "CubeProcess cubeprocess JOIN cubeprocess.cubeTaskPerformanceList cubetaskperformance JOIN cubetaskperformance.cubeActivity cubeactivity JOIN cubeactivity.cubeProcess cubeprocess2";
            }
            this.fromItems.add(cubeActivityTable);
            this.fromItems.add(cubeTaskPerformanceTable);
        }
        this.addDefaultWhereClause("(cubeprocess.undeployDate IS NULL)");
        if (this.fromItems.contains(cubeActivityTable) && !this.whereClauses.contains("cubetaskperformance.discriminator = 'MEASUREMENT_COUNTER'") && !this.defaultWhereClauses.contains("cubetaskperformance.discriminator = 'MEASUREMENT_COUNTER'")) {
            this.addDefaultWhereClause("(cubetaskperformance.discriminator IS NULL)");
        }
        if (this.fromItems.contains(cubeActivityTable) && this.ignoreMeasurementsAndSubprocesses()) {
            this.addDefaultWhereClause(this.getIgnoreMeasurementsAndSubprocessesClause());
        }
        return from;
    }

    private boolean useAggregateFunction() {
        return !this.measure.getTableName().equals(SqlLookup.getWorkloadTable()) || this.measure.getColumnName().equals(SqlLookup.getQuantityColumn().getColumnName());
    }

    private boolean ignoreMeasurementsAndSubprocesses() {
        if (this.measurementDimension) {
            return false;
        }
        for (String clause : this.getWhereClauses()) {
            if (!clause.contains(SqlLookup.getActivityNameColumn().getQualifiedColumn()) && !clause.contains(SqlLookup.getActivityTypeColumn().getQualifiedColumn())) continue;
            return false;
        }
        return true;
    }

    private String getIgnoreMeasurementsAndSubprocessesClause() {
        return SQL_IGNORE_MEASUREMENTS_SUBPROCESSES;
    }

    private String getMeasurementDimensionClause() {
        return SQL_MEASUREMENTS_DIMENSION;
    }
}

