/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.impl;

import oracle.bpm.lang.Interval;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.processdashboard.model.impl.ConditionValueUtil;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;

public class WidgetIdHelper {
    public static String setWidgetId(WidgetType widget) {
        String id = "";
        if (widget != null && widget.isSetData() && widget.getData().isSetSeries()) {
            for (SeriesType series : widget.getData().getSeries()) {
                id = id + WidgetIdHelper.setSeriesId(series);
            }
            widget.setId(id);
        }
        return id;
    }

    private static String setSeriesId(SeriesType series) {
        StringBuilder id = new StringBuilder("");
        if (series != null) {
            if (series.isSetDataSource()) {
                id.append(series.getDataSource().hashCode());
            }
            if (series.isSetProcess()) {
                id.append(series.getProcess().hashCode());
            }
            if (series.isSetMeasurement()) {
                id.append(series.getMeasurement().getVariable().hashCode());
                id.append(series.getMeasurement().getAggregateFunction().hashCode());
            }
            if (series.isSetDimensions()) {
                if (series.getDimensions().isSetXSeries() && series.getDimensions().getXSeries().isSetValue()) {
                    id.append(series.getDimensions().getXSeries().getValue().hashCode());
                    id.append(series.getDimensions().getXSeries().isSetUseRange() && series.getDimensions().getXSeries().isUseRange() ? "1" : "0");
                }
                if (series.getDimensions().isSetXGroup() && series.getDimensions().getXGroup().isSetValue()) {
                    id.append(series.getDimensions().getXGroup().getValue().hashCode());
                    id.append(series.getDimensions().getXGroup().isSetUseRange() && series.getDimensions().getXGroup().isUseRange() ? "1" : "0");
                }
            }
            if (series.isSetPredicate()) {
                id.append(WidgetIdHelper.generatePredicateId(series.getPredicate()));
            }
            series.setId(id.toString());
        }
        return id.toString();
    }

    private static String generatePredicateId(PredicateType predicate) {
        StringBuilder id = new StringBuilder("");
        if (predicate.isSetJoinOperator()) {
            id.append(predicate.getJoinOperator().hashCode());
        }
        if (predicate.isSetConditions()) {
            for (ConditionType condition : predicate.getConditions()) {
                String variable = condition.getVariable();
                if ("activity".equalsIgnoreCase(variable)) {
                    id.append(WidgetIdHelper.generateActivityConditionId(condition));
                    continue;
                }
                if ("process".equalsIgnoreCase(variable)) {
                    id.append(WidgetIdHelper.generateProcessConditionId(condition));
                    continue;
                }
                id.append(WidgetIdHelper.generateConditionId(condition));
            }
        }
        if (predicate.isSetLeftCondition()) {
            id.append(WidgetIdHelper.generatePredicateId(predicate.getLeftCondition()));
        }
        if (predicate.isSetRightCondition()) {
            id.append(WidgetIdHelper.generatePredicateId(predicate.getRightCondition()));
        }
        return id.toString();
    }

    private static String generateConditionId(ConditionType condition) {
        StringBuilder id = new StringBuilder("");
        id.append(condition.getVariable().hashCode());
        id.append(condition.getOperator().hashCode());
        if (condition.isSetUseRange() && condition.isUseRange()) {
            id.append("R");
        }
        if (condition.isSetValue() && condition.getValue() != null) {
            Class conditionValueType = ConditionValueUtil.getValueType((String)condition.getValue());
            if (conditionValueType != null && conditionValueType == Interval.class) {
                id.append("I");
            } else {
                id.append("V");
            }
        }
        return id.toString();
    }

    private static String generateActivityConditionId(ConditionType condition) {
        StringBuilder id = new StringBuilder();
        id.append(condition.getVariable().hashCode());
        id.append(condition.getOperator().hashCode());
        id.append("V");
        int indexOf = -1;
        String conditionValue = ConditionValueUtil.getObjectStringValue((ConditionType)condition);
        if (conditionValue != null) {
            indexOf = conditionValue.lastIndexOf("/");
        }
        if (indexOf == -1) {
            if (conditionValue != null && conditionValue.indexOf("#") > -1) {
                id.append("G");
            } else {
                id.append("L");
            }
        }
        return id.toString();
    }

    private static String generateProcessConditionId(ConditionType condition) {
        StringBuilder id = new StringBuilder();
        id.append(condition.getVariable().hashCode());
        id.append(condition.getOperator().hashCode());
        id.append("V");
        ComponentDNModel componentDN = null;
        try {
            componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)ConditionValueUtil.getObjectStringValue((ConditionType)condition));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (componentDN != null) {
            id.append("DN");
            if (componentDN.getCompositeDN().getLabel() != null && !componentDN.getCompositeDN().getLabel().isEmpty()) {
                id.append("L");
            }
            if (componentDN.getCompositeDN().getRevision() != null && !componentDN.getCompositeDN().getRevision().isEmpty()) {
                id.append("R");
            }
        }
        return id.toString();
    }
}

