/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.services.common.resources.BPMServicesResource;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionsType;
import oracle.bpm.services.processdashboard.model.jaxb.DrillDownType;
import oracle.bpm.services.processdashboard.model.jaxb.JoinOperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.OperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.TitleType;
import oracle.bpm.services.processdashboard.model.jaxb.VisualizationType;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public class WidgetDrillDownBuilder {
    private static final ObjectFactory widgetFactory = new ObjectFactory();
    private static final Map<String, String> drillDownMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public static WidgetType buildWidgetDrillDown(@NotNull WidgetType widget, @NotNull String dimension, String value) {
        return WidgetDrillDownBuilder.buildWidgetDrillDown(widget, dimension, value, value);
    }

    public static WidgetType buildWidgetDrillDown(@NotNull WidgetType widget, @NotNull String dimension, String value, String valueLabel) {
        WidgetType drillDownWidget = WidgetDrillDownBuilder.cloneWidget(widget);
        String drillDownSeries = "";
        for (SeriesType series : drillDownWidget.getData().getSeries()) {
            boolean useActivityRoleGroup;
            boolean useRange = false;
            if (series.isSetDimensions() && series.getDimensions().isSetXSeries()) {
                useRange = series.getDimensions().getXSeries().isSetUseRange() && series.getDimensions().getXSeries().isUseRange();
            }
            ConditionType condition = widgetFactory.createConditionType();
            condition.setVariable(dimension);
            condition.setOperator(OperatorTypeEnum.EQUALS);
            condition.setValue(value);
            condition.setUseRange(useRange);
            PredicateType predicate = widgetFactory.createPredicateType();
            if (series.isSetPredicate()) {
                PredicateType conditionPredicate = widgetFactory.createPredicateType();
                conditionPredicate.getConditions().add(condition);
                predicate.setLeftCondition(series.getPredicate());
                predicate.setJoinOperator(JoinOperatorTypeEnum.AND);
                predicate.setRightCondition(conditionPredicate);
            } else {
                predicate.getConditions().add(condition);
            }
            series.setPredicate(predicate);
            DrillDownType drillDownType = null;
            for (DrillDownType drillDown : series.getDrilldown()) {
                if (drillDownType != null && drillDownType.getOrder().compareTo(drillDown.getOrder()) <= 0) continue;
                drillDownType = drillDown;
            }
            boolean drillDownSeriesUseRange = false;
            if (drillDownType != null) {
                drillDownSeries = drillDownType.getDimension().getValue();
                drillDownSeriesUseRange = drillDownType.getDimension().isSetUseRange() && drillDownType.getDimension().isUseRange();
                series.getDrilldown().remove(drillDownType);
            } else {
                drillDownSeries = WidgetDrillDownBuilder.getDrillDownVariable(dimension);
            }
            String drillDownGroup = null;
            boolean drillDownGroupUseRange = false;
            if (series.isSetDimensions() && series.getDimensions().isSetXGroup() && !drillDownSeries.equalsIgnoreCase(series.getDimensions().getXGroup().getValue())) {
                drillDownGroup = series.getDimensions().getXGroup().getValue();
                drillDownGroupUseRange = series.getDimensions().getXGroup().isSetUseRange() && series.getDimensions().getXGroup().isUseRange();
            }
            DimensionsType dimensions = widgetFactory.createDimensionsType();
            DimensionType xSeries = widgetFactory.createDimensionType();
            xSeries.setValue(drillDownSeries);
            xSeries.setUseRange(drillDownSeriesUseRange);
            dimensions.setXSeries(xSeries);
            if (drillDownGroup != null) {
                DimensionType xGroup = widgetFactory.createDimensionType();
                xGroup.setValue(drillDownGroup);
                xGroup.setUseRange(drillDownGroupUseRange);
                dimensions.setXGroup(xGroup);
            }
            series.setDimensions(dimensions);
            boolean useActivityRoleSeries = drillDownSeries.equalsIgnoreCase("role") || drillDownSeries.equalsIgnoreCase("activity");
            boolean bl = useActivityRoleGroup = drillDownGroup != null && (drillDownGroup.equalsIgnoreCase("role") || drillDownGroup.equalsIgnoreCase("activity"));
            if (series.getDataSource() != DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE || !useActivityRoleSeries && !useActivityRoleGroup) continue;
            series.setDataSource(DataSourceTypeEnum.CUBE_TASK_PERFORMANCE);
        }
        if (drillDownWidget.isSetVisualization() && drillDownWidget.getVisualization().isSetTitles()) {
            List<TitleType> drillDownTitles = WidgetDrillDownBuilder.getTitles(drillDownWidget, drillDownSeries, valueLabel);
            drillDownWidget.getVisualization().getTitles().clear();
            drillDownWidget.getVisualization().getTitles().addAll(drillDownTitles);
        }
        return drillDownWidget;
    }

    private static WidgetType cloneWidget(@NotNull WidgetType widget) {
        WidgetType _widget = widgetFactory.createWidgetType();
        if (widget.isSetVisualization()) {
            VisualizationType _visualization = widgetFactory.createVisualizationType();
            _visualization.setType(widget.getVisualization().getType());
            if (widget.getVisualization().isSetTitles()) {
                _visualization.getTitles().addAll(widget.getVisualization().getTitles());
            }
            _visualization.setDefinition(widget.getVisualization().getDefinition());
            _visualization.getOtherAttributes().putAll(widget.getVisualization().getOtherAttributes());
            _widget.setVisualization(_visualization);
        }
        if (widget.isSetData()) {
            DataType _data = widgetFactory.createDataType();
            if (widget.getData().isSetSeries()) {
                for (SeriesType series : widget.getData().getSeries()) {
                    SeriesType _series = widgetFactory.createSeriesType();
                    if (series.isSetTitles()) {
                        _series.getTitles().addAll(series.getTitles());
                    }
                    if (series.isSetDataSource()) {
                        _series.setDataSource(series.getDataSource());
                    }
                    if (series.isSetProcess()) {
                        _series.setProcess(series.getProcess());
                    }
                    if (series.isSetStandard()) {
                        _series.setStandard(series.isStandard());
                    }
                    if (series.isSetMeasurement()) {
                        MeasurementType _measurement = widgetFactory.createMeasurementType();
                        _measurement.setVariable(series.getMeasurement().getVariable());
                        _measurement.setAggregateFunction(series.getMeasurement().getAggregateFunction());
                        _measurement.setValueType(series.getMeasurement().getValueType());
                        _series.setMeasurement(_measurement);
                    }
                    if (series.isSetDimensions()) {
                        DimensionsType _dimensionsType = widgetFactory.createDimensionsType();
                        if (series.getDimensions().isSetXSeries()) {
                            _dimensionsType.setXSeries(series.getDimensions().getXSeries());
                        }
                        if (series.getDimensions().isSetXGroup()) {
                            _dimensionsType.setXGroup(series.getDimensions().getXGroup());
                        }
                        _series.setDimensions(_dimensionsType);
                    }
                    if (series.isSetPredicate()) {
                        _series.setPredicate(WidgetDrillDownBuilder.clonePredicate(series.getPredicate()));
                    }
                    if (series.isSetDrilldown()) {
                        for (DrillDownType drillDownType : series.getDrilldown()) {
                            DrillDownType _drillDownType = widgetFactory.createDrillDownType();
                            _drillDownType.setDimension(drillDownType.getDimension());
                            _drillDownType.setOrder(drillDownType.getOrder());
                            _series.getDrilldown().add(_drillDownType);
                        }
                    }
                    _data.getSeries().add(_series);
                }
            }
            _widget.setData(_data);
        }
        return _widget;
    }

    private static PredicateType clonePredicate(@NotNull PredicateType predicate) {
        PredicateType _predicate = widgetFactory.createPredicateType();
        if (predicate.isSetConditions()) {
            for (ConditionType condition : predicate.getConditions()) {
                ConditionType _condition = widgetFactory.createConditionType();
                _condition.setVariable(condition.getVariable());
                _condition.setOperator(condition.getOperator());
                _condition.setValue(condition.getValue());
                _condition.setUseRange(condition.isSetUseRange() && condition.isUseRange());
                _predicate.getConditions().add(_condition);
            }
        }
        if (predicate.isSetLeftCondition()) {
            _predicate.setLeftCondition(WidgetDrillDownBuilder.clonePredicate(predicate.getLeftCondition()));
        }
        if (predicate.isSetJoinOperator()) {
            _predicate.setJoinOperator(predicate.getJoinOperator());
        }
        if (predicate.isSetRightCondition()) {
            _predicate.setRightCondition(WidgetDrillDownBuilder.clonePredicate(predicate.getRightCondition()));
        }
        return _predicate;
    }

    private static String getDrillDownVariable(@NotNull String variable) {
        String seriesDrillDown = drillDownMapping.get(variable);
        return seriesDrillDown == null ? "activity" : seriesDrillDown;
    }

    private static List<TitleType> getTitles(@NotNull WidgetType widget, @NotNull String dimension, String value) {
        DataSourceTypeEnum dataSource = null;
        boolean isStandard = false;
        boolean isMultiDataSource = false;
        if (widget.getData().isSetSeries()) {
            String previousDS = null;
            for (SeriesType series : widget.getData().getSeries()) {
                if (series.isSetDataSource()) {
                    dataSource = series.getDataSource();
                    if (previousDS == null) {
                        previousDS = dataSource.value();
                    }
                    isMultiDataSource = !dataSource.value().equals(previousDS);
                }
                isStandard = isStandard || series.isSetStandard() && series.isStandard();
            }
        }
        ArrayList<TitleType> titles = new ArrayList();
        if (isStandard) {
            titles = WidgetDrillDownBuilder.getTitles(dataSource, dimension, value, isMultiDataSource);
        } else {
            for (TitleType title : widget.getVisualization().getTitles()) {
                TitleType newTitle = widgetFactory.createTitleType();
                newTitle.setLang(title.getLang());
                newTitle.setCountry(title.getCountry());
                newTitle.setValue(WidgetDrillDownBuilder.getTitle(title, dimension, value));
                titles.add(newTitle);
            }
        }
        return titles;
    }

    private static String getResourceIdFromDataSource(DataSourceTypeEnum dataSource, String dimension) {
        String resourceId = null;
        switch (dataSource) {
            case CUBE_WORKLOAD: {
                if ("activity".equalsIgnoreCase(dimension)) {
                    resourceId = "WORKLOAD_PER_ACTIVITY";
                    break;
                }
                if ("process".equalsIgnoreCase(dimension)) {
                    resourceId = "WORKLOAD_PER_PROCESS";
                    break;
                }
                if (!"participant".equalsIgnoreCase(dimension)) break;
                resourceId = "WORKLOAD_PER_PARTICIPANT";
                break;
            }
            case CUBE_PROCESS_PERFORMANCE: 
            case CUBE_TASK_PERFORMANCE: {
                if ("activity".equalsIgnoreCase(dimension)) {
                    resourceId = "PERFORMANCE_PER_ACTIVITY";
                    break;
                }
                if ("process".equalsIgnoreCase(dimension)) {
                    resourceId = "PERFORMANCE_PER_PROCESS";
                    break;
                }
                if (!"participant".equalsIgnoreCase(dimension)) break;
                resourceId = "PERFORMANCE_PER_PARTICIPANT";
            }
        }
        return resourceId;
    }

    private static String getResourceIdForMultiDataSource(String dimension) {
        String resourceId = null;
        if ("activity".equalsIgnoreCase(dimension)) {
            resourceId = "COMPARISON_PER_ACTIVITY";
        } else if ("process".equalsIgnoreCase(dimension)) {
            resourceId = "COMPARISON_PER_PROCESS";
        } else if ("participant".equalsIgnoreCase(dimension)) {
            resourceId = "COMPARISON_PER_PARTICIPANT";
        }
        return resourceId;
    }

    private static List<TitleType> getTitles(DataSourceTypeEnum dataSource, String dimension, String value, boolean isMultiDatasource) {
        String resourceId;
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        String string = resourceId = isMultiDatasource ? WidgetDrillDownBuilder.getResourceIdForMultiDataSource(dimension) : WidgetDrillDownBuilder.getResourceIdFromDataSource(dataSource, dimension);
        if (resourceId != null) {
            boolean addValue = value != null && !value.isEmpty();
            for (Locale locale : Locale.getAvailableLocales()) {
                String resource = BPMServicesResource.getResource((String)resourceId, (Locale)locale);
                if (resource == null || resource.isEmpty()) continue;
                StringBuilder titleStr = new StringBuilder(resource);
                if (addValue) {
                    titleStr.append(" - ");
                    titleStr.append(value);
                }
                TitleType title = widgetFactory.createTitleType();
                title.setLang(locale.getLanguage());
                title.setCountry(locale.getCountry());
                title.setValue(titleStr.toString());
                titles.add(title);
            }
        }
        return titles;
    }

    private static String getTitle(TitleType title, String dimension, String value) {
        StringBuilder newTitle = new StringBuilder("");
        if (title.isSetValue() && title.getValue() != null && !title.getValue().isEmpty()) {
            newTitle.append(title.getValue());
            newTitle.append(WidgetDrillDownBuilder.getDimensionTitle(title.getLang(), title.getCountry(), dimension, value));
        }
        return newTitle.toString();
    }

    private static String getDimensionTitle(String language, String country, String dimension, String value) {
        StringBuilder title = new StringBuilder("");
        if (dimension != null) {
            Locale locale = new Locale(language, country);
            title.append(" ");
            title.append(BPMServicesResource.getNotNullResource((String)"PER", (Locale)locale).toLowerCase());
            title.append(" ");
            if (dimension.equals("completionDate")) {
                title.append(BPMServicesResource.getNotNullResource((String)"COMPLETION_DATE", (Locale)locale).toLowerCase());
            } else if (dimension.equals("creationDate")) {
                title.append(BPMServicesResource.getNotNullResource((String)"CREATION_DATE", (Locale)locale).toLowerCase());
            } else if (dimension.equals("process")) {
                title.append(BPMServicesResource.getNotNullResource((String)"PROCESS", (Locale)locale).toLowerCase());
            } else if (dimension.equals("role")) {
                title.append(BPMServicesResource.getNotNullResource((String)"ROLE", (Locale)locale).toLowerCase());
            } else if (dimension.equals("activity")) {
                title.append(BPMServicesResource.getNotNullResource((String)"ACTIVITY", (Locale)locale).toLowerCase());
            } else if (dimension.equals("participant")) {
                title.append(BPMServicesResource.getNotNullResource((String)"PARTICIPANT", (Locale)locale).toLowerCase());
            } else {
                title.append(dimension);
            }
            if (value != null && !value.isEmpty()) {
                title.append(" ");
                title.append(BPMServicesResource.getNotNullResource((String)"FOR", (Locale)locale).toLowerCase());
                title.append(" ");
                title.append(value);
            }
        }
        return title.toString();
    }

    static {
        drillDownMapping.put("process", "activity");
        drillDownMapping.put("role", "activity");
        drillDownMapping.put("activity", "participant");
        drillDownMapping.put("participant", "process");
    }
}

