/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action.common.synthesizer;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.analytics.action.common.synthesizer.ProcessMessage;
import oracle.bpm.analytics.action.common.synthesizer.exception.SynthesizerException;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.internal.InternalBPMContext;

public class AuditInstanceSynthesizer {
    private Map<String, String> activityTypes;
    private IBPMContext bpmContext;
    private String compositeDn;
    private IInstanceQueryService iqs;
    private Map<String, ProcessMessage> messageMap;
    private String processName;
    private List<AuditInstanceOperation> registeredOperations;
    private boolean synthesizeTransition = true;
    private Map<String, ProcessMessage> unmatchedMessageMap;
    private static final String CLASS_NAME = AuditInstanceSynthesizer.class.getName();
    private static final String GATEWAY_ACTIVITY_TYPE = "GATEWAY";

    public AuditInstanceSynthesizer(String compositeDn, String processName) {
        this.compositeDn = compositeDn;
        this.processName = processName;
        this.messageMap = new HashMap<String, ProcessMessage>();
        this.unmatchedMessageMap = new HashMap<String, ProcessMessage>();
        this.synthesizeTransition = true;
        this.registeredOperations = new ArrayList<AuditInstanceOperation>();
        this.registeredOperations.add(AuditInstanceOperation.FLOW_NODE_OUT);
        this.registeredOperations.add(AuditInstanceOperation.INSTANCE_FAULT);
        this.registeredOperations.add(AuditInstanceOperation.INSTANCE_CREATED);
    }

    public AuditInstanceSynthesizer(IBPMContext bpmContext, IInstanceQueryService instanceQueryService, String compositeDn, String processName) {
        this(compositeDn, processName);
        this.bpmContext = bpmContext;
        this.iqs = instanceQueryService;
    }

    public AuditInstanceSynthesizer(String compositeDn, String processName, Map<String, String> activityTypes, List<AuditInstanceOperation> synthesizeOperationList, boolean synthesizeTransition) {
        this(compositeDn, processName);
        this.synthesizeTransition = synthesizeTransition;
        this.activityTypes = activityTypes;
        if (synthesizeOperationList != null) {
            this.registeredOperations = synthesizeOperationList;
        }
    }

    public synchronized void reset() {
        this.messageMap.clear();
        this.unmatchedMessageMap.clear();
    }

    public synchronized List<ProcessMessage> synthesize(IAuditInstance auditInstance) throws SynthesizerException {
        ProcessMessage transition;
        ArrayList<ProcessMessage> messages = new ArrayList<ProcessMessage>();
        ProcessMessage startMessage = null;
        ProcessMessage message = this.prepareMessage(auditInstance);
        if (this.isStartMessage(auditInstance.getOperation())) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"synthesize", (String)("Saving Start message :" + message.getComponentInstanceId() + "  " + message.getCompositeDn() + " " + message.getProcessName() + " " + message.getFlowElementId() + " " + message.getScopeId() + "  " + message.getOperation()));
            this.saveMessage(message);
        } else if (this.isEndMessage(auditInstance.getOperation())) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"synthesize", (String)("Processing end message :" + message.getComponentInstanceId() + "  " + message.getCompositeDn() + " " + message.getProcessName() + " " + message.getFlowElementId() + " " + message.getScopeId() + "  " + message.getOperation()));
            startMessage = this.fetchStartMessage(message);
            if (startMessage == null && this.isProcessingRequired(auditInstance)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"synthesize", (String)"Start message not found. Hence saving the end message");
                this.saveUnmatchedMessage(message);
            }
            if (startMessage != null) {
                this.removeMessage(startMessage);
            }
        } else {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"synthesize", (String)("Ignoring the message :" + message.getComponentInstanceId() + "  " + message.getCompositeDn() + " " + message.getProcessName() + " " + message.getFlowElementId() + " " + message.getScopeId() + "  " + message.getOperation()));
            return messages;
        }
        if (this.synthesizeTransition && (transition = this.prepareTransitionMessage(auditInstance)) != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"synthesize", (String)"Synthesizing TRANSITION message");
            messages.add(transition);
        }
        if (this.isProcessingRequired(auditInstance)) {
            if (this.isEndMessage(auditInstance.getOperation())) {
                if (startMessage != null) {
                    ProcessMessage synthesizedMessage = this.prepareSynthesizedMessage(message, startMessage);
                    messages.add(synthesizedMessage);
                }
            } else {
                messages.add(message);
            }
        }
        if (this.unmatchedMessageMap.size() >= 500) {
            messages.addAll(this.syncUnmatchedMessages());
        }
        return messages;
    }

    public List<ProcessMessage> syncUnmatchedMessages() throws SynthesizerException {
        ArrayList<ProcessMessage> messageList = new ArrayList<ProcessMessage>();
        if (this.unmatchedMessageMap == null || this.unmatchedMessageMap.isEmpty()) {
            return messageList;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"syncUnmatchedMessages", (String)(this.unmatchedMessageMap.size() + " unmatched messages found"));
        try {
            Iterator<ProcessMessage> iter = this.unmatchedMessageMap.values().iterator();
            StringBuffer predicateBuf = new StringBuffer();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            int i = 1;
            while (iter.hasNext()) {
                ProcessMessage endMessage = iter.next();
                String operation = endMessage.getOperation();
                String startOperation = this.getStartOperation(operation);
                if (startOperation == null) continue;
                if (predicateBuf.length() != 0) {
                    predicateBuf.append(" OR ");
                }
                predicateBuf.append(" ( ");
                predicateBuf.append("aq.componentInstanceId = :instanceid" + i + " and aq.operation = :operation" + i + " ");
                parameterMap.put("instanceid" + i, endMessage.getComponentInstanceId());
                parameterMap.put("operation" + i, startOperation);
                if (!(AuditInstanceOperation.INSTANCE_ABORTED.toString().equals(operation) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(operation) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equals(operation))) {
                    predicateBuf.append(" and aq.activityId = :activityid" + i + " and  aq.scopeId = :scopeid" + i + " ");
                    parameterMap.put("activityid" + i, endMessage.getFlowElementId());
                    parameterMap.put("scopeid" + i, endMessage.getScopeId());
                }
                predicateBuf.append(" ) ");
                ++i;
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"syncUnmatchedMessages", (String)("InstanceQuery predicate : " + predicateBuf.toString()));
            List aqList = null;
            IBPMContext bpmContext = this.getBPMContext();
            aqList = this.getInstanceQueryService().queryAuditInstances(bpmContext, predicateBuf.toString(), parameterMap);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"syncUnmatchedMessages", (String)("InstanceQueryService api returned : " + (aqList != null ? aqList.size() : 0) + " entries"));
            for (IAuditInstance startAuditInstance : aqList) {
                ProcessMessage startMessage = this.prepareMessage(startAuditInstance);
                String endOperation = this.getEndOperation(startMessage.getOperation());
                String key = this.preparekey(startMessage);
                ProcessMessage endMessage = this.unmatchedMessageMap.get(key = key.replace(startMessage.getOperation(), endOperation));
                if (endMessage == null) continue;
                ProcessMessage synthesizedMessage = this.prepareSynthesizedMessage(endMessage, startMessage);
                messageList.add(synthesizedMessage);
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (Throwable)e);
            throw new SynthesizerException(e);
        }
        this.unmatchedMessageMap.clear();
        return messageList;
    }

    private boolean isProcessingRequired(IAuditInstance input) {
        if (this.registeredOperations == null || this.registeredOperations.isEmpty()) {
            return true;
        }
        return this.registeredOperations.contains(input.getOperation());
    }

    private boolean isStartMessage(AuditInstanceOperation operationType) {
        return AuditInstanceOperation.INSTANCE_CREATED == operationType || AuditInstanceOperation.FLOW_NODE_IN == operationType || AuditInstanceOperation.MEASUREMENT_START == operationType;
    }

    private boolean isEndMessage(AuditInstanceOperation operationType) {
        return AuditInstanceOperation.INSTANCE_ABORTED == operationType || AuditInstanceOperation.INSTANCE_TERMINATED == operationType || AuditInstanceOperation.FLOW_NODE_OUT == operationType || AuditInstanceOperation.MEASUREMENT_STOP == operationType || AuditInstanceOperation.FLOW_NODE_MOVED == operationType || AuditInstanceOperation.INSTANCE_FAULT == operationType || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT == operationType;
    }

    private boolean isFaultMessage(AuditInstanceOperation operationType) {
        return AuditInstanceOperation.INSTANCE_FAULT == operationType || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT == operationType;
    }

    private String getStartOperation(String operationType) {
        String startOperation = null;
        if (AuditInstanceOperation.INSTANCE_ABORTED.toString().equals(operationType)) {
            startOperation = AuditInstanceOperation.INSTANCE_CREATED.toString();
        } else if (AuditInstanceOperation.INSTANCE_TERMINATED.toString().equals(operationType)) {
            startOperation = AuditInstanceOperation.INSTANCE_CREATED.toString();
        } else if (AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(operationType)) {
            startOperation = AuditInstanceOperation.INSTANCE_CREATED.toString();
        } else if (AuditInstanceOperation.INSTANCE_FAULT.toString().equals(operationType)) {
            startOperation = AuditInstanceOperation.FLOW_NODE_IN.toString();
        } else if (AuditInstanceOperation.FLOW_NODE_OUT.toString().equals(operationType)) {
            startOperation = AuditInstanceOperation.FLOW_NODE_IN.toString();
        }
        return startOperation;
    }

    private String getEndOperation(String operationType) {
        String endOperation = null;
        if (AuditInstanceOperation.INSTANCE_CREATED.toString().equals(operationType)) {
            endOperation = AuditInstanceOperation.INSTANCE_TERMINATED.toString();
        } else if (AuditInstanceOperation.FLOW_NODE_IN.toString().equals(operationType)) {
            endOperation = AuditInstanceOperation.FLOW_NODE_OUT.toString();
        }
        return endOperation;
    }

    private ProcessMessage prepareMessage(IAuditInstance auditInstance) {
        ProcessMessage message = new ProcessMessage();
        message.setComponentInstanceId(auditInstance.getComponentInstanceId());
        message.setComponentName(auditInstance.getComponentName());
        message.setCompositeDn(auditInstance.getCompositeDn());
        message.setCompositeInstanceId(auditInstance.getCompositeInstanceId());
        message.setCreationTime(new Timestamp(auditInstance.getCreateTime().getTimeInMillis()));
        message.setFaulted(this.isFaultMessage(auditInstance.getOperation()));
        message.setFlowElementId(auditInstance.getActivityId());
        message.setTargetFlowElementId(auditInstance.getTargetActivity());
        if (AuditInstanceOperation.MEASUREMENT_STOP == auditInstance.getOperation()) {
            message.setFlowElementId(auditInstance.getReferenceId());
        }
        message.setFlowElementType(auditInstance.getFlowElementType());
        message.setLoopCount(auditInstance.getLoopCount());
        message.setOperation(auditInstance.getOperation().toString());
        message.setParticipant(auditInstance.getParticipant());
        message.setProcessName(auditInstance.getProcessName());
        message.setRoleId(auditInstance.getRoleId());
        message.setScopeId(auditInstance.getScopeId());
        message.setThreadId(auditInstance.getThreadId());
        return message;
    }

    private ProcessMessage prepareTransitionMessage(IAuditInstance auditInstance) throws SynthesizerException {
        String sourceFlowElementId = auditInstance.getSourceActivity();
        String targetFlowElementId = auditInstance.getTargetActivity();
        if (sourceFlowElementId == null || targetFlowElementId == null) {
            return null;
        }
        if (AuditInstanceOperation.FLOW_NODE_IN == auditInstance.getOperation()) {
            String sourceActivityType;
            if (this.isGatewayActivityType(auditInstance.getFlowElementType()) && !this.isGatewayActivityType(sourceActivityType = this.getActivityType(sourceFlowElementId))) {
                return null;
            }
        } else if (AuditInstanceOperation.FLOW_NODE_OUT == auditInstance.getOperation()) {
            if (this.isGatewayActivityType(auditInstance.getFlowElementType())) {
                return null;
            }
            String targetActivityType = this.getActivityType(targetFlowElementId);
            if (!this.isGatewayActivityType(targetActivityType)) {
                return null;
            }
        } else {
            return null;
        }
        ProcessMessage message = this.prepareMessage(auditInstance);
        message.setOperation("TRANSITION");
        message.setSourceFlowElementId(sourceFlowElementId);
        message.setTargetFlowElementId(targetFlowElementId);
        return message;
    }

    private ProcessMessage prepareSynthesizedMessage(ProcessMessage endMessage, ProcessMessage startMessage) {
        if (startMessage != null) {
            long startTimeMillis = startMessage.getCreationTime().getTime();
            long endTimeMillis = endMessage.getCreationTime().getTime();
            long executionTime = endTimeMillis - startTimeMillis;
            if (executionTime < 0L) {
                executionTime = 0L;
            }
            endMessage.setExecutionTime(executionTime);
            endMessage.setStartTime(new Timestamp(startTimeMillis));
            if (AuditInstanceOperation.FLOW_NODE_OUT.toString().equals(endMessage.getOperation()) || AuditInstanceOperation.INSTANCE_FAULT.toString().equals(endMessage.getOperation())) {
                endMessage.setOperation("FLOWELEMENT_EXECUTION");
            } else if (AuditInstanceOperation.INSTANCE_ABORTED.toString().equals(endMessage.getOperation()) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equals(endMessage.getOperation()) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(endMessage.getOperation())) {
                endMessage.setOperation("INSTANCE_EXECUTION");
            }
        }
        return endMessage;
    }

    private ProcessMessage fetchStartMessage(ProcessMessage processMessage) {
        String startOperation = this.getStartOperation(processMessage.getOperation());
        if (startOperation == null) {
            return null;
        }
        String key = this.preparekey(processMessage);
        key = key.replace(processMessage.getOperation(), startOperation);
        ProcessMessage startMessage = this.messageMap.get(key);
        return startMessage;
    }

    private boolean isGatewayActivityType(String activityType) {
        return activityType != null && activityType.contains(GATEWAY_ACTIVITY_TYPE);
    }

    private void saveMessage(ProcessMessage message) {
        String key = this.preparekey(message);
        this.messageMap.put(key, message);
    }

    private String getActivityType(String flowElementId) throws SynthesizerException {
        if (this.activityTypes == null) {
            this.loadActivityTypes();
        }
        String compositeRevision = null;
        if (this.compositeDn.contains("*")) {
            compositeRevision = this.compositeDn.substring(0, this.compositeDn.indexOf("*"));
        }
        String key = compositeRevision + "#" + this.processName + "#" + flowElementId;
        return this.activityTypes.get(key);
    }

    private void removeMessage(ProcessMessage processMessage) {
        String key = this.preparekey(processMessage);
        this.messageMap.remove(key);
    }

    private String preparekey(ProcessMessage processMessage) {
        String operation = processMessage.getOperation();
        String componentInstanceId = processMessage.getComponentInstanceId();
        Long threadId = processMessage.getThreadId();
        String activityId = processMessage.getFlowElementId();
        String scopeId = processMessage.getScopeId();
        String key = componentInstanceId + "#" + operation;
        if (!(AuditInstanceOperation.INSTANCE_ABORTED.toString().equals(operation) || AuditInstanceOperation.INSTANCE_CREATED.toString().equals(operation) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equals(operation) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equals(operation))) {
            key = key + "#" + activityId + "#" + threadId + "#" + scopeId;
        }
        return key;
    }

    private void loadActivityTypes() throws SynthesizerException {
        this.activityTypes = new HashMap<String, String>();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"loadActivityTypes", (String)"Loading Activity types");
        try {
            IBPMContext bpmContext = this.getBPMContext();
            this.activityTypes = this.getInstanceQueryService().getActivityTypes(bpmContext, this.compositeDn, this.processName);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"loadActivityTypes", (String)(this.activityTypes.size() + " activity Types for composite = " + this.compositeDn + "  and process = " + this.processName + " loaded"));
                StringBuffer buf = new StringBuffer();
                for (String key : this.activityTypes.keySet()) {
                    buf.append(key + " : " + this.activityTypes.get(key) + "\n");
                }
                if (buf.length() > 0) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"loadActivityTypes", (String)buf.toString());
                }
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (Throwable)e);
            throw new SynthesizerException(e);
        }
    }

    private synchronized IInstanceQueryService getInstanceQueryService() throws NamingException {
        if (this.iqs != null) {
            return this.iqs;
        }
        InitialContext ctx = new InitialContext();
        this.iqs = (IInstanceQueryService)ctx.lookup("ejb/bpm/services/InstanceQueryServiceBean");
        return this.iqs;
    }

    private void saveUnmatchedMessage(ProcessMessage message) {
        String key = this.preparekey(message);
        this.unmatchedMessageMap.put(key, message);
    }

    private synchronized IBPMContext getBPMContext() throws BPMException {
        if (this.bpmContext == null) {
            this.bpmContext = InternalBPMContext.getInternalBPMContext();
        }
        return this.bpmContext;
    }
}

