/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.model;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.ConstantDistribution;
import fuego.simulation.UniformDistribution;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.simulation.jaxb.model.Activities;
import oracle.bpm.project.io.simulation.jaxb.model.Activity;
import oracle.bpm.project.io.simulation.jaxb.model.CalculatedDistributions;
import oracle.bpm.project.io.simulation.jaxb.model.ExponentialDistribution;
import oracle.bpm.project.io.simulation.jaxb.model.NormalDistribution;
import oracle.bpm.project.io.simulation.jaxb.model.ObjectFactory;
import oracle.bpm.project.io.simulation.jaxb.model.RealDistribution;
import oracle.bpm.project.io.simulation.jaxb.model.Transition;
import oracle.bpm.project.io.simulation.jaxb.model.Transitions;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.CostType;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ParticipantSelectionPolicy;
import oracle.bpm.project.model.simulation.QueuePolicy;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.xml.JaxbHelper;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelSimulationJaxbLoader {
    private final Reader reader;
    private final ResourceContainer resourceContainer;
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext(ObjectFactory.class);

    public ModelSimulationJaxbLoader(@NotNull Reader reader, @NotNull ResourceContainer resourceContainer) {
        this.reader = reader;
        this.resourceContainer = resourceContainer;
    }

    @NotNull
    public static ModelSimulationJaxbLoader create(@NotNull Reader reader, @NotNull ResourceContainer resourceContainer) {
        return new ModelSimulationJaxbLoader(reader, resourceContainer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ModelSimulation load() throws UnsupportedEncodingException, ParserException, ProjectException {
        ModelSimulation modelSimulation = null;
        try {
            JAXBContext jc = JAXB_CONTEXT;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal(this.reader);
            if (!(unmarshalledObject instanceof oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation)) throw new ParserException("Invalid JAXB element found");
            oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation jaxbModelSimulation = (oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation)unmarshalledObject;
            modelSimulation = this.load(jaxbModelSimulation);
        }
        catch (JAXBException e) {
            try {
                Log.logFatal(e);
                throw new ParserException((Throwable)e);
                catch (Exception t) {
                    Log.logFatal(t);
                    throw new ParserException((Throwable)t);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(this.reader);
                throw throwable;
            }
        }
        StreamUtils.close(this.reader);
        return modelSimulation;
    }

    @NotNull
    public String getParticipantSelectionPolicy(@NotNull Activity jaxbActivity) {
        String participantSelectionPolicy = jaxbActivity.getParticipantSelectionPolicy();
        if (participantSelectionPolicy == null) {
            participantSelectionPolicy = ParticipantSelectionPolicy.MINIMUM_COST.toString();
        }
        return participantSelectionPolicy;
    }

    @NotNull
    private ModelSimulation load(@NotNull oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation jaxbModelSimulation) throws ProjectException {
        ModelSimulation modelSimulation = this.resourceContainer.createEmptyModelSimulation(jaxbModelSimulation.getName());
        String processId = jaxbModelSimulation.getProcessId();
        if (processId == null) {
            String processPath = jaxbModelSimulation.getProcessPath();
            processId = processPath.substring(processPath.lastIndexOf(47) + 1, processPath.lastIndexOf(46));
        }
        modelSimulation.setProcess(this.resourceContainer.getProject().findProcess(processId));
        modelSimulation.setMaxInstances(jaxbModelSimulation.getMaxInstances());
        modelSimulation.setUseMaxInstances(jaxbModelSimulation.isUseMaxInstances());
        this.loadFlowNodes(jaxbModelSimulation, modelSimulation);
        this.loadSequenceFlows(jaxbModelSimulation, modelSimulation);
        this.loadDistribution(jaxbModelSimulation, modelSimulation);
        this.loadCalculatedDistributions(jaxbModelSimulation, modelSimulation);
        return modelSimulation;
    }

    private void loadFlowNodes(@NotNull oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation jaxbModelSimulation, @NotNull ModelSimulation modelSimulation) throws ProjectException {
        List<Activity> jaxbActivityList;
        Activities jaxbModelSimulationActivities = jaxbModelSimulation.getActivities();
        if (jaxbModelSimulationActivities != null && (jaxbActivityList = jaxbModelSimulationActivities.getActivity()) != null && jaxbActivityList.size() > 0) {
            for (Activity jaxbActivity : jaxbActivityList) {
                this.loadFlowNode(jaxbActivity, modelSimulation);
            }
        }
    }

    private void loadFlowNode(@NotNull Activity jaxbActivity, @NotNull ModelSimulation modelSimulation) throws ProjectException {
        String jaxbActivityName = jaxbActivity.getName();
        if (jaxbActivityName != null) {
            SimulationFlowNode simulationActivity = modelSimulation.createSimulationFlowNode(jaxbActivityName);
            if (simulationActivity == null) {
                return;
            }
            simulationActivity.setQueueWarningLevel(jaxbActivity.getQueueWarningLevel());
            simulationActivity.setQueuePolicy(QueuePolicy.valueOf(this.getQueuePolicy(jaxbActivity)));
            simulationActivity.setCostType(CostType.valueOf(this.getActivityCostType(jaxbActivity)));
            simulationActivity.setParticipantSelectionPolicy(ParticipantSelectionPolicy.valueOf(this.getParticipantSelectionPolicy(jaxbActivity)));
            simulationActivity.setExceptionProbability(jaxbActivity.getExceptionProbability());
            simulationActivity.setAbortProbability(jaxbActivity.getAbortProbability());
            simulationActivity.setCost(jaxbActivity.getCost());
            simulationActivity.setUseOrgResources(jaxbActivity.isUseOrgResources());
            simulationActivity.setCapacity(jaxbActivity.getCapacity());
            simulationActivity.setInnerSimulation(jaxbActivity.isInnerSimulation());
            this.generateDistributionData(jaxbActivity, simulationActivity);
            modelSimulation.addSimulationFlowNode(simulationActivity);
        }
    }

    private void generateDistributionData(@NotNull Activity jaxbActivity, @NotNull SimulationFlowNode simulationActivity) {
        Distribution distribution;
        oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution jaxbAbstractDistribution;
        CalculatedDistributions jaxbCalculatedDistributions;
        Distribution distribution2;
        oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution jaxbAbstractDistribution2;
        oracle.bpm.project.io.simulation.jaxb.model.Distribution jaxbDistribution = jaxbActivity.getDistribution();
        if (jaxbDistribution != null && (jaxbAbstractDistribution2 = jaxbDistribution.getConstantDistributionOrNormalDistributionOrUniformDistribution()) != null && (distribution2 = this.createAbstractDistribution(jaxbAbstractDistribution2)) != null) {
            simulationActivity.setDistribution(distribution2);
        }
        if ((jaxbCalculatedDistributions = jaxbActivity.getCalculatedDistributions()) != null && (jaxbAbstractDistribution = jaxbCalculatedDistributions.getConstantDistributionOrNormalDistributionOrUniformDistribution()) != null && (distribution = this.createAbstractDistribution(jaxbAbstractDistribution)) != null) {
            simulationActivity.addCalculatedDistribution(distribution);
        }
    }

    @NotNull
    private String getQueuePolicy(@NotNull Activity jaxbActivity) {
        String queuePolicy = jaxbActivity.getQueuePolicy();
        if (queuePolicy == null) {
            queuePolicy = QueuePolicy.FIFO.toString();
        }
        return queuePolicy;
    }

    @NotNull
    private String getActivityCostType(@NotNull Activity jaxbActivity) {
        String activityCostType = jaxbActivity.getActivityCostType();
        if (activityCostType == null) {
            activityCostType = CostType.FIXED_BASE_COST.toString();
        }
        return activityCostType;
    }

    private void loadSequenceFlows(@NotNull oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation jaxbModelSimulation, @NotNull ModelSimulation modelSimulation) throws ProjectException {
        List<Transition> jaxbTransitionList;
        Transitions jaxbTransitions = jaxbModelSimulation.getTransitions();
        if (jaxbTransitions != null && (jaxbTransitionList = jaxbTransitions.getTransition()) != null && jaxbTransitionList.size() > 0) {
            for (Transition jaxbTransition : jaxbTransitionList) {
                this.loadSequenceFlow(jaxbTransition, modelSimulation);
            }
        }
    }

    private void loadSequenceFlow(@NotNull Transition jaxbTransition, @NotNull ModelSimulation modelSimulation) throws ProjectException {
        SimulationSequenceFlow sequenceFlow = modelSimulation.createSimulationSequenceFlow(jaxbTransition.getName());
        sequenceFlow.setProbability(jaxbTransition.getProbability());
        String dueInterval = jaxbTransition.getDueInterval();
        if (!Str.isEmpty(dueInterval)) {
            sequenceFlow.setDueInterval(Interval.valueOf(dueInterval));
            sequenceFlow.setUsesInterval(jaxbTransition.isUseInterval());
            sequenceFlow.setRelatedBoundaryId(jaxbTransition.getRelatedBoundary());
        }
        modelSimulation.addSimulationSequenceFlow(sequenceFlow);
    }

    private void loadDistribution(@NotNull oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation jaxbModelSimulation, @NotNull ModelSimulation modelSimulation) throws ProjectException {
        Distribution distribution;
        oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution jaxbAbstractDistribution;
        oracle.bpm.project.io.simulation.jaxb.model.Distribution jaxbDistribution = jaxbModelSimulation.getDistribution();
        if (jaxbDistribution != null && (jaxbAbstractDistribution = jaxbDistribution.getConstantDistributionOrNormalDistributionOrUniformDistribution()) != null && (distribution = this.createAbstractDistribution(jaxbAbstractDistribution)) != null) {
            modelSimulation.setDistribution(distribution);
        }
    }

    @Nullable
    private Distribution createAbstractDistribution(@NotNull oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution jaxbAbstractDistribution) {
        ConstantDistribution distribution = null;
        if (jaxbAbstractDistribution instanceof oracle.bpm.project.io.simulation.jaxb.model.ConstantDistribution) {
            ConstantDistribution constantDistribution = (ConstantDistribution)AbstractDistribution.create((DistributionType)DistributionType.CONSTANT);
            constantDistribution.setPeriod(((oracle.bpm.project.io.simulation.jaxb.model.ConstantDistribution)jaxbAbstractDistribution).getPeriod());
            distribution = constantDistribution;
        } else if (jaxbAbstractDistribution instanceof NormalDistribution) {
            NormalDistribution jaxbNormalDistribution = (NormalDistribution)jaxbAbstractDistribution;
            fuego.simulation.NormalDistribution normalDistribution = (fuego.simulation.NormalDistribution)AbstractDistribution.create((DistributionType)DistributionType.NORMAL);
            normalDistribution.setMean(jaxbNormalDistribution.getMean());
            normalDistribution.setDeviation(jaxbNormalDistribution.getDeviation());
            distribution = normalDistribution;
        } else if (jaxbAbstractDistribution instanceof oracle.bpm.project.io.simulation.jaxb.model.UniformDistribution) {
            oracle.bpm.project.io.simulation.jaxb.model.UniformDistribution jaxbUniformDistribution = (oracle.bpm.project.io.simulation.jaxb.model.UniformDistribution)jaxbAbstractDistribution;
            UniformDistribution uniformDistribution = (UniformDistribution)AbstractDistribution.create((DistributionType)DistributionType.UNIFORM);
            uniformDistribution.setAvg(jaxbUniformDistribution.getAvg());
            uniformDistribution.setDeviation(jaxbUniformDistribution.getDeviation());
            distribution = uniformDistribution;
        } else if (jaxbAbstractDistribution instanceof ExponentialDistribution) {
            ExponentialDistribution jaxbExponentialDistribution = (ExponentialDistribution)jaxbAbstractDistribution;
            fuego.simulation.ExponentialDistribution exponentialDistribution = (fuego.simulation.ExponentialDistribution)AbstractDistribution.create((DistributionType)DistributionType.EXPONENTIAL);
            exponentialDistribution.setEvents(jaxbExponentialDistribution.getEvents());
            exponentialDistribution.setInterval(Interval.valueOf(jaxbExponentialDistribution.getIntervalValue()));
            distribution = exponentialDistribution;
        } else if (jaxbAbstractDistribution instanceof RealDistribution) {
            RealDistribution jaxbRealDistribution = (RealDistribution)jaxbAbstractDistribution;
            fuego.simulation.RealDistribution realDistribution = (fuego.simulation.RealDistribution)AbstractDistribution.create((DistributionType)DistributionType.REAL);
            realDistribution.clearAllSlots();
            realDistribution.setRealDistributionCriteria(RealDistributionCriteria.valueOf(jaxbRealDistribution.getRealDistributionSubtype()));
            List<oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution> subdistributions = jaxbRealDistribution.getConstantDistributionOrNormalDistributionOrUniformDistribution();
            for (oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution jaxbAbsSubdistribution : subdistributions) {
                realDistribution.addDistribution(this.createAbstractDistribution(jaxbAbsSubdistribution));
            }
            distribution = realDistribution;
        }
        return distribution;
    }

    private void loadCalculatedDistributions(@NotNull oracle.bpm.project.io.simulation.jaxb.model.ModelSimulation jaxbModelSimulation, @NotNull ModelSimulation modelSimulation) throws ProjectException {
        Distribution distribution;
        oracle.bpm.project.io.simulation.jaxb.model.AbstractDistribution jaxbAbstractDistribution;
        CalculatedDistributions jaxbCalculatedDistributions = jaxbModelSimulation.getCalculatedDistributions();
        if (jaxbCalculatedDistributions != null && (jaxbAbstractDistribution = jaxbCalculatedDistributions.getConstantDistributionOrNormalDistributionOrUniformDistribution()) != null && (distribution = this.createAbstractDistribution(jaxbAbstractDistribution)) != null) {
            modelSimulation.addCalculatedDistribution(distribution);
        }
    }
}

