/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import oracle.bpm.data.CalendarRuleData;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRuleAssignment;
import oracle.bpm.xml.XmlWriter;

public class XmlCalendarRuleSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof CalendarRule);
        CalendarRule calendarRule = (CalendarRule)object;
        xmlWriter.startElement("DirCalendarRule");
        xmlWriter.printValuedElement("name", calendarRule.getId());
        CalendarRuleData calendarRuleData = new CalendarRuleData();
        calendarRuleData.timeZone = calendarRule.getTimeZone();
        calendarRuleData.workWeek = calendarRule.getWorkWeek();
        HolidayRuleAssignment holidayRuleAssignment = calendarRule.getHolidayRuleAssignment();
        calendarRuleData.holidayRule = holidayRuleAssignment == null ? CoreMsg.NONE.toString().toUpperCase() : (holidayRuleAssignment.getHolidayRule() != null ? holidayRuleAssignment.getHolidayRule().getId() : holidayRuleAssignment.getHolidayRuleId());
        xmlWriter.printCDATAElement("properties", calendarRuleData.toString(), true);
        xmlWriter.endElement();
    }
}

