/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.HashMap;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.xml.sax.SAXException;

class VariableHandler
extends BaseSourceHandler {
    protected LocaleStringMap displayNames = LocaleStringMap.create();
    protected String id;
    protected HashMap<String, String> propertiesByCategory = new HashMap();
    protected String size;
    protected String type;

    VariableHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("id".equals(name)) {
            return new IdHandler(this);
        }
        if ("type".equals(name)) {
            return new TypeHandler(this);
        }
        if ("size".equals(name)) {
            return new SizeHandler(this);
        }
        if ("mask".equals(name)) {
            return new MaskHandler(this);
        }
        if ("localizedDisplayNames".equals(name)) {
            return new LocalizedDisplayNamesHandler(this);
        }
        if ("processVariableProperties".equals(name)) {
            return new ProcessVariablePropertiesHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ProjectDataObject projectDataObject = this.getProject().createDeclaration(this.id, CatalogType.Default.get((TypeRef)TypeFactory.forNameNonPrimitive((String)this.type, (String)this.size)));
            for (Locale locale : this.displayNames.keySet()) {
                projectDataObject.getLabelMap().put(locale, (String)this.displayNames.get((Object)locale));
            }
            if (this.propertiesByCategory.size() > 0) {
                if (this.propertiesByCategory.get("DATA") != null) {
                    projectDataObject.setBusinessVariableData(BusinessVariableData.create((String)this.propertiesByCategory.get("DATA")));
                }
                if (this.propertiesByCategory.get("TYPE") != null) {
                    projectDataObject.setBusinessVariableType(BusinessVariableType.valueOf((String)this.propertiesByCategory.get("TYPE")));
                }
            }
            this.getParseListener().objectParsed(this, projectDataObject);
        }
        catch (ProjectException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
        ProjectDataObject projectDataObject = (ProjectDataObject)projectObject;
        this.getProject().addDeclaration(projectDataObject);
    }

    private class TypeHandler
    extends DataElementHandler {
        public TypeHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            VariableHandler.this.type = this.getData();
        }
    }

    private class SizeHandler
    extends DataElementHandler {
        public SizeHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            VariableHandler.this.size = this.getData();
        }
    }

    private class LocalizedDisplayNamesHandler
    extends BaseSourceHandler {
        public LocalizedDisplayNamesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("localizedDisplayName".equals(name)) {
                return new LocalizedDisplayNameHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class LocalizedDisplayNameHandler
        extends BaseSourceHandler {
            private Locale locale;
            private String message;

            public LocalizedDisplayNameHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public SourceHandler getHandler(String uri, String qName, String name) {
                if ("locale".equals(name)) {
                    return new LocaleHandler(this);
                }
                if ("message".equals(name)) {
                    return new MessageHandler(this);
                }
                return new BaseSourceHandler(this);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                VariableHandler.this.displayNames.put(this.locale, this.message);
            }

            private class MessageHandler
            extends DataElementHandler {
                public MessageHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    LocalizedDisplayNameHandler.this.message = this.getData();
                }
            }

            private class LocaleHandler
            extends DataElementHandler {
                public LocaleHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    LocalizedDisplayNameHandler.this.locale = new Locale(this.getData());
                }
            }
        }
    }

    private class IdHandler
    extends DataElementHandler {
        public IdHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            VariableHandler.this.id = this.getData();
        }
    }

    private static class MaskHandler
    extends DataElementHandler {
        public MaskHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class ProcessVariablePropertiesHandler
    extends BaseSourceHandler {
        public static final String PROPERTY_KEY_TYPE = "TYPE";
        public static final String PROPERTY_KEY_DATA = "DATA";

        public ProcessVariablePropertiesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if (name.endsWith("processVariableProperty")) {
                return new ProcessVariablePropertyHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class ProcessVariablePropertyHandler
        extends BaseSourceHandler {
            private String category;
            private String key;
            private String value;

            public ProcessVariablePropertyHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public SourceHandler getHandler(String uri, String qName, String name) {
                if ("prop_category".equals(name)) {
                    return new PropertyCategoryHandler(this);
                }
                if ("prop_key".equals(name)) {
                    return new PropertyKeyHandler(this);
                }
                if ("prop_value".equals(name)) {
                    return new PropertyValueHandler(this);
                }
                return new BaseSourceHandler(this);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                VariableHandler.this.propertiesByCategory.put(this.key, this.value);
            }

            private class PropertyValueHandler
            extends DataElementHandler {
                public PropertyValueHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    ProcessVariablePropertyHandler.this.value = this.getData();
                }
            }

            private class PropertyKeyHandler
            extends DataElementHandler {
                public PropertyKeyHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    ProcessVariablePropertyHandler.this.key = this.getData();
                }
            }

            private class PropertyCategoryHandler
            extends DataElementHandler {
                public PropertyCategoryHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    ProcessVariablePropertyHandler.this.category = this.getData();
                }
            }
        }
    }
}

