/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.LinkedList;
import oracle.bpm.lang.Id;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.ParseListener;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ResourceContainer;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectSourceHandler
extends DefaultHandler
implements SourceHandler {
    private ResourceContainer container;
    private SourceHandler currentHandler;
    private ParseListener parseListener;
    private Project project;
    private int sourceVersion = -1;
    private final LinkedList<SourceHandler> stack = new LinkedList();
    private static final String FUEGO_TARGET = "fuego";

    ProjectSourceHandler() {
    }

    ProjectSourceHandler(@NotNull Project project, ResourceContainer container) {
        this.project = project;
        this.container = container;
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        return new BaseSourceHandler(this);
    }

    public Project getProject() {
        return this.project;
    }

    public ResourceContainer getContainer() {
        return this.container;
    }

    public int getSourceVersion() {
        return this.sourceVersion;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentHandler.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentHandler.endElement(uri, localName, qName);
        this.popHandler();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (FUEGO_TARGET.equals(target)) {
            this.sourceVersion = Id.parseXmlVersion(data);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.pushHandler(this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.pushHandler(this.currentHandler.getHandler(uri, localName, qName));
        this.currentHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        Log.logWarning(e);
    }

    public ParseListener getParseListener() {
        return this.parseListener;
    }

    public void addParseListener(ParseListener parseListener) {
        this.parseListener = parseListener;
    }

    private void popHandler() {
        this.stack.removeLast();
        this.currentHandler = this.stack.getLast();
    }

    private void pushHandler(SourceHandler handler) {
        assert (handler != null) : "Handler cannot be null";
        this.stack.addLast(handler);
        this.currentHandler = handler;
    }
}

