/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.HolidayRule;
import org.xml.sax.SAXException;

class HolidayRuleHandler
extends BaseSourceHandler {
    private String calendarData;
    private String id;

    HolidayRuleHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("name".equals(name)) {
            return new NameHandler(this);
        }
        if ("properties".equals(name)) {
            return new PropertiesHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ResourceContainer container = this.getContainer();
            HolidayRule hr = container.createHolidayRule(this.id);
            HolidayRule.Mutable holidayRule = hr.asMutable();
            if (this.calendarData != null) {
                HolidayCalendar holidayCalendar = HolidayCalendar.valueOf(null, (String)this.calendarData);
                holidayRule.setHolidayCalendar(holidayCalendar);
            }
            this.getParseListener().objectParsed(this, holidayRule);
        }
        catch (ProjectException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private boolean isLegacy(String calendarData) {
        while (calendarData.startsWith("\n") || calendarData.startsWith("\t")) {
            calendarData = calendarData.substring(1, calendarData.length());
        }
        return calendarData.startsWith("<");
    }

    private class PropertiesHandler
    extends DataElementHandler {
        public PropertiesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            HolidayRuleHandler.this.calendarData = this.getData();
        }
    }

    private class NameHandler
    extends DataElementHandler {
        public NameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            HolidayRuleHandler.this.id = this.getData();
        }
    }
}

