/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import oracle.bpm.project.io.serializers.organization.ParseListener;
import oracle.bpm.project.io.serializers.organization.ProjectObjectParser;
import oracle.bpm.project.io.serializers.organization.ProjectSourceHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseSourceHandler
extends DefaultHandler
implements SourceHandler,
ProjectObjectParser {
    private boolean checkContentType = false;
    private ParseListener parseListener;
    private final ProjectSourceHandler topHandler;

    BaseSourceHandler(ProjectSourceHandler topHandler) {
        this.topHandler = topHandler;
        this.parseListener = topHandler.getParseListener();
    }

    BaseSourceHandler(BaseSourceHandler parent) {
        this.topHandler = parent.topHandler;
        this.parseListener = parent.getParseListener();
    }

    BaseSourceHandler(ProjectSourceHandler topHandler, boolean checkContentType) {
        this.topHandler = topHandler;
        this.parseListener = topHandler.getParseListener();
        this.checkContentType = checkContentType;
    }

    BaseSourceHandler(BaseSourceHandler parent, boolean checkContentType) {
        this.topHandler = parent.topHandler;
        this.parseListener = parent.getParseListener();
        this.checkContentType = checkContentType;
    }

    public ParseListener getParseListener() {
        return this.parseListener;
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        return this;
    }

    public int getSourceVersion() {
        return this.topHandler.getSourceVersion();
    }

    public boolean isCheckContentType() {
        return this.checkContentType;
    }

    protected void migrateFile(ProjectObject projectObject) {
        try {
            projectObject.getProject().getWriter().write(projectObject);
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    Project getProject() {
        return this.topHandler.getProject();
    }

    ResourceContainer getContainer() {
        return this.topHandler.getContainer();
    }
}

