/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.fuego;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.io.serializers.model.fuego.AbstractHandler;
import oracle.bpm.project.io.serializers.model.fuego.RootHandler;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.util.documentation.DocumentationType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CDATADocumentationHandler
extends AbstractHandler {
    private int crimsonBugCounter = 0;
    private StringBuffer documentation;
    private String language;
    private DocumentationType type;

    public CDATADocumentationHandler(RootHandler root, AbstractHandler handler, String tagName) {
        super(root, handler, tagName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            if (ch.length > start && ch[start] == ']') {
                ++this.crimsonBugCounter;
                if (this.crimsonBugCounter > 2) {
                    throw new SAXException(ProjectCompileMsg.PRJ_00090.getString());
                }
            }
        } else {
            this.crimsonBugCounter = 0;
        }
        this.documentation.append(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (qName.equals(this.tagName_d)) {
            this.tagEnded();
        }
    }

    @Override
    public void init(Attributes atts) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.documentation = new StringBuffer();
        try {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attname = atts.getQName(i);
                String value = atts.getValue(i);
                if (attname.equals("language")) {
                    this.language = value;
                    continue;
                }
                if (!attname.equals("type")) continue;
                this.type = DocumentationType.valueOf((String)value);
            }
        }
        catch (Exception ex) {
            Log.logWarning(ex);
        }
    }

    @Override
    protected Object getProjectElement() {
        return this.getParentElement();
    }

    protected void tagEnded() {
        String doc = this.documentation.toString();
        if (this.type == DocumentationType.USE_CASE_DOCUMENTATION) {
            ((Localizable)this.getProjectElement()).getUseCaseDocumentationMap().put(new Locale(this.language), doc);
        } else {
            ((Localizable)this.getProjectElement()).getDocumentationMap().put(new Locale(this.language), doc);
        }
    }
}

