/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation.transformers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import oracle.bpm.extensionpoint.metadata.XMLModelTransformerMetadata;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.DOMTransformer;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@XMLModelTransformerMetadata
public class XMLModelTransformer20110201
extends DOMTransformer {
    private static String OLD_USER_TASK_TRANSFORMATION_ARG_NAME = "task";
    private static String NEW_USER_TASK_TRANSFORMATION_ARG_NAME = "execData";

    @Override
    public Integer getToVersion() {
        return 20110201;
    }

    @Override
    protected void transform(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        this.fixTaskArguments(document, xPath);
    }

    @Override
    protected Map<String, String> getCurrentVersionNamespacesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("bpmn", "http://www.omg.org/bpmn20");
        result.put("bpmnext", "http://xmlns.oracle.com/bpm/OracleExtensions");
        return result;
    }

    private void fixTaskArguments(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug("Task argument conversion...");
        String expression = "//bpmn:userTask/bpmn:dataInputAssociation/bpmn:targetRef[../bpmn:transformation and text()='" + OLD_USER_TASK_TRANSFORMATION_ARG_NAME + "'] | ";
        expression = expression + "//bpmn:userTask/bpmn:dataOutputAssociation/bpmn:sourceRef[../bpmn:transformation and text()='" + OLD_USER_TASK_TRANSFORMATION_ARG_NAME + "']";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            element.setTextContent(NEW_USER_TASK_TRANSFORMATION_ARG_NAME);
        }
    }
}

