/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNamespaceTranslator {
    private Map<Key<String>, Value<String>> translations = new HashMap<Key<String>, Value<String>>();

    public XMLNamespaceTranslator addTranslation(String fromNamespaceURI, String toNamespaceURI) {
        Key<String> key = new Key<String>(fromNamespaceURI);
        Value<String> value = new Value<String>(toNamespaceURI);
        this.translations.put(key, value);
        return this;
    }

    public void translateNamespaces(Document xmlDoc) {
        Stack<Node> nodes = new Stack<Node>();
        nodes.push(xmlDoc.getDocumentElement());
        while (!nodes.isEmpty()) {
            NodeList childNodes;
            Node node = (Node)nodes.pop();
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    Value<String> value = this.translations.get(new Key<String>(node.getNamespaceURI()));
                    if (value == null) break;
                    node = xmlDoc.renameNode(node, (String)value.getValue(), node.getNodeName());
                }
            }
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && attributes.getLength() != 0) {
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    Node attribute = attributes.item(i);
                    if (attribute == null) continue;
                    nodes.push(attribute);
                }
            }
            if ((childNodes = node.getChildNodes()) == null || childNodes.getLength() == 0) continue;
            int count = childNodes.getLength();
            for (int i = 0; i < count; ++i) {
                Node childNode = childNodes.item(i);
                if (childNode == null) continue;
                nodes.push(childNode);
            }
        }
    }

    private static class Value<T>
    extends Holder<T> {
        public Value(T value) {
            super(value);
        }
    }

    private static class Key<T>
    extends Holder<T> {
        public Key(T value) {
            super(value);
        }
    }

    private static class Holder<T> {
        protected final T value;

        public Holder(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Holder other = (Holder)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

