/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation;

import java.io.InputStream;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.XMLModelTransformerMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.InputOutputStream;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.TransformationException;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.XMLModelTransformer;
import org.jetbrains.annotations.NotNull;

public class TransformationManager {
    private static SortedSet<XMLModelTransformer> transformers = new TreeSet<XMLModelTransformer>();

    public static InputStream transform(@NotNull InputStream inputStream, @NotNull Integer fromVersion, @NotNull Integer toVersion) throws TransformationException {
        try {
            InputOutputStream ioStream = new InputOutputStream();
            StreamUtils.copy(inputStream, ioStream);
            for (XMLModelTransformer transformer : transformers) {
                if (transformer.getToVersion() <= fromVersion || transformer.getToVersion() > toVersion) continue;
                transformer.transform(ioStream);
            }
            return ioStream.getInputStream();
        }
        catch (Exception e) {
            throw TransformationException.createInvalidModel(e);
        }
    }

    static {
        ExtensionService service = Platform.getExtensionService();
        List<Extension<XMLModelTransformerMetadata>> extensions = service.getExtensionsByPoint(XMLModelTransformerMetadata.class);
        for (Extension<XMLModelTransformerMetadata> extension : extensions) {
            try {
                XMLModelTransformer transformer = extension.instantiateAs(XMLModelTransformer.class);
                transformers.add(transformer);
            }
            catch (InstantiationException e) {}
        }
    }
}

