/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.normalization;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.JAXBModelNormalizerMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.io.serializers.model.bpmn.normalization.JAXBModelNormalizer;
import oracle.bpm.project.io.serializers.model.bpmn.normalization.NormalizationException;
import org.jetbrains.annotations.NotNull;

public class NormalizationManager {
    private static SortedSet<JAXBModelNormalizer> normalizers = new TreeSet<JAXBModelNormalizer>();

    public static void normalize(@NotNull JAXBElement rootElement, @NotNull Integer fromVersion, @NotNull Integer toVersion) throws NormalizationException {
        try {
            for (JAXBModelNormalizer normalizer : normalizers) {
                if (normalizer.getToVersion() <= fromVersion || normalizer.getToVersion() > toVersion) continue;
                normalizer.normalize(rootElement);
            }
        }
        catch (Exception e) {
            throw NormalizationException.createInvalidModel(e);
        }
    }

    static {
        ExtensionService service = Platform.getExtensionService();
        List<Extension<JAXBModelNormalizerMetadata>> extensions = service.getExtensionsByPoint(JAXBModelNormalizerMetadata.class);
        for (Extension<JAXBModelNormalizerMetadata> extension : extensions) {
            try {
                JAXBModelNormalizer normalizer = extension.instantiateAs(JAXBModelNormalizer.class);
                normalizers.add(normalizer);
            }
            catch (InstantiationException e) {}
        }
    }
}

