/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.catalog.correlation.PropertyAliasSetId;
import oracle.bpm.project.catalog.type.utils.NotificationServiceHelper;
import oracle.bpm.project.catalog.type.utils.TaskManagementServiceHelper;
import oracle.bpm.project.io.bpmn.jaxb.TActivity;
import oracle.bpm.project.io.bpmn.jaxb.TArtifact;
import oracle.bpm.project.io.bpmn.jaxb.TAssignment;
import oracle.bpm.project.io.bpmn.jaxb.TAttributeExpression;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElement;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElementWithMixedContent;
import oracle.bpm.project.io.bpmn.jaxb.TBoundaryEvent;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessIndicator;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessIndicators;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessRuleTask;
import oracle.bpm.project.io.bpmn.jaxb.TCallActivity;
import oracle.bpm.project.io.bpmn.jaxb.TCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TComplexGateway;
import oracle.bpm.project.io.bpmn.jaxb.TCounter;
import oracle.bpm.project.io.bpmn.jaxb.TDataAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDataInput;
import oracle.bpm.project.io.bpmn.jaxb.TDataInputAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDataObject;
import oracle.bpm.project.io.bpmn.jaxb.TDataOutput;
import oracle.bpm.project.io.bpmn.jaxb.TDataOutputAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDefinitions;
import oracle.bpm.project.io.bpmn.jaxb.TEndEvent;
import oracle.bpm.project.io.bpmn.jaxb.TErrorEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TEvent;
import oracle.bpm.project.io.bpmn.jaxb.TEventBasedGateway;
import oracle.bpm.project.io.bpmn.jaxb.TEventBasedGatewayType;
import oracle.bpm.project.io.bpmn.jaxb.TEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TExclusiveGateway;
import oracle.bpm.project.io.bpmn.jaxb.TExtensionElements;
import oracle.bpm.project.io.bpmn.jaxb.TFlowElement;
import oracle.bpm.project.io.bpmn.jaxb.TFlowNode;
import oracle.bpm.project.io.bpmn.jaxb.TFormalExpression;
import oracle.bpm.project.io.bpmn.jaxb.TGateway;
import oracle.bpm.project.io.bpmn.jaxb.TGatewayDirection;
import oracle.bpm.project.io.bpmn.jaxb.TInclusiveGateway;
import oracle.bpm.project.io.bpmn.jaxb.TInputOutputSpecification;
import oracle.bpm.project.io.bpmn.jaxb.TInputSet;
import oracle.bpm.project.io.bpmn.jaxb.TIntermediateCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TIntermediateThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.TLane;
import oracle.bpm.project.io.bpmn.jaxb.TLaneSet;
import oracle.bpm.project.io.bpmn.jaxb.TLogHandler;
import oracle.bpm.project.io.bpmn.jaxb.TLogHandlers;
import oracle.bpm.project.io.bpmn.jaxb.TLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TManualTask;
import oracle.bpm.project.io.bpmn.jaxb.TMeasurementMark;
import oracle.bpm.project.io.bpmn.jaxb.TMessageEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TMultiInstanceFlowCondition;
import oracle.bpm.project.io.bpmn.jaxb.TMultiInstanceLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TOutputSet;
import oracle.bpm.project.io.bpmn.jaxb.TParallelGateway;
import oracle.bpm.project.io.bpmn.jaxb.TProcess;
import oracle.bpm.project.io.bpmn.jaxb.TProcessType;
import oracle.bpm.project.io.bpmn.jaxb.TReceiveTask;
import oracle.bpm.project.io.bpmn.jaxb.TResourceRole;
import oracle.bpm.project.io.bpmn.jaxb.TScript;
import oracle.bpm.project.io.bpmn.jaxb.TScriptTask;
import oracle.bpm.project.io.bpmn.jaxb.TSendTask;
import oracle.bpm.project.io.bpmn.jaxb.TSequenceFlow;
import oracle.bpm.project.io.bpmn.jaxb.TServiceProperties;
import oracle.bpm.project.io.bpmn.jaxb.TServicePropertiesContainer;
import oracle.bpm.project.io.bpmn.jaxb.TServiceProperty;
import oracle.bpm.project.io.bpmn.jaxb.TServiceTask;
import oracle.bpm.project.io.bpmn.jaxb.TSignalEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TStandardLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TStartEvent;
import oracle.bpm.project.io.bpmn.jaxb.TSubProcess;
import oracle.bpm.project.io.bpmn.jaxb.TTask;
import oracle.bpm.project.io.bpmn.jaxb.TText;
import oracle.bpm.project.io.bpmn.jaxb.TTextAnnotation;
import oracle.bpm.project.io.bpmn.jaxb.TThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.TTimerEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TUserTask;
import oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAnnotations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAppCategory;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAppExternalDocument;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAppExternalDocuments;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAppLinkName;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAppTags;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TApplicationInfo;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBaseCorrelationEnabledData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBooleanFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessDataRange;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessRuleTaskData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversation;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversational;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversationalError;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationEnabledData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationItem;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationItems;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationKey;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationKeys;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationPropertyAliasExpressionMode;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TCorrelationPropertyAliasExpressionModeMap;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDailyScheduleEntry;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDataAssignment;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDataObjectType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDefineInterfaceConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDefineInterfaceConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDescription;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TExternalTransformation;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TFeatureSet;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TGraphicsAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.THiddenAnnotations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.THumanTask;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TInputCorrelationEnabledData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TIntegerFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLaneAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalization;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalizedContent;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalizedItemsContainer;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TMessageHeader;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TMessageHeaders;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TMessageHeadersSet;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TMonthlyScheduleEntry;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOptionalTimerEventFeatures;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOracleExtensions;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOutOfCalendarPolicy;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOutputCorrelationEnabledData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TPosition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TProcessCallConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TProcessCallConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TProperty;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TRescheduleRestrictionsPolicy;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TSchedule;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TSequenceFlowAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TServiceCallConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TServiceCallConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TSize;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TStringFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TTypeRef;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TUseInterfaceConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TUseInterfaceConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TUserAnnotations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TWeeklyScheduleEntry;
import oracle.bpm.project.io.serializers.model.bpmn.BPMNVersionParser;
import oracle.bpm.project.io.serializers.model.bpmn.IoUtils;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.DailySchedule;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectVisitorAdapter;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.WeeklySchedule;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.FaultObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.catalog.SystemFaultObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.CorrelationItemsFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IncludesStoredI18n;
import oracle.bpm.project.model.features.InputCorrelationItemsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.OutputCorrelationItemsFeature;
import oracle.bpm.project.model.features.OutputDataAssociationFeature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ApplicationInfo;
import oracle.bpm.project.model.processes.ArgumentsEnabled;
import oracle.bpm.project.model.processes.Artifact;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.CheckedEventTriggerAdapter;
import oracle.bpm.project.model.processes.CheckedFlowNodeAdapter;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.ExternalDocument;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OperationReferenceExtended;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.DefineInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemRef;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.project.model.processes.messageheaders.InputMessageHeadersEnabled;
import oracle.bpm.project.model.processes.messageheaders.MessageHeader;
import oracle.bpm.project.model.processes.messageheaders.MessageHeaderSet;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import oracle.bpm.project.model.processes.messageheaders.OutputMessageHeadersEnabled;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.project.model.processes.serviceproperties.InputServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.OutputServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.conversation.ProcessCallConversationDefinitionImpl;
import oracle.bpm.project.process.conversation.ServiceCallConversationDefinitionImpl;
import oracle.bpm.project.process.conversation.UseInterfaceConversationDefinitionImpl;
import oracle.bpm.project.process.conversational.DefineInterfaceConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.ProcessCallConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.ServiceCallConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.UseInterfaceConversationalDefinitionImpl;
import oracle.bpm.project.process.notification.NotificationOperationRefFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessVisitorBPMN
extends ProjectVisitorAdapter {
    private List<JAXBElement<? extends TArtifact>> currentArtifactList;
    private List<JAXBElement<? extends TFlowElement>> currentElementList;
    private TFeatureSet currentFeatureSet;
    private TDefinitions definitions;
    private ObjectFactory extensionsFactory = new ObjectFactory();
    private oracle.bpm.project.io.bpmn.jaxb.ObjectFactory objectFactory = new oracle.bpm.project.io.bpmn.jaxb.ObjectFactory();
    private TProcess tProcess;
    private static final String BPMN_NS = "http://www.omg.org/spec/BPMN/20100524/MODEL";

    public JAXBElement<TDefinitions> getDefinitions() {
        return this.objectFactory.createDefinitions(this.definitions);
    }

    @Override
    public void visit(Process process) throws ProjectException {
        this.definitions = this.objectFactory.createTDefinitions();
        this.tProcess = this.objectFactory.createTProcess();
        this.tProcess.setId(process.getId());
        this.tProcess.setName(process.getDefaultLabel());
        this.tProcess.setProcessType(TProcessType.PUBLIC);
        this.tProcess.setIsExecutable(true);
        this.addLanes(process);
        this.currentElementList = this.tProcess.getFlowElement();
        this.currentArtifactList = this.tProcess.getArtifact();
        this.visitNodeContainer(process, this.tProcess);
        this.fillOracleExtensions(process);
        this.fillProcessIoSpecification(process);
        this.definitions.getRootElement().add(this.objectFactory.createProcess(this.tProcess));
        Map<QName, String> otherAttributes = this.definitions.getOtherAttributes();
        otherAttributes.put(new QName(BPMNVersionParser.VERSION_ATTRIBUTE), Id.getAbsoluteVersion());
        otherAttributes.put(new QName(BPMNVersionParser.REVISION_ATTRIBUTE), "20120217");
    }

    @Override
    public void visit(Activity activity) throws ProjectException {
        PersistenceFlowNodeHandler persistenceFlowNodeHandler = new PersistenceFlowNodeHandler(this.currentElementList);
        ModelUtils.handleFlowNodeChecked(activity, persistenceFlowNodeHandler);
        TActivity tActivity = persistenceFlowNodeHandler.getActivityRef();
        if (tActivity != null) {
            this.fillActivityAttributes(tActivity, activity);
            this.fillOracleExtensions(tActivity, activity);
            this.fillActivityIoSpecification(tActivity, activity);
            this.fillCorrelationData(tActivity, activity);
        }
    }

    @Override
    public void visit(Event event) throws ProjectException {
        PersistenceFlowNodeHandler persistenceFlowNodeHandler = new PersistenceFlowNodeHandler(this.currentElementList);
        ModelUtils.handleFlowNodeChecked(event, persistenceFlowNodeHandler);
        TEvent tEvent = persistenceFlowNodeHandler.getEventRef();
        if (tEvent != null) {
            this.fillEventAttributes(tEvent, event);
            this.fillOracleExtensions(tEvent, event);
            this.fillEventTrigger(tEvent, event);
            this.fillCorrelationData(tEvent, event);
        }
    }

    @Override
    public void visit(BoundaryEvent boundaryEvent) throws ProjectException {
        this.visit((Event)boundaryEvent);
    }

    @Override
    public void visit(Gateway gateway) throws ProjectException {
        PersistenceFlowNodeHandler persistenceFlowNodeHandler = new PersistenceFlowNodeHandler(this.currentElementList);
        ModelUtils.handleFlowNodeChecked(gateway, persistenceFlowNodeHandler);
        TGateway tGateway = persistenceFlowNodeHandler.getGatewayRef();
        if (tGateway != null) {
            this.fillGatewayAttributes(tGateway, gateway);
            this.fillOracleExtensions(tGateway, gateway);
        }
    }

    @Override
    public void visit(SequenceFlow sequenceFlow) throws ProjectException {
        TSequenceFlow tSequenceflow = this.objectFactory.createTSequenceFlow();
        this.fillSequenceFlowAttributes(tSequenceflow, sequenceFlow);
        if (sequenceFlow.isConditionalFlow()) {
            Expression expression = sequenceFlow.toConditionalFlow().getCondition();
            tSequenceflow.setConditionExpression(this.createExtendedTFormalExpression(expression));
        }
        this.fillOracleExtensions(tSequenceflow, sequenceFlow);
        this.currentElementList.add(this.objectFactory.createSequenceFlow(tSequenceflow));
    }

    @Override
    public void visitFeature(Feature feature) throws ProjectException {
        block3: {
            block2: {
                Object value;
                block6: {
                    block5: {
                        block4: {
                            if (feature.isSet()) break block2;
                            if (!(feature instanceof PersistentFeature) || !((PersistentFeature)feature).mustBeSaved()) break block3;
                            value = feature.getValue();
                            if (!(value instanceof Expression)) break block4;
                            this.addExpressionExtension(feature.getName(), (Expression)value);
                            break block3;
                        }
                        if (!(value instanceof Integer)) break block5;
                        this.addIntegerExtension(feature.getName(), ((Integer)value).longValue());
                        break block3;
                    }
                    if (!(value instanceof Boolean)) break block6;
                    this.addBooleanExtension(feature.getName(), (Boolean)value);
                    break block3;
                }
                if (value == null) break block3;
                this.addStringExtension(feature.getName(), value.toString());
                break block3;
            }
            FeatureSet set = (FeatureSet)feature;
            if (set.mustBeSaved()) {
                for (Feature f : set.getFeatures()) {
                    if (!(f instanceof PersistentFeature)) continue;
                    f.visit(this);
                }
            }
        }
    }

    private TFlowElement createTBaseElementRef(FlowNode source) {
        TScriptTask result = this.objectFactory.createTScriptTask();
        result.setId(source.getId());
        return result;
    }

    private void fillCorrelationData(@NotNull TFlowNode tFlowNode, @NotNull FlowNode flowNode) {
        if (CorrelationsEnabled.class.isAssignableFrom(flowNode.getClass())) {
            CorrelationsEnabled correlationsEnabledNode = (CorrelationsEnabled)flowNode;
            if (correlationsEnabledNode.isInputCorrelationsEnabled()) {
                this.fillInputCorrelationData(tFlowNode, flowNode);
            }
            if (correlationsEnabledNode.isOutputArgumentsEnabled()) {
                this.fillOutputCorrelationData(tFlowNode, flowNode);
            }
        }
    }

    private void fillInputCorrelationData(@NotNull TFlowNode tFlowNode, @NotNull FlowNode flowNode) {
        InputCorrelationItemsFeature inputCorrelation = flowNode.getFeature(InputCorrelationItemsFeature.class);
        if (inputCorrelation != null) {
            TInputCorrelationEnabledData tInputCorrelationEnabledData = this.extensionsFactory.createTInputCorrelationEnabledData();
            this.fillBaseCorrelationData(tFlowNode, tInputCorrelationEnabledData, inputCorrelation);
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFlowNode);
            TCorrelationEnabledData tCorrelationEnabledData = tOracleExtensions.getCorrelationEnabledData();
            if (tCorrelationEnabledData != null && tInputCorrelationEnabledData.getCorrelationItems() != null) {
                tCorrelationEnabledData.setInputCorrelationEnabledData(tInputCorrelationEnabledData);
            }
        }
    }

    private void fillOutputCorrelationData(@NotNull TFlowNode tFlowNode, @NotNull FlowNode flowNode) {
        OutputCorrelationItemsFeature outputCorrelation = flowNode.getFeature(OutputCorrelationItemsFeature.class);
        if (outputCorrelation != null) {
            TOutputCorrelationEnabledData tOutputCorrelationEnabledData = this.extensionsFactory.createTOutputCorrelationEnabledData();
            this.fillBaseCorrelationData(tFlowNode, tOutputCorrelationEnabledData, outputCorrelation);
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFlowNode);
            TCorrelationEnabledData tCorrelationEnabledData = tOracleExtensions.getCorrelationEnabledData();
            if (tCorrelationEnabledData != null && tOutputCorrelationEnabledData.getCorrelationItems() != null) {
                tCorrelationEnabledData.setOutputCorrelationEnabledData(tOutputCorrelationEnabledData);
            }
        }
    }

    private void fillBaseCorrelationData(@NotNull TFlowNode tFlowNode, @NotNull TBaseCorrelationEnabledData tBaseCorrelationEnabledData, @NotNull CorrelationItemsFeature correlationItemsFeature) {
        CorrelationItemsContainer itemsContainer = correlationItemsFeature.getValue();
        Sequence<CorrelationItem> itemSequence = itemsContainer.getCorrelationItems();
        if (!itemSequence.isEmpty()) {
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFlowNode);
            TCorrelationEnabledData tCorrelationEnabledData = tOracleExtensions.getCorrelationEnabledData();
            if (tCorrelationEnabledData == null) {
                tCorrelationEnabledData = this.extensionsFactory.createTCorrelationEnabledData();
                tOracleExtensions.setCorrelationEnabledData(tCorrelationEnabledData);
            }
            TCorrelationItems tCorrelationItems = this.extensionsFactory.createTCorrelationItems();
            tBaseCorrelationEnabledData.setCorrelationItems(tCorrelationItems);
            for (CorrelationItem item : itemSequence) {
                TCorrelationItem tCorrelationItem = this.extensionsFactory.createTCorrelationItem();
                tCorrelationItem.setCorrelationKeyName(item.getCorrelationKey().getId());
                tCorrelationItem.setInitiates(item.initiates());
                tCorrelationItems.getCorrelationItem().add(tCorrelationItem);
            }
        }
    }

    private void visitFlowElements(NodeContainer nodeContainer) throws ProjectException {
        this.visitActivities(nodeContainer);
        this.visitEvents(nodeContainer);
        this.visitBoundaryEvents(nodeContainer);
        this.visitGateways(nodeContainer);
        this.visitSequenceFlows(nodeContainer);
        this.visitDataObjects(nodeContainer);
    }

    private void visitArtifacts(NodeContainer nodeContainer) throws ProjectException {
        this.visitMeasurementMarks(nodeContainer);
        this.visitCounters(nodeContainer);
        this.visitTextAnnotations(nodeContainer);
    }

    private void visitTextAnnotations(NodeContainer nodeContainer) throws ProjectException {
        for (TextAnnotation textAnnotation : nodeContainer.getTextAnnotations()) {
            TTextAnnotation tTextAnnotation = this.objectFactory.createTTextAnnotation();
            TText tText = this.objectFactory.createTText();
            tText.getContent().add(textAnnotation.getDefaultLabel());
            tTextAnnotation.setId(textAnnotation.getId());
            tTextAnnotation.setText(tText);
            this.fillOracleExtensions(tTextAnnotation, textAnnotation);
            this.currentArtifactList.add(this.objectFactory.createArtifact(tTextAnnotation));
        }
    }

    private void visitMeasurementMarks(NodeContainer nodeContainer) throws ProjectException {
        for (Measurement measurement : nodeContainer.getMeasurements()) {
            TMeasurementMark tMeasurementMark = this.objectFactory.createTMeasurementMark();
            tMeasurementMark.setId(measurement.getId());
            this.fillOracleExtensions(tMeasurementMark, measurement);
            if (measurement.getMeasurementType() != MeasurementType.STOP) {
                this.fillBusinessIndicators(tMeasurementMark, measurement.getBusinessIndicators());
            }
            this.currentArtifactList.add(this.objectFactory.createArtifact(tMeasurementMark));
        }
    }

    private void fillBusinessIndicators(TArtifact artifact, Sequence<ProjectDataObject> businessIndicators) {
        TExtensionElements extensionElements = this.getOrCreateExtensionsFor(artifact);
        TBusinessIndicators tBusinessIndicators = this.objectFactory.createTBusinessIndicators();
        for (ProjectDataObject businessIndicator : businessIndicators) {
            TBusinessIndicator tBusinessIndicator = this.objectFactory.createTBusinessIndicator();
            tBusinessIndicator.setId(businessIndicator.getId());
            tBusinessIndicators.getBusinessIndicator().add(tBusinessIndicator);
        }
        extensionElements.getAny().add(this.objectFactory.createBusinessIndicators(tBusinessIndicators));
    }

    private void visitCounters(NodeContainer nodeContainer) throws ProjectException {
        for (Counter counter : nodeContainer.getCounters()) {
            TCounter tCounter = this.objectFactory.createTCounter();
            tCounter.setId(counter.getId());
            this.fillOracleExtensions(tCounter, counter);
            this.fillBusinessIndicators(tCounter, counter.getBusinessIndicators());
            this.currentArtifactList.add(this.objectFactory.createArtifact(tCounter));
        }
    }

    private void visitDataObjects(DataDeclarationContainer container) {
        Sequence<DataObject> dataObjects = container.getLocalDeclarations(DataObject.class);
        for (DataObject dataObject : dataObjects) {
            TDataObject tDataObject = this.createTDataObject(dataObject);
            this.currentElementList.add(this.objectFactory.createDataObject(tDataObject));
        }
    }

    private TDataObject createTDataObject(DataObject dataObject) {
        ProjectDataObject projectDataObject;
        TDataObject tDataObject = this.objectFactory.createTDataObject();
        tDataObject.setId(dataObject.getId());
        tDataObject.setName(dataObject.getId());
        TOracleExtensions extensions = this.getOrCreateOracleExtensionsFor(tDataObject);
        TDataObjectType dataObjectType = this.extensionsFactory.createTDataObjectType();
        CatalogType type = dataObject.getType();
        dataObjectType.setTypeRef(this.createTTypeRef(type));
        dataObjectType.setInitialize(dataObject.isInitialize());
        if (dataObject instanceof ProjectDataObject && (projectDataObject = (ProjectDataObject)dataObject).isBusiness()) {
            TBusinessAttributes tBussinesAttributes = this.extensionsFactory.createTBusinessAttributes();
            BusinessVariableType businessVariableType = projectDataObject.getBusinessVariableType();
            tBussinesAttributes.setType(businessVariableType.name());
            BusinessVariableData variableData = projectDataObject.getBusinessVariableData();
            if (variableData != null && !variableData.isEmpty()) {
                try {
                    BusinessVariableData.Range[] ranges;
                    List<TBusinessDataRange> tBusinessDataRangeList = tBussinesAttributes.getBusinessDataRange();
                    for (BusinessVariableData.Range range : ranges = variableData.getRange()) {
                        TBusinessDataRange tBusinessDataRange = this.extensionsFactory.createTBusinessDataRange();
                        tBusinessDataRange.setName(range.getName());
                        tBusinessDataRange.setStart(range.getStart());
                        tBusinessDataRange.setFinish(range.getFinish());
                        tBusinessDataRangeList.add(tBusinessDataRange);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            dataObjectType.setBusinessAttributes(tBussinesAttributes);
        }
        extensions.setDataObjectType(dataObjectType);
        return tDataObject;
    }

    private TTypeRef createTTypeRef(@NotNull CatalogType catalogType) {
        TypeDescription type;
        TypeDescription td = catalogType.getDelegate();
        boolean isArray = catalogType.isArray();
        TTypeRef tTypeRef = new TTypeRef();
        TypeDescription typeDescription = type = isArray ? td.getElementType() : td;
        if (!type.isUnknown() && type.getErrors().isEmpty()) {
            if (type.isSchemaObject()) {
                SchemaObject schemaObject = type.asSchemaObject();
                tTypeRef.setNamespace(schemaObject.getNamespace());
                switch (schemaObject.getXmlElementType()) {
                    case TYPE: {
                        tTypeRef.setType(schemaObject.getName());
                        break;
                    }
                    case ELEMENT: {
                        tTypeRef.setElement(schemaObject.getName());
                        break;
                    }
                    case FAULT: {
                        tTypeRef.setFault(schemaObject.getName());
                        assert (catalogType instanceof FaultObject);
                        FaultObject errorObject = (FaultObject)catalogType;
                        QName message = errorObject.getMessageQName();
                        if (message == null) break;
                        tTypeRef.setMessageNamespace(message.getNamespaceURI());
                        tTypeRef.setMessage(message.getLocalPart());
                    }
                }
            } else if (catalogType instanceof SystemFaultObject) {
                SystemFaultObject fault = (SystemFaultObject)catalogType;
                QName errorCode = fault.getErrorCode();
                tTypeRef.setNamespace(errorCode.getNamespaceURI());
                tTypeRef.setType(errorCode.getLocalPart());
            }
        } else {
            tTypeRef.setNamespace(type.get().getName());
        }
        tTypeRef.setIsArray(isArray);
        return tTypeRef;
    }

    private void fillActivityIoSpecification(TActivity tActivity, Activity activity) throws ProjectException {
        if (this.hasIoSpecification(activity)) {
            OutputArgumentsEnabled outputArgumentEnabled;
            InputArgumentsEnabled inputArgumentEnabled;
            TInputOutputSpecification tInputOutputSpecification = this.objectFactory.createTInputOutputSpecification();
            InputDataAssociationFeature inputDataAssociationFeature = activity.getFeature(InputDataAssociationFeature.class);
            OutputDataAssociationFeature outputDataAssociationFeature = activity.getFeature(OutputDataAssociationFeature.class);
            ArgumentsEnabled argumentsEnabled = (ArgumentsEnabled)((Object)activity);
            InputArgumentsEnabled inputArgumentsEnabled = inputArgumentEnabled = argumentsEnabled.isInputArgumentsEnabled() ? (InputArgumentsEnabled)argumentsEnabled : null;
            if (inputArgumentEnabled != null) {
                this.createDataInputs(activity, inputArgumentEnabled.getInputArgumentsContainer().getDeclarations(), tInputOutputSpecification.getDataInput(), tInputOutputSpecification.getInputSet(), null);
            }
            this.createInputDataAssociations(activity, inputDataAssociationFeature, tActivity);
            OutputArgumentsEnabled outputArgumentsEnabled = outputArgumentEnabled = argumentsEnabled.isOutputArgumentsEnabled() ? (OutputArgumentsEnabled)argumentsEnabled : null;
            if (outputArgumentEnabled != null) {
                this.createDataOutputs(activity, outputArgumentEnabled.getOutputArgumentsContainer().getDeclarations(), tInputOutputSpecification.getDataOutput(), tInputOutputSpecification.getOutputSet(), null);
            }
            this.createOutDataAssociations(activity, outputDataAssociationFeature, tActivity);
            tActivity.setIoSpecification(tInputOutputSpecification);
        }
    }

    private void fillProcessIoSpecification(Process process) throws ProjectException {
        if (process.isCallableSubprocess()) {
            TInputOutputSpecification tInputOutputSpecification = this.objectFactory.createTInputOutputSpecification();
            DataDeclarationContainer inputContainer = process.getInputArgumentsContainer();
            this.createDataInputs(process, inputContainer.getDeclarations(), tInputOutputSpecification.getDataInput(), tInputOutputSpecification.getInputSet(), null);
            DataDeclarationContainer outputContainer = process.getOutputArgumentsContainer();
            this.createDataOutputs(process, outputContainer.getDeclarations(), tInputOutputSpecification.getDataOutput(), tInputOutputSpecification.getOutputSet(), null);
            this.tProcess.setIoSpecification(tInputOutputSpecification);
        }
    }

    private void fillEventTrigger(TEvent tEvent, Event event) throws ProjectException {
        if (event.getEventDefinition() != null || event.getEventTriggerType() == EventTriggerType.NONE) {
            ModelUtils.handleEventTriggerChecked(event, new PersistenceEventDefinitionHandler(tEvent));
        }
    }

    private boolean hasIoSpecification(FlowElement flowElement) {
        return this.hasInputDataAssociation(flowElement) || this.hasOutputDataAssociation(flowElement);
    }

    private boolean hasOutputDataAssociation(FlowElement flowElement) {
        return flowElement.getFeature(OutputDataAssociationFeature.class) != null;
    }

    private boolean hasInputDataAssociation(FlowElement flowElement) {
        return flowElement.getFeature(InputDataAssociationFeature.class) != null;
    }

    private void createInputDataAssociations(ProjectObject projectObject, InputDataAssociationFeature inputDataAssociationFeature, TBaseElement tBaseElement) throws ProjectException {
        if (inputDataAssociationFeature != null) {
            List<TDataInputAssociation> tDataInputAssociations;
            if (tBaseElement instanceof TActivity) {
                tDataInputAssociations = ((TActivity)tBaseElement).getDataInputAssociation();
            } else if (tBaseElement instanceof TThrowEvent) {
                tDataInputAssociations = ((TThrowEvent)tBaseElement).getDataInputAssociation();
            } else {
                throw new ProjectException(projectObject, CoreMsg.ERROR_MSG("invalid type with no dataInputAssociations"));
            }
            DataAssociationSet dataAssociationSet = inputDataAssociationFeature.getDataAssociationSet(false);
            DataAssociationSet draftDataAssociationSet = inputDataAssociationFeature.getDataAssociationSet(true);
            this.fillTDataInputAssociation(tDataInputAssociations, dataAssociationSet, false);
            this.fillTDataInputAssociation(tDataInputAssociations, draftDataAssociationSet, true);
        }
    }

    private void fillTDataInputAssociation(@NotNull List<TDataInputAssociation> tDataInputAssociations, @NotNull DataAssociationSet inputDataAssociationSet, boolean draft) {
        TDataAssociation tDataInputAssociation = null;
        for (DataAssociation dataAssociation : inputDataAssociationSet.getDataAssociations()) {
            boolean mustCreateDataInputAssociation;
            String targetRefId = this.getTargetRef(dataAssociation);
            TBaseElement targetRef = tDataInputAssociation != null ? (TBaseElement)tDataInputAssociation.getTargetRef() : null;
            boolean bl = mustCreateDataInputAssociation = dataAssociation.isDataTransformation() || targetRef == null || !Any.equals(targetRefId, targetRef.getId());
            if (mustCreateDataInputAssociation) {
                tDataInputAssociation = this.objectFactory.createTDataInputAssociation();
                if (targetRefId != null) {
                    TDataInput tTarget = this.objectFactory.createTDataInput();
                    tTarget.setId(targetRefId);
                    tDataInputAssociation.setTargetRef(tTarget);
                }
                if (draft) {
                    TOracleExtensions dataInputAssociationExtension = this.getOrCreateOracleExtensionsFor(tDataInputAssociation);
                    oracle.bpm.project.io.bpmn.jaxb.extensions.TDataAssociation tDataAssociationExtension = this.extensionsFactory.createTDataAssociation();
                    tDataAssociationExtension.setDraft(draft);
                    dataInputAssociationExtension.setDataAssociation(tDataAssociationExtension);
                }
                tDataInputAssociations.add((TDataInputAssociation)tDataInputAssociation);
            }
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = dataAssociation.as(DataAssignment.class);
                this.setTDataAssociationValues(tDataInputAssociation, dataAssignment);
                continue;
            }
            if (!dataAssociation.isDataTransformation()) continue;
            DataTransformation dataTransformation = dataAssociation.as(DataTransformation.class);
            this.setTDataAssociationValues(tDataInputAssociation, dataTransformation);
        }
    }

    private String getTargetRef(@NotNull DataAssociation dataAssociation) {
        String result = null;
        if (dataAssociation.isDataAssignment()) {
            DataAssignment dataAssignment = dataAssociation.as(DataAssignment.class);
            Sequence<String> targetRefs = dataAssignment.getTarget().getRefs();
            if (!targetRefs.isEmpty()) {
                result = targetRefs.iterator().next();
            }
        } else if (dataAssociation.isDataTransformation()) {
            DataTransformation dataTransformation = dataAssociation.as(DataTransformation.class);
            result = dataTransformation.getTargetRef();
        }
        return result;
    }

    private void createDataInputs(ProjectObject projectObject, Sequence<DataDeclaration> inputArguments, List<TDataInput> tDataInputs, List<TInputSet> tInputSets, TInputSet tInputSet) {
        if (inputArguments != null && !inputArguments.isEmpty()) {
            List<JAXBElement<Object>> inputRefs;
            String id = projectObject.getId() + "_uniqueInputSet";
            if (tInputSet == null) {
                TInputSet uniqueInputSet = this.objectFactory.createTInputSet();
                inputRefs = uniqueInputSet.getDataInputRefs();
                uniqueInputSet.setId(id);
                tInputSets.add(uniqueInputSet);
            } else {
                inputRefs = tInputSet.getDataInputRefs();
                tInputSet.setId(id);
            }
            for (DataDeclaration inputArgument : inputArguments) {
                TDataInput tDataInput = this.objectFactory.createTDataInput();
                tDataInput.setId(inputArgument.getName());
                tDataInput.setName(inputArgument.getName());
                TOracleExtensions extensions = this.getOrCreateOracleExtensionsFor(tDataInput);
                extensions.setTypeRef(this.createTTypeRef(inputArgument.getType()));
                tDataInputs.add(tDataInput);
                JAXBElement<Object> tInputRef = this.objectFactory.createTInputSetDataInputRefs(tDataInput);
                inputRefs.add(tInputRef);
            }
        }
    }

    private void setTDataAssociationValues(TDataAssociation tDataAssociation, DataAssignment dataAssignment) {
        DataAssignmentItem sourceItem = dataAssignment.getSource();
        DataAssignmentItem targetItem = dataAssignment.getTarget();
        TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tDataAssociation);
        List<String> otherRefs = tOracleExtensions.getOtherRef();
        for (DataAssignmentItemRef ref : sourceItem.getDataAssignmentItemRefs()) {
            String refId = ref.getRef();
            if (!ref.isOtherRef()) {
                TDataInput tDataInput = this.objectFactory.createTDataInput();
                tDataInput.setId(refId);
                JAXBElement<Object> tDataAssociationSourceRef = this.objectFactory.createTDataAssociationSourceRef(tDataInput);
                if (this.listContainsRef(tDataAssociation.getSourceRef(), refId)) continue;
                tDataAssociation.getSourceRef().add(tDataAssociationSourceRef);
                continue;
            }
            if (otherRefs.contains(refId)) continue;
            otherRefs.add(refId);
        }
        for (DataAssignmentItemRef ref : targetItem.getDataAssignmentItemRefs()) {
            if (!ref.isOtherRef() || otherRefs.contains(ref.getRef())) continue;
            otherRefs.add(ref.getRef());
        }
        TAssignment tAssignment = this.createTAssignment(sourceItem, targetItem);
        tDataAssociation.getAssignment().add(tAssignment);
        TOracleExtensions assignmentExtensions = this.getOrCreateOracleExtensionsFor(tAssignment);
        TDataAssignment assignmentExtension = this.extensionsFactory.createTDataAssignment();
        assignmentExtensions.setDataAssignment(assignmentExtension);
        String operationId = dataAssignment.getOperation().getId();
        assignmentExtension.setOperation(operationId);
    }

    private void setTDataAssociationValues(TDataAssociation tDataAssociation, DataTransformation dataTransformation) {
        Sequence<String> sourceRefs = dataTransformation.getSourceRefs();
        for (String sourceRefId : sourceRefs) {
            TDataInput tDataInput = this.objectFactory.createTDataInput();
            tDataInput.setId(sourceRefId);
            JAXBElement<Object> tDataAssociationSourceRef = this.objectFactory.createTDataAssociationSourceRef(tDataInput);
            if (this.listContainsRef(tDataAssociation.getSourceRef(), sourceRefId)) continue;
            tDataAssociation.getSourceRef().add(tDataAssociationSourceRef);
        }
        TFormalExpression transformation = this.createTransformation(dataTransformation.getTransformationName());
        tDataAssociation.setTransformation(transformation);
    }

    private boolean listContainsRef(@NotNull List<JAXBElement<Object>> list, @NotNull String refId) {
        for (JAXBElement<Object> objectJAXBElement : list) {
            TBaseElement tBaseElement;
            Object object = objectJAXBElement.getValue();
            if (!(object instanceof TBaseElement) || !refId.equals((tBaseElement = (TBaseElement)object).getId())) continue;
            return true;
        }
        return false;
    }

    private TAssignment createTAssignment(@NotNull DataAssignmentItem sourceItem, @NotNull DataAssignmentItem targetItem) {
        TAssignment tAssignment = this.objectFactory.createTAssignment();
        Expression sourceExpression = sourceItem.getExpression();
        Expression targetExpression = targetItem.getExpression();
        TFormalExpression tFrom = this.createExtendedTFormalExpression(sourceExpression);
        tAssignment.setFrom(tFrom);
        TFormalExpression tTo = this.createExtendedTFormalExpression(targetExpression);
        tAssignment.setTo(tTo);
        return tAssignment;
    }

    private TAttributeExpression createTAttributeExpression(String attName, Expression expression) {
        TAttributeExpression tAttributeExpression = this.objectFactory.createTAttributeExpression();
        tAttributeExpression.setAttributeName(attName);
        this.fillFormalExpression(tAttributeExpression, expression);
        this.fillExtendedTFormalExpression(expression, tAttributeExpression);
        return tAttributeExpression;
    }

    private TFormalExpression createTFormalExpression(Expression expression) {
        TFormalExpression tFormalExpression = this.objectFactory.createTFormalExpression();
        this.fillFormalExpression(tFormalExpression, expression);
        return tFormalExpression;
    }

    private void fillFormalExpression(TFormalExpression tFormalExpression, Expression expression) {
        if (expression != null) {
            tFormalExpression.getContent().add((Serializable)((Object)expression.getExpressionValue()));
            tFormalExpression.setLanguage(expression.getLanguage().getId());
            Map namespaces = expression.getNamespaces();
            Map<QName, String> otherAtts = tFormalExpression.getOtherAttributes();
            for (String key : namespaces.keySet()) {
                URI uri = (URI)namespaces.get(key);
                otherAtts.put(this.createQNameFor(key, "http://xmlns.oracle.com/bpm/XPathNamespace"), uri.toString());
            }
        }
    }

    private TFormalExpression createExtendedTFormalExpression(@Nullable Expression expression) {
        TFormalExpression tFormalExpression = this.createTFormalExpression(expression);
        this.fillExtendedTFormalExpression(expression, tFormalExpression);
        return tFormalExpression;
    }

    private void fillExtendedTFormalExpression(@Nullable Expression expression, @NotNull TFormalExpression tFormalExpression) {
        if (expression != null) {
            InvalidExpression invalidExpression;
            String invalidExpressionString;
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFormalExpression);
            TExpression tExpressionExtension = this.extensionsFactory.createTExpression();
            tExpressionExtension.setMode(expression.getMode().getId());
            if (expression.isInvalidExpression() && !Str.isEmpty(invalidExpressionString = (invalidExpression = expression.asInvalidExpression()).getInvalidExpressionString())) {
                tExpressionExtension.setInvalidExpressionString(invalidExpressionString);
            }
            tOracleExtensions.setExpression(tExpressionExtension);
        }
    }

    private Tuple<String, String> getParticipantAndOperation(@NotNull Conversational conversational) {
        Tuple<String, String> result = null;
        ProjectObject participant = null;
        ProjectObject operation = null;
        Conversation conversation = conversational.getConversation();
        if (conversation != null) {
            ConversationType conversationType = conversation.getConversationType();
            if (conversationType == ConversationType.SERVICE_CALL) {
                ServiceCallConversationalDefinition definition = conversational.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                participant = definition.getService();
                operation = definition.getOperation();
            } else if (conversationType == ConversationType.USE_INTERFACE) {
                UseInterfaceConversationalDefinition definition = conversational.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                participant = definition.getReference();
                operation = definition.getOperation();
            }
        }
        if (participant != null && operation != null) {
            result = Tuple.create(participant.getId(), operation.getId());
        }
        return result;
    }

    private TFormalExpression createTransformation(@Nullable String transformationName) {
        TFormalExpression transformation = this.objectFactory.createTFormalExpression();
        transformation.setLanguage("xsl");
        TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(transformation);
        TExternalTransformation tExternalTransformation = this.extensionsFactory.createTExternalTransformation();
        String transformationFileName = null;
        if (!Str.isEmpty(transformationName)) {
            transformationFileName = transformationName + ".xsl";
        }
        tExternalTransformation.setResource(transformationFileName);
        tOracleExtensions.setExternalTransformation(tExternalTransformation);
        return transformation;
    }

    private void createOutDataAssociations(ProjectObject flowNode, OutputDataAssociationFeature outputDataAssociationFeature, TBaseElement tBaseElement) throws ProjectException {
        if (outputDataAssociationFeature != null) {
            List<TDataOutputAssociation> tDataOutputAssociations;
            if (tBaseElement instanceof TActivity) {
                tDataOutputAssociations = ((TActivity)tBaseElement).getDataOutputAssociation();
            } else if (tBaseElement instanceof TCatchEvent) {
                tDataOutputAssociations = ((TCatchEvent)tBaseElement).getDataOutputAssociation();
            } else {
                throw new ProjectException(flowNode, CoreMsg.ERROR_MSG("invalid type with no dataOutputAssociations"));
            }
            DataAssociationSet dataAssociationSet = outputDataAssociationFeature.getDataAssociationSet(false);
            DataAssociationSet draftDataAssociationSet = outputDataAssociationFeature.getDataAssociationSet(true);
            this.fillTDataOutputAssociation(tDataOutputAssociations, dataAssociationSet, false);
            this.fillTDataOutputAssociation(tDataOutputAssociations, draftDataAssociationSet, true);
        }
    }

    private void fillTDataOutputAssociation(@NotNull List<TDataOutputAssociation> tDataOutputAssociations, @NotNull DataAssociationSet outputDataAssociationSet, boolean draft) {
        TDataAssociation dataOutputAssociation = null;
        for (DataAssociation dataAssociation : outputDataAssociationSet.getDataAssociations()) {
            boolean mustCreateDataInputAssociation;
            String targetRefId = this.getTargetRef(dataAssociation);
            TBaseElement targetRef = dataOutputAssociation != null ? (TBaseElement)dataOutputAssociation.getTargetRef() : null;
            boolean bl = mustCreateDataInputAssociation = dataAssociation.isDataTransformation() || targetRef == null || !Any.equals(targetRefId, targetRef.getId());
            if (mustCreateDataInputAssociation) {
                dataOutputAssociation = this.objectFactory.createTDataOutputAssociation();
                if (targetRefId != null) {
                    TDataOutput tTarget = this.objectFactory.createTDataOutput();
                    tTarget.setId(targetRefId);
                    dataOutputAssociation.setTargetRef(tTarget);
                }
                if (draft) {
                    TOracleExtensions dataOutputAssociationExtension = this.getOrCreateOracleExtensionsFor(dataOutputAssociation);
                    oracle.bpm.project.io.bpmn.jaxb.extensions.TDataAssociation tDataAssociationExtension = this.extensionsFactory.createTDataAssociation();
                    tDataAssociationExtension.setDraft(draft);
                    dataOutputAssociationExtension.setDataAssociation(tDataAssociationExtension);
                }
                tDataOutputAssociations.add((TDataOutputAssociation)dataOutputAssociation);
            }
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = dataAssociation.as(DataAssignment.class);
                this.setTDataAssociationValues(dataOutputAssociation, dataAssignment);
                continue;
            }
            if (!dataAssociation.isDataTransformation()) continue;
            DataTransformation dataTransformation = dataAssociation.as(DataTransformation.class);
            this.setTDataAssociationValues(dataOutputAssociation, dataTransformation);
        }
    }

    private void createDataOutputs(ProjectObject projectObject, Sequence<DataDeclaration> outputArguments, List<TDataOutput> tDataOutputs, List<TOutputSet> tOutputSets, TOutputSet tOutputSet) {
        if (outputArguments != null && !outputArguments.isEmpty()) {
            List<JAXBElement<Object>> outputRefs;
            String id = projectObject.getId() + "_uniqueOutputSet";
            if (tOutputSet == null) {
                TOutputSet uniqueOutputSet = this.objectFactory.createTOutputSet();
                outputRefs = uniqueOutputSet.getDataOutputRefs();
                uniqueOutputSet.setId(id);
                tOutputSets.add(uniqueOutputSet);
            } else {
                outputRefs = tOutputSet.getDataOutputRefs();
                tOutputSet.setId(id);
            }
            for (DataDeclaration outputArgument : outputArguments) {
                TDataOutput tDataOutput = this.objectFactory.createTDataOutput();
                tDataOutput.setId(outputArgument.getName());
                tDataOutput.setName(outputArgument.getName());
                TOracleExtensions extensions = this.getOrCreateOracleExtensionsFor(tDataOutput);
                extensions.setTypeRef(this.createTTypeRef(outputArgument.getType()));
                tDataOutputs.add(tDataOutput);
                JAXBElement<Object> tOutputRef = this.objectFactory.createTOutputSetDataOutputRefs(tDataOutput);
                outputRefs.add(tOutputRef);
            }
        }
    }

    private void addLanes(Process process) throws ProjectException {
        TLaneSet tLaneSet = this.objectFactory.createTLaneSet();
        List<TLane> lanes = tLaneSet.getLane();
        for (Lane lane : process.getLanes()) {
            TLane tLane = this.objectFactory.createTLane();
            tLane.setName(lane.getName());
            tLane.setId(lane.getId());
            this.fillOracleExtensions(tLane, lane);
            lanes.add(tLane);
        }
        this.tProcess.getLaneSet().add(tLaneSet);
    }

    private void fillOracleExtensions(TLane tLane, Lane lane) throws ProjectException {
        TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tLane);
        TGraphicsAttributes tGraphicsAttributes = this.generateNodesGraphicalExtension(lane);
        tOracleExtensions.setGraphicsAttributes(tGraphicsAttributes);
        TLaneAttributes laneAttributes = this.extensionsFactory.createTLaneAttributes();
        laneAttributes.setRoleId(lane.getRole());
        tOracleExtensions.setLaneAttributes(laneAttributes);
        tOracleExtensions.setFeatureSet(this.generateFeaturesExtensions(lane.getFeatures()));
    }

    private TExtensionElements getOrCreateExtensionsFor(TBaseElement tElement) {
        TExtensionElements result = IoUtils.findExtensionsIn(tElement);
        if (result == null) {
            result = this.objectFactory.createTExtensionElements();
            tElement.setExtensionElements(result);
        }
        return result;
    }

    private TOracleExtensions getOrCreateOracleExtensionsFor(TBaseElement tElement) {
        TOracleExtensions extensions = IoUtils.findOracleExtensionsIn(tElement);
        if (extensions == null) {
            extensions = this.extensionsFactory.createTOracleExtensions();
            TExtensionElements extensionElements = this.getOrCreateExtensionsFor(tElement);
            extensionElements.getAny().add(this.extensionsFactory.createOracleExtensions(extensions));
        }
        return extensions;
    }

    private TExtensionElements getOrCreateExtensionsFor(TBaseElementWithMixedContent tElement) {
        TExtensionElements result = IoUtils.findExtensionsIn(tElement);
        if (result == null) {
            result = this.objectFactory.createTExtensionElements();
            tElement.getContent().add((Serializable)this.objectFactory.createExtensionElements(result));
        }
        return result;
    }

    private TOracleExtensions getOrCreateOracleExtensionsFor(TBaseElementWithMixedContent element) {
        TOracleExtensions extensions = IoUtils.findOracleExtensionsIn(element);
        if (extensions == null) {
            extensions = this.extensionsFactory.createTOracleExtensions();
            TExtensionElements extensionElements = this.getOrCreateExtensionsFor(element);
            extensionElements.getAny().add(this.extensionsFactory.createOracleExtensions(extensions));
        }
        return extensions;
    }

    private TLocalization createLocalizationFor(Localizable localizable) {
        TLocalization tLocalization = this.extensionsFactory.createTLocalization();
        this.addLocalizationIn(tLocalization, localizable.getLabelMap(), localizable.getDescriptionMap(), localizable.getDocumentationMap(), localizable.getUseCaseDocumentationMap());
        return tLocalization;
    }

    private void addLocalizationIn(TLocalization tLocalization, LocaleStringMap labelMap, LocaleStringMap descriptionMap, LocaleStringMap documentationMap, LocaleStringMap useCaseDocumentationMap) {
        Set<Map.Entry<Locale, String>> entries;
        if (labelMap != null && !(entries = labelMap.entrySet()).isEmpty()) {
            tLocalization.setLabel(this.extensionsFactory.createTLabel());
            this.addLocalizationItems(entries, tLocalization.getLabel());
        }
        if (descriptionMap != null && !(entries = descriptionMap.entrySet()).isEmpty()) {
            tLocalization.setDescription(this.extensionsFactory.createTDescription());
            this.addLocalizationItems(entries, tLocalization.getDescription());
        }
        if (documentationMap != null && !(entries = documentationMap.entrySet()).isEmpty()) {
            tLocalization.setDocumentation(this.extensionsFactory.createTDocumentation());
            this.addLocalizationItems(entries, tLocalization.getDocumentation());
        }
        if (useCaseDocumentationMap != null && !(entries = useCaseDocumentationMap.entrySet()).isEmpty()) {
            tLocalization.setUseCaseDocumentation(this.extensionsFactory.createTUseCaseDocumentation());
            this.addLocalizationItems(entries, tLocalization.getUseCaseDocumentation());
        }
    }

    private void addLocalizationItems(Set<Map.Entry<Locale, String>> entries, TLocalizedItemsContainer tLocalizedItemsContainer) {
        for (Map.Entry<Locale, String> entry : entries) {
            tLocalizedItemsContainer.getLocalizedContent().add(this.createLocalizedContent(entry.getKey(), entry.getValue()));
        }
    }

    private TLocalizedContent createLocalizedContent(Locale locale, String contentValue) {
        TLocalizedContent tLocalizedContent = this.extensionsFactory.createTLocalizedContent();
        tLocalizedContent.setLanguage(locale.toString());
        tLocalizedContent.setContent(contentValue);
        return tLocalizedContent;
    }

    private void createResourceRole(TActivity tActivity, Activity activity) {
        Lane lane = activity.getLane();
        if (lane != null) {
            TResourceRole tResourceRole = new TResourceRole();
            tResourceRole.setId(lane.getId());
            tResourceRole.setName(lane.getName());
            tActivity.getResourceRole().add(this.objectFactory.createResourceRole(tResourceRole));
        }
    }

    private void fillOracleExtensions(@NotNull TFlowElement tFlowElement, @NotNull FlowNode flowNode) throws ProjectException {
        ServicePropertiesEnabled servicePropertiesEnabled;
        TServicePropertiesContainer tServicePropertiesContainer;
        TOracleExtensions extensions = this.getOrCreateOracleExtensionsFor(tFlowElement);
        extensions.setGraphicsAttributes(this.generateNodesGraphicalExtension(flowNode));
        Boolean shouldPersistI18N = flowNode.getProcess().getFeature(IncludesStoredI18n.class).getValue();
        if (shouldPersistI18N.booleanValue()) {
            extensions.setLocalization(this.createLocalizationFor(flowNode));
        }
        extensions.setFeatureSet(this.generateFeaturesExtensions(flowNode.getFeatures()));
        if (flowNode.isServicePropertiesEnabled() && (tServicePropertiesContainer = this.generateServicePropertySets(servicePropertiesEnabled = flowNode.asAnyNode(ServicePropertiesEnabled.class))) != null) {
            extensions.getAny().add(this.objectFactory.createServicePropertiesContainer(tServicePropertiesContainer));
        }
        if (flowNode.isLoggable()) {
            Loggable loggable = flowNode.asAnyNode(Loggable.class);
            TLogHandlers tLogHandlers = this.generateLogHandlers(loggable);
            extensions.getAny().add(this.objectFactory.createLogHandlers(tLogHandlers));
        }
        if (flowNode.isMessageHeadersEnabled()) {
            MessageHeadersEnabled mhe = flowNode.asAnyNode(MessageHeadersEnabled.class);
            TMessageHeaders tMessageHeaders = this.generateMessageHeaders(mhe);
            extensions.setMessageHeaders(tMessageHeaders);
        }
        if (flowNode.isConversational()) {
            Conversational conversational = flowNode.asAnyNode(Conversational.class);
            TConversational tConversational = this.generateConversational(conversational);
            extensions.setConversational(tConversational);
        }
    }

    private TMessageHeaders generateMessageHeaders(@NotNull MessageHeadersEnabled mhe) {
        TMessageHeaders tMessageHeaders = this.extensionsFactory.createTMessageHeaders();
        if (mhe.isInputMessageHeadersEnable()) {
            InputMessageHeadersEnabled inputMessageHeadersEnabled = mhe.asAnyNode(InputMessageHeadersEnabled.class);
            MessageHeaderSet inputMessageHeaderSet = inputMessageHeadersEnabled.getInputMessageHeaderSet();
            TMessageHeadersSet tInputMessageHeadersSet = this.generateMessageHeaderSet(inputMessageHeaderSet);
            tMessageHeaders.setInputMessageHeaderSet(tInputMessageHeadersSet);
        }
        if (mhe.isOutputMessageHeadersEnable()) {
            OutputMessageHeadersEnabled outputMessageHeadersEnabled = mhe.asAnyNode(OutputMessageHeadersEnabled.class);
            MessageHeaderSet outputMessageHeaderSet = outputMessageHeadersEnabled.getOutputMessageHeaderSet();
            TMessageHeadersSet tOutputMessageHeadersSet = this.generateMessageHeaderSet(outputMessageHeaderSet);
            tMessageHeaders.setOutputMessageHeaderSet(tOutputMessageHeadersSet);
        }
        boolean isEmpty = tMessageHeaders.getInputMessageHeaderSet() == null && tMessageHeaders.getOutputMessageHeaderSet() == null;
        return isEmpty ? null : tMessageHeaders;
    }

    private TMessageHeadersSet generateMessageHeaderSet(@NotNull MessageHeaderSet messageHeaderSet) {
        TMessageHeadersSet tMessageHeadersSet = null;
        Sequence<MessageHeader> messageHeaders = messageHeaderSet.getMessageHeaders();
        if (!messageHeaders.isEmpty()) {
            tMessageHeadersSet = this.extensionsFactory.createTMessageHeadersSet();
            List<TMessageHeader> list = tMessageHeadersSet.getMessageHeader();
            for (MessageHeader messageHeader : messageHeaders) {
                TMessageHeader tMessageHeader = this.extensionsFactory.createTMessageHeader();
                tMessageHeader.setDeclarationName(messageHeader.getName());
                list.add(tMessageHeader);
            }
        }
        return tMessageHeadersSet;
    }

    private TConversational generateConversational(@NotNull Conversational conversational) {
        TConversational result = this.extensionsFactory.createTConversational();
        Conversation conversation = conversational.getConversation();
        String conversationId = conversation != null ? conversation.getId() : null;
        result.setConversation(conversationId);
        if (conversation != null) {
            ConversationType conversationType = conversation.getConversationType();
            ConversationalDefinition conversationalDefinition = conversational.getConversationalDefinition();
            if (conversationType == ConversationType.DEFINE_INTERFACE) {
                TDefineInterfaceConversationalDefinition tDefinition = this.extensionsFactory.createTDefineInterfaceConversationalDefinition();
                DefineInterfaceConversationalDefinitionImpl definition = conversationalDefinition.as(DefineInterfaceConversationalDefinitionImpl.class);
                tDefinition.setDefinedOperationName(definition.getDefinedOperationName());
                tDefinition.setReplyTo(definition.getReplyToId());
                ErrorObject error = definition.getError();
                if (error != null) {
                    TConversationalError tConversationalError = this.createTConversationalError(error);
                    tDefinition.setConversationalError(tConversationalError);
                }
                result.setDefineInterfaceConversationalDefinition(tDefinition);
            } else if (conversationType == ConversationType.USE_INTERFACE) {
                TUseInterfaceConversationalDefinition tDefinition = this.extensionsFactory.createTUseInterfaceConversationalDefinition();
                UseInterfaceConversationalDefinitionImpl definition = conversationalDefinition.as(UseInterfaceConversationalDefinitionImpl.class);
                tDefinition.setOperation(definition.getOperationId());
                ErrorObject error = definition.getError();
                if (error != null) {
                    TConversationalError tConversationalError = this.createTConversationalError(error);
                    tDefinition.setConversationalError(tConversationalError);
                }
                result.setUseInterfaceConversationalDefinition(tDefinition);
            } else if (conversationType == ConversationType.PROCESS_CALL) {
                TProcessCallConversationalDefinition tDefinition = this.extensionsFactory.createTProcessCallConversationalDefinition();
                ProcessCallConversationalDefinitionImpl definition = conversationalDefinition.as(ProcessCallConversationalDefinitionImpl.class);
                tDefinition.setTargetConversational(definition.getTargetConversationalId());
                result.setProcessCallConversationalDefinition(tDefinition);
            } else if (conversationType == ConversationType.SERVICE_CALL) {
                TServiceCallConversationalDefinition tDefinition = this.extensionsFactory.createTServiceCallConversationalDefinition();
                ServiceCallConversationalDefinitionImpl definition = conversationalDefinition.as(ServiceCallConversationalDefinitionImpl.class);
                tDefinition.setOperation(definition.getOperationId());
                result.setServiceCallConversationalDefinition(tDefinition);
            }
        }
        return result;
    }

    private TConversationalError createTConversationalError(@NotNull ErrorObject error) {
        String errorId = error.getText();
        TTypeRef tTypeRef = this.createTTypeRef(error);
        TConversationalError tConversationalError = this.extensionsFactory.createTConversationalError();
        tConversationalError.setErrorName(errorId);
        tConversationalError.setTypeRef(tTypeRef);
        return tConversationalError;
    }

    private TLogHandlers generateLogHandlers(@NotNull Loggable loggable) {
        TLogHandlers tLogHandlers = this.objectFactory.createTLogHandlers();
        List<TLogHandler> logHandlerList = tLogHandlers.getLogHandler();
        LogHandlerSet logHandlerSet = loggable.getLogHandlerSet();
        for (LogHandler logHandler : logHandlerSet.getLogHandlers()) {
            TLogHandler tLogHandler = this.objectFactory.createTLogHandler();
            String triggerId = logHandler.getTrigger().getId();
            String levelId = logHandler.getLevel().getId();
            TFormalExpression formalExpression = this.createExtendedTFormalExpression(logHandler.getExpression());
            boolean mustDisplayInAuditTrail = logHandler.mustDisplayInAuditTrail();
            tLogHandler.setTrigger(triggerId);
            tLogHandler.setLevel(levelId);
            tLogHandler.setExpression(formalExpression);
            tLogHandler.setMustDisplayInAuditTrail(mustDisplayInAuditTrail);
            logHandlerList.add(tLogHandler);
        }
        return tLogHandlers;
    }

    @Nullable
    private TServicePropertiesContainer generateServicePropertySets(@NotNull ServicePropertiesEnabled node) {
        OutputServicePropertiesEnabled outputServicePropertiesEnabled;
        TServiceProperties tOutputServiceProperties;
        InputServicePropertiesEnabled inputServicePropertiesEnabled;
        TServiceProperties tInputServiceProperties;
        TServicePropertiesContainer tServicePropertiesContainer = this.objectFactory.createTServicePropertiesContainer();
        boolean hasInputServiceProperties = false;
        boolean hasOutputServiceProperties = false;
        if (node.isInputServicePropertiesEnabled() && (tInputServiceProperties = this.generateInputServiceProperties(inputServicePropertiesEnabled = node.asAnyNode(InputServicePropertiesEnabled.class))) != null) {
            tServicePropertiesContainer.getServiceProperties().add(tInputServiceProperties);
            hasInputServiceProperties = true;
        }
        if (node.isOutputServicePropertiesEnabled() && (tOutputServiceProperties = this.generateOutputServiceProperties(outputServicePropertiesEnabled = node.asAnyNode(OutputServicePropertiesEnabled.class))) != null) {
            tServicePropertiesContainer.getServiceProperties().add(tOutputServiceProperties);
            hasOutputServiceProperties = true;
        }
        return hasInputServiceProperties || hasOutputServiceProperties ? tServicePropertiesContainer : null;
    }

    @Nullable
    private TServiceProperties generateInputServiceProperties(@NotNull InputServicePropertiesEnabled node) {
        ServicePropertySet inputServicePropertySet = node.getInputServicePropertySet();
        TServiceProperties tServiceProperties = this.generateServiceProperties(inputServicePropertySet);
        if (tServiceProperties != null) {
            tServiceProperties.setType("input");
        }
        return tServiceProperties;
    }

    @Nullable
    private TServiceProperties generateOutputServiceProperties(@NotNull OutputServicePropertiesEnabled node) {
        ServicePropertySet set = node.getOutputServicePropertySet();
        TServiceProperties tServiceProperties = this.generateServiceProperties(set);
        if (tServiceProperties != null) {
            tServiceProperties.setType("output");
        }
        return tServiceProperties;
    }

    @Nullable
    private TServiceProperties generateServiceProperties(@NotNull ServicePropertySet servicePropertySet) {
        Sequence<ServiceProperty> serviceProperties;
        TServiceProperties tServiceProperties = null;
        if (servicePropertySet != null && !(serviceProperties = servicePropertySet.getServiceProperties()).isEmpty()) {
            tServiceProperties = this.objectFactory.createTServiceProperties();
            for (ServiceProperty serviceProperty : serviceProperties) {
                tServiceProperties.getServiceProperty().add(this.generateServiceProperty(serviceProperty));
            }
        }
        return tServiceProperties;
    }

    @NotNull
    private TServiceProperty generateServiceProperty(@NotNull ServiceProperty serviceProperty) {
        TServiceProperty tServiceProperty = this.objectFactory.createTServiceProperty();
        tServiceProperty.setName(serviceProperty.getName());
        tServiceProperty.setExpression(this.createExtendedTFormalExpression(serviceProperty.getExpression()));
        return tServiceProperty;
    }

    private void fillOracleExtensions(TArtifact tArtifact, Artifact artifact) throws ProjectException {
        TOracleExtensions extensions = this.getOrCreateOracleExtensionsFor(tArtifact);
        TGraphicsAttributes graphicAttributes = this.generateNodesGraphicalExtension(artifact);
        extensions.setGraphicsAttributes(graphicAttributes);
        TLocalization localization = this.createLocalizationFor(artifact);
        extensions.setLocalization(localization);
        TFeatureSet tFeatureSet = this.generateFeaturesExtensions(artifact.getFeatures());
        extensions.setFeatureSet(tFeatureSet);
    }

    private TFeatureSet generateFeaturesExtensions(Features features) throws ProjectException {
        this.currentFeatureSet = this.extensionsFactory.createTFeatureSet();
        for (Feature feature : features) {
            if (feature instanceof AnnotationsFeature) {
                this.generateAllAnnotations((AnnotationsFeature)feature);
                continue;
            }
            feature.visit(this);
        }
        return this.currentFeatureSet;
    }

    private void generateAllAnnotations(AnnotationsFeature annotationsFeature) throws ProjectException {
        if (annotationsFeature.hasAnnotations()) {
            AnnotationsFeature.HiddenAnnotationsFeature hiddenAnnotationsFeature;
            TFeatureSet oldFeatureSet = this.currentFeatureSet;
            TAnnotations tAnnotations = this.extensionsFactory.createTAnnotations();
            this.currentFeatureSet = tAnnotations;
            AnnotationsFeature.UserAnnotationsFeature userAnnotationsFeature = annotationsFeature.getFeature(AnnotationsFeature.UserAnnotationsFeature.class);
            if (userAnnotationsFeature.hasAnnotations()) {
                tAnnotations.setUserAnnotations(this.generateUserAnnotations(userAnnotationsFeature));
            }
            if ((hiddenAnnotationsFeature = annotationsFeature.getFeature(AnnotationsFeature.HiddenAnnotationsFeature.class)).hasAnnotations()) {
                tAnnotations.setHiddenAnnotations(this.generateHiddenAnnotations(hiddenAnnotationsFeature));
            }
            this.currentFeatureSet = oldFeatureSet;
            this.currentFeatureSet.setAnnotations(tAnnotations);
        }
    }

    private TUserAnnotations generateUserAnnotations(AnnotationsFeature.UserAnnotationsFeature mapFeature) throws ProjectException {
        TFeatureSet oldFeatureSet = this.currentFeatureSet;
        TUserAnnotations tUserAnnotations = this.extensionsFactory.createTUserAnnotations();
        this.currentFeatureSet = tUserAnnotations;
        for (Feature annotation : mapFeature.getFeatures()) {
            annotation.visit(this);
        }
        this.currentFeatureSet = oldFeatureSet;
        return tUserAnnotations;
    }

    private THiddenAnnotations generateHiddenAnnotations(AnnotationsFeature.HiddenAnnotationsFeature mapFeature) throws ProjectException {
        TFeatureSet oldFeatureSet = this.currentFeatureSet;
        THiddenAnnotations tUserAnnotations = this.extensionsFactory.createTHiddenAnnotations();
        this.currentFeatureSet = tUserAnnotations;
        for (Feature annotation : mapFeature.getFeatures()) {
            annotation.visit(this);
        }
        this.currentFeatureSet = oldFeatureSet;
        return tUserAnnotations;
    }

    private void fillOracleExtensions(TSequenceFlow tSequenceFlow, SequenceFlow sequenceFlow) throws ProjectException {
        TOracleExtensions extensions = this.getOrCreateOracleExtensionsFor(tSequenceFlow);
        TSequenceFlowAttributes sequenceFlowAttributes = this.generateSequenceFlowAttributes(sequenceFlow);
        extensions.setSequenceFlowAttributes(sequenceFlowAttributes);
        TFeatureSet tFeatureSet = this.generateFeaturesExtensions(sequenceFlow.getFeatures());
        extensions.setFeatureSet(tFeatureSet);
    }

    private TSequenceFlowAttributes generateSequenceFlowAttributes(SequenceFlow sequenceFlow) {
        TSequenceFlowAttributes sequenceFlowAttributes = this.extensionsFactory.createTSequenceFlowAttributes();
        if (sequenceFlow.isCurve()) {
            TPosition position = this.extensionsFactory.createTPosition();
            position.setX(sequenceFlow.getControlPoint().getX());
            position.setY(sequenceFlow.getControlPoint().getY());
            sequenceFlowAttributes.getPositions().add(position);
        }
        return sequenceFlowAttributes;
    }

    private TGraphicsAttributes generateNodesGraphicalExtension(Lane lane) {
        TGraphicsAttributes graphicAttributes = this.extensionsFactory.createTGraphicsAttributes();
        TPosition position = this.extensionsFactory.createTPosition();
        position.setX(lane.getOffset());
        TSize size = this.extensionsFactory.createTSize();
        size.setWidth(lane.getSize());
        int backgroundColor = lane.getBackgroundColor();
        graphicAttributes.setPosition(position);
        graphicAttributes.setSize(size);
        graphicAttributes.setBackgroundColor(backgroundColor);
        return graphicAttributes;
    }

    private TGraphicsAttributes generateNodesGraphicalExtension(Positional positional) {
        TGraphicsAttributes graphicAttributes = this.extensionsFactory.createTGraphicsAttributes();
        TPosition position = this.extensionsFactory.createTPosition();
        position.setX(positional.getX());
        position.setY(positional.getY());
        graphicAttributes.setPosition(position);
        if (positional.getWidth() != 0 || positional.getHeight() != 0) {
            TSize size = this.extensionsFactory.createTSize();
            size.setHeight(positional.getHeight());
            size.setWidth(positional.getWidth());
            graphicAttributes.setSize(size);
        }
        return graphicAttributes;
    }

    private QName createQNameFor(String str) {
        return this.createQNameFor(str, BPMN_NS);
    }

    private QName createQNameFor(String str, String namespace) {
        return QName.valueOf(str == null ? "" : (namespace == null || namespace.equals("") ? str : "{" + namespace + "}" + str));
    }

    private void visitEvents(NodeContainer nodeContainer) throws ProjectException {
        for (Event event : nodeContainer.getEvents()) {
            event.visit(this);
        }
    }

    private void visitBoundaryEvents(NodeContainer nodeContainer) throws ProjectException {
        for (BoundaryEvent boundaryEvent : nodeContainer.getBoundaryEvents()) {
            boundaryEvent.visit(this);
        }
    }

    private void visitActivities(NodeContainer nodeContainer) throws ProjectException {
        for (Activity activity : nodeContainer.getActivities()) {
            activity.visit(this);
        }
    }

    private void visitGateways(NodeContainer nodeContainer) throws ProjectException {
        for (Gateway gateway : nodeContainer.getGateways()) {
            gateway.visit(this);
        }
    }

    private void visitSequenceFlows(NodeContainer nodeContainer) throws ProjectException {
        for (SequenceFlow sequenceFlow : nodeContainer.getSequenceFlows()) {
            sequenceFlow.visit(this);
        }
    }

    private void fillSequenceFlowAttributes(TSequenceFlow tSequenceflow, SequenceFlow sequenceFlow) {
        tSequenceflow.setId(sequenceFlow.getId());
        tSequenceflow.setName(sequenceFlow.getId());
        tSequenceflow.setSourceRef(this.createTBaseElementRef(sequenceFlow.getSource()));
        tSequenceflow.setTargetRef(this.createTBaseElementRef(sequenceFlow.getTarget()));
    }

    private void fillGatewayAttributes(TGateway tGateway, Gateway gateway) {
        if (gateway != null && gateway.getId() != null) {
            tGateway.setId(gateway.getId());
            String defaultLabel = gateway.getDefaultLabel();
            if (!Str.isEmpty(defaultLabel)) {
                tGateway.setName(defaultLabel);
            }
            tGateway.setGatewayDirection(TGatewayDirection.fromValue(Str.capitalize(gateway.getDirection().getId())));
        }
    }

    private void fillEventAttributes(TEvent tEvent, Event event) {
        if (event != null && event.getId() != null) {
            tEvent.setId(event.getId());
            String defaultLabel = event.getDefaultLabel();
            if (!Str.isEmpty(defaultLabel)) {
                tEvent.setName(defaultLabel);
            }
        }
    }

    private void fillActivityAttributes(TActivity tActivity, Activity activity) {
        if (activity != null && activity.getId() != null) {
            tActivity.setId(activity.getId());
            String defaultLabel = activity.getDefaultLabel();
            if (!Str.isEmpty(defaultLabel)) {
                tActivity.setName(defaultLabel);
            }
        }
        tActivity.setIsForCompensation(false);
        this.fillActivityLoopCharacteristics(tActivity, activity);
    }

    private void fillActivityLoopCharacteristics(TActivity tActivity, Activity activity) {
        LoopCharacteristicsType loopType = activity.getLoopCharacteristicsType();
        if (loopType != null && loopType != LoopCharacteristicsType.NONE) {
            TLoopCharacteristics loopCharacteristics = null;
            switch (loopType) {
                case LOOP: {
                    TStandardLoopCharacteristics characteristics;
                    Loop loop = activity.getLoopCharacteristics().as(Loop.class);
                    loopCharacteristics = characteristics = this.objectFactory.createTStandardLoopCharacteristics();
                    characteristics.setTestBefore(loop.isTestBefore());
                    if (loop.hasLoopMaximum()) {
                        characteristics.setLoopMaximum(BigInteger.valueOf(loop.getLoopMaximum()));
                    }
                    characteristics.setLoopCondition(this.createExtendedTFormalExpression(loop.getLoopExpression()));
                    break;
                }
                case MULTIINSTANCE: {
                    DataDeclaration outputDataDeclaration;
                    MultiInstance multiInstance = activity.getLoopCharacteristics().as(MultiInstance.class);
                    TMultiInstanceLoopCharacteristics characteristics = this.objectFactory.createTMultiInstanceLoopCharacteristics();
                    loopCharacteristics = characteristics;
                    characteristics.setBehavior(TMultiInstanceFlowCondition.ALL);
                    characteristics.setIsSequential(multiInstance.isSequential());
                    characteristics.setLoopCardinality(this.createExtendedTFormalExpression(multiInstance.getLoopCardinality()));
                    characteristics.setCompletionCondition(this.createExtendedTFormalExpression(multiInstance.getCompletionCondition()));
                    DataDeclaration inputDataDeclaration = multiInstance.getLoopDataInput();
                    if (inputDataDeclaration != null) {
                        QName dataInput = new QName(inputDataDeclaration.getName());
                        characteristics.setLoopDataInputRef(dataInput);
                    }
                    if ((outputDataDeclaration = multiInstance.getLoopDataOutput()) == null) break;
                    QName dataOutput = new QName(outputDataDeclaration.getName());
                    characteristics.setLoopDataOutputRef(dataOutput);
                    break;
                }
            }
            tActivity.setLoopCharacteristics(this.objectFactory.createLoopCharacteristics(loopCharacteristics));
        }
    }

    private void fillOracleExtensions(Process process) throws ProjectException {
        TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(this.tProcess);
        TFeatureSet tFeatureSet = this.generateFeaturesExtensions(process.getFeatures());
        tOracleExtensions.setFeatureSet(tFeatureSet);
        if (ModelUtils.isDefaultProcess(process)) {
            this.fillCorrelationPropertyAliasExpressionModeMap(tOracleExtensions, process);
        }
        this.fillApplicationInfo(tOracleExtensions, process);
    }

    private void fillCorrelationPropertyAliasExpressionModeMap(TOracleExtensions tOracleExtensions, Process process) {
        TCorrelationPropertyAliasExpressionModeMap tModeMap = tOracleExtensions.getCorrelationPropertyAliasExpressionModeMap();
        if (tModeMap == null) {
            tModeMap = this.extensionsFactory.createTCorrelationPropertyAliasExpressionModeMap();
            tOracleExtensions.setCorrelationPropertyAliasExpressionModeMap(tModeMap);
        }
        List<TCorrelationPropertyAliasExpressionMode> tMapList = tModeMap.getCorrelationPropertyAliasExpressionMode();
        Project project = process.getProject();
        Sequence<CorrelationPropertyAlias> propertyAliases = project.getPropertyAliases();
        for (CorrelationPropertyAlias propertyAlias : propertyAliases) {
            PropertyAliasSetId propertyAliasSetId;
            Expression expression = propertyAlias.getExpression();
            if (expression == null) continue;
            ExpressionMode mode = expression.getMode();
            String modeId = mode.getId();
            if (propertyAlias.isElement()) {
                propertyAliasSetId = PropertyAliasSetId.create((QName)propertyAlias.getElement());
            } else if (propertyAlias.isMessage()) {
                propertyAliasSetId = PropertyAliasSetId.create((QName)propertyAlias.getMessageType(), (String)propertyAlias.getPartName());
            } else {
                throw new IllegalArgumentException("Property Alias must be declared either for an Element or a Message");
            }
            String id = propertyAliasSetId.getId();
            QName propertyName = propertyAlias.getProperty().getFullName();
            TCorrelationPropertyAliasExpressionMode tCorrelationPropertyAliasExpressionMode = this.extensionsFactory.createTCorrelationPropertyAliasExpressionMode();
            tCorrelationPropertyAliasExpressionMode.setExpressionMode(modeId);
            tCorrelationPropertyAliasExpressionMode.setId(id);
            tCorrelationPropertyAliasExpressionMode.setPropertyName(propertyName);
            tMapList.add(tCorrelationPropertyAliasExpressionMode);
        }
    }

    private void fillApplicationInfo(TOracleExtensions tOracleExtensions, Process process) {
        TApplicationInfo tApplicationInfo = this.extensionsFactory.createTApplicationInfo();
        ApplicationInfo appInfo = process.getApplicationInfo();
        TAppLinkName tLinkName = this.extensionsFactory.createTAppLinkName();
        this.addLocalizationItems(appInfo.getLinkNames().entrySet(), tLinkName);
        tApplicationInfo.setAppLinkName(tLinkName);
        TDescription tDescription = this.extensionsFactory.createTDescription();
        this.addLocalizationItems(appInfo.getDescriptions().entrySet(), tDescription);
        tApplicationInfo.setDescription(tDescription);
        TAppCategory tCategory = this.extensionsFactory.createTAppCategory();
        this.addLocalizationItems(appInfo.getCategories().entrySet(), tCategory);
        tApplicationInfo.setAppCategory(tCategory);
        TAppTags tTags = this.extensionsFactory.createTAppTags();
        Sequence<String> tags = appInfo.getTags();
        for (String tag : tags) {
            tTags.getList().add(tag);
        }
        tApplicationInfo.setAppTags(tTags);
        TAppExternalDocuments tAppExternalDocuments = this.extensionsFactory.createTAppExternalDocuments();
        Sequence<ExternalDocument> externalDocuments = appInfo.getExternalDocuments();
        for (ExternalDocument doc : externalDocuments) {
            TAppExternalDocument tAppExternalDocument = this.extensionsFactory.createTAppExternalDocument();
            tAppExternalDocument.setName(doc.getName());
            tAppExternalDocument.setLink(doc.getLink());
            tAppExternalDocuments.getList().add(tAppExternalDocument);
        }
        tApplicationInfo.setAppExternalDocuments(tAppExternalDocuments);
        tOracleExtensions.setApplicationInfo(tApplicationInfo);
    }

    private void addStringExtension(String featureName, String value) {
        this.currentFeatureSet.getStringFeature().add(this.createStringFeature(featureName, value));
    }

    private TStringFeature createStringFeature(String featureName, String value) {
        TStringFeature stringFeature = this.extensionsFactory.createTStringFeature();
        stringFeature.setName(featureName);
        stringFeature.setValue(value);
        return stringFeature;
    }

    private void addBooleanExtension(String featureName, Boolean value) {
        this.currentFeatureSet.getBooleanFeature().add(this.createBooleanFeature(featureName, value));
    }

    private TBooleanFeature createBooleanFeature(String featureName, Boolean value) {
        TBooleanFeature booleanFeature = this.extensionsFactory.createTBooleanFeature();
        booleanFeature.setName(featureName);
        booleanFeature.setValue(value);
        return booleanFeature;
    }

    private void addIntegerExtension(String featureName, Long value) {
        this.currentFeatureSet.getIntegerFeature().add(this.createIntegerFeature(featureName, value));
    }

    private void addExpressionExtension(String featureName, Expression value) {
        this.currentFeatureSet.getAny().add(this.objectFactory.createAttributeExpression(this.createTAttributeExpression(featureName, value)));
    }

    private TIntegerFeature createIntegerFeature(String featureName, Long value) {
        TIntegerFeature tIntegerFeature = this.extensionsFactory.createTIntegerFeature();
        tIntegerFeature.setName(featureName);
        tIntegerFeature.setValue(BigInteger.valueOf(value));
        return tIntegerFeature;
    }

    private void visitNodeContainer(@NotNull NodeContainer nodeContainer, @NotNull TBaseElement tElement) throws ProjectException {
        this.visitFlowElements(nodeContainer);
        this.visitArtifacts(nodeContainer);
        this.visitCorrelationKeys(nodeContainer, tElement);
        this.visitConversations(nodeContainer, tElement);
    }

    private void visitCorrelationKeys(@NotNull NodeContainer nodeContainer, @NotNull TBaseElement tElement) {
        Sequence<CorrelationKey> correlationKeys = nodeContainer.getCorrelationKeys();
        if (!correlationKeys.isEmpty()) {
            TOracleExtensions oracleExtensions = this.getOrCreateOracleExtensionsFor(tElement);
            oracleExtensions.setCorrelationKeys(this.createCorrelationKeysFrom(correlationKeys));
        }
    }

    private void visitConversations(@NotNull ConversationContainer container, @NotNull TBaseElement tElement) {
        Sequence<Conversation> conversations = container.getLocalConversations();
        if (!conversations.isEmpty()) {
            TOracleExtensions oracleExtensions = this.getOrCreateOracleExtensionsFor(tElement);
            oracleExtensions.setConversations(this.createConversationsFrom(conversations));
        }
    }

    @NotNull
    private TConversations createConversationsFrom(@NotNull Sequence<Conversation> conversations) {
        TConversations result = this.extensionsFactory.createTConversations();
        for (Conversation conversation : conversations) {
            if (conversation.isDefaultConversation() && conversation.getConversationals().isEmpty()) continue;
            result.getConversation().add(this.createConversationFrom(conversation));
        }
        return result;
    }

    @NotNull
    private TConversation createConversationFrom(@NotNull Conversation conversation) {
        TConversation result = this.extensionsFactory.createTConversation();
        result.setId(conversation.getId());
        if (!conversation.isDefaultConversation()) {
            result.setName(conversation.getName());
        }
        ConversationType conversationType = conversation.getConversationType();
        result.setType(conversationType.getId());
        ConversationDefinition conversationDefinition = conversation.getConversationDefinition();
        if (conversationType == ConversationType.DEFINE_INTERFACE) {
            TDefineInterfaceConversationDefinition tDefinition = this.extensionsFactory.createTDefineInterfaceConversationDefinition();
            DefineInterfaceConversationDefinition definition = conversationDefinition.as(DefineInterfaceConversationDefinition.class);
            tDefinition.setExposeSOAPService(definition.isSoapServiceExposed());
            result.setDefineInterfaceConversationDefinition(tDefinition);
        } else if (conversationType == ConversationType.USE_INTERFACE) {
            TUseInterfaceConversationDefinition tDefinition = this.extensionsFactory.createTUseInterfaceConversationDefinition();
            UseInterfaceConversationDefinitionImpl definition = conversationDefinition.as(UseInterfaceConversationDefinitionImpl.class);
            tDefinition.setReference(definition.getReferenceId());
            result.setUseInterfaceConversationDefinition(tDefinition);
        } else if (conversationType == ConversationType.PROCESS_CALL) {
            TProcessCallConversationDefinition tDefinition = this.extensionsFactory.createTProcessCallConversationDefinition();
            ProcessCallConversationDefinitionImpl definition = conversationDefinition.as(ProcessCallConversationDefinitionImpl.class);
            tDefinition.setProcess(definition.getProcessId());
            result.setProcessCallConversationDefinition(tDefinition);
        } else if (conversationType == ConversationType.SERVICE_CALL) {
            TServiceCallConversationDefinition tDefinition = this.extensionsFactory.createTServiceCallConversationDefinition();
            ServiceCallConversationDefinitionImpl definition = conversationDefinition.as(ServiceCallConversationDefinitionImpl.class);
            tDefinition.setService(definition.getServiceId());
            result.setServiceCallConversationDefinition(tDefinition);
        }
        return result;
    }

    @NotNull
    private TCorrelationKeys createCorrelationKeysFrom(@NotNull Sequence<CorrelationKey> correlationKeys) {
        TCorrelationKeys tCorrelationKeys = this.extensionsFactory.createTCorrelationKeys();
        for (CorrelationKey correlationKey : correlationKeys) {
            tCorrelationKeys.getCorrelationKey().add(this.createCorrelationKeyFrom(correlationKey));
        }
        return tCorrelationKeys;
    }

    @NotNull
    private TCorrelationKey createCorrelationKeyFrom(@NotNull CorrelationKey correlationKey) {
        TCorrelationKey tCorrelationKey = this.extensionsFactory.createTCorrelationKey();
        tCorrelationKey.setName(correlationKey.getName());
        Sequence<CorrelationProperty> correlationPropertySequence = correlationKey.getProperties();
        if (!correlationPropertySequence.isEmpty()) {
            for (CorrelationProperty correlationProperty : correlationPropertySequence) {
                tCorrelationKey.getProperty().add(this.createCorrelationPropertyFrom(correlationProperty));
            }
        }
        return tCorrelationKey;
    }

    @NotNull
    private TProperty createCorrelationPropertyFrom(@NotNull CorrelationProperty correlationProperty) {
        TProperty tProperty = this.extensionsFactory.createTProperty();
        tProperty.setPropertyQName(correlationProperty.getFullName().toString());
        return tProperty;
    }

    private void fillSubprocessData(Subprocess subprocess, TSubProcess tSubProcess) throws ProjectException {
        List<JAXBElement<? extends TFlowElement>> oldElementList = this.currentElementList;
        List<JAXBElement<? extends TArtifact>> oldArtifactList = this.currentArtifactList;
        this.currentElementList = tSubProcess.getFlowElement();
        this.currentArtifactList = tSubProcess.getArtifact();
        this.visitNodeContainer(subprocess, tSubProcess);
        this.currentElementList = oldElementList;
        this.currentArtifactList = oldArtifactList;
    }

    private class PersistenceFlowNodeHandler
    extends CheckedFlowNodeAdapter {
        private final List<JAXBElement<? extends TFlowElement>> flowElements;
        private TActivity tActivityRef;
        private TEvent tEventRef;
        private TGateway tGatewayRef;

        PersistenceFlowNodeHandler(List<JAXBElement<? extends TFlowElement>> flowElements) {
            this.flowElements = flowElements;
        }

        public TActivity getActivityRef() {
            return this.tActivityRef;
        }

        public TEvent getEventRef() {
            return this.tEventRef;
        }

        public TGateway getGatewayRef() {
            return this.tGatewayRef;
        }

        @Override
        public void handleAbstractActivity(Activity node) {
            this.handleDefault(node);
        }

        @Override
        public void handleBoundaryEvent(BoundaryEvent boundaryEvent) throws ProjectException {
            TBoundaryEvent tBoundaryEvent = ProcessVisitorBPMN.this.objectFactory.createTBoundaryEvent();
            this.tEventRef = tBoundaryEvent;
            Activity boundaryActivity = boundaryEvent.getBoundaryActivity();
            if (boundaryActivity != null) {
                tBoundaryEvent.setAttachedToRef(ProcessVisitorBPMN.this.createQNameFor(boundaryActivity.getId()));
            }
            tBoundaryEvent.setCancelActivity(boundaryEvent.cancelActivity());
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createBoundaryEvent(tBoundaryEvent));
        }

        @Override
        public void handleManualTask(ManualTask manualTask) {
            TManualTask tManualTask = ProcessVisitorBPMN.this.objectFactory.createTManualTask();
            this.tActivityRef = tManualTask;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createManualTask(tManualTask));
        }

        @Override
        public void handleBusinessRuleTask(BusinessRuleTask businessRuleTask) {
            String functionName;
            CatalogMember function;
            String businessRuleName;
            TBusinessRuleTask tBusinessRuleTask = ProcessVisitorBPMN.this.objectFactory.createTBusinessRuleTask();
            this.tActivityRef = tBusinessRuleTask;
            TBusinessRuleTaskData businessRuleData = ProcessVisitorBPMN.this.extensionsFactory.createTBusinessRuleTaskData();
            BusinessRule businessRule = businessRuleTask.getBusinessRule();
            if (businessRule != null && !Str.isEmpty(businessRuleName = businessRule.getText())) {
                businessRuleData.setBusinessRuleName(businessRuleName);
            }
            if ((function = businessRuleTask.getFunction()) != null && !Str.isEmpty(functionName = businessRuleTask.getFunctionName())) {
                businessRuleData.setFunctionName(functionName);
            }
            if (businessRule != null || function != null) {
                TOracleExtensions oracleExt = ProcessVisitorBPMN.this.getOrCreateOracleExtensionsFor(tBusinessRuleTask);
                oracleExt.setBusinessRuleTaskData(businessRuleData);
            }
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createBusinessRuleTask(tBusinessRuleTask));
        }

        @Override
        public void handleUserTask(UserTask userTask) {
            TUserTask tUserTask = ProcessVisitorBPMN.this.objectFactory.createTUserTask();
            this.tActivityRef = tUserTask;
            ProcessVisitorBPMN.this.createResourceRole(tUserTask, userTask);
            TOracleExtensions extensions = ProcessVisitorBPMN.this.getOrCreateOracleExtensionsFor(tUserTask);
            THumanTask humanTask = ProcessVisitorBPMN.this.extensionsFactory.createTHumanTask();
            HumanTask task = userTask.getHumanTask();
            if (task != null) {
                humanTask.setHumanTaskReference(task.getId());
            }
            extensions.setHumanTask(humanTask);
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createUserTask(tUserTask));
        }

        @Override
        public void handleServiceTask(ServiceTask serviceTask) {
            TServiceTask tServiceTask = ProcessVisitorBPMN.this.objectFactory.createTServiceTask();
            this.tActivityRef = tServiceTask;
            Tuple participantAndOperation = ProcessVisitorBPMN.this.getParticipantAndOperation(serviceTask);
            if (participantAndOperation != null) {
                String participantName = (String)participantAndOperation.getFirst();
                String operationName = (String)participantAndOperation.getSecond();
                tServiceTask.setImplementation(participantName);
                tServiceTask.setOperationRef(ProcessVisitorBPMN.this.createQNameFor(operationName));
            }
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createServiceTask(tServiceTask));
        }

        @Override
        public void handleReceiveTask(ReceiveTask receiveTask) {
            TReceiveTask tReceiveTask = ProcessVisitorBPMN.this.objectFactory.createTReceiveTask();
            this.tActivityRef = tReceiveTask;
            tReceiveTask.setInstantiate(receiveTask.isInstantiate());
            Tuple participantAndOperation = ProcessVisitorBPMN.this.getParticipantAndOperation(receiveTask);
            if (participantAndOperation != null) {
                String participantName = (String)participantAndOperation.getFirst();
                String operationName = (String)participantAndOperation.getSecond();
                tReceiveTask.setMessageRef(ProcessVisitorBPMN.this.createQNameFor(participantName));
                tReceiveTask.setOperationRef(ProcessVisitorBPMN.this.createQNameFor(operationName));
            }
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createReceiveTask(tReceiveTask));
        }

        @Override
        public void handleSendTask(SendTask sendTask) {
            TSendTask tSendTask = ProcessVisitorBPMN.this.objectFactory.createTSendTask();
            this.tActivityRef = tSendTask;
            Tuple participantAndOperation = ProcessVisitorBPMN.this.getParticipantAndOperation(sendTask);
            if (participantAndOperation != null) {
                String participantName = (String)participantAndOperation.getFirst();
                String operationName = (String)participantAndOperation.getSecond();
                tSendTask.setMessageRef(ProcessVisitorBPMN.this.createQNameFor(participantName));
                tSendTask.setOperationRef(ProcessVisitorBPMN.this.createQNameFor(operationName));
            }
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createSendTask(tSendTask));
        }

        @Override
        public void handleScriptTask(ScriptTask scriptTask) {
            TScriptTask tScriptTask = ProcessVisitorBPMN.this.objectFactory.createTScriptTask();
            this.tActivityRef = tScriptTask;
            tScriptTask.setScriptFormat(scriptTask.getLanguage());
            TScript script = ProcessVisitorBPMN.this.objectFactory.createTScript();
            script.getContent().add(scriptTask.getScript());
            tScriptTask.setScript(script);
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createScriptTask(tScriptTask));
        }

        @Override
        public void handleCallActivity(CallActivity callActivity) {
            TCallActivity tCallActivity = ProcessVisitorBPMN.this.objectFactory.createTCallActivity();
            this.tActivityRef = tCallActivity;
            Process process = callActivity.getCalledElement();
            if (process != null) {
                tCallActivity.setCalledElement(ProcessVisitorBPMN.this.createQNameFor(process.getId()));
            }
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createCallActivity(tCallActivity));
        }

        @Override
        public void handleSubprocess(Subprocess subprocess) throws ProjectException {
            TSubProcess tSubProcess = ProcessVisitorBPMN.this.objectFactory.createTSubProcess();
            this.tActivityRef = tSubProcess;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createSubProcess(tSubProcess));
            tSubProcess.setTriggeredByEvent(subprocess.isTriggeredByEvent());
            ProcessVisitorBPMN.this.fillSubprocessData(subprocess, tSubProcess);
        }

        @Override
        public void handleStartEvent(StartEvent startEvent) throws ProjectException {
            TStartEvent tStartEvent = ProcessVisitorBPMN.this.objectFactory.createTStartEvent();
            this.tEventRef = tStartEvent;
            tStartEvent.setIsInterrupting(startEvent.isInterrupting());
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createStartEvent(tStartEvent));
        }

        @Override
        public void handleEndEvent(EndEvent endEvent) {
            TEndEvent tEndEvent = ProcessVisitorBPMN.this.objectFactory.createTEndEvent();
            this.tEventRef = tEndEvent;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createEndEvent(tEndEvent));
        }

        @Override
        public void handleCatchIntermediateEvent(CatchEvent event) throws ProjectException {
            TIntermediateCatchEvent tIntCatchEvent = ProcessVisitorBPMN.this.objectFactory.createTIntermediateCatchEvent();
            this.tEventRef = tIntCatchEvent;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createIntermediateCatchEvent(tIntCatchEvent));
        }

        @Override
        public void handleIntermediateThrowEvent(ThrowEvent throwEvent) throws ProjectException {
            TIntermediateThrowEvent tIntThrowEvent = ProcessVisitorBPMN.this.objectFactory.createTIntermediateThrowEvent();
            this.tEventRef = tIntThrowEvent;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createIntermediateThrowEvent(tIntThrowEvent));
        }

        @Override
        public void handleExclusiveGateway(ExclusiveGateway exclusiveGateway) throws ProjectException {
            TExclusiveGateway tExclusiveGateway = ProcessVisitorBPMN.this.objectFactory.createTExclusiveGateway();
            this.tGatewayRef = tExclusiveGateway;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createExclusiveGateway(tExclusiveGateway));
        }

        @Override
        public void handleInclusiveGateway(InclusiveGateway inclusiveGateway) throws ProjectException {
            TInclusiveGateway tInclusiveGateway = ProcessVisitorBPMN.this.objectFactory.createTInclusiveGateway();
            this.tGatewayRef = tInclusiveGateway;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createInclusiveGateway(tInclusiveGateway));
        }

        @Override
        public void handleParallelGateway(ParallelGateway parallelGateway) throws ProjectException {
            TParallelGateway tParallelGateway = ProcessVisitorBPMN.this.objectFactory.createTParallelGateway();
            this.tGatewayRef = tParallelGateway;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createParallelGateway(tParallelGateway));
        }

        @Override
        public void handleEventBasedGateway(EventBasedGateway eventBasedGateway) throws ProjectException {
            TEventBasedGateway tEventBasedGateway = ProcessVisitorBPMN.this.objectFactory.createTEventBasedGateway();
            this.tGatewayRef = tEventBasedGateway;
            tEventBasedGateway.setInstantiate(eventBasedGateway.isInstantiate());
            tEventBasedGateway.setEventGatewayType(TEventBasedGatewayType.fromValue(Str.capitalize(eventBasedGateway.getType().toString().toLowerCase())));
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createEventBasedGateway(tEventBasedGateway));
        }

        @Override
        public void handleComplexGateway(ComplexGateway complexGateway) throws ProjectException {
            TComplexGateway tComplexGateway = ProcessVisitorBPMN.this.objectFactory.createTComplexGateway();
            this.tGatewayRef = tComplexGateway;
            tComplexGateway.setActivationCondition(ProcessVisitorBPMN.this.createExtendedTFormalExpression(complexGateway.getActivationCondition()));
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createComplexGateway(tComplexGateway));
        }

        @Override
        public void handleNotificationTask(NotificationTask notificationTask) throws ProjectException {
            TServiceTask tServiceTask = ProcessVisitorBPMN.this.objectFactory.createTServiceTask();
            this.tActivityRef = tServiceTask;
            String serviceRefName = NotificationServiceHelper.buildNotificationReferenceName((Activity)notificationTask);
            tServiceTask.setImplementation(serviceRefName);
            OperationReferenceExtended operationReference = NotificationOperationRefFactory.buildOperationReference((NotificationType)notificationTask.getNotificationType());
            QName operationName = new QName(operationReference.getName());
            tServiceTask.setOperationRef(operationName);
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createServiceTask(tServiceTask));
        }

        @Override
        public void handleUpdateTask(UpdateTask updateTask) throws ProjectException {
            TServiceTask tServiceTask = ProcessVisitorBPMN.this.objectFactory.createTServiceTask();
            this.tActivityRef = tServiceTask;
            String updateServiceNativeName = TaskManagementServiceHelper.buildTaskManagementReferenceName();
            tServiceTask.setImplementation(updateServiceNativeName);
            String operationNativeName = TaskManagementServiceHelper.getOperationNativeName((UpdateType)updateTask.getUpdateType());
            QName operationName = new QName(operationNativeName);
            tServiceTask.setOperationRef(operationName);
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createServiceTask(tServiceTask));
        }

        private void handleDefault(FlowNode node) {
            TTask tTask = ProcessVisitorBPMN.this.objectFactory.createTTask();
            this.tActivityRef = tTask;
            this.flowElements.add(ProcessVisitorBPMN.this.objectFactory.createTask(tTask));
        }
    }

    private class PersistenceEventDefinitionHandler
    extends CheckedEventTriggerAdapter {
        private TEvent tEvent;

        PersistenceEventDefinitionHandler(TEvent tEvent) {
            this.tEvent = tEvent;
        }

        public TEvent getTEventRef() {
            return this.tEvent;
        }

        @Override
        public void handleErrorEvent(Event event) throws ProjectException {
            this.fillEventDefinition(event, this.createTErrorEventDefinition(event.getEventDefinition().as(ErrorEventDefinition.class)));
            this.fillEventAssociations(event);
        }

        @Override
        public void handleTerminateEvent(Event event) throws ProjectException {
            this.fillEventDefinition(event, ProcessVisitorBPMN.this.objectFactory.createTerminateEventDefinition(ProcessVisitorBPMN.this.objectFactory.createTTerminateEventDefinition()));
        }

        @Override
        public void handleSignalEvent(Event event) throws ProjectException {
            String signalId;
            SignalEventDefinition signalEventDefinition = event.getEventDefinition().as(SignalEventDefinition.class);
            TSignalEventDefinition tSignalEventDefinition = ProcessVisitorBPMN.this.objectFactory.createTSignalEventDefinition();
            SignalObject signalObject = signalEventDefinition.getSignal();
            String string = signalId = signalObject != null ? signalObject.getText() : "";
            if (!Str.isEmpty(signalId)) {
                tSignalEventDefinition.setSignalRef(ProcessVisitorBPMN.this.createQNameFor(signalId));
            }
            TOracleExtensions tOracleExtensions = ProcessVisitorBPMN.this.getOrCreateOracleExtensionsFor(tSignalEventDefinition);
            Expression expression = signalEventDefinition.getExpression();
            tOracleExtensions.getAny().add(ProcessVisitorBPMN.this.objectFactory.createFormalExpression(ProcessVisitorBPMN.this.createExtendedTFormalExpression(expression)));
            this.fillEventDefinition(event, ProcessVisitorBPMN.this.objectFactory.createSignalEventDefinition(tSignalEventDefinition));
            this.fillEventAssociations(event);
        }

        @Override
        public void handleNoneEvent(Event event) throws ProjectException {
            this.fillEventDefinition(event, null);
            this.fillEventAssociations(event);
        }

        @Override
        public void handleMessageEvent(Event event) throws ProjectException {
            Conversational conversational;
            Tuple participantAndOperation;
            TMessageEventDefinition tMessageEventDefinition = ProcessVisitorBPMN.this.objectFactory.createTMessageEventDefinition();
            this.fillEventDefinition(event, ProcessVisitorBPMN.this.objectFactory.createMessageEventDefinition(tMessageEventDefinition));
            this.fillEventAssociations(event);
            if (event.isConversational() && (participantAndOperation = ProcessVisitorBPMN.this.getParticipantAndOperation(conversational = event.asAnyNode(Conversational.class))) != null) {
                String participantName = (String)participantAndOperation.getFirst();
                String operationName = (String)participantAndOperation.getSecond();
                tMessageEventDefinition.setMessageRef(ProcessVisitorBPMN.this.createQNameFor(participantName));
                tMessageEventDefinition.setOperationRef(ProcessVisitorBPMN.this.createQNameFor(operationName));
            }
        }

        @Override
        public void handleTimerEvent(Event event) throws ProjectException {
            TimerEventDefinition timerEventDefinition = event.getEventDefinition().as(TimerEventDefinition.class);
            TTimerEventDefinition tTimerEventDefinition = ProcessVisitorBPMN.this.objectFactory.createTTimerEventDefinition();
            TOracleExtensions timerDefExtensions = ProcessVisitorBPMN.this.getOrCreateOracleExtensionsFor(tTimerEventDefinition);
            TOptionalTimerEventFeatures optionalTimerEventFeatures = ProcessVisitorBPMN.this.extensionsFactory.createTOptionalTimerEventFeatures();
            timerDefExtensions.setOptionalTimerEventFeatures(optionalTimerEventFeatures);
            if (timerEventDefinition.getOptionalFeatures().getStartDate() != null) {
                optionalTimerEventFeatures.setStartDate(timerEventDefinition.getOptionalFeatures().getStartDate().toXMLString());
            }
            if (timerEventDefinition.getOptionalFeatures().getEndDate() != null) {
                optionalTimerEventFeatures.setEndDate(timerEventDefinition.getOptionalFeatures().getEndDate().toXMLString());
            }
            if (timerEventDefinition.getOptionalFeatures().getRepetitions() != null) {
                optionalTimerEventFeatures.setRepetitions(BigInteger.valueOf(timerEventDefinition.getOptionalFeatures().getRepetitions().intValue()));
            }
            optionalTimerEventFeatures.setUseCalendar(timerEventDefinition.getOptionalFeatures().isUseCalendarRules());
            optionalTimerEventFeatures.setOutOfCalendarPolicy(TOutOfCalendarPolicy.valueOf(timerEventDefinition.getOptionalFeatures().getOutOfCalendarPolicy().toString()));
            optionalTimerEventFeatures.setRescheduleRestrictionsPolicy(TRescheduleRestrictionsPolicy.valueOf(timerEventDefinition.getOptionalFeatures().getRescheduleRestrictionsPolicy().toString()));
            switch (timerEventDefinition.getType()) {
                case TIME_CYCLE: {
                    TFormalExpression tFormalExpression = ProcessVisitorBPMN.this.createExtendedTFormalExpression(timerEventDefinition.getTimeCycleExpression());
                    tTimerEventDefinition.setTimeCycle(tFormalExpression);
                    break;
                }
                case TIME_DATE: {
                    TFormalExpression tFormalExpression = ProcessVisitorBPMN.this.createExtendedTFormalExpression(timerEventDefinition.getTimeDateExpression());
                    tTimerEventDefinition.setTimeDate(tFormalExpression);
                    break;
                }
                case SCHEDULE: {
                    tTimerEventDefinition.setTimeCycle(ProcessVisitorBPMN.this.objectFactory.createTFormalExpression());
                    TOracleExtensions timeCycleExtensions = ProcessVisitorBPMN.this.getOrCreateOracleExtensionsFor(tTimerEventDefinition.getTimeCycle());
                    TSchedule scheduleExtension = ProcessVisitorBPMN.this.extensionsFactory.createTSchedule();
                    timeCycleExtensions.setSchedule(scheduleExtension);
                    Schedule schedule = timerEventDefinition.getSchedule();
                    for (DailySchedule dailySchedule : schedule.getDailyEntries()) {
                        scheduleExtension.getDailyEntries().add(this.migrate(dailySchedule));
                    }
                    for (WeeklySchedule weeklySchedule : schedule.getWeeklyEntries()) {
                        scheduleExtension.getWeeklyEntries().add(this.migrate(weeklySchedule));
                    }
                    for (MonthlySchedule monthlySchedule : schedule.getMonthlyEntries()) {
                        scheduleExtension.getMonthlyEntries().add(this.migrate(monthlySchedule));
                    }
                    break;
                }
            }
            this.fillEventDefinition(event, ProcessVisitorBPMN.this.objectFactory.createTimerEventDefinition(tTimerEventDefinition));
        }

        private TDailyScheduleEntry migrate(DailySchedule entry) {
            TDailyScheduleEntry result = ProcessVisitorBPMN.this.extensionsFactory.createTDailyScheduleEntry();
            result.setWhen(entry.getWhen().toXMLString());
            return result;
        }

        private TWeeklyScheduleEntry migrate(WeeklySchedule entry) {
            TWeeklyScheduleEntry result = ProcessVisitorBPMN.this.extensionsFactory.createTWeeklyScheduleEntry();
            result.setWhen(entry.getWhen().toXMLString());
            result.setDay(entry.getDayOfWeek().toString());
            return result;
        }

        private TMonthlyScheduleEntry migrate(MonthlySchedule entry) {
            TMonthlyScheduleEntry result = ProcessVisitorBPMN.this.extensionsFactory.createTMonthlyScheduleEntry();
            result.setWhen(entry.getWhen().toXMLString());
            if (entry.getMonth() != null) {
                result.setMonth(entry.getMonth().toString());
            }
            if (entry.getWeek() != null) {
                result.setWeek(entry.getWeek().toString());
                result.setDay(entry.getDayOfWeek().toString());
            } else {
                result.setDay(String.valueOf(entry.getDayOfMonth()));
            }
            return result;
        }

        private void fillEventDefinition(Event event, JAXBElement<? extends TEventDefinition> eventDefJaxbElement) {
            if (event.isCatchEvent()) {
                ((TCatchEvent)this.tEvent).getEventDefinition().add(eventDefJaxbElement);
            } else if (event.isThrowEvent()) {
                ((TThrowEvent)this.tEvent).getEventDefinition().add(eventDefJaxbElement);
            }
        }

        private void fillEventAssociations(Event event) throws ProjectException {
            if (event.isCatchEvent()) {
                this.fillEventOutAssociations(event.asCatchEvent(), (TCatchEvent)this.tEvent);
            } else if (event.isThrowEvent()) {
                this.fillEventInAssociations(event.asThrowEvent(), (TThrowEvent)this.tEvent);
            }
        }

        private void fillEventInAssociations(ThrowEvent throwEvent, TThrowEvent tThrowEvent) throws ProjectException {
            tThrowEvent.setInputSet(ProcessVisitorBPMN.this.objectFactory.createTInputSet());
            if (throwEvent.getEventTriggerType() != EventTriggerType.NONE) {
                ProcessVisitorBPMN.this.createDataInputs(throwEvent, throwEvent.getInputArgumentsContainer().getDeclarations(), tThrowEvent.getDataInput(), null, tThrowEvent.getInputSet());
            }
            InputDataAssociationFeature inputDataAssociationFeature = throwEvent.getFeature(InputDataAssociationFeature.class);
            ProcessVisitorBPMN.this.createInputDataAssociations(throwEvent, inputDataAssociationFeature, this.tEvent);
        }

        private void fillEventOutAssociations(CatchEvent catchEvent, TCatchEvent tCatchEvent) throws ProjectException {
            tCatchEvent.setOutputSet(ProcessVisitorBPMN.this.objectFactory.createTOutputSet());
            if (catchEvent.getEventTriggerType() != EventTriggerType.NONE) {
                ProcessVisitorBPMN.this.createDataOutputs(catchEvent, catchEvent.getOutputArgumentsContainer().getDeclarations(), tCatchEvent.getDataOutput(), null, tCatchEvent.getOutputSet());
            }
            OutputDataAssociationFeature outputDataAssociationFeature = catchEvent.getFeature(OutputDataAssociationFeature.class);
            ProcessVisitorBPMN.this.createOutDataAssociations(catchEvent, outputDataAssociationFeature, this.tEvent);
        }

        private JAXBElement<TErrorEventDefinition> createTErrorEventDefinition(ErrorEventDefinition errorEventDefinition) {
            TErrorEventDefinition tErrorEventDefinition = ProcessVisitorBPMN.this.objectFactory.createTErrorEventDefinition();
            ErrorObject errorObject = errorEventDefinition.getError();
            if (errorObject != null) {
                TOracleExtensions extensions = ProcessVisitorBPMN.this.getOrCreateOracleExtensionsFor(tErrorEventDefinition);
                extensions.setTypeRef(ProcessVisitorBPMN.this.createTTypeRef(errorObject));
                TypeDescription td = errorObject.getDelegate();
                if (td.isArray()) {
                    throw new IllegalArgumentException("Array data types are not supported '" + td + "'");
                }
                QName errorRef = errorObject.getErrorCode();
                tErrorEventDefinition.setErrorRef(errorRef);
            }
            return ProcessVisitorBPMN.this.objectFactory.createErrorEventDefinition(tErrorEventDefinition);
        }
    }
}

