/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidXPathExpression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElement;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElementWithMixedContent;
import oracle.bpm.project.io.bpmn.jaxb.TExpression;
import oracle.bpm.project.io.bpmn.jaxb.TExtensionElements;
import oracle.bpm.project.io.bpmn.jaxb.TFormalExpression;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessRuleTaskData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TGraphicsAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.THumanTask;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOracleExtensions;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IoUtils {
    private IoUtils() {
    }

    public static <T> T getUnnamedOracleExtension(Class<T> clazz, TBaseElement tBaseElement) {
        return IoUtils.getUnnamedOracleExtension(clazz, IoUtils.getOracleExtensionsFrom(tBaseElement));
    }

    public static <T> T getUnnamedOracleExtension(Class<T> clazz, TBaseElementWithMixedContent tBaseElementWithMixedContent) {
        return IoUtils.getUnnamedOracleExtension(clazz, IoUtils.getOracleExtensionsFrom(tBaseElementWithMixedContent));
    }

    public static <T> T getNamedOracleExtension(Class<T> clazz, TBaseElement tBaseElement) {
        return IoUtils.getNamedOracleExtension(clazz, IoUtils.getOracleExtensionsFrom(tBaseElement));
    }

    public static <T> T getNamedOracleExtension(Class<T> clazz, TBaseElementWithMixedContent tBaseElementWithMixedContent) {
        return IoUtils.getNamedOracleExtension(clazz, IoUtils.getOracleExtensionsFrom(tBaseElementWithMixedContent));
    }

    @Nullable
    public static TOracleExtensions getOracleExtensionsFrom(TBaseElement tBaseElement) {
        return IoUtils.findOracleExtensionsIn(tBaseElement);
    }

    @Nullable
    public static TOracleExtensions getOracleExtensionsFrom(TBaseElementWithMixedContent tBaseElementWithMixedContent) {
        return IoUtils.findOracleExtensionsIn(tBaseElementWithMixedContent);
    }

    @Nullable
    public static TExtensionElements findExtensionsIn(TBaseElement element) {
        TExtensionElements result = null;
        if (element != null) {
            result = element.getExtensionElements();
        }
        return result;
    }

    @Nullable
    public static TOracleExtensions findOracleExtensionsIn(TBaseElement element) {
        TExtensionElements extensionElements;
        TOracleExtensions result = null;
        if (element != null && (extensionElements = element.getExtensionElements()) != null) {
            result = IoUtils.findOracleExtensions(extensionElements.getAny());
        }
        return result;
    }

    @Nullable
    public static TExtensionElements findExtensionsIn(TBaseElementWithMixedContent element) {
        TExtensionElements result = null;
        if (element != null) {
            for (Serializable content : element.getContent()) {
                Object value;
                if (!(content instanceof JAXBElement) || !((value = ((JAXBElement)content).getValue()) instanceof TExtensionElements)) continue;
                result = (TExtensionElements)value;
            }
        }
        return result;
    }

    @Nullable
    public static TOracleExtensions findOracleExtensionsIn(TBaseElementWithMixedContent element) {
        TExtensionElements extensionElements;
        TOracleExtensions result = null;
        if (element != null && (extensionElements = IoUtils.findExtensionsIn(element)) != null) {
            result = IoUtils.findOracleExtensions(extensionElements.getAny());
        }
        return result;
    }

    public static String getExpressionStringContent(TExpression tExpression) {
        Serializable content;
        List<Serializable> contents = tExpression.getContent();
        String expressionValue = "";
        if (contents != null && !contents.isEmpty() && (content = contents.get(0)) instanceof String) {
            expressionValue = (String)((Object)content);
        }
        return expressionValue.trim();
    }

    public static <T> T getUnnamedOracleExtension(Class<T> clazz, TOracleExtensions tOracleExtensions) {
        List<Object> any;
        T returnExtension = null;
        if (tOracleExtensions != null && (any = tOracleExtensions.getAny()) != null) {
            for (Object extension : any) {
                if (extension instanceof JAXBElement) {
                    extension = ((JAXBElement)extension).getValue();
                }
                if (!clazz.isInstance(extension)) continue;
                returnExtension = clazz.cast(extension);
            }
        }
        return returnExtension;
    }

    @Nullable
    public static Expression getExpressionFrom(@Nullable TExpression tExpression) {
        Expression retVal = null;
        if (tExpression != null) {
            if (tExpression instanceof TFormalExpression) {
                TFormalExpression tFormalExpression = (TFormalExpression)tExpression;
                String language = tFormalExpression.getLanguage();
                ExpressionLanguage expLanguage = null;
                if (language != null) {
                    expLanguage = ExpressionLanguage.fromId((String)language);
                }
                if (expLanguage != null) {
                    retVal = IoUtils.createXPathExpression(tExpression);
                }
            } else {
                retVal = IoUtils.createXPathExpression(tExpression);
            }
        }
        return retVal;
    }

    @NotNull
    public static Map<String, URI> createNamespacesMapFor(@Nullable Map<QName, String> otherAttributes) {
        if (otherAttributes == null || otherAttributes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, URI> namespaces = new HashMap<String, URI>();
        for (Map.Entry<QName, String> entry : otherAttributes.entrySet()) {
            QName qName = entry.getKey();
            if (!"http://xmlns.oracle.com/bpm/XPathNamespace".equals(qName.getNamespaceURI())) continue;
            try {
                namespaces.put(qName.getLocalPart(), new URI(entry.getValue()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return namespaces;
    }

    @Nullable
    public static Expression buildExpressionFrom(@Nullable TBaseElement tBaseElement, @Nullable TExpression tExpression) {
        Expression expression;
        oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression expressionExtension = IoUtils.getNamedOracleExtension(oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression.class, tBaseElement);
        if (expressionExtension != null) {
            expression = IoUtils.getExpressionFromExtension(tExpression, expressionExtension);
        } else {
            expressionExtension = IoUtils.getNamedOracleExtension(oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression.class, tExpression);
            expression = IoUtils.getExpressionFromExtension(tExpression, expressionExtension);
        }
        if (expression == null && (expression = IoUtils.getExpressionFrom(tExpression)) != null) {
            expression.setMode(ExpressionMode.XPATH);
        }
        return expression;
    }

    @Nullable
    private static TOracleExtensions findOracleExtensions(@Nullable List<?> extensions) {
        TOracleExtensions tOracleExtensions = null;
        if (extensions != null) {
            for (Object extension : extensions) {
                Object value;
                if (!(extension instanceof JAXBElement) || !((value = ((JAXBElement)extension).getValue()) instanceof TOracleExtensions)) continue;
                tOracleExtensions = (TOracleExtensions)value;
                break;
            }
        }
        return tOracleExtensions;
    }

    @NotNull
    private static Expression createXPathExpression(@NotNull TExpression tExpression) {
        String expressionValue = IoUtils.getExpressionStringContent(tExpression);
        Map<String, URI> namespaces = IoUtils.createNamespacesMapFor(tExpression.getOtherAttributes());
        return new XPathExpression(expressionValue, namespaces);
    }

    private static <T> T getNamedOracleExtension(Class<T> clazz, TOracleExtensions tOracleExtensions) {
        Object returnExtension = null;
        if (tOracleExtensions != null) {
            if (clazz == oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression.class) {
                returnExtension = tOracleExtensions.getExpression() != null ? clazz.cast(tOracleExtensions.getExpression()) : null;
            } else if (clazz == TGraphicsAttributes.class) {
                returnExtension = tOracleExtensions.getGraphicsAttributes() != null ? clazz.cast(tOracleExtensions.getGraphicsAttributes()) : null;
            } else if (clazz == THumanTask.class) {
                returnExtension = tOracleExtensions.getHumanTask() != null ? clazz.cast(tOracleExtensions.getHumanTask()) : null;
            } else if (clazz == TBusinessRuleTaskData.class) {
                returnExtension = tOracleExtensions.getBusinessRuleTaskData() != null ? clazz.cast(tOracleExtensions.getBusinessRuleTaskData()) : null;
            }
        }
        return returnExtension;
    }

    @Nullable
    private static Expression getExpressionFromExtension(@Nullable TExpression tExpression, @Nullable oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression expressionExtension) {
        Expression expression = IoUtils.getExpressionFrom(tExpression);
        if (expression != null && expressionExtension != null) {
            ExpressionMode mode;
            String invalidExpressionString = expressionExtension.getInvalidExpressionString();
            if (!Str.isEmpty(invalidExpressionString)) {
                expression = new InvalidXPathExpression(invalidExpressionString, ProjectIoMsg.INVALID_EXPRESSION_LOADED_CAUSE);
            }
            if ((mode = ExpressionMode.fromId((String)expressionExtension.getMode())) == null) {
                mode = ExpressionMode.XPATH;
            }
            expression.setMode(mode);
        }
        return expression;
    }
}

