/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.collections.Tuple;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.SchemaNamespaces;
import oracle.bpm.log.Log;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BPMNVersionParser {
    private static String VERSION_ELEMENT = "definitions";
    public static String VERSION_ATTRIBUTE = "version";
    public static String REVISION_ATTRIBUTE = "fileRevision";

    public static Tuple<String, Integer> getVersionAndRevision(@NotNull InputStream inputStream) {
        Integer revisionNumber;
        String revision;
        final HashMap versionMap = new HashMap();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(inputStream, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (localName != null && localName.equals(VERSION_ELEMENT) && uri != null && SchemaNamespaces.isBPMNSchema((String)uri)) {
                        String revision;
                        String version = attributes.getValue(VERSION_ATTRIBUTE);
                        if (version != null) {
                            versionMap.put(VERSION_ATTRIBUTE, version);
                        }
                        if ((revision = attributes.getValue(REVISION_ATTRIBUTE)) != null) {
                            versionMap.put(REVISION_ATTRIBUTE, revision);
                        }
                    }
                }
            });
        }
        catch (SAXException e) {
            Log.logWarning(e);
        }
        catch (ParserConfigurationException e) {
            Log.logWarning(e);
        }
        catch (IOException e) {
            Log.logWarning(e);
        }
        String version = (String)versionMap.get(VERSION_ATTRIBUTE);
        if (Str.isEmpty(version)) {
            version = "11.1.1";
        }
        if (Str.isEmpty(revision = (String)versionMap.get(REVISION_ATTRIBUTE))) {
            revision = "20090820";
        }
        try {
            revisionNumber = Integer.valueOf(revision);
        }
        catch (NumberFormatException e) {
            revisionNumber = Integer.valueOf("20090820");
        }
        return Tuple.create(version, revisionNumber);
    }
}

